/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.SyncStats;
import android.os.Parcel;
import android.os.Parcelable;

public final class SyncResult
implements Parcelable {
    public static final SyncResult ALREADY_IN_PROGRESS = new SyncResult(true);
    public static final Parcelable.Creator<SyncResult> CREATOR = new Parcelable.Creator<SyncResult>(){

        @Override
        public SyncResult createFromParcel(Parcel parcel) {
            return new SyncResult(parcel);
        }

        public SyncResult[] newArray(int n) {
            return new SyncResult[n];
        }
    };
    public boolean databaseError;
    public long delayUntil;
    public boolean fullSyncRequested;
    public boolean moreRecordsToGet;
    public boolean partialSyncUnavailable;
    public final SyncStats stats;
    public final boolean syncAlreadyInProgress;
    public boolean tooManyDeletions;
    public boolean tooManyRetries;

    public SyncResult() {
        this(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private SyncResult(Parcel parcel) {
        SyncStats syncStats;
        long l;
        boolean bl = parcel.readInt() != 0;
        this.syncAlreadyInProgress = bl;
        boolean bl2 = parcel.readInt() != 0;
        this.tooManyDeletions = bl2;
        boolean bl3 = parcel.readInt() != 0;
        this.tooManyRetries = bl3;
        boolean bl4 = parcel.readInt() != 0;
        this.databaseError = bl4;
        boolean bl5 = parcel.readInt() != 0;
        this.fullSyncRequested = bl5;
        boolean bl6 = parcel.readInt() != 0;
        this.partialSyncUnavailable = bl6;
        boolean bl7 = parcel.readInt() != 0;
        this.moreRecordsToGet = bl7;
        this.delayUntil = l = parcel.readLong();
        this.stats = syncStats = new SyncStats(parcel);
    }

    private SyncResult(boolean bl) {
        SyncStats syncStats;
        this.syncAlreadyInProgress = bl;
        this.tooManyDeletions = false;
        this.tooManyRetries = false;
        this.fullSyncRequested = false;
        this.partialSyncUnavailable = false;
        this.moreRecordsToGet = false;
        this.delayUntil = 0L;
        this.stats = syncStats = new SyncStats();
    }

    public void clear() {
        if (this.syncAlreadyInProgress) {
            throw new UnsupportedOperationException("you are not allowed to clear the ALREADY_IN_PROGRESS SyncStats");
        }
        this.tooManyDeletions = false;
        this.tooManyRetries = false;
        this.databaseError = false;
        this.fullSyncRequested = false;
        this.partialSyncUnavailable = false;
        this.moreRecordsToGet = false;
        this.delayUntil = 0L;
        this.stats.clear();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasError() {
        if (this.hasSoftError()) return true;
        if (!this.hasHardError()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasHardError() {
        if (this.stats.numParseExceptions > 0L) return true;
        if (this.stats.numConflictDetectedExceptions > 0L) return true;
        if (this.stats.numAuthExceptions > 0L) return true;
        if (this.tooManyDeletions) return true;
        if (this.tooManyRetries) return true;
        if (!this.databaseError) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSoftError() {
        if (this.syncAlreadyInProgress) return true;
        if (this.stats.numIoExceptions <= 0L) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean madeSomeProgress() {
        if (this.stats.numDeletes > 0L) {
            if (!this.tooManyDeletions) return true;
        }
        if (this.stats.numInserts > 0L) return true;
        if (this.stats.numUpdates <= 0L) return false;
        return true;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fullSyncRequested) {
            StringBuffer stringBuffer2 = stringBuffer.append("f1");
        }
        if (this.partialSyncUnavailable) {
            StringBuffer stringBuffer3 = stringBuffer.append("r1");
        }
        if (this.hasHardError()) {
            StringBuffer stringBuffer4 = stringBuffer.append("X1");
        }
        if (this.stats.numParseExceptions > 0L) {
            StringBuffer stringBuffer5 = stringBuffer.append("e");
            long l = this.stats.numParseExceptions;
            StringBuffer stringBuffer6 = stringBuffer5.append(l);
        }
        if (this.stats.numConflictDetectedExceptions > 0L) {
            StringBuffer stringBuffer7 = stringBuffer.append("c");
            long l = this.stats.numConflictDetectedExceptions;
            StringBuffer stringBuffer8 = stringBuffer7.append(l);
        }
        if (this.stats.numAuthExceptions > 0L) {
            StringBuffer stringBuffer9 = stringBuffer.append("a");
            long l = this.stats.numAuthExceptions;
            StringBuffer stringBuffer10 = stringBuffer9.append(l);
        }
        if (this.tooManyDeletions) {
            StringBuffer stringBuffer11 = stringBuffer.append("D1");
        }
        if (this.tooManyRetries) {
            StringBuffer stringBuffer12 = stringBuffer.append("R1");
        }
        if (this.databaseError) {
            StringBuffer stringBuffer13 = stringBuffer.append("b1");
        }
        if (this.hasSoftError()) {
            StringBuffer stringBuffer14 = stringBuffer.append("x1");
        }
        if (this.syncAlreadyInProgress) {
            StringBuffer stringBuffer15 = stringBuffer.append("l1");
        }
        if (this.stats.numIoExceptions > 0L) {
            StringBuffer stringBuffer16 = stringBuffer.append("I");
            long l = this.stats.numIoExceptions;
            StringBuffer stringBuffer17 = stringBuffer16.append(l);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("SyncResult:");
        if (this.syncAlreadyInProgress) {
            StringBuilder stringBuilder3 = stringBuilder.append(" syncAlreadyInProgress: ");
            boolean bl = this.syncAlreadyInProgress;
            StringBuilder stringBuilder4 = stringBuilder3.append(bl);
        }
        if (this.tooManyDeletions) {
            StringBuilder stringBuilder5 = stringBuilder.append(" tooManyDeletions: ");
            boolean bl = this.tooManyDeletions;
            StringBuilder stringBuilder6 = stringBuilder5.append(bl);
        }
        if (this.tooManyRetries) {
            StringBuilder stringBuilder7 = stringBuilder.append(" tooManyRetries: ");
            boolean bl = this.tooManyRetries;
            StringBuilder stringBuilder8 = stringBuilder7.append(bl);
        }
        if (this.databaseError) {
            StringBuilder stringBuilder9 = stringBuilder.append(" databaseError: ");
            boolean bl = this.databaseError;
            StringBuilder stringBuilder10 = stringBuilder9.append(bl);
        }
        if (this.fullSyncRequested) {
            StringBuilder stringBuilder11 = stringBuilder.append(" fullSyncRequested: ");
            boolean bl = this.fullSyncRequested;
            StringBuilder stringBuilder12 = stringBuilder11.append(bl);
        }
        if (this.partialSyncUnavailable) {
            StringBuilder stringBuilder13 = stringBuilder.append(" partialSyncUnavailable: ");
            boolean bl = this.partialSyncUnavailable;
            StringBuilder stringBuilder14 = stringBuilder13.append(bl);
        }
        if (this.moreRecordsToGet) {
            StringBuilder stringBuilder15 = stringBuilder.append(" moreRecordsToGet: ");
            boolean bl = this.moreRecordsToGet;
            StringBuilder stringBuilder16 = stringBuilder15.append(bl);
        }
        if (this.delayUntil > 0L) {
            StringBuilder stringBuilder17 = stringBuilder.append(" delayUntil: ");
            long l = this.delayUntil;
            StringBuilder stringBuilder18 = stringBuilder17.append(l);
        }
        SyncStats syncStats = this.stats;
        StringBuilder stringBuilder19 = stringBuilder.append(syncStats);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.syncAlreadyInProgress ? 1 : 0;
        parcel.writeInt(n2);
        int n3 = this.tooManyDeletions ? 1 : 0;
        parcel.writeInt(n3);
        int n4 = this.tooManyRetries ? 1 : 0;
        parcel.writeInt(n4);
        int n5 = this.databaseError ? 1 : 0;
        parcel.writeInt(n5);
        int n6 = this.fullSyncRequested ? 1 : 0;
        parcel.writeInt(n6);
        int n7 = this.partialSyncUnavailable ? 1 : 0;
        parcel.writeInt(n7);
        int n8 = this.moreRecordsToGet ? 1 : 0;
        parcel.writeInt(n8);
        long l = this.delayUntil;
        parcel.writeLong(l);
        this.stats.writeToParcel(parcel, n);
    }
}

