/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;

public class SyncStatusInfo
implements Parcelable {
    public static final Parcelable.Creator<SyncStatusInfo> CREATOR = new Parcelable.Creator<SyncStatusInfo>(){

        @Override
        public SyncStatusInfo createFromParcel(Parcel parcel) {
            return new SyncStatusInfo(parcel);
        }

        public SyncStatusInfo[] newArray(int n) {
            return new SyncStatusInfo[n];
        }
    };
    private static final String TAG = "Sync";
    static final int VERSION = 2;
    public final int authorityId;
    public long initialFailureTime;
    public boolean initialize;
    public String lastFailureMesg;
    public int lastFailureSource;
    public long lastFailureTime;
    public int lastSuccessSource;
    public long lastSuccessTime;
    public int numSourceLocal;
    public int numSourcePeriodic;
    public int numSourcePoll;
    public int numSourceServer;
    public int numSourceUser;
    public int numSyncs;
    public boolean pending;
    public ArrayList<Long> periodicSyncTimes;
    public long totalElapsedTime;

    SyncStatusInfo(int n) {
        this.authorityId = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    SyncStatusInfo(Parcel parcel) {
        long l;
        String string2;
        int n;
        long l2;
        int n2;
        long l3;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        long l4;
        int n8;
        int n9 = parcel.readInt();
        if (n9 != 2 && n9 != 1) {
            String string3 = "Unknown version: " + n9;
            int n10 = Log.w("SyncStatusInfo", string3);
        }
        this.authorityId = n8 = parcel.readInt();
        this.totalElapsedTime = l4 = parcel.readLong();
        this.numSyncs = n7 = parcel.readInt();
        this.numSourcePoll = n6 = parcel.readInt();
        this.numSourceServer = n5 = parcel.readInt();
        this.numSourceLocal = n4 = parcel.readInt();
        this.numSourceUser = n3 = parcel.readInt();
        this.lastSuccessTime = l3 = parcel.readLong();
        this.lastSuccessSource = n2 = parcel.readInt();
        this.lastFailureTime = l2 = parcel.readLong();
        this.lastFailureSource = n = parcel.readInt();
        this.lastFailureMesg = string2 = parcel.readString();
        this.initialFailureTime = l = parcel.readLong();
        boolean bl = parcel.readInt() != 0;
        this.pending = bl;
        boolean bl2 = parcel.readInt() != 0;
        this.initialize = bl2;
        if (n9 == 1) {
            this.periodicSyncTimes = null;
            return;
        }
        int n11 = parcel.readInt();
        if (n11 < 0) {
            this.periodicSyncTimes = null;
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.periodicSyncTimes = arrayList;
        int n12 = 0;
        while (n12 < n11) {
            ArrayList<Long> arrayList2 = this.periodicSyncTimes;
            Long l5 = parcel.readLong();
            boolean bl3 = arrayList2.add(l5);
            ++n12;
        }
        return;
    }

    private void ensurePeriodicSyncTimeSize(int n) {
        if (this.periodicSyncTimes == null) {
            ArrayList arrayList = new ArrayList(0);
            this.periodicSyncTimes = arrayList;
        }
        int n2 = n + 1;
        if (this.periodicSyncTimes.size() >= n2) {
            return;
        }
        int n3 = this.periodicSyncTimes.size();
        while (n3 < n2) {
            ArrayList<Long> arrayList = this.periodicSyncTimes;
            Long l = 0L;
            boolean bl = arrayList.add(l);
            ++n3;
        }
        return;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLastFailureMesgAsInt(int n) {
        try {
            if (this.lastFailureMesg == null) return n;
            int n2 = Integer.parseInt(this.lastFailureMesg);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder stringBuilder = new StringBuilder().append("error parsing lastFailureMesg of ");
            String string2 = this.lastFailureMesg;
            String string3 = stringBuilder.append(string2).toString();
            int n3 = Log.d(TAG, string3, numberFormatException);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getPeriodicSyncTime(int n) {
        int n2;
        if (this.periodicSyncTimes == null) return 0L;
        int n3 = this.periodicSyncTimes.size();
        if (n3 >= (n2 = n + 1)) return this.periodicSyncTimes.get(n);
        return 0L;
    }

    public void removePeriodicSyncTime(int n) {
        this.ensurePeriodicSyncTimeSize(n);
        Long l = this.periodicSyncTimes.remove(n);
    }

    public void setPeriodicSyncTime(int n, long l) {
        this.ensurePeriodicSyncTimeSize(n);
        ArrayList<Long> arrayList = this.periodicSyncTimes;
        Long l2 = l;
        Long l3 = arrayList.set(n, l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(2);
        int n2 = this.authorityId;
        parcel.writeInt(n2);
        long l = this.totalElapsedTime;
        parcel.writeLong(l);
        int n3 = this.numSyncs;
        parcel.writeInt(n3);
        int n4 = this.numSourcePoll;
        parcel.writeInt(n4);
        int n5 = this.numSourceServer;
        parcel.writeInt(n5);
        int n6 = this.numSourceLocal;
        parcel.writeInt(n6);
        int n7 = this.numSourceUser;
        parcel.writeInt(n7);
        long l2 = this.lastSuccessTime;
        parcel.writeLong(l2);
        int n8 = this.lastSuccessSource;
        parcel.writeInt(n8);
        long l3 = this.lastFailureTime;
        parcel.writeLong(l3);
        int n9 = this.lastFailureSource;
        parcel.writeInt(n9);
        String string2 = this.lastFailureMesg;
        parcel.writeString(string2);
        long l4 = this.initialFailureTime;
        parcel.writeLong(l4);
        int n10 = this.pending ? 1 : 0;
        parcel.writeInt(n10);
        int n11 = this.initialize ? 1 : 0;
        parcel.writeInt(n11);
        if (this.periodicSyncTimes == null) {
            parcel.writeInt(-1);
            return;
        }
        int n12 = this.periodicSyncTimes.size();
        parcel.writeInt(n12);
        Iterator<Long> iterator = this.periodicSyncTimes.iterator();
        while (iterator.hasNext()) {
            long l5 = iterator.next();
            parcel.writeLong(l5);
        }
        return;
    }
}

