/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.PeriodicSync;
import android.content.SyncInfo;
import android.content.SyncManager;
import android.content.SyncStatusInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteQueryBuilder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.xmlpull.v1.XmlPullParser;

public class SyncStorageEngine
extends Handler {
    private static final int ACCOUNTS_VERSION = 2;
    private static final boolean DEBUG_FILE = false;
    private static final long DEFAULT_POLL_FREQUENCY_SECONDS = 86400L;
    public static final String[] EVENTS;
    public static final int EVENT_START = 0;
    public static final int EVENT_STOP = 1;
    public static final int MAX_HISTORY = 100;
    public static final String MESG_CANCELED = "canceled";
    public static final String MESG_SUCCESS = "success";
    static final long MILLIS_IN_4WEEKS = 2419200000L;
    private static final int MSG_WRITE_STATISTICS = 2;
    private static final int MSG_WRITE_STATUS = 1;
    public static final long NOT_IN_BACKOFF_MODE = 255L;
    private static final int PENDING_FINISH_TO_WRITE = 4;
    public static final int PENDING_OPERATION_VERSION = 2;
    public static final String[] SOURCES;
    public static final int SOURCE_LOCAL = 1;
    public static final int SOURCE_PERIODIC = 4;
    public static final int SOURCE_POLL = 2;
    public static final int SOURCE_SERVER = 0;
    public static final int SOURCE_USER = 3;
    public static final int STATISTICS_FILE_END = 0;
    public static final int STATISTICS_FILE_ITEM = 101;
    public static final int STATISTICS_FILE_ITEM_OLD = 100;
    public static final int STATUS_FILE_END = 0;
    public static final int STATUS_FILE_ITEM = 100;
    public static final Intent SYNC_CONNECTION_SETTING_CHANGED_INTENT;
    private static final boolean SYNC_ENABLED_DEFAULT = false;
    private static final String TAG = "SyncManager";
    private static final long WRITE_STATISTICS_DELAY = 1800000L;
    private static final long WRITE_STATUS_DELAY = 600000L;
    private static HashMap<String, String> sAuthorityRenames;
    private static volatile SyncStorageEngine sSyncStorageEngine;
    private final AtomicFile mAccountInfoFile;
    private final HashMap<Account, AccountInfo> mAccounts;
    private final SparseArray<AuthorityInfo> mAuthorities;
    private final Calendar mCal;
    private final RemoteCallbackList<ISyncStatusObserver> mChangeListeners;
    private final Context mContext;
    private SyncInfo mCurrentSync;
    private final DayStats[] mDayStats;
    private boolean mMasterSyncAutomatically;
    private int mNextAuthorityId;
    private int mNextHistoryId;
    private int mNumPendingFinished;
    private final AtomicFile mPendingFile;
    private final ArrayList<PendingOperation> mPendingOperations;
    private final AtomicFile mStatisticsFile;
    private final AtomicFile mStatusFile;
    private final ArrayList<SyncHistoryItem> mSyncHistory;
    private final SparseArray<SyncStatusInfo> mSyncStatus;
    private int mYear;
    private int mYearInDays;

    static {
        String[] stringArray = new String[]{"START", "STOP"};
        EVENTS = stringArray;
        SYNC_CONNECTION_SETTING_CHANGED_INTENT = new Intent("com.android.sync.SYNC_CONN_STATUS_CHANGED");
        String[] stringArray2 = new String[]{"SERVER", "LOCAL", "POLL", "USER", "PERIODIC"};
        SOURCES = stringArray2;
        sAuthorityRenames = new HashMap();
        String string2 = sAuthorityRenames.put("contacts", "com.android.contacts");
        String string3 = sAuthorityRenames.put("calendar", "com.android.calendar");
        sSyncStorageEngine = null;
    }

    private SyncStorageEngine(Context context, File file) {
        AtomicFile atomicFile;
        AtomicFile atomicFile2;
        AtomicFile atomicFile3;
        AtomicFile atomicFile4;
        Calendar calendar;
        SparseArray sparseArray = new SparseArray();
        this.mAuthorities = sparseArray;
        HashMap hashMap = new HashMap();
        this.mAccounts = hashMap;
        ArrayList arrayList = new ArrayList();
        this.mPendingOperations = arrayList;
        SparseArray sparseArray2 = new SparseArray();
        this.mSyncStatus = sparseArray2;
        ArrayList arrayList2 = new ArrayList();
        this.mSyncHistory = arrayList2;
        RemoteCallbackList remoteCallbackList = new RemoteCallbackList();
        this.mChangeListeners = remoteCallbackList;
        this.mNextAuthorityId = 0;
        DayStats[] dayStatsArray = new DayStats[28];
        this.mDayStats = dayStatsArray;
        this.mNumPendingFinished = 0;
        this.mNextHistoryId = 0;
        this.mMasterSyncAutomatically = true;
        this.mContext = context;
        sSyncStorageEngine = this;
        this.mCal = calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        File file2 = new File(file, "system");
        File file3 = new File(file2, "sync");
        boolean bl = file3.mkdirs();
        File file4 = new File(file3, "accounts.xml");
        this.mAccountInfoFile = atomicFile4 = new AtomicFile(file4);
        File file5 = new File(file3, "status.bin");
        this.mStatusFile = atomicFile3 = new AtomicFile(file5);
        File file6 = new File(file3, "pending.bin");
        this.mPendingFile = atomicFile2 = new AtomicFile(file6);
        File file7 = new File(file3, "stats.bin");
        this.mStatisticsFile = atomicFile = new AtomicFile(file7);
        this.readAccountInfoLocked();
        this.readStatusLocked();
        this.readPendingOperationsLocked();
        this.readStatisticsLocked();
        this.readAndDeleteLegacyAccountInfoLocked();
        this.writeAccountInfoLocked();
        this.writeStatusLocked();
        this.writePendingOperationsLocked();
        this.writeStatisticsLocked();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendPendingOperationLocked(PendingOperation pendingOperation) {
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2 = fileOutputStream = this.mPendingFile.openAppend();
        Parcel parcel = Parcel.obtain();
        this.writePendingOperationLocked(pendingOperation, parcel);
        byte[] byArray = parcel.marshall();
        fileOutputStream2.write(byArray);
        parcel.recycle();
        fileOutputStream2.close();
        return;
        {
            catch (IOException iOException) {
                return;
            }
        }
        catch (IOException iOException) {
            this.writePendingOperationsLocked();
            return;
        }
        catch (IOException iOException) {
            try {
                int n = Log.w(TAG, "Error writing pending operations", iOException);
            }
            catch (Throwable throwable) {
                try {
                    fileOutputStream2.close();
                }
                catch (IOException iOException2) {
                    throw throwable;
                }
                throw throwable;
            }
            fileOutputStream2.close();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(Bundle bundle, Bundle bundle2) {
        Object object;
        String string2;
        Object object2;
        int n;
        int n2 = bundle.size();
        if (n2 != (n = bundle2.size())) {
            return false;
        }
        if (bundle.isEmpty()) {
            return true;
        }
        Iterator<String> iterator = bundle.keySet().iterator();
        do {
            if (!iterator.hasNext()) return true;
            string2 = iterator.next();
            if (bundle2.containsKey(string2)) continue;
            return false;
        } while ((object2 = bundle.get(string2)).equals(object = bundle2.get(string2)));
        return false;
    }

    private static byte[] flattenBundle(Bundle bundle) {
        Parcel parcel = Parcel.obtain();
        try {
            byte[] byArray;
            bundle.writeToParcel(parcel, 0);
            byte[] byArray2 = byArray = parcel.marshall();
            parcel.recycle();
            return byArray2;
        }
        catch (Throwable throwable) {
            parcel.recycle();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthorityInfo getAuthorityLocked(Account account, String string2, String string3) {
        AccountInfo accountInfo = this.mAccounts.get(account);
        if (accountInfo == null) {
            if (string3 == null) return null;
            if (!Log.isLoggable(TAG, 2)) return null;
            String string4 = string3 + ": unknown account " + account;
            int n = Log.v(TAG, string4);
            return null;
        }
        AuthorityInfo authorityInfo = accountInfo.authorities.get(string2);
        if (authorityInfo != null) return authorityInfo;
        if (string3 == null) return null;
        if (!Log.isLoggable(TAG, 2)) return null;
        String string5 = string3 + ": unknown authority " + string2;
        int n = Log.v(TAG, string5);
        return null;
    }

    private int getCurrentDayLocked() {
        Calendar calendar = this.mCal;
        long l = System.currentTimeMillis();
        calendar.setTimeInMillis(l);
        int n = this.mCal.get(6);
        int n2 = this.mYear;
        int n3 = this.mCal.get(1);
        if (n2 != n3) {
            int n4;
            int n5;
            this.mYear = n5 = this.mCal.get(1);
            this.mCal.clear();
            Calendar calendar2 = this.mCal;
            int n6 = this.mYear;
            calendar2.set(1, n6);
            this.mYearInDays = n4 = (int)(this.mCal.getTimeInMillis() / 86400000L);
        }
        return this.mYearInDays + n;
    }

    static int getIntColumn(Cursor cursor, String string2) {
        int n = cursor.getColumnIndex(string2);
        return cursor.getInt(n);
    }

    static long getLongColumn(Cursor cursor, String string2) {
        int n = cursor.getColumnIndex(string2);
        return cursor.getLong(n);
    }

    private AuthorityInfo getOrCreateAuthorityLocked(Account account, String string2, int n, boolean bl) {
        AuthorityInfo authorityInfo;
        AccountInfo accountInfo = this.mAccounts.get(account);
        if (accountInfo == null) {
            accountInfo = new AccountInfo(account);
            AccountInfo accountInfo2 = this.mAccounts.put(account, accountInfo);
        }
        if ((authorityInfo = accountInfo.authorities.get(string2)) == null) {
            if (n < 0) {
                int n2;
                n = this.mNextAuthorityId;
                this.mNextAuthorityId = n2 = this.mNextAuthorityId + 1;
                bl = true;
            }
            if (Log.isLoggable(TAG, 2)) {
                String string3 = "created a new AuthorityInfo for " + account + ", provider " + string2;
                int n3 = Log.v(TAG, string3);
            }
            authorityInfo = new AuthorityInfo(account, string2, n);
            AuthorityInfo authorityInfo2 = accountInfo.authorities.put(string2, authorityInfo);
            this.mAuthorities.put(n, authorityInfo);
            if (bl) {
                this.writeAccountInfoLocked();
            }
        }
        return authorityInfo;
    }

    private SyncStatusInfo getOrCreateSyncStatusLocked(int n) {
        SyncStatusInfo syncStatusInfo = this.mSyncStatus.get(n);
        if (syncStatusInfo == null) {
            syncStatusInfo = new SyncStatusInfo(n);
            this.mSyncStatus.put(n, syncStatusInfo);
        }
        return syncStatusInfo;
    }

    public static SyncStorageEngine getSingleton() {
        if (sSyncStorageEngine == null) {
            throw new IllegalStateException("not initialized");
        }
        return sSyncStorageEngine;
    }

    public static void init(Context context) {
        if (sSyncStorageEngine != null) {
            return;
        }
        File file = Environment.getSecureDataDirectory();
        sSyncStorageEngine = new SyncStorageEngine(context, file);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean maybeMigrateSettingsForRenamedAuthorities() {
        boolean bl = false;
        ArrayList<AuthorityInfo> arrayList = new ArrayList<AuthorityInfo>();
        int n = this.mAuthorities.size();
        for (int i = 0; i < n; ++i) {
            Account account;
            AuthorityInfo authorityInfo = this.mAuthorities.valueAt(i);
            HashMap<String, String> hashMap = sAuthorityRenames;
            String string2 = authorityInfo.authority;
            String string3 = hashMap.get(string2);
            if (string3 == null) continue;
            boolean bl2 = arrayList.add(authorityInfo);
            if (!authorityInfo.enabled || this.getAuthorityLocked(account = authorityInfo.account, string3, "cleanup") != null) continue;
            Account account2 = authorityInfo.account;
            this.getOrCreateAuthorityLocked((Account)account2, (String)string3, (int)-1, (boolean)false).enabled = true;
            bl = true;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AuthorityInfo authorityInfo = (AuthorityInfo)iterator.next();
            Account account = authorityInfo.account;
            String string4 = authorityInfo.authority;
            this.removeAuthorityLocked(account, string4, false);
            bl = true;
        }
        return bl;
    }

    public static SyncStorageEngine newTestInstance(Context context) {
        File file = context.getFilesDir();
        return new SyncStorageEngine(context, file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthorityInfo parseAuthority(XmlPullParser xmlPullParser, int n) {
        AuthorityInfo authorityInfo = null;
        int n2 = -1;
        int n3 = 0;
        try {
            int n4;
            n2 = n4 = Integer.parseInt(xmlPullParser.getAttributeValue(null, "id"));
        }
        catch (NumberFormatException numberFormatException) {
            int n5 = Log.e(TAG, "error parsing the id of the authority", numberFormatException);
        }
        catch (NullPointerException nullPointerException) {
            int n6 = Log.e(TAG, "the id of the authority is null", nullPointerException);
        }
        if (n2 < 0) return authorityInfo;
        String string2 = xmlPullParser.getAttributeValue(null, "authority");
        String string3 = xmlPullParser.getAttributeValue(null, "enabled");
        String string4 = xmlPullParser.getAttributeValue(null, "syncable");
        String string5 = xmlPullParser.getAttributeValue(null, "account");
        String string6 = xmlPullParser.getAttributeValue(null, "type");
        if (string6 == null) {
            string6 = "com.google";
            string4 = "unknown";
        }
        if ((authorityInfo = this.mAuthorities.get(n2)) == null) {
            Account account = new Account(string5, string6);
            AuthorityInfo authorityInfo2 = this.getOrCreateAuthorityLocked(account, string2, n2, false);
            if (n > 0) {
                authorityInfo2.periodicSyncs.clear();
            }
        }
        if (authorityInfo == null) {
            String string7 = "Failure adding authority: account=" + string5 + " auth=" + string2 + " enabled=" + string3 + " syncable=" + string4;
            int n7 = Log.w(TAG, string7);
            return authorityInfo;
        }
        boolean bl = string3 == null || Boolean.parseBoolean(string3);
        authorityInfo.enabled = bl;
        if ("unknown".equals(string4)) {
            authorityInfo.syncable = -1;
            return authorityInfo;
        }
        n3 = string4 == null || Boolean.parseBoolean(string4) ? 1 : 0;
        authorityInfo.syncable = n3;
        return authorityInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseExtra(XmlPullParser xmlPullParser, Pair<Bundle, Long> pair) {
        Bundle bundle = (Bundle)pair.first;
        String string2 = xmlPullParser.getAttributeValue(null, "name");
        String string3 = xmlPullParser.getAttributeValue(null, "type");
        String string4 = xmlPullParser.getAttributeValue(null, "value1");
        String string5 = xmlPullParser.getAttributeValue(null, "value2");
        try {
            if ("long".equals(string3)) {
                long l = Long.parseLong(string4);
                bundle.putLong(string2, l);
                return;
            }
            if ("integer".equals(string3)) {
                int n = Integer.parseInt(string4);
                bundle.putInt(string2, n);
                return;
            }
            if ("double".equals(string3)) {
                double d = Double.parseDouble(string4);
                bundle.putDouble(string2, d);
                return;
            }
            if ("float".equals(string3)) {
                float f = Float.parseFloat(string4);
                bundle.putFloat(string2, f);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            int n = Log.e(TAG, "error parsing bundle value", numberFormatException);
            return;
        }
        catch (NullPointerException nullPointerException) {
            int n = Log.e(TAG, "error parsing bundle value", nullPointerException);
            return;
        }
        if ("boolean".equals(string3)) {
            boolean bl = Boolean.parseBoolean(string4);
            bundle.putBoolean(string2, bl);
            return;
        }
        if ("string".equals(string3)) {
            bundle.putString(string2, string4);
            return;
        }
        if (!"account".equals(string3)) {
            return;
        }
        Account account = new Account(string4, string5);
        bundle.putParcelable(string2, account);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pair<Bundle, Long> parsePeriodicSync(XmlPullParser xmlPullParser, AuthorityInfo authorityInfo) {
        long l;
        Bundle bundle = new Bundle();
        String string2 = xmlPullParser.getAttributeValue(null, "period");
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            int n = Log.e(TAG, "error parsing the period of a periodic sync", numberFormatException);
            return null;
        }
        catch (NullPointerException nullPointerException) {
            int n = Log.e(TAG, "the period of a periodic sync is null", nullPointerException);
            return null;
        }
        Long l2 = l;
        Pair<Bundle, Long> pair = Pair.create(bundle, l2);
        boolean bl = authorityInfo.periodicSyncs.add(pair);
        return pair;
    }

    /*
     * Exception decompiling
     */
    private void readAccountInfoLocked() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 10[TRYBLOCK] [25 : 706->711)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAndDeleteLegacyAccountInfoLocked() {
        var1_1 = this.mContext.getDatabasePath("syncmanager.db");
        if (!var1_1.exists()) {
            return;
        }
        var2_2 = var1_1.getPath();
        var3_3 = null;
        var4_4 = null;
        var5_5 = 1;
        try {
            var6_6 = var2_2;
            var7_7 = var4_4;
            var8_8 = var5_5;
            var3_3 = var9_9 = SQLiteDatabase.openDatabase(var6_6, var7_7, var8_8);
        }
        catch (SQLiteException var202_10) {}
        if (var3_3 == null) {
            return;
        }
        var10_11 = var3_3.getVersion() >= 11;
        var11_12 = new SQLiteQueryBuilder();
        var11_12.setTables("stats, status");
        var13_14 = var12_13 = new HashMap<String, String>();
        var14_15 = "_id";
        var15_16 = "status._id as _id";
        var16_17 = var13_14.put(var14_15, var15_16);
        var17_18 = var12_13;
        var18_19 = "account";
        var19_20 = "stats.account as account";
        var20_21 = var17_18.put(var18_19, var19_20);
        if (var10_11) {
            var21_22 = var12_13;
            var22_23 = "account_type";
            var23_24 = "stats.account_type as account_type";
            var24_25 = var21_22.put(var22_23, var23_24);
        }
        var25_26 = var12_13;
        var26_27 = "authority";
        var27_28 = "stats.authority as authority";
        var28_29 = var25_26.put(var26_27, var27_28);
        var29_30 = var12_13;
        var30_31 = "totalElapsedTime";
        var31_32 = "totalElapsedTime";
        var32_33 = var29_30.put(var30_31, var31_32);
        var33_34 = var12_13;
        var34_35 = "numSyncs";
        var35_36 = "numSyncs";
        var36_37 = var33_34.put(var34_35, var35_36);
        var37_38 = var12_13;
        var38_39 = "numSourceLocal";
        var39_40 = "numSourceLocal";
        var40_41 = var37_38.put(var38_39, var39_40);
        var41_42 = var12_13;
        var42_43 = "numSourcePoll";
        var43_44 = "numSourcePoll";
        var44_45 = var41_42.put(var42_43, var43_44);
        var45_46 = var12_13;
        var46_47 = "numSourceServer";
        var47_48 = "numSourceServer";
        var48_49 = var45_46.put(var46_47, var47_48);
        var49_50 = var12_13;
        var50_51 = "numSourceUser";
        var51_52 = "numSourceUser";
        var52_53 = var49_50.put(var50_51, var51_52);
        var53_54 = var12_13;
        var54_55 = "lastSuccessSource";
        var55_56 = "lastSuccessSource";
        var56_57 = var53_54.put(var54_55, var55_56);
        var57_58 = var12_13;
        var58_59 = "lastSuccessTime";
        var59_60 = "lastSuccessTime";
        var60_61 = var57_58.put(var58_59, var59_60);
        var61_62 = var12_13;
        var62_63 = "lastFailureSource";
        var63_64 = "lastFailureSource";
        var64_65 = var61_62.put(var62_63, var63_64);
        var65_66 = var12_13;
        var66_67 = "lastFailureTime";
        var67_68 = "lastFailureTime";
        var68_69 = var65_66.put(var66_67, var67_68);
        var69_70 = var12_13;
        var70_71 = "lastFailureMesg";
        var71_72 = "lastFailureMesg";
        var72_73 = var69_70.put(var70_71, var71_72);
        var73_74 = var12_13;
        var74_75 = "pending";
        var75_76 = "pending";
        var76_77 = var73_74.put(var74_75, var75_76);
        var77_78 = var11_12;
        var78_79 = var12_13;
        var77_78.setProjectionMap(var78_79);
        var11_12.appendWhere("stats._id = status.stats_id");
        var79_80 = var11_12.query(var3_3, null, null, null, null, null, null);
        while (var79_80.moveToNext()) {
            var80_81 = var79_80;
            var81_82 = "account";
            var82_83 = var80_81.getColumnIndex(var81_82);
            var83_84 = var79_80;
            var84_85 = var82_83;
            var85_86 = var83_84.getString(var84_85);
            if (var10_11) {
                var86_87 = var79_80;
                var87_88 = "account_type";
                var88_89 = var86_87.getColumnIndex(var87_88);
                var89_90 = var79_80;
                var90_91 = var88_89;
                var91_92 = var89_90.getString(var90_91);
            } else {
                var91_92 = null;
            }
            if (var91_92 == null) {
                var91_92 = "com.google";
            }
            if ((var104_105 = (var99_100 = this).getOrCreateAuthorityLocked(var100_101 = (var98_99 = new Account(var85_86, var91_92)), var101_102 = (var97_98 = (var95_96 = var79_80).getString(var96_97 = (var94_95 = (var92_93 = var79_80).getColumnIndex(var93_94 = "authority")))), var102_103 = -1, var103_104 = false)) == null) continue;
            var105_106 = this.mSyncStatus.size();
            var106_107 = false;
            var107_108 = null;
            while (var105_106 > 0) {
                var108_109 = this.mSyncStatus;
                var109_110 = var105_106 += -1;
                var107_108 = var108_109.valueAt(var109_110);
                var110_111 = var107_108.authorityId;
                var111_112 = var104_105.ident;
                if (var110_111 == var111_112) continue;
                var106_107 = true;
                break;
            }
            if (!var106_107) {
                var112_113 = var104_105.ident;
                var113_114 = var107_108;
                var114_115 = var112_113;
                var113_114(var114_115);
                var115_116 = this.mSyncStatus;
                var116_117 = var104_105.ident;
                var117_118 = var115_116;
                var118_119 = var116_117;
                var119_120 = var107_108;
                var117_118.put(var118_119, var119_120);
            }
            var120_121 = var79_80;
            var121_122 = "totalElapsedTime";
            var107_108.totalElapsedTime = var122_123 = SyncStorageEngine.getLongColumn(var120_121, var121_122);
            var124_124 = var79_80;
            var125_125 = "numSyncs";
            var107_108.numSyncs = var126_126 = SyncStorageEngine.getIntColumn(var124_124, var125_125);
            var127_127 = var79_80;
            var128_128 = "numSourceLocal";
            var107_108.numSourceLocal = var129_129 = SyncStorageEngine.getIntColumn(var127_127, var128_128);
            var130_130 = var79_80;
            var131_131 = "numSourcePoll";
            var107_108.numSourcePoll = var132_132 = SyncStorageEngine.getIntColumn(var130_130, var131_131);
            var133_133 = var79_80;
            var134_134 = "numSourceServer";
            var107_108.numSourceServer = var135_135 = SyncStorageEngine.getIntColumn(var133_133, var134_134);
            var136_136 = var79_80;
            var137_137 = "numSourceUser";
            var107_108.numSourceUser = var138_138 = SyncStorageEngine.getIntColumn(var136_136, var137_137);
            var107_108.numSourcePeriodic = var139_139 = 0;
            var140_140 = var79_80;
            var141_141 = "lastSuccessSource";
            var107_108.lastSuccessSource = var142_142 = SyncStorageEngine.getIntColumn(var140_140, var141_141);
            var143_143 = var79_80;
            var144_144 = "lastSuccessTime";
            var107_108.lastSuccessTime = var145_145 = SyncStorageEngine.getLongColumn(var143_143, var144_144);
            var147_146 = var79_80;
            var148_147 = "lastFailureSource";
            var107_108.lastFailureSource = var149_148 = SyncStorageEngine.getIntColumn(var147_146, var148_147);
            var150_149 = var79_80;
            var151_150 = "lastFailureTime";
            var107_108.lastFailureTime = var152_151 = SyncStorageEngine.getLongColumn(var150_149, var151_150);
            var154_152 = var79_80;
            var155_153 = "lastFailureMesg";
            var156_154 = var154_152.getColumnIndex(var155_153);
            var157_155 = var79_80;
            var158_156 = var156_154;
            var107_108.lastFailureMesg = var159_157 = var157_155.getString(var158_156);
            var160_158 = var79_80;
            var161_159 = "pending";
            var162_160 = SyncStorageEngine.getIntColumn(var160_158, var161_159) != 0;
            var107_108.pending = var163_161 = var162_160;
        }
        var79_80.close();
        var164_162 = new SQLiteQueryBuilder();
        var164_162.setTables("settings");
        var165_163 = var164_162.query(var3_3, null, null, null, null, null, null);
        block4: while (true) {
            if (!var165_163.moveToNext()) {
                var165_163.close();
                var3_3.close();
                var199_197 = var198_196;
                var200_198 = var2_2;
                var199_197(var200_198);
                var201_199 = var198_196.delete();
                return;
            }
            var166_164 = var165_163;
            var167_165 = "name";
            var168_166 = var166_164.getColumnIndex(var167_165);
            var169_167 = var165_163;
            var170_168 = var168_166;
            var171_169 = var169_167.getString(var170_168);
            var172_170 = var165_163;
            var173_171 = "value";
            var174_172 = var172_170.getColumnIndex(var173_171);
            var175_173 = var165_163;
            var176_174 = var174_172;
            var177_175 = var175_173.getString(var176_174);
            if (var171_169 == null) continue;
            var178_176 = var171_169;
            var179_177 = "listen_for_tickles";
            if (var178_176.equals(var179_177)) {
                var180_178 = var177_175 == null || Boolean.parseBoolean(var177_175) != false;
                var181_179 = this;
                var182_180 = var180_178;
                var181_179.setMasterSyncAutomatically(var182_180);
                continue;
            }
            var183_181 = var171_169;
            var184_182 = "sync_provider_";
            if (!var183_181.startsWith(var184_182)) continue;
            var185_183 = "sync_provider_".length();
            var186_184 = var171_169.length();
            var187_185 = var171_169;
            var188_186 = var185_183;
            var189_187 = var186_184;
            var190_188 = var187_185.substring(var188_186, var189_187);
            var191_189 = this.mAuthorities.size();
            while (true) {
                if (var191_189 > 0) ** break;
                continue block4;
                var192_190 = this.mAuthorities;
                var193_191 = var191_189 += -1;
                var194_192 = var192_190.valueAt(var193_191);
                var195_193 = var194_192.authority;
                var196_194 = var190_188;
                if (!var195_193.equals(var196_194)) continue;
                var197_195 = var177_175 == null || Boolean.parseBoolean(var177_175) != false;
                var194_192.enabled = var197_195;
                var194_192.syncable = 1;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPendingOperationsLocked() {
        try {
            byte[] byArray = this.mPendingFile.readFully();
            Parcel parcel = Parcel.obtain();
            int n = byArray.length;
            parcel.unmarshall(byArray, 0, n);
            parcel.setDataPosition(0);
            int n2 = parcel.dataSize();
            while (true) {
                if (parcel.dataPosition() >= n2) {
                    return;
                }
                int n3 = parcel.readInt();
                if (n3 != 2 && n3 != 1) {
                    String string2 = "Unknown pending operation version " + n3 + "; dropping all ops";
                    int n4 = Log.w(TAG, string2);
                    return;
                }
                int n5 = parcel.readInt();
                int n6 = parcel.readInt();
                byte[] byArray2 = parcel.createByteArray();
                boolean bl = n3 == 2 ? parcel.readInt() != 0 : false;
                AuthorityInfo authorityInfo = this.mAuthorities.get(n5);
                if (authorityInfo == null) continue;
                Bundle bundle = null;
                if (byArray2 != null) {
                    bundle = SyncStorageEngine.unflattenBundle(byArray2);
                }
                Account account = authorityInfo.account;
                String string3 = authorityInfo.authority;
                PendingOperation pendingOperation = new PendingOperation(account, n6, string3, bundle, bl);
                pendingOperation.authorityId = n5;
                pendingOperation.flatExtras = byArray2;
                boolean bl2 = this.mPendingOperations.add(pendingOperation);
            }
        }
        catch (IOException iOException) {
            int n = Log.i(TAG, "No initial pending operations");
            return;
        }
    }

    private void readStatisticsLocked() {
        try {
            int n;
            byte[] byArray = this.mStatisticsFile.readFully();
            Parcel parcel = Parcel.obtain();
            int n2 = byArray.length;
            parcel.unmarshall(byArray, 0, n2);
            parcel.setDataPosition(0);
            int n3 = 0;
            while (true) {
                long l;
                int n4;
                long l2;
                int n5;
                if ((n = parcel.readInt()) == 0) {
                    return;
                }
                if (n != 101 && n != 100) break;
                int n6 = parcel.readInt();
                if (n == 100) {
                    n6 = n6 - 2009 + 14245;
                }
                DayStats dayStats = new DayStats(n6);
                dayStats.successCount = n5 = parcel.readInt();
                dayStats.successTime = l2 = parcel.readLong();
                dayStats.failureCount = n4 = parcel.readInt();
                dayStats.failureTime = l = parcel.readLong();
                int n7 = this.mDayStats.length;
                if (n3 >= n7) continue;
                this.mDayStats[n3] = dayStats;
                ++n3;
            }
            String string2 = "Unknown stats token: " + n;
            int n8 = Log.w(TAG, string2);
            return;
        }
        catch (IOException iOException) {
            int n = Log.i(TAG, "No initial statistics");
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readStatusLocked() {
        int n;
        try {
            byte[] byArray = this.mStatusFile.readFully();
            Parcel parcel = Parcel.obtain();
            int n2 = byArray.length;
            parcel.unmarshall(byArray, 0, n2);
            parcel.setDataPosition(0);
            while (true) {
                if ((n = parcel.readInt()) == 0) {
                    return;
                }
                if (n == 100) {
                    SyncStatusInfo syncStatusInfo = new SyncStatusInfo(parcel);
                    SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
                    int n3 = syncStatusInfo.authorityId;
                    if (sparseArray.indexOfKey(n3) < 0) continue;
                    syncStatusInfo.pending = false;
                    SparseArray<SyncStatusInfo> sparseArray2 = this.mSyncStatus;
                    int n4 = syncStatusInfo.authorityId;
                    sparseArray2.put(n4, syncStatusInfo);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            int n5 = Log.i(TAG, "No initial status");
            return;
        }
        {
            String string2 = "Unknown status token: " + n;
            int n6 = Log.w(TAG, string2);
            return;
        }
    }

    private void removeAuthorityLocked(Account account, String string2, boolean bl) {
        AccountInfo accountInfo = this.mAccounts.get(account);
        if (accountInfo == null) {
            return;
        }
        AuthorityInfo authorityInfo = accountInfo.authorities.remove(string2);
        if (authorityInfo == null) {
            return;
        }
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        int n = authorityInfo.ident;
        sparseArray.remove(n);
        if (!bl) {
            return;
        }
        this.writeAccountInfoLocked();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void reportChange(int n) {
        int n2;
        int n3;
        ArrayList<ISyncStatusObserver> arrayList = null;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        ArrayList<ISyncStatusObserver> arrayList2 = null;
        for (n3 = n2 = this.mChangeListeners.beginBroadcast(); n3 > 0; n3 += -1) {
            if (((Integer)this.mChangeListeners.getBroadcastCookie(n3) & n) == 0) continue;
            arrayList = arrayList2 == null ? new ArrayList<ISyncStatusObserver>(n3) : arrayList2;
            ISyncStatusObserver iSyncStatusObserver = this.mChangeListeners.getBroadcastItem(n3);
            boolean bl = arrayList.add(iSyncStatusObserver);
            arrayList2 = arrayList;
        }
        try {
            this.mChangeListeners.finishBroadcast();
            // MONITOREXIT : sparseArray
        }
        catch (Throwable throwable) {
            ArrayList<ISyncStatusObserver> arrayList3 = arrayList2;
            throw throwable;
        }
        if (Log.isLoggable(TAG, 2)) {
            String string2 = "reportChange " + n + " to: " + arrayList2;
            int n4 = Log.v(TAG, string2);
        }
        if (arrayList2 == null) {
            return;
        }
        n3 = arrayList2.size();
        while (n3 > 0) {
            n3 += -1;
            try {
                ((ISyncStatusObserver)arrayList2.get(n3)).onStatusChanged(n);
            }
            catch (RemoteException remoteException) {
            }
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bundle unflattenBundle(byte[] byArray) {
        Bundle bundle;
        Parcel parcel = Parcel.obtain();
        try {
            Bundle bundle2;
            int n = byArray.length;
            parcel.unmarshall(byArray, 0, n);
            parcel.setDataPosition(0);
            bundle = bundle2 = parcel.readBundle();
            return bundle;
        }
        catch (RuntimeException runtimeException) {
            bundle = new Bundle();
            return bundle;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateOrRemovePeriodicSync(Account var1_1, String var2_2, Bundle var3_3, long var4_4, boolean var6_5) {
        block26: {
            if (var4_4 <= 0L) {
                var4_4 = 0L;
            }
            if (var3_3 == null) {
                var3_3 = new Bundle();
            }
            if (Log.isLoggable("SyncManager", 2)) {
                var7_6 = new StringBuilder().append("addOrRemovePeriodicSync: ");
                var8_7 = var1_1;
                var9_8 = var7_6.append(var8_7).append(", provider ");
                var10_9 = var2_2;
                var11_10 = var9_8.append(var10_9).append(" -> period ");
                var12_11 = var4_4;
                var14_12 = var11_10.append(var12_11).append(", extras ");
                var15_13 = var3_3;
                var16_14 = var14_12.append(var15_13).toString();
                var17_15 = Log.v("SyncManager", var16_14);
            }
            var18_16 = this.mAuthorities;
            synchronized (var18_16) {
                block25: {
                    block24: {
                        var19_17 = null;
                        var20_19 = false;
                        var21_20 = this;
                        var22_21 = var1_1;
                        var23_22 = var2_2;
                        var24_23 = var19_17;
                        var25_24 = var20_19;
                        var26_25 = var21_20.getOrCreateAuthorityLocked(var22_21, var23_22, var24_23, var25_24);
                        if (var6_5) {
                            var25_24 = false;
                            var29_28 = var26_25.periodicSyncs.size();
                            break block24;
                        }
                        var61_58 = this.mSyncStatus;
                        var62_59 = var26_25.ident;
                        var63_60 = var61_58.get(var62_59);
                        var60_56 = 0;
                        var65_61 = var26_25.periodicSyncs.iterator();
                        var28_27 = 0;
                        break block25;
                    }
                    for (var28_26 = 0; var28_26 < var29_28; ++var28_26) {
                        var30_29 = var26_25.periodicSyncs.get(var28_26);
                        var31_30 = (Bundle)var30_29.first;
                        var32_31 = var3_3;
                        if (!SyncStorageEngine.equals(var31_30, var32_31)) continue;
                        var33_32 = (Long)var30_29.second;
                        if (var33_32 == var4_4) {
                            this.writeAccountInfoLocked();
                            this.writeStatusLocked();
                            return;
                        }
                        ** try [egrp 2[TRYBLOCK] [2 : 275->432)] { 
lbl52:
                        // 1 sources

                        var35_33 = var26_25.periodicSyncs;
                        var36_34 = var4_4;
                        var37_35 = var3_3;
                        var38_36 = var36_34;
                        var39_37 = Pair.create(var37_35, var38_36);
                        var40_38 = var35_33;
                        var41_39 = var28_26;
                        var42_40 = var39_37;
                        var43_41 = var40_38.set(var41_39, var42_40);
                        var25_24 = true;
                        break;
                    }
                    if (!var25_24) {
                        var44_42 = var26_25.periodicSyncs;
                        var45_43 = var4_4;
                        var46_44 = var3_3;
                        var47_45 = var45_43;
                        var48_46 = Pair.create(var46_44, var47_45);
                        var49_47 = var44_42.add(var48_46);
                        var50_48 = var26_25.ident;
                        var51_49 = this;
                        var52_50 = var50_48;
                        var53_51 = var51_49.getOrCreateSyncStatusLocked(var52_50);
                        var54_52 = var26_25.periodicSyncs.size() - 1;
                        var55_53 = var53_51;
                        var56_54 = var54_52;
                        var57_55 = 0L;
                        var55_53.setPeriodicSyncTime(var56_54, var57_55);
                    }
                    break block26;
lbl80:
                    // 1 sources

                    finally {
                        this.writeAccountInfoLocked();
                        this.writeStatusLocked();
                    }
                }
                while (var65_61.hasNext()) {
                    var66_62 = (Bundle)var65_61.next().first;
                    var67_63 = var3_3;
                    if (SyncStorageEngine.equals(var66_62, var67_63)) {
                        var65_61.remove();
                        var60_56 = 1;
                        if (var63_60 == null) continue;
                        var63_60.removePeriodicSyncTime(var28_27);
                        continue;
                    }
                    ++var28_27;
                }
                if (var60_56 == 0) ** break block27
            }
        }
        var59_57 = this;
        var60_56 = 1;
        var59_57.reportChange(var60_56);
        return;
        {
            this.writeAccountInfoLocked();
            this.writeStatusLocked();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAccountInfoLocked() {
        block11: {
            try {
                var1_1 = this.mAccountInfoFile.startWrite();
                var2_2 = new FastXmlSerializer();
                var2_2.setOutput(var1_1, "utf-8");
                var3_3 = true;
                var2_2.startDocument(null, var3_3);
                var2_2.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                var4_4 = var2_2.startTag(null, "accounts");
                var5_5 = Integer.toString(2);
                var6_6 = var2_2.attribute(null, "version", var5_5);
                var7_7 = Integer.toString(this.mNextAuthorityId);
                var8_8 = var2_2.attribute(null, "nextAuthorityId", var7_7);
                if (!this.mMasterSyncAutomatically) {
                    var9_9 = var2_2.attribute(null, "listen-for-tickles", "false");
                }
                var10_10 = this.mAuthorities.size();
                var11_11 = 0;
lbl17:
                // 2 sources

                while (var11_11 < var10_10) {
                    var12_12 = this.mAuthorities.valueAt(var11_11);
                    var13_13 = var2_2.startTag(null, "authority");
                    var14_14 = Integer.toString(var12_12.ident);
                    var15_15 = var2_2.attribute(null, "id", var14_14);
                    var16_16 = var12_12.account.name;
                    var17_17 = var2_2.attribute(null, "account", var16_16);
                    var18_18 = var12_12.account.type;
                    var19_19 = var2_2.attribute(null, "type", var18_18);
                    var20_20 = var12_12.authority;
                    var21_21 = var2_2.attribute(null, "authority", var20_20);
                    var22_22 = Boolean.toString(var12_12.enabled);
                    var23_23 = var2_2.attribute(null, "enabled", var22_22);
                    if (var12_12.syncable >= 0) break block11;
                    var24_24 = var2_2.attribute(null, "syncable", "unknown");
lbl32:
                    // 2 sources

                    while (true) lbl-1000:
                    // 2 sources

                    {
                        for (Pair<Bundle, Long> var26_26 : var12_12.periodicSyncs) {
                            var27_27 = var2_2.startTag(null, "periodicSync");
                            var28_28 = Long.toString((Long)var26_26.second);
                            var29_29 = var2_2.attribute(null, "period", var28_28);
                            var30_30 = (Bundle)var26_26.first;
                            block6: for (String var32_32 : var30_30.keySet()) {
                                var33_33 = var2_2.startTag(null, "extra");
                                var34_34 = var2_2.attribute(null, "name", var32_32);
                                var35_35 = var30_30.get(var32_32);
                                if (var35_35 instanceof Long) {
                                    var36_36 = var2_2.attribute(null, "type", "long");
                                    var37_37 = var35_35.toString();
                                    var38_38 = var2_2.attribute(null, "value1", var37_37);
lbl46:
                                    // 8 sources

                                    while (true) {
                                        var39_39 = var2_2.endTag(null, "extra");
                                        continue block6;
                                        break;
                                    }
                                }
                                ** GOTO lbl66
                            }
                            ** GOTO lbl103
                        }
                        ** GOTO lbl105
                        break;
                    }
                }
                ** GOTO lbl108
            }
            catch (IOException var40_67) {
                var41_68 = Log.w("SyncManager", "Error writing accounts", var40_67);
                if (var1_1 == null) {
                    return;
                }
                this.mAccountInfoFile.failWrite(var1_1);
                return;
            }
        }
        var42_40 = null;
        {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                var43_41 = "syncable";
                                var44_42 = var12_12.syncable != 0;
                                var45_43 = Boolean.toString(var44_42);
                                var46_44 = var2_2.attribute(var42_40, var43_41, var45_43);
                                ** continue;
lbl66:
                                // 1 sources

                                if (!(var35_35 instanceof Integer)) break block12;
                                var47_45 = var2_2.attribute(null, "type", "integer");
                                var48_46 = var35_35.toString();
                                var49_47 = var2_2.attribute(null, "value1", var48_46);
                                ** GOTO lbl46
                            }
                            if (!(var35_35 instanceof Boolean)) break block13;
                            var50_48 = var2_2.attribute(null, "type", "boolean");
                            var51_49 = var35_35.toString();
                            var52_50 = var2_2.attribute(null, "value1", var51_49);
                            ** GOTO lbl46
                        }
                        if (!(var35_35 instanceof Float)) break block14;
                        var53_51 = var2_2.attribute(null, "type", "float");
                        var54_52 = var35_35.toString();
                        var55_53 = var2_2.attribute(null, "value1", var54_52);
                        ** GOTO lbl46
                    }
                    if (!(var35_35 instanceof Double)) break block15;
                    var56_54 = var2_2.attribute(null, "type", "double");
                    var57_55 = var35_35.toString();
                    var58_56 = var2_2.attribute(null, "value1", var57_55);
                    ** GOTO lbl46
                }
                if (!(var35_35 instanceof String)) break block16;
                var59_57 = var2_2.attribute(null, "type", "string");
                var60_58 = var35_35.toString();
                var61_59 = var2_2.attribute(null, "value1", var60_58);
                ** GOTO lbl46
            }
            if (!(var35_35 instanceof Account)) ** GOTO lbl46
            var62_60 = var2_2.attribute(null, "type", "account");
            var63_61 = ((Account)var35_35).name;
            var64_62 = var2_2.attribute(null, "value1", var63_61);
            var65_63 = ((Account)var35_35).type;
            var66_64 = var2_2.attribute(null, "value2", var65_63);
            ** continue;
lbl103:
            // 1 sources

            var67_65 = var2_2.endTag(null, "periodicSync");
            ** GOTO lbl-1000
lbl105:
            // 1 sources

            var68_66 = var2_2.endTag(null, "authority");
            ++var11_11;
            ** GOTO lbl17
lbl108:
            // 1 sources

            var69_69 = var2_2.endTag(null, "accounts");
            var2_2.endDocument();
            this.mAccountInfoFile.finishWrite(var1_1);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writePendingOperationLocked(PendingOperation pendingOperation, Parcel parcel) {
        parcel.writeInt(2);
        int n = pendingOperation.authorityId;
        parcel.writeInt(n);
        int n2 = pendingOperation.syncSource;
        parcel.writeInt(n2);
        if (pendingOperation.flatExtras == null && pendingOperation.extras != null) {
            byte[] byArray = SyncStorageEngine.flattenBundle(pendingOperation.extras);
            pendingOperation.flatExtras = byArray;
        }
        byte[] byArray = pendingOperation.flatExtras;
        parcel.writeByteArray(byArray);
        int n3 = pendingOperation.expedited ? 1 : 0;
        parcel.writeInt(n3);
    }

    /*
     * Unable to fully structure code
     */
    private void writePendingOperationsLocked() {
        var1_1 = this.mPendingOperations.size();
        var2_2 = null;
        if (var1_1 != 0) ** GOTO lbl7
        try {
            this.mPendingFile.truncate();
            return;
lbl7:
            // 1 sources

            var2_2 = this.mPendingFile.startWrite();
            var3_3 = Parcel.obtain();
            for (var4_4 = 0; var4_4 < var1_1; ++var4_4) {
                var5_5 = this.mPendingOperations.get(var4_4);
                this.writePendingOperationLocked(var5_5, var3_3);
            }
            var6_6 = var3_3.marshall();
            var2_2.write(var6_6);
            var3_3.recycle();
            this.mPendingFile.finishWrite(var2_2);
            return;
        }
        catch (IOException var7_7) {
            var8_8 = Log.w("SyncManager", "Error writing pending operations", var7_7);
            if (var2_2 == null) {
                return;
            }
            this.mPendingFile.failWrite(var2_2);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void writeStatisticsLocked() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void writeStatusLocked() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addPeriodicSync(Account account, String string2, Bundle bundle, long l) {
        SyncStorageEngine syncStorageEngine = this;
        Account account2 = account;
        String string3 = string2;
        Bundle bundle2 = bundle;
        long l2 = l;
        syncStorageEngine.updateOrRemovePeriodicSync(account2, string3, bundle2, l2, true);
    }

    public void addStatusChangeListener(int n, ISyncStatusObserver iSyncStatusObserver) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            RemoteCallbackList<ISyncStatusObserver> remoteCallbackList = this.mChangeListeners;
            Integer n2 = n;
            boolean bl = remoteCallbackList.register(iSyncStatusObserver, n2);
            return;
        }
    }

    public void clearAndReadState() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.mAuthorities.clear();
            this.mAccounts.clear();
            this.mPendingOperations.clear();
            this.mSyncStatus.clear();
            this.mSyncHistory.clear();
            this.readAccountInfoLocked();
            this.readStatusLocked();
            this.readPendingOperationsLocked();
            this.readStatisticsLocked();
            this.readAndDeleteLegacyAccountInfoLocked();
            this.writeAccountInfoLocked();
            this.writeStatusLocked();
            this.writePendingOperationsLocked();
            this.writeStatisticsLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int clearPending() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (Log.isLoggable(TAG, 2)) {
                int n = Log.v(TAG, "clearPending");
            }
            int n = this.mPendingOperations.size();
            this.mPendingOperations.clear();
            int n2 = this.mSyncStatus.size();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    this.writePendingOperationsLocked();
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 4] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.reportChange(2);
                    return n;
                }
                this.mSyncStatus.valueAt((int)n3).pending = false;
                ++n3;
            }
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteFromPending(PendingOperation pendingOperation) {
        boolean bl;
        block13: {
            bl = false;
            SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
            synchronized (sparseArray) {
                if (Log.isLoggable(TAG, 2)) {
                    StringBuilder stringBuilder = new StringBuilder().append("deleteFromPending: account=");
                    Account account = pendingOperation.account;
                    StringBuilder stringBuilder2 = stringBuilder.append(account).append(" auth=");
                    String string2 = pendingOperation.authority;
                    StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(" src=");
                    int n = pendingOperation.syncSource;
                    StringBuilder stringBuilder4 = stringBuilder3.append(n).append(" extras=");
                    Bundle bundle = pendingOperation.extras;
                    String string3 = stringBuilder4.append(bundle).toString();
                    int n2 = Log.v(TAG, string3);
                }
                if (!this.mPendingOperations.remove(pendingOperation)) break block13;
                if (this.mPendingOperations.size() == 0 || this.mNumPendingFinished >= 4) {
                    this.writePendingOperationsLocked();
                    this.mNumPendingFinished = 0;
                } else {
                    int n;
                    this.mNumPendingFinished = n = this.mNumPendingFinished + 1;
                }
                boolean bl2 = true;
                while (true) {
                    int n;
                    block17: {
                        block15: {
                            boolean bl3;
                            AuthorityInfo authorityInfo;
                            block16: {
                                String string4;
                                String string5;
                                int n3;
                                block14: {
                                    if (!bl2 || (bl2 = false)) break block14;
                                    Account account = pendingOperation.account;
                                    String string6 = pendingOperation.authority;
                                    authorityInfo = this.getAuthorityLocked(account, string6, "deleteFromPending");
                                    if (authorityInfo == null) break block15;
                                    if (Log.isLoggable(TAG, 2)) {
                                        String string7 = "removing - " + authorityInfo;
                                        int n4 = Log.v(TAG, string7);
                                    }
                                    n3 = this.mPendingOperations.size();
                                    bl3 = false;
                                    n = 0;
                                }
                                if (n >= n3) break block16;
                                PendingOperation pendingOperation2 = this.mPendingOperations.get(n);
                                Account account = pendingOperation2.account;
                                Account account2 = pendingOperation.account;
                                if (!account.equals(account2) || !(string5 = pendingOperation2.authority).equals(string4 = pendingOperation.authority)) break block17;
                                bl3 = true;
                            }
                            if (!bl3) {
                                if (Log.isLoggable(TAG, 2)) {
                                    int n5 = Log.v(TAG, "no more pending!");
                                }
                                int n6 = authorityInfo.ident;
                                this.getOrCreateSyncStatusLocked((int)n6).pending = false;
                            }
                        }
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
        }
        this.reportChange(2);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDatabaseCleanup(Account[] accountArray) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (Log.isLoggable(TAG, 2)) {
                int n = Log.w(TAG, "Updating for new accounts...");
            }
            SparseArray<AuthorityInfo> sparseArray2 = new SparseArray<AuthorityInfo>();
            Iterator<AccountInfo> iterator = this.mAccounts.values().iterator();
            while (iterator.hasNext()) {
                AccountInfo accountInfo = iterator.next();
                Account account = accountInfo.account;
                if (ArrayUtils.contains(accountArray, account)) continue;
                if (Log.isLoggable(TAG, 2)) {
                    StringBuilder stringBuilder = new StringBuilder().append("Account removed: ");
                    Account account2 = accountInfo.account;
                    String string2 = stringBuilder.append(account2).toString();
                    int n = Log.w(TAG, string2);
                }
                for (AuthorityInfo authorityInfo : accountInfo.authorities.values()) {
                    int n = authorityInfo.ident;
                    sparseArray2.put(n, authorityInfo);
                }
                iterator.remove();
            }
            int n = sparseArray2.size();
            if (n > 0) {
                while (n > 0) {
                    int n2 = sparseArray2.keyAt(n += -1);
                    this.mAuthorities.remove(n2);
                    int n3 = this.mSyncStatus.size();
                    while (n3 > 0) {
                        if (this.mSyncStatus.keyAt(n3 += -1) == n2) continue;
                        SparseArray<SyncStatusInfo> sparseArray3 = this.mSyncStatus;
                        int n4 = this.mSyncStatus.keyAt(n3);
                        sparseArray3.remove(n4);
                    }
                    n3 = this.mSyncHistory.size();
                    while (n3 > 0) {
                        if (this.mSyncHistory.get((int)(n3 += -1)).authorityId == n2) continue;
                        SyncHistoryItem syncHistoryItem = this.mSyncHistory.remove(n3);
                    }
                }
                this.writeAccountInfoLocked();
                this.writeStatusLocked();
                this.writePendingOperationsLocked();
                this.writeStatisticsLocked();
            }
            return;
        }
    }

    public ArrayList<AuthorityInfo> getAuthorities() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mAuthorities.size();
            ArrayList<AuthorityInfo> arrayList = new ArrayList<AuthorityInfo>(n);
            for (int i = 0; i < n; ++i) {
                AuthorityInfo authorityInfo = this.mAuthorities.valueAt(i);
                boolean bl = arrayList.add(authorityInfo);
            }
            return arrayList;
        }
    }

    public AuthorityInfo getAuthority(int n) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.mAuthorities.get(n);
            return authorityInfo;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<Long, Long> getBackoff(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.getAuthorityLocked(account, string2, "getBackoff");
            if (authorityInfo == null) return null;
            if (authorityInfo.backoffTime < 0L) {
                return null;
            }
            Long l = authorityInfo.backoffTime;
            Long l2 = authorityInfo.backoffDelay;
            Pair<Long, Long> pair = Pair.create(l, l2);
            return pair;
        }
    }

    public SyncInfo getCurrentSync() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            SyncInfo syncInfo = this.mCurrentSync;
            return syncInfo;
        }
    }

    public DayStats[] getDayStatistics() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            DayStats[] dayStatsArray = new DayStats[this.mDayStats.length];
            DayStats[] dayStatsArray2 = this.mDayStats;
            int n = dayStatsArray.length;
            System.arraycopy(dayStatsArray2, 0, dayStatsArray, 0, n);
            return dayStatsArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getDelayUntilTime(Account account, String string2) {
        Object object = this.mAuthorities;
        synchronized (object) {
            AuthorityInfo authorityInfo = this.getAuthorityLocked(account, string2, "getDelayUntil");
            if (authorityInfo == null) {
                return (long)((Object)0L);
            }
            long l = authorityInfo.delayUntil;
            return (long)((Object)l);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getInitialSyncFailureTime() {
        Object object = this.mAuthorities;
        synchronized (object) {
            if (!this.mMasterSyncAutomatically) {
                return (long)((Object)0L);
            }
            long l = 0L;
            int n = this.mSyncStatus.size();
            while (n > 0) {
                SyncStatusInfo syncStatusInfo = this.mSyncStatus.valueAt(n += -1);
                SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
                int n2 = syncStatusInfo.authorityId;
                AuthorityInfo authorityInfo = sparseArray.get(n2);
                if (authorityInfo == null || !authorityInfo.enabled || l != 0L && syncStatusInfo.initialFailureTime >= l) continue;
                l = syncStatusInfo.initialFailureTime;
            }
            return (long)((Object)l);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int getIsSyncable(Account var1_1, String var2_2) {
        var3_3 /* !! */  = this.mAuthorities;
        synchronized (var3_3 /* !! */ ) {
            if (var1_1 == null) ** GOTO lbl15
            var4_4 = this.getAuthorityLocked(var1_1, var2_2, "getIsSyncable");
            if (var4_4 == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3 /* !! */ 
                var3_3 /* !! */  = (SparseArray<AuthorityInfo>)-1;
lbl9:
                // 4 sources

                return (int)var3_3 /* !! */ ;
            }
            var5_6 = var4_4.syncable;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3 /* !! */ 
            var3_3 /* !! */  = (SparseArray<AuthorityInfo>)var5_6;
            ** GOTO lbl9
lbl15:
            // 1 sources

            var6_7 = this.mAuthorities.size();
            while (var6_7 > 0) {
                var4_5 = this.mAuthorities.valueAt(var6_7 += -1);
                if (!var4_5.authority.equals(var2_2)) continue;
                var7_8 = var4_5.syncable;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl20 : MonitorExitStatement: MONITOREXIT : var3_3 /* !! */ 
                var3_3 /* !! */  = (SparseArray<AuthorityInfo>)var7_8;
                ** GOTO lbl9
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3 /* !! */ 
            var3_3 /* !! */  = (SparseArray<AuthorityInfo>)-1;
            ** continue;
        }
    }

    public boolean getMasterSyncAutomatically() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            boolean bl = this.mMasterSyncAutomatically;
            return bl;
        }
    }

    public AuthorityInfo getOrCreateAuthority(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, -1, true);
            return authorityInfo;
        }
    }

    public SyncStatusInfo getOrCreateSyncStatus(AuthorityInfo authorityInfo) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = authorityInfo.ident;
            SyncStatusInfo syncStatusInfo = this.getOrCreateSyncStatusLocked(n);
            return syncStatusInfo;
        }
    }

    public int getPendingOperationCount() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mPendingOperations.size();
            return n;
        }
    }

    public ArrayList<PendingOperation> getPendingOperations() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            ArrayList<PendingOperation> arrayList = this.mPendingOperations;
            ArrayList<PendingOperation> arrayList2 = new ArrayList<PendingOperation>(arrayList);
            return arrayList2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<PeriodicSync> getPeriodicSyncs(Account account, String string2) {
        ArrayList<PeriodicSync> arrayList = new ArrayList<PeriodicSync>();
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.getAuthorityLocked(account, string2, "getPeriodicSyncs");
            if (authorityInfo != null) {
                for (Pair<Bundle, Long> pair : authorityInfo.periodicSyncs) {
                    Bundle bundle = (Bundle)pair.first;
                    long l = (Long)pair.second;
                    Account account2 = account;
                    String string3 = string2;
                    PeriodicSync periodicSync = new PeriodicSync(account2, string3, bundle, l);
                    boolean bl = arrayList.add(periodicSync);
                }
            }
            return arrayList;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SyncStatusInfo getStatusByAccountAndAuthority(Account account, String string2) {
        if (account == null) throw new IllegalArgumentException();
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mSyncStatus.size();
            int n2 = 0;
            while (n2 < n) {
                Account account2;
                SyncStatusInfo syncStatusInfo = this.mSyncStatus.valueAt(n2);
                SparseArray<AuthorityInfo> sparseArray2 = this.mAuthorities;
                int n3 = syncStatusInfo.authorityId;
                AuthorityInfo authorityInfo = sparseArray2.get(n3);
                if (authorityInfo != null && authorityInfo.authority.equals(string2) && account.equals(account2 = authorityInfo.account)) {
                    return syncStatusInfo;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getSyncAutomatically(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo;
            if (account != null) {
                AuthorityInfo authorityInfo2 = this.getAuthorityLocked(account, string2, "getSyncAutomatically");
                if (authorityInfo2 == null) return (boolean)null;
                if (!authorityInfo2.enabled) return (boolean)null;
                return (boolean)null;
            }
            int n = this.mAuthorities.size();
            do {
                if (n <= 0) {
                    return (boolean)null;
                }
                authorityInfo = this.mAuthorities.valueAt(n += -1);
            } while (!authorityInfo.authority.equals(string2) || !authorityInfo.enabled);
            return (boolean)null;
        }
    }

    public ArrayList<SyncHistoryItem> getSyncHistory() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mSyncHistory.size();
            ArrayList<SyncHistoryItem> arrayList = new ArrayList<SyncHistoryItem>(n);
            for (int i = 0; i < n; ++i) {
                SyncHistoryItem syncHistoryItem = this.mSyncHistory.get(i);
                boolean bl = arrayList.add(syncHistoryItem);
            }
            return arrayList;
        }
    }

    public ArrayList<SyncStatusInfo> getSyncStatus() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mSyncStatus.size();
            ArrayList<SyncStatusInfo> arrayList = new ArrayList<SyncStatusInfo>(n);
            for (int i = 0; i < n; ++i) {
                SyncStatusInfo syncStatusInfo = this.mSyncStatus.valueAt(i);
                boolean bl = arrayList.add(syncStatusInfo);
            }
            return arrayList;
        }
    }

    @Override
    public void handleMessage(Message message) {
        if (message.what == 1) {
            SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
            synchronized (sparseArray) {
                this.writeStatusLocked();
                return;
            }
        }
        if (message.what != 2) {
            return;
        }
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.writeStatisticsLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PendingOperation insertIntoPending(PendingOperation pendingOperation) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            String string2;
            Account account;
            AuthorityInfo authorityInfo;
            if (Log.isLoggable(TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("insertIntoPending: account=");
                Account account2 = pendingOperation.account;
                StringBuilder stringBuilder2 = stringBuilder.append(account2).append(" auth=");
                String string3 = pendingOperation.authority;
                StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(" src=");
                int n = pendingOperation.syncSource;
                StringBuilder stringBuilder4 = stringBuilder3.append(n).append(" extras=");
                Bundle bundle = pendingOperation.extras;
                String string4 = stringBuilder4.append(bundle).toString();
                int n2 = Log.v(TAG, string4);
            }
            if ((authorityInfo = this.getOrCreateAuthorityLocked(account = pendingOperation.account, string2 = pendingOperation.authority, -1, true)) == null) {
                return null;
            }
            PendingOperation pendingOperation2 = new PendingOperation(pendingOperation);
            try {
                int n;
                pendingOperation2.authorityId = n = authorityInfo.ident;
                boolean bl = this.mPendingOperations.add(pendingOperation2);
                this.appendPendingOperationLocked(pendingOperation2);
                int n3 = authorityInfo.ident;
                this.getOrCreateSyncStatusLocked((int)n3).pending = true;
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl24 : MonitorExitStatement: MONITOREXIT : var2_2
                this.reportChange(2);
                PendingOperation pendingOperation3 = pendingOperation2;
                return pendingOperation2;
            }
            catch (Throwable throwable) {
                PendingOperation pendingOperation4 = pendingOperation2;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insertStartSyncEvent(Account account, String string2, long l, int n) {
        long l2;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n2;
            int n3;
            AuthorityInfo authorityInfo;
            if (Log.isLoggable(TAG, 2)) {
                String string3 = "insertStartSyncEvent: account=" + account + " auth=" + string2 + " source=" + n;
                int n4 = Log.v(TAG, string3);
            }
            if ((authorityInfo = this.getAuthorityLocked(account, string2, "insertStartSyncEvent")) == null) {
                return 65535L;
            }
            SyncHistoryItem syncHistoryItem = new SyncHistoryItem();
            syncHistoryItem.authorityId = n3 = authorityInfo.ident;
            int n5 = this.mNextHistoryId;
            this.mNextHistoryId = n2 = n5 + 1;
            syncHistoryItem.historyId = n5;
            if (this.mNextHistoryId < 0) {
                this.mNextHistoryId = 0;
            }
            syncHistoryItem.eventTime = l;
            syncHistoryItem.source = n;
            syncHistoryItem.event = 0;
            this.mSyncHistory.add(0, syncHistoryItem);
            while (this.mSyncHistory.size() > 100) {
                ArrayList<SyncHistoryItem> arrayList = this.mSyncHistory;
                int n6 = this.mSyncHistory.size() - 1;
                SyncHistoryItem syncHistoryItem2 = arrayList.remove(n6);
            }
            l2 = syncHistoryItem.historyId;
            if (Log.isLoggable(TAG, 2)) {
                String string4 = "returning historyId " + l2;
                int n7 = Log.v(TAG, string4);
            }
        }
        this.reportChange(8);
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSyncActive(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mPendingOperations.size();
            while (n > 0) {
                PendingOperation pendingOperation = this.mPendingOperations.get(n += -1);
                if (!pendingOperation.account.equals(account) || !pendingOperation.authority.equals(string2)) continue;
                return (boolean)null;
            }
            if (this.mCurrentSync == null) return (boolean)null;
            int n2 = this.mCurrentSync.authorityId;
            AuthorityInfo authorityInfo = this.getAuthority(n2);
            if (authorityInfo == null) return (boolean)null;
            if (!authorityInfo.account.equals(account)) return (boolean)null;
            if (!authorityInfo.authority.equals(string2)) return (boolean)null;
            return (boolean)null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSyncPending(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mSyncStatus.size();
            int n2 = 0;
            while (n2 < n) {
                SyncStatusInfo syncStatusInfo = this.mSyncStatus.valueAt(n2);
                SparseArray<AuthorityInfo> sparseArray2 = this.mAuthorities;
                int n3 = syncStatusInfo.authorityId;
                AuthorityInfo authorityInfo = sparseArray2.get(n3);
                if (authorityInfo != null && (account == null || authorityInfo.account.equals(account)) && authorityInfo.authority.equals(string2) && syncStatusInfo.pending) {
                    return (boolean)null;
                }
                ++n2;
            }
            return (boolean)null;
        }
    }

    public void removeAuthority(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.removeAuthorityLocked(account, string2, true);
            return;
        }
    }

    public void removePeriodicSync(Account account, String string2, Bundle bundle) {
        SyncStorageEngine syncStorageEngine = this;
        Account account2 = account;
        String string3 = string2;
        Bundle bundle2 = bundle;
        syncStorageEngine.updateOrRemovePeriodicSync(account2, string3, bundle2, 0L, false);
    }

    public void removeStatusChangeListener(ISyncStatusObserver iSyncStatusObserver) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            boolean bl = this.mChangeListeners.unregister(iSyncStatusObserver);
            return;
        }
    }

    public void reportActiveChange() {
        this.reportChange(4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setActiveSync(SyncManager.ActiveSyncContext activeSyncContext) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (activeSyncContext != null) {
                SyncInfo syncInfo;
                String string2;
                Account account;
                AuthorityInfo authorityInfo;
                if (Log.isLoggable(TAG, 2)) {
                    StringBuilder stringBuilder = new StringBuilder().append("setActiveSync: account=");
                    Account account2 = activeSyncContext.mSyncOperation.account;
                    StringBuilder stringBuilder2 = stringBuilder.append(account2).append(" auth=");
                    String string3 = activeSyncContext.mSyncOperation.authority;
                    StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(" src=");
                    int n = activeSyncContext.mSyncOperation.syncSource;
                    StringBuilder stringBuilder4 = stringBuilder3.append(n).append(" extras=");
                    Bundle bundle = activeSyncContext.mSyncOperation.extras;
                    String string4 = stringBuilder4.append(bundle).toString();
                    int n2 = Log.v(TAG, string4);
                }
                if (this.mCurrentSync != null) {
                    int n = Log.w(TAG, "setActiveSync called with existing active sync!");
                }
                if ((authorityInfo = this.getAuthorityLocked(account = activeSyncContext.mSyncOperation.account, string2 = activeSyncContext.mSyncOperation.authority, "setActiveSync")) == null) {
                    return;
                }
                int n = authorityInfo.ident;
                Account account3 = authorityInfo.account;
                String string5 = authorityInfo.authority;
                long l = activeSyncContext.mStartTime;
                this.mCurrentSync = syncInfo = new SyncInfo(n, account3, string5, l);
            } else {
                if (Log.isLoggable(TAG, 2)) {
                    int n = Log.v(TAG, "setActiveSync: null");
                }
                this.mCurrentSync = null;
            }
        }
        this.reportChange(4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setBackoff(Account account, String string2, long l, long l2) {
        if (Log.isLoggable(TAG, 2)) {
            String string3 = "setBackoff: " + account + ", provider " + string2 + " -> nextSyncTime " + l + ", nextDelay " + l2;
            int n = Log.v(TAG, string3);
        }
        boolean bl = false;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        if (account == null || string2 == null) {
            for (AccountInfo accountInfo : this.mAccounts.values()) {
                Account account2;
                if (account != null && !account.equals(account2 = accountInfo.account)) continue;
                for (AuthorityInfo authorityInfo : accountInfo.authorities.values()) {
                    String string4;
                    if (string2 != null && !string2.equals(string4 = authorityInfo.authority) || authorityInfo.backoffTime == l && authorityInfo.backoffDelay == l2) continue;
                    authorityInfo.backoffTime = l;
                    authorityInfo.backoffDelay = l2;
                    bl = true;
                }
            }
        } else {
            AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, -1, true);
            if (authorityInfo.backoffTime == l && authorityInfo.backoffDelay == l2) {
                // MONITOREXIT : sparseArray
                return;
            }
            authorityInfo.backoffTime = l;
            authorityInfo.backoffDelay = l2;
            bl = true;
        }
        // MONITOREXIT : sparseArray
        if (!bl) {
            return;
        }
        this.reportChange(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDelayUntilTime(Account account, String string2, long l) {
        if (Log.isLoggable(TAG, 2)) {
            String string3 = "setDelayUntil: " + account + ", provider " + string2 + " -> delayUntil " + l;
            int n = Log.v(TAG, string3);
        }
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = null;
            boolean bl = true;
            AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, n, bl);
            if (authorityInfo.delayUntil == l) {
                return;
            }
            authorityInfo.delayUntil = l;
        }
        this.reportChange(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setIsSyncable(Account account, String string2, int n) {
        SparseArray<AuthorityInfo> sparseArray = null;
        String string3 = TAG;
        if (n > 1) {
            n = 1;
        } else if (n < -1) {
            n = -1;
        }
        String string4 = "setIsSyncable: " + account + ", provider " + string2 + " -> " + n;
        int n2 = Log.d(TAG, string4);
        sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        int n3 = null;
        string3 = null;
        AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, n3, (boolean)string3);
        if (authorityInfo.syncable != n) {
            String string5 = "setIsSyncable: already set to " + n + ", doing nothing";
            int n4 = Log.d(TAG, string5);
            // MONITOREXIT : sparseArray
            return;
        }
        authorityInfo.syncable = n;
        this.writeAccountInfoLocked();
        // MONITOREXIT : sparseArray
        if (n > 0) {
            Bundle bundle = new Bundle();
            ContentResolver.requestSync(account, string2, bundle);
        }
        this.reportChange(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setMasterSyncAutomatically(boolean bl) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        if (this.mMasterSyncAutomatically != bl) {
            // MONITOREXIT : sparseArray
            return;
        }
        this.mMasterSyncAutomatically = bl;
        this.writeAccountInfoLocked();
        // MONITOREXIT : sparseArray
        if (bl) {
            Bundle bundle = new Bundle();
            ContentResolver.requestSync(null, null, bundle);
        }
        this.reportChange(1);
        Context context = this.mContext;
        Intent intent = SYNC_CONNECTION_SETTING_CHANGED_INTENT;
        context.sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setSyncAutomatically(Account account, String string2, boolean bl) {
        String string3 = "setSyncAutomatically: , provider " + string2 + " -> " + bl;
        int n = Log.d(TAG, string3);
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        Object var7_7 = null;
        AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, -1, false);
        if (authorityInfo.enabled != bl) {
            String string4 = "setSyncAutomatically: already set to " + bl + ", doing nothing";
            int n2 = Log.d(TAG, string4);
            // MONITOREXIT : sparseArray
            return;
        }
        authorityInfo.enabled = bl;
        this.writeAccountInfoLocked();
        // MONITOREXIT : sparseArray
        if (bl) {
            Bundle bundle = new Bundle();
            ContentResolver.requestSync(account, string2, bundle);
        }
        this.reportChange(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopSyncEvent(long l, long l2, String string2, long l3, long l4) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            long l5;
            int n;
            long l6;
            long l7;
            String string3;
            long l8;
            if (Log.isLoggable(TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("stopSyncEvent: historyId=");
                long l9 = l;
                String string4 = stringBuilder.append(l9).toString();
                int n2 = Log.v(TAG, string4);
            }
            SyncHistoryItem syncHistoryItem = null;
            int n3 = this.mSyncHistory.size();
            while (true) {
                block34: {
                    block33: {
                        if (n3 <= 0) break block33;
                        syncHistoryItem = this.mSyncHistory.get(n3 += -1);
                        if ((long)syncHistoryItem.historyId != l) break block34;
                    }
                    if (syncHistoryItem != null) break;
                    StringBuilder stringBuilder = new StringBuilder().append("stopSyncEvent: no history for id ");
                    long l10 = l;
                    String string5 = stringBuilder.append(l10).toString();
                    int n4 = Log.w(TAG, string5);
                    return;
                }
                syncHistoryItem = null;
            }
            syncHistoryItem.elapsedTime = l8 = l2;
            syncHistoryItem.event = 1;
            syncHistoryItem.mesg = string3 = string2;
            syncHistoryItem.downstreamActivity = l7 = l3;
            syncHistoryItem.upstreamActivity = l6 = l4;
            int n5 = syncHistoryItem.authorityId;
            SyncStorageEngine syncStorageEngine = this;
            int n6 = n5;
            SyncStatusInfo syncStatusInfo = syncStorageEngine.getOrCreateSyncStatusLocked(n6);
            syncStatusInfo.numSyncs = n = syncStatusInfo.numSyncs + 1;
            syncStatusInfo.totalElapsedTime = l5 = syncStatusInfo.totalElapsedTime + l2;
            switch (syncHistoryItem.source) {
                case 1: {
                    int n7;
                    syncStatusInfo.numSourceLocal = n7 = syncStatusInfo.numSourceLocal + 1;
                    break;
                }
                case 2: {
                    int n8;
                    syncStatusInfo.numSourcePoll = n8 = syncStatusInfo.numSourcePoll + 1;
                    break;
                }
                case 3: {
                    int n9;
                    syncStatusInfo.numSourceUser = n9 = syncStatusInfo.numSourceUser + 1;
                    break;
                }
                case 0: {
                    int n10;
                    syncStatusInfo.numSourceServer = n10 = syncStatusInfo.numSourceServer + 1;
                    break;
                }
                case 4: {
                    int n11;
                    syncStatusInfo.numSourcePeriodic = n11 = syncStatusInfo.numSourcePeriodic + 1;
                }
            }
            boolean bl = false;
            int n12 = this.getCurrentDayLocked();
            if (this.mDayStats[0] == null) {
                DayStats dayStats;
                DayStats[] dayStatsArray = this.mDayStats;
                DayStats dayStats2 = dayStats;
                int n13 = n12;
                dayStats2(n13);
                dayStatsArray[0] = dayStats;
            } else {
                int n14 = this.mDayStats[0].day;
                if (n12 != n14) {
                    DayStats dayStats;
                    DayStats[] dayStatsArray = this.mDayStats;
                    DayStats[] dayStatsArray2 = this.mDayStats;
                    int n15 = this.mDayStats.length - 1;
                    System.arraycopy(dayStatsArray, 0, dayStatsArray2, 1, n15);
                    DayStats[] dayStatsArray3 = this.mDayStats;
                    DayStats dayStats3 = dayStats;
                    int n16 = n12;
                    dayStats3(n16);
                    dayStatsArray3[0] = dayStats;
                    bl = true;
                } else if (this.mDayStats[0] == null) {
                    // empty if block
                }
            }
            DayStats dayStats = this.mDayStats[0];
            long l11 = syncHistoryItem.eventTime + l2;
            boolean bl2 = false;
            String string6 = MESG_SUCCESS;
            String string7 = string2;
            if (string6.equals(string7)) {
                long l12;
                int n17;
                int n18;
                if (syncStatusInfo.lastSuccessTime == 0L || syncStatusInfo.lastFailureTime != 0L) {
                    bl2 = true;
                }
                syncStatusInfo.lastSuccessTime = l11;
                syncStatusInfo.lastSuccessSource = n18 = syncHistoryItem.source;
                syncStatusInfo.lastFailureTime = 0L;
                syncStatusInfo.lastFailureSource = -1;
                syncStatusInfo.lastFailureMesg = null;
                syncStatusInfo.initialFailureTime = 0L;
                dayStats.successCount = n17 = dayStats.successCount + 1;
                dayStats.successTime = l12 = dayStats.successTime + l2;
            } else {
                String string8 = MESG_CANCELED;
                String string9 = string2;
                if (!string8.equals(string9)) {
                    long l13;
                    int n19;
                    String string10;
                    int n20;
                    if (syncStatusInfo.lastFailureTime == 0L) {
                        bl2 = true;
                    }
                    syncStatusInfo.lastFailureTime = l11;
                    syncStatusInfo.lastFailureSource = n20 = syncHistoryItem.source;
                    syncStatusInfo.lastFailureMesg = string10 = string2;
                    if (syncStatusInfo.initialFailureTime == 0L) {
                        syncStatusInfo.initialFailureTime = l11;
                    }
                    dayStats.failureCount = n19 = dayStats.failureCount + 1;
                    dayStats.failureTime = l13 = dayStats.failureTime + l2;
                }
            }
            if (bl2) {
                this.writeStatusLocked();
            } else {
                SyncStorageEngine syncStorageEngine2 = this;
                int n21 = 1;
                if (!syncStorageEngine2.hasMessages(n21)) {
                    SyncStorageEngine syncStorageEngine3 = this;
                    int n22 = 1;
                    Message message = syncStorageEngine3.obtainMessage(n22);
                    SyncStorageEngine syncStorageEngine4 = this;
                    Message message2 = message;
                    long l14 = 600000L;
                    boolean bl3 = syncStorageEngine4.sendMessageDelayed(message2, l14);
                }
            }
            if (bl) {
                this.writeStatisticsLocked();
            } else {
                SyncStorageEngine syncStorageEngine5 = this;
                int n23 = 2;
                if (!syncStorageEngine5.hasMessages(n23)) {
                    SyncStorageEngine syncStorageEngine6 = this;
                    int n24 = 2;
                    Message message = syncStorageEngine6.obtainMessage(n24);
                    SyncStorageEngine syncStorageEngine7 = this;
                    Message message3 = message;
                    long l15 = 1800000L;
                    boolean bl4 = syncStorageEngine7.sendMessageDelayed(message3, l15);
                }
            }
        }
        SyncStorageEngine syncStorageEngine = this;
        int n = 8;
        syncStorageEngine.reportChange(n);
    }

    public void writeAllState() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (this.mNumPendingFinished > 0) {
                this.writePendingOperationsLocked();
            }
            this.writeStatusLocked();
            this.writeStatisticsLocked();
            return;
        }
    }

    public static class DayStats {
        public final int day;
        public int failureCount;
        public long failureTime;
        public int successCount;
        public long successTime;

        public DayStats(int n) {
            this.day = n;
        }
    }

    public static class SyncHistoryItem {
        int authorityId;
        long downstreamActivity;
        long elapsedTime;
        int event;
        long eventTime;
        int historyId;
        String mesg;
        int source;
        long upstreamActivity;
    }

    public static class AuthorityInfo {
        final Account account;
        final String authority;
        long backoffDelay;
        long backoffTime;
        long delayUntil;
        boolean enabled;
        final int ident;
        final ArrayList<Pair<Bundle, Long>> periodicSyncs;
        int syncable;

        AuthorityInfo(Account account, String string2, int n) {
            this.account = account;
            this.authority = string2;
            this.ident = n;
            this.enabled = false;
            this.syncable = -1;
            this.backoffTime = 65535L;
            this.backoffDelay = 65535L;
            ArrayList arrayList = new ArrayList();
            ArrayList<Pair<Bundle, Long>> arrayList2 = this.periodicSyncs = arrayList;
            Bundle bundle = new Bundle();
            Long l = 86400L;
            Pair<Bundle, Long> pair = Pair.create(bundle, l);
            boolean bl = arrayList2.add(pair);
        }
    }

    static class AccountInfo {
        final Account account;
        final HashMap<String, AuthorityInfo> authorities;

        AccountInfo(Account account) {
            HashMap hashMap = new HashMap();
            this.authorities = hashMap;
            this.account = account;
        }
    }

    public static class PendingOperation {
        final Account account;
        final String authority;
        int authorityId;
        final boolean expedited;
        final Bundle extras;
        byte[] flatExtras;
        final int syncSource;

        /*
         * Enabled aggressive block sorting
         */
        PendingOperation(Account account, int n, String string2, Bundle bundle, boolean bl) {
            this.account = account;
            this.syncSource = n;
            this.authority = string2;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : bundle;
            this.extras = bundle2;
            this.expedited = bl;
            this.authorityId = -1;
        }

        PendingOperation(PendingOperation pendingOperation) {
            boolean bl;
            int n;
            Bundle bundle;
            String string2;
            int n2;
            Account account;
            this.account = account = pendingOperation.account;
            this.syncSource = n2 = pendingOperation.syncSource;
            this.authority = string2 = pendingOperation.authority;
            this.extras = bundle = pendingOperation.extras;
            this.authorityId = n = pendingOperation.authorityId;
            this.expedited = bl = pendingOperation.expedited;
        }
    }
}

