/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Printer;
import java.text.Collator;
import java.util.Comparator;

public class ApplicationInfo
extends PackageItemInfo
implements Parcelable {
    public static final Parcelable.Creator<ApplicationInfo> CREATOR = new Parcelable.Creator<ApplicationInfo>(){

        @Override
        public ApplicationInfo createFromParcel(Parcel parcel) {
            return new ApplicationInfo(parcel);
        }

        public ApplicationInfo[] newArray(int n) {
            return new ApplicationInfo[n];
        }
    };
    public static final int FLAG_ALLOW_BACKUP = 32768;
    public static final int FLAG_ALLOW_CLEAR_USER_DATA = 64;
    public static final int FLAG_ALLOW_TASK_REPARENTING = 32;
    public static final int FLAG_CANT_SAVE_STATE = 0x8000000;
    public static final int FLAG_DEBUGGABLE = 2;
    public static final int FLAG_EXTERNAL_STORAGE = 262144;
    public static final int FLAG_FACTORY_TEST = 16;
    public static final int FLAG_FORWARD_LOCK = 0x20000000;
    public static final int FLAG_HAS_CODE = 4;
    public static final int FLAG_KILL_AFTER_RESTORE = 65536;
    public static final int FLAG_NEVER_ENCRYPT = 0x40000000;
    public static final int FLAG_PERSISTENT = 8;
    public static final int FLAG_RESIZEABLE_FOR_SCREENS = 4096;
    public static final int FLAG_RESTORE_ANY_VERSION = 131072;
    public static final int FLAG_SUPPORTS_LARGE_SCREENS = 2048;
    public static final int FLAG_SUPPORTS_NORMAL_SCREENS = 1024;
    public static final int FLAG_SUPPORTS_SCREEN_DENSITIES = 8192;
    public static final int FLAG_SUPPORTS_SMALL_SCREENS = 512;
    public static final int FLAG_SUPPORTS_XLARGE_SCREENS = 524288;
    public static final int FLAG_SYSTEM = 1;
    public static final int FLAG_TEST_ONLY = 256;
    public static final int FLAG_UPDATED_SYSTEM_APP = 128;
    public static final int FLAG_VM_SAFE_MODE = 16384;
    public String backupAgentName;
    public String className;
    public String dataDir;
    public int descriptionRes;
    public boolean enabled = true;
    public int flags = 0;
    public int installLocation = -1;
    public String manageSpaceActivityName;
    public String nativeLibraryDir;
    public String permission;
    public String processName;
    public String publicSourceDir;
    public String[] resourceDirs;
    public String[] sharedLibraryFiles;
    public String sourceDir;
    public int targetSdkVersion;
    public String taskAffinity;
    public int theme;
    public int uid;

    public ApplicationInfo() {
    }

    public ApplicationInfo(ApplicationInfo applicationInfo) {
        super(applicationInfo);
        int n;
        String string2;
        int n2;
        boolean bl;
        int n3;
        int n4;
        String string3;
        String[] stringArray;
        String[] stringArray2;
        String string4;
        String string5;
        String string6;
        int n5;
        int n6;
        String string7;
        String string8;
        String string9;
        String string10;
        this.taskAffinity = string10 = applicationInfo.taskAffinity;
        this.permission = string9 = applicationInfo.permission;
        this.processName = string8 = applicationInfo.processName;
        this.className = string7 = applicationInfo.className;
        this.theme = n6 = applicationInfo.theme;
        this.flags = n5 = applicationInfo.flags;
        this.sourceDir = string6 = applicationInfo.sourceDir;
        this.publicSourceDir = string5 = applicationInfo.publicSourceDir;
        this.nativeLibraryDir = string4 = applicationInfo.nativeLibraryDir;
        this.resourceDirs = stringArray2 = applicationInfo.resourceDirs;
        this.sharedLibraryFiles = stringArray = applicationInfo.sharedLibraryFiles;
        this.dataDir = string3 = applicationInfo.dataDir;
        this.uid = n4 = applicationInfo.uid;
        this.targetSdkVersion = n3 = applicationInfo.targetSdkVersion;
        this.enabled = bl = applicationInfo.enabled;
        this.installLocation = n2 = applicationInfo.installLocation;
        this.manageSpaceActivityName = string2 = applicationInfo.manageSpaceActivityName;
        this.descriptionRes = n = applicationInfo.descriptionRes;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ApplicationInfo(Parcel parcel) {
        super(parcel);
        int n;
        String string2;
        String string3;
        int n2;
        int n3;
        int n4;
        String string4;
        String string5;
        String string6;
        String string7;
        int n5;
        int n6;
        String string8;
        String string9;
        String string10;
        String string11;
        this.taskAffinity = string11 = parcel.readString();
        this.permission = string10 = parcel.readString();
        this.processName = string9 = parcel.readString();
        this.className = string8 = parcel.readString();
        this.theme = n6 = parcel.readInt();
        this.flags = n5 = parcel.readInt();
        this.sourceDir = string7 = parcel.readString();
        this.publicSourceDir = string6 = parcel.readString();
        this.nativeLibraryDir = string5 = parcel.readString();
        String[] stringArray = parcel.readStringArray();
        this.resourceDirs = stringArray;
        String[] stringArray2 = parcel.readStringArray();
        this.sharedLibraryFiles = stringArray2;
        this.dataDir = string4 = parcel.readString();
        this.uid = n4 = parcel.readInt();
        this.targetSdkVersion = n3 = parcel.readInt();
        boolean bl = parcel.readInt() != 0;
        this.enabled = bl;
        this.installLocation = n2 = parcel.readInt();
        this.manageSpaceActivityName = string3 = parcel.readString();
        this.backupAgentName = string2 = parcel.readString();
        this.descriptionRes = n = parcel.readInt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPackageUnavailable(PackageManager packageManager) {
        try {
            String string2 = this.packageName;
            PackageInfo packageInfo = packageManager.getPackageInfo(string2, 0);
            if (packageInfo != null) return false;
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return true;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void disableCompatibilityMode() {
        int n;
        this.flags = n = this.flags | 0x83E00;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dump(Printer printer, String string2) {
        super.dumpFront(printer, string2);
        if (this.className != null) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("className=");
            String string3 = this.className;
            String string4 = stringBuilder.append(string3).toString();
            printer.println(string4);
        }
        if (this.permission != null) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("permission=");
            String string5 = this.permission;
            String string6 = stringBuilder.append(string5).toString();
            printer.println(string6);
        }
        StringBuilder stringBuilder = new StringBuilder().append(string2).append("processName=");
        String string7 = this.processName;
        String string8 = stringBuilder.append(string7).toString();
        printer.println(string8);
        StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("taskAffinity=");
        String string9 = this.taskAffinity;
        String string10 = stringBuilder2.append(string9).toString();
        printer.println(string10);
        StringBuilder stringBuilder3 = new StringBuilder().append(string2).append("uid=");
        int n = this.uid;
        StringBuilder stringBuilder4 = stringBuilder3.append(n).append(" flags=0x");
        String string11 = Integer.toHexString(this.flags);
        StringBuilder stringBuilder5 = stringBuilder4.append(string11).append(" theme=0x");
        String string12 = Integer.toHexString(this.theme);
        String string13 = stringBuilder5.append(string12).toString();
        printer.println(string13);
        StringBuilder stringBuilder6 = new StringBuilder().append(string2).append("sourceDir=");
        String string14 = this.sourceDir;
        String string15 = stringBuilder6.append(string14).toString();
        printer.println(string15);
        if (this.sourceDir == null) {
            if (this.publicSourceDir != null) {
                StringBuilder stringBuilder7 = new StringBuilder().append(string2).append("publicSourceDir=");
                String string16 = this.publicSourceDir;
                String string17 = stringBuilder7.append(string16).toString();
                printer.println(string17);
            }
        } else {
            String string18 = this.sourceDir;
            String string19 = this.publicSourceDir;
            if (!string18.equals(string19)) {
                StringBuilder stringBuilder8 = new StringBuilder().append(string2).append("publicSourceDir=");
                String string20 = this.publicSourceDir;
                String string21 = stringBuilder8.append(string20).toString();
                printer.println(string21);
            }
        }
        if (this.resourceDirs != null) {
            StringBuilder stringBuilder9 = new StringBuilder().append(string2).append("resourceDirs=");
            String[] stringArray = this.resourceDirs;
            String string22 = stringBuilder9.append(stringArray).toString();
            printer.println(string22);
        }
        StringBuilder stringBuilder10 = new StringBuilder().append(string2).append("dataDir=");
        String string23 = this.dataDir;
        String string24 = stringBuilder10.append(string23).toString();
        printer.println(string24);
        if (this.sharedLibraryFiles != null) {
            StringBuilder stringBuilder11 = new StringBuilder().append(string2).append("sharedLibraryFiles=");
            String[] stringArray = this.sharedLibraryFiles;
            String string25 = stringBuilder11.append(stringArray).toString();
            printer.println(string25);
        }
        StringBuilder stringBuilder12 = new StringBuilder().append(string2).append("enabled=");
        boolean bl = this.enabled;
        StringBuilder stringBuilder13 = stringBuilder12.append(bl).append(" targetSdkVersion=");
        int n2 = this.targetSdkVersion;
        String string26 = stringBuilder13.append(n2).toString();
        printer.println(string26);
        if (this.manageSpaceActivityName != null) {
            StringBuilder stringBuilder14 = new StringBuilder().append(string2).append("manageSpaceActivityName=");
            String string27 = this.manageSpaceActivityName;
            String string28 = stringBuilder14.append(string27).toString();
            printer.println(string28);
        }
        if (this.descriptionRes != 0) {
            StringBuilder stringBuilder15 = new StringBuilder().append(string2).append("description=0x");
            String string29 = Integer.toHexString(this.descriptionRes);
            String string30 = stringBuilder15.append(string29).toString();
            printer.println(string30);
        }
        super.dumpBack(printer, string2);
    }

    @Override
    protected ApplicationInfo getApplicationInfo() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Drawable loadDefaultIcon(PackageManager packageManager) {
        if ((this.flags & 0x40000) == 0) return packageManager.getDefaultActivityIcon();
        if (!this.isPackageUnavailable(packageManager)) return packageManager.getDefaultActivityIcon();
        return Resources.getSystem().getDrawable(17302245);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence loadDescription(PackageManager packageManager) {
        if (this.descriptionRes == 0) return null;
        String string2 = this.packageName;
        int n = this.descriptionRes;
        CharSequence charSequence = packageManager.getText(string2, n, this);
        if (charSequence == null) return null;
        return charSequence;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("ApplicationInfo{");
        String string2 = Integer.toHexString(System.identityHashCode(this));
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
        String string3 = this.packageName;
        return stringBuilder2.append(string3).append("}").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        String string2 = this.taskAffinity;
        parcel.writeString(string2);
        String string3 = this.permission;
        parcel.writeString(string3);
        String string4 = this.processName;
        parcel.writeString(string4);
        String string5 = this.className;
        parcel.writeString(string5);
        int n2 = this.theme;
        parcel.writeInt(n2);
        int n3 = this.flags;
        parcel.writeInt(n3);
        String string6 = this.sourceDir;
        parcel.writeString(string6);
        String string7 = this.publicSourceDir;
        parcel.writeString(string7);
        String string8 = this.nativeLibraryDir;
        parcel.writeString(string8);
        String[] stringArray = this.resourceDirs;
        parcel.writeStringArray(stringArray);
        String[] stringArray2 = this.sharedLibraryFiles;
        parcel.writeStringArray(stringArray2);
        String string9 = this.dataDir;
        parcel.writeString(string9);
        int n4 = this.uid;
        parcel.writeInt(n4);
        int n5 = this.targetSdkVersion;
        parcel.writeInt(n5);
        int n6 = this.enabled ? 1 : 0;
        parcel.writeInt(n6);
        int n7 = this.installLocation;
        parcel.writeInt(n7);
        String string10 = this.manageSpaceActivityName;
        parcel.writeString(string10);
        String string11 = this.backupAgentName;
        parcel.writeString(string11);
        int n8 = this.descriptionRes;
        parcel.writeInt(n8);
    }

    public static class DisplayNameComparator
    implements Comparator<ApplicationInfo> {
        private PackageManager mPM;
        private final Collator sCollator;

        public DisplayNameComparator(PackageManager packageManager) {
            Collator collator;
            this.sCollator = collator = Collator.getInstance();
            this.mPM = packageManager;
        }

        @Override
        public final int compare(ApplicationInfo applicationInfo, ApplicationInfo applicationInfo2) {
            CharSequence charSequence;
            CharSequence charSequence2 = this.mPM.getApplicationLabel(applicationInfo);
            if (charSequence2 == null) {
                charSequence2 = applicationInfo.packageName;
            }
            if ((charSequence = this.mPM.getApplicationLabel(applicationInfo2)) == null) {
                charSequence = applicationInfo2.packageName;
            }
            Collator collator = this.sCollator;
            String string2 = ((Object)charSequence2).toString();
            String string3 = ((Object)charSequence).toString();
            return collator.compare(string2, string3);
        }
    }
}

