/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.util.Printer;

public class ComponentInfo
extends PackageItemInfo {
    public ApplicationInfo applicationInfo;
    public int descriptionRes;
    public boolean enabled = true;
    public boolean exported = false;
    public String processName;

    public ComponentInfo() {
    }

    public ComponentInfo(ComponentInfo componentInfo) {
        super(componentInfo);
        boolean bl;
        boolean bl2;
        int n;
        String string2;
        ApplicationInfo applicationInfo;
        this.applicationInfo = applicationInfo = componentInfo.applicationInfo;
        this.processName = string2 = componentInfo.processName;
        this.descriptionRes = n = componentInfo.descriptionRes;
        this.enabled = bl2 = componentInfo.enabled;
        this.exported = bl = componentInfo.exported;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ComponentInfo(Parcel parcel) {
        super(parcel);
        int n;
        String string2;
        ApplicationInfo applicationInfo;
        this.applicationInfo = applicationInfo = ApplicationInfo.CREATOR.createFromParcel(parcel);
        this.processName = string2 = parcel.readString();
        this.descriptionRes = n = parcel.readInt();
        boolean bl = parcel.readInt() != 0;
        this.enabled = bl;
        boolean bl2 = parcel.readInt() != 0;
        this.exported = bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dumpBack(Printer printer, String string2) {
        if (this.applicationInfo != null) {
            String string3 = string2 + "ApplicationInfo:";
            printer.println(string3);
            ApplicationInfo applicationInfo = this.applicationInfo;
            String string4 = string2 + "  ";
            applicationInfo.dump(printer, string4);
        } else {
            String string5 = string2 + "ApplicationInfo: null";
            printer.println(string5);
        }
        super.dumpBack(printer, string2);
    }

    @Override
    protected void dumpFront(Printer printer, String string2) {
        super.dumpFront(printer, string2);
        StringBuilder stringBuilder = new StringBuilder().append(string2).append("enabled=");
        boolean bl = this.enabled;
        StringBuilder stringBuilder2 = stringBuilder.append(bl).append(" exported=");
        boolean bl2 = this.exported;
        StringBuilder stringBuilder3 = stringBuilder2.append(bl2).append(" processName=");
        String string3 = this.processName;
        String string4 = stringBuilder3.append(string3).toString();
        printer.println(string4);
        if (this.descriptionRes == 0) {
            return;
        }
        StringBuilder stringBuilder4 = new StringBuilder().append(string2).append("description=");
        int n = this.descriptionRes;
        String string5 = stringBuilder4.append(n).toString();
        printer.println(string5);
    }

    @Override
    protected ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getIconResource() {
        if (this.icon == 0) return this.applicationInfo.icon;
        return this.icon;
    }

    @Override
    protected Drawable loadDefaultIcon(PackageManager packageManager) {
        return this.applicationInfo.loadIcon(packageManager);
    }

    @Override
    protected Drawable loadDefaultLogo(PackageManager packageManager) {
        return this.applicationInfo.loadLogo(packageManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence loadLabel(PackageManager packageManager) {
        int n;
        String string2;
        CharSequence charSequence;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        ApplicationInfo applicationInfo = this.applicationInfo;
        if (this.labelRes != 0 && (charSequence = packageManager.getText(string2 = this.packageName, n = this.labelRes, applicationInfo)) != null) {
            return charSequence;
        }
        if (applicationInfo.nonLocalizedLabel != null) {
            return applicationInfo.nonLocalizedLabel;
        }
        if (applicationInfo.labelRes == 0) return this.name;
        String string3 = this.packageName;
        int n2 = applicationInfo.labelRes;
        charSequence = packageManager.getText(string3, n2, applicationInfo);
        if (charSequence == null) return this.name;
        return charSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        this.applicationInfo.writeToParcel(parcel, n);
        String string2 = this.processName;
        parcel.writeString(string2);
        int n2 = this.descriptionRes;
        parcel.writeInt(n2);
        int n3 = this.enabled ? 1 : 0;
        parcel.writeInt(n3);
        int n4 = this.exported ? 1 : 0;
        parcel.writeInt(n4);
    }
}

