/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class LabeledIntent
extends Intent {
    public static final Parcelable.Creator<LabeledIntent> CREATOR = new Parcelable.Creator<LabeledIntent>(){

        @Override
        public LabeledIntent createFromParcel(Parcel parcel) {
            return new LabeledIntent(parcel);
        }

        public LabeledIntent[] newArray(int n) {
            return new LabeledIntent[n];
        }
    };
    private int mIcon;
    private int mLabelRes;
    private CharSequence mNonLocalizedLabel;
    private String mSourcePackage;

    public LabeledIntent(Intent intent, String string2, int n, int n2) {
        super(intent);
        this.mSourcePackage = string2;
        this.mLabelRes = n;
        this.mNonLocalizedLabel = null;
        this.mIcon = n2;
    }

    public LabeledIntent(Intent intent, String string2, CharSequence charSequence, int n) {
        super(intent);
        this.mSourcePackage = string2;
        this.mLabelRes = 0;
        this.mNonLocalizedLabel = charSequence;
        this.mIcon = n;
    }

    protected LabeledIntent(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public LabeledIntent(String string2, int n, int n2) {
        this.mSourcePackage = string2;
        this.mLabelRes = n;
        this.mNonLocalizedLabel = null;
        this.mIcon = n2;
    }

    public LabeledIntent(String string2, CharSequence charSequence, int n) {
        this.mSourcePackage = string2;
        this.mLabelRes = 0;
        this.mNonLocalizedLabel = charSequence;
        this.mIcon = n;
    }

    public int getIconResource() {
        return this.mIcon;
    }

    public int getLabelResource() {
        return this.mLabelRes;
    }

    public CharSequence getNonLocalizedLabel() {
        return this.mNonLocalizedLabel;
    }

    public String getSourcePackage() {
        return this.mSourcePackage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable loadIcon(PackageManager packageManager) {
        if (this.mIcon == 0) return null;
        if (this.mSourcePackage == null) return null;
        String string2 = this.mSourcePackage;
        int n = this.mIcon;
        Drawable drawable2 = packageManager.getDrawable(string2, n, null);
        if (drawable2 == null) return null;
        return drawable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence loadLabel(PackageManager packageManager) {
        if (this.mNonLocalizedLabel != null) {
            return this.mNonLocalizedLabel;
        }
        if (this.mLabelRes == 0) return null;
        if (this.mSourcePackage == null) return null;
        String string2 = this.mSourcePackage;
        int n = this.mLabelRes;
        CharSequence charSequence = packageManager.getText(string2, n, null);
        if (charSequence == null) return null;
        return charSequence;
    }

    @Override
    public void readFromParcel(Parcel parcel) {
        int n;
        CharSequence charSequence;
        int n2;
        String string2;
        super.readFromParcel(parcel);
        this.mSourcePackage = string2 = parcel.readString();
        this.mLabelRes = n2 = parcel.readInt();
        this.mNonLocalizedLabel = charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mIcon = n = parcel.readInt();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        String string2 = this.mSourcePackage;
        parcel.writeString(string2);
        int n2 = this.mLabelRes;
        parcel.writeInt(n2);
        TextUtils.writeToParcel(this.mNonLocalizedLabel, parcel, n);
        int n3 = this.mIcon;
        parcel.writeInt(n3);
    }
}

