/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.Printer;
import java.text.Collator;
import java.util.Comparator;

public class PackageItemInfo {
    public int icon;
    public int labelRes;
    public int logo;
    public Bundle metaData;
    public String name;
    public CharSequence nonLocalizedLabel;
    public String packageName;

    public PackageItemInfo() {
    }

    public PackageItemInfo(PackageItemInfo packageItemInfo) {
        Bundle bundle;
        int n;
        int n2;
        CharSequence charSequence;
        int n3;
        String string2;
        String string3;
        this.name = string3 = packageItemInfo.name;
        if (this.name != null) {
            String string4;
            this.name = string4 = this.name.trim();
        }
        this.packageName = string2 = packageItemInfo.packageName;
        this.labelRes = n3 = packageItemInfo.labelRes;
        this.nonLocalizedLabel = charSequence = packageItemInfo.nonLocalizedLabel;
        if (this.nonLocalizedLabel != null) {
            String string5 = ((Object)this.nonLocalizedLabel).toString().trim();
            this.nonLocalizedLabel = string5;
        }
        this.icon = n2 = packageItemInfo.icon;
        this.logo = n = packageItemInfo.logo;
        this.metaData = bundle = packageItemInfo.metaData;
    }

    protected PackageItemInfo(Parcel parcel) {
        Bundle bundle;
        int n;
        int n2;
        CharSequence charSequence;
        int n3;
        String string2;
        String string3;
        this.name = string3 = parcel.readString();
        this.packageName = string2 = parcel.readString();
        this.labelRes = n3 = parcel.readInt();
        this.nonLocalizedLabel = charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.icon = n2 = parcel.readInt();
        this.logo = n = parcel.readInt();
        this.metaData = bundle = parcel.readBundle();
    }

    protected void dumpBack(Printer printer, String string2) {
    }

    protected void dumpFront(Printer printer, String string2) {
        if (this.name != null) {
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("name=");
            String string3 = this.name;
            String string4 = stringBuilder.append(string3).toString();
            printer.println(string4);
        }
        StringBuilder stringBuilder = new StringBuilder().append(string2).append("packageName=");
        String string5 = this.packageName;
        String string6 = stringBuilder.append(string5).toString();
        printer.println(string6);
        if (this.labelRes == 0 && this.nonLocalizedLabel == null && this.icon == 0) {
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder().append(string2).append("labelRes=0x");
        String string7 = Integer.toHexString(this.labelRes);
        StringBuilder stringBuilder3 = stringBuilder2.append(string7).append(" nonLocalizedLabel=");
        CharSequence charSequence = this.nonLocalizedLabel;
        StringBuilder stringBuilder4 = stringBuilder3.append((Object)charSequence).append(" icon=0x");
        String string8 = Integer.toHexString(this.icon);
        String string9 = stringBuilder4.append(string8).toString();
        printer.println(string9);
    }

    protected ApplicationInfo getApplicationInfo() {
        return null;
    }

    protected Drawable loadDefaultIcon(PackageManager packageManager) {
        return packageManager.getDefaultActivityIcon();
    }

    protected Drawable loadDefaultLogo(PackageManager packageManager) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable loadIcon(PackageManager packageManager) {
        if (this.icon == 0) return this.loadDefaultIcon(packageManager);
        String string2 = this.packageName;
        int n = this.icon;
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        Drawable drawable2 = packageManager.getDrawable(string2, n, applicationInfo);
        if (drawable2 == null) return this.loadDefaultIcon(packageManager);
        return drawable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence loadLabel(PackageManager packageManager) {
        ApplicationInfo applicationInfo;
        int n;
        String string2;
        CharSequence charSequence;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        if (this.labelRes != 0 && (charSequence = packageManager.getText(string2 = this.packageName, n = this.labelRes, applicationInfo = this.getApplicationInfo())) != null) {
            return ((Object)charSequence).toString().trim();
        }
        if (this.name == null) return this.packageName;
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable loadLogo(PackageManager packageManager) {
        if (this.logo == 0) return this.loadDefaultLogo(packageManager);
        String string2 = this.packageName;
        int n = this.logo;
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        Drawable drawable2 = packageManager.getDrawable(string2, n, applicationInfo);
        if (drawable2 == null) return this.loadDefaultLogo(packageManager);
        return drawable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XmlResourceParser loadXmlMetaData(PackageManager packageManager, String string2) {
        if (this.metaData == null) return null;
        int n = this.metaData.getInt(string2);
        if (n == 0) return null;
        String string3 = this.packageName;
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        return packageManager.getXml(string3, n, applicationInfo);
    }

    public void writeToParcel(Parcel parcel, int n) {
        String string2 = this.name;
        parcel.writeString(string2);
        String string3 = this.packageName;
        parcel.writeString(string3);
        int n2 = this.labelRes;
        parcel.writeInt(n2);
        TextUtils.writeToParcel(this.nonLocalizedLabel, parcel, n);
        int n3 = this.icon;
        parcel.writeInt(n3);
        int n4 = this.logo;
        parcel.writeInt(n4);
        Bundle bundle = this.metaData;
        parcel.writeBundle(bundle);
    }

    public static class DisplayNameComparator
    implements Comparator<PackageItemInfo> {
        private PackageManager mPM;
        private final Collator sCollator;

        public DisplayNameComparator(PackageManager packageManager) {
            Collator collator;
            this.sCollator = collator = Collator.getInstance();
            this.mPM = packageManager;
        }

        @Override
        public final int compare(PackageItemInfo packageItemInfo, PackageItemInfo packageItemInfo2) {
            PackageManager packageManager;
            CharSequence charSequence;
            PackageManager packageManager2 = this.mPM;
            CharSequence charSequence2 = packageItemInfo.loadLabel(packageManager2);
            if (charSequence2 == null) {
                charSequence2 = packageItemInfo.name;
            }
            if ((charSequence = packageItemInfo2.loadLabel(packageManager = this.mPM)) == null) {
                charSequence = packageItemInfo2.name;
            }
            Collator collator = this.sCollator;
            String string2 = ((Object)charSequence2).toString();
            String string3 = ((Object)charSequence).toString();
            return collator.compare(string2, string3);
        }
    }
}

