/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageParser {
    private static final String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";
    public static final NewPermissionInfo[] NEW_PERMISSIONS;
    public static final int PARSE_CHATTY = 2;
    private static final int PARSE_DEFAULT_INSTALL_LOCATION = 255;
    public static final int PARSE_FORWARD_LOCK = 16;
    public static final int PARSE_IGNORE_PROCESSES = 8;
    public static final int PARSE_IS_SYSTEM = 1;
    public static final int PARSE_IS_SYSTEM_DIR = 64;
    public static final int PARSE_MUST_BE_APK = 4;
    public static final int PARSE_ON_SDCARD = 32;
    private static final boolean RIGID_PARSER = false;
    private static final String SDK_CODENAME;
    private static final int SDK_VERSION = 0;
    private static final String TAG = "PackageParser";
    private static WeakReference<byte[]> mReadBuffer;
    private static final Object mSync;
    private static boolean sCompatibilityModeEnabled;
    private String mArchiveSourcePath;
    private ParseComponentArgs mParseActivityAliasArgs;
    private ParseComponentArgs mParseActivityArgs;
    private int mParseError = 1;
    private ParsePackageItemArgs mParseInstrumentationArgs;
    private ParseComponentArgs mParseProviderArgs;
    private ParseComponentArgs mParseServiceArgs;
    private String[] mSeparateProcesses;

    /*
     * Enabled aggressive block sorting
     */
    static {
        NewPermissionInfo newPermissionInfo = new NewPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", 4, 0);
        NewPermissionInfo newPermissionInfo2 = new NewPermissionInfo("android.permission.READ_PHONE_STATE", 4, 0);
        NewPermissionInfo[] newPermissionInfoArray = new NewPermissionInfo[]{newPermissionInfo, newPermissionInfo2};
        NEW_PERMISSIONS = newPermissionInfoArray;
        SDK_VERSION = Build.VERSION.SDK_INT;
        String string2 = Build.VERSION.CODENAME;
        String string3 = "REL".equals(string2) ? null : Build.VERSION.CODENAME;
        SDK_CODENAME = string3;
        mSync = new Object();
        sCompatibilityModeEnabled = true;
    }

    public PackageParser(String string2) {
        this.mArchiveSourcePath = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildClassName(String string2, CharSequence charSequence, String[] stringArray) {
        String string3;
        if (charSequence == null || charSequence.length() <= 0) {
            String string4;
            stringArray[0] = string4 = "Empty class name in package " + string2;
            return null;
        }
        String string5 = ((Object)charSequence).toString();
        char c = string5.charAt(0);
        if (c == '.') {
            return (string2 + string5).intern();
        }
        if (string5.indexOf(46) < 0) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            StringBuilder stringBuilder2 = stringBuilder.append('.');
            StringBuilder stringBuilder3 = stringBuilder.append(string5);
            return stringBuilder.toString().intern();
        }
        if (c >= 'a' && c <= 'z') {
            return string5.intern();
        }
        stringArray[0] = string3 = "Bad class name " + string5 + " in package " + string2;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildCompoundName(String string2, CharSequence charSequence, String string3, String[] stringArray) {
        String string4;
        String string5 = ((Object)charSequence).toString();
        char c = string5.charAt(0);
        if (string2 != null && c == ':') {
            String string6;
            if (string5.length() < 2) {
                String string7;
                stringArray[0] = string7 = "Bad " + string3 + " name " + string5 + " in package " + string2 + ": must be at least two characters";
                return null;
            }
            String string8 = PackageParser.validateName(string5.substring(1), false);
            if (string8 == null) return (string2 + string5).intern();
            stringArray[0] = string6 = "Invalid " + string3 + " name " + string5 + " in package " + string2 + ": " + string8;
            return null;
        }
        String string9 = PackageParser.validateName(string5, true);
        if (string9 == null) return string5.intern();
        if ("system".equals(string5)) return string5.intern();
        stringArray[0] = string4 = "Invalid " + string3 + " name " + string5 + " in package " + string2 + ": " + string9;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildProcessName(String string2, String string3, CharSequence charSequence, int n, String[] stringArray, String[] stringArray2) {
        if ((n & 8) != 0 && !"system".equals(charSequence)) {
            if (string3 == null) return string2;
            return string3;
        }
        if (stringArray != null) {
            for (int i = stringArray.length - 1; i >= 0; i += -1) {
                String string4 = stringArray[i];
                if (string4.equals(string2)) return string2;
                if (string4.equals(string3)) return string2;
                if (!string4.equals(charSequence)) continue;
                return string2;
            }
        }
        if (charSequence == null) return string3;
        if (charSequence.length() > 0) return PackageParser.buildCompoundName(string2, charSequence, "process", stringArray2);
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildTaskAffinityName(String string2, String string3, CharSequence charSequence, String[] stringArray) {
        if (charSequence == null) {
            return string3;
        }
        if (charSequence.length() > 0) return PackageParser.buildCompoundName(string2, charSequence, "taskAffinity", stringArray);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean copyNeeded(int n, Package package_, Bundle bundle) {
        boolean bl;
        if (package_.mSetEnabled != 0 && package_.applicationInfo.enabled != (bl = package_.mSetEnabled == 1)) {
            return true;
        }
        if ((n & 0x80) != 0) {
            if (bundle != null) return true;
            if (package_.mAppMetaData != null) {
                return true;
            }
        }
        if ((n & 0x400) == 0) return false;
        if (package_.usesLibraryFiles == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ActivityInfo generateActivityInfo(Activity activity, int n) {
        ApplicationInfo applicationInfo;
        Bundle bundle;
        if (activity == null) {
            return null;
        }
        Package package_ = activity.owner;
        Bundle bundle2 = activity.metaData;
        if (!PackageParser.copyNeeded(n, package_, bundle2)) {
            return activity.info;
        }
        ActivityInfo activityInfo = activity.info;
        ActivityInfo activityInfo2 = new ActivityInfo(activityInfo);
        activityInfo2.metaData = bundle = activity.metaData;
        activityInfo2.applicationInfo = applicationInfo = PackageParser.generateApplicationInfo(activity.owner, n);
        return activityInfo2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationInfo generateApplicationInfo(Package package_, int n) {
        ApplicationInfo applicationInfo = null;
        if (package_ == null) {
            return applicationInfo;
        }
        if (!PackageParser.copyNeeded(n, package_, null)) {
            if (sCompatibilityModeEnabled) return package_.applicationInfo;
            package_.applicationInfo.disableCompatibilityMode();
            return package_.applicationInfo;
        }
        ApplicationInfo applicationInfo2 = package_.applicationInfo;
        ApplicationInfo applicationInfo3 = new ApplicationInfo(applicationInfo2);
        if ((n & 0x80) != 0) {
            Bundle bundle;
            applicationInfo3.metaData = bundle = package_.mAppMetaData;
        }
        if ((n & 0x400) != 0) {
            String[] stringArray = package_.usesLibraryFiles;
            applicationInfo3.sharedLibraryFiles = stringArray;
        }
        if (!sCompatibilityModeEnabled) {
            applicationInfo3.disableCompatibilityMode();
        }
        if (package_.mSetEnabled == 1) {
            applicationInfo3.enabled = true;
            return applicationInfo3;
        }
        if (package_.mSetEnabled != 2) return applicationInfo3;
        applicationInfo3.enabled = false;
        return applicationInfo3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final InstrumentationInfo generateInstrumentationInfo(Instrumentation instrumentation, int n) {
        Bundle bundle;
        if (instrumentation == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return instrumentation.info;
        }
        InstrumentationInfo instrumentationInfo = instrumentation.info;
        InstrumentationInfo instrumentationInfo2 = new InstrumentationInfo(instrumentationInfo);
        instrumentationInfo2.metaData = bundle = instrumentation.metaData;
        return instrumentationInfo2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        ApplicationInfo applicationInfo;
        int n11;
        String string2;
        String string3;
        int n12;
        String string4;
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = string4 = package_.packageName;
        packageInfo.versionCode = n12 = package_.mVersionCode;
        packageInfo.versionName = string3 = package_.mVersionName;
        packageInfo.sharedUserId = string2 = package_.mSharedUserId;
        packageInfo.sharedUserLabel = n11 = package_.mSharedUserLabel;
        packageInfo.applicationInfo = applicationInfo = PackageParser.generateApplicationInfo(package_, n);
        packageInfo.installLocation = n10 = package_.installLocation;
        packageInfo.firstInstallTime = l;
        packageInfo.lastUpdateTime = l2;
        if ((n & 0x100) != 0) {
            packageInfo.gids = nArray;
        }
        if ((n & 0x4000) != 0) {
            int n13;
            int n14 = package_.configPreferences.size();
            if (n14 > 0) {
                ConfigurationInfo[] configurationInfoArray = new ConfigurationInfo[n14];
                packageInfo.configPreferences = configurationInfoArray;
                ArrayList<ConfigurationInfo> arrayList = package_.configPreferences;
                ConfigurationInfo[] configurationInfoArray2 = packageInfo.configPreferences;
                ConfigurationInfo[] configurationInfoArray3 = arrayList.toArray(configurationInfoArray2);
            }
            if ((n13 = package_.reqFeatures != null ? package_.reqFeatures.size() : 0) > 0) {
                FeatureInfo[] featureInfoArray = new FeatureInfo[n13];
                packageInfo.reqFeatures = featureInfoArray;
                ArrayList<FeatureInfo> arrayList = package_.reqFeatures;
                FeatureInfo[] featureInfoArray2 = packageInfo.reqFeatures;
                FeatureInfo[] featureInfoArray3 = arrayList.toArray(featureInfoArray2);
            }
        }
        if ((n & 1) != 0 && (n9 = package_.activities.size()) > 0) {
            if ((n & 0x200) != 0) {
                ActivityInfo[] activityInfoArray = new ActivityInfo[n9];
                packageInfo.activities = activityInfoArray;
            } else {
                int n15 = 0;
                for (int i = 0; i < n9; ++i) {
                    if (!package_.activities.get((int)i).info.enabled) continue;
                    ++n15;
                }
                ActivityInfo[] activityInfoArray = new ActivityInfo[n15];
                packageInfo.activities = activityInfoArray;
            }
            int n16 = 0;
            for (n8 = 0; n8 < n9; ++n8) {
                ActivityInfo activityInfo;
                if (!package_.activities.get((int)n8).info.enabled && (n & 0x200) == 0) continue;
                ActivityInfo[] activityInfoArray = packageInfo.activities;
                int n17 = n16 + 1;
                activityInfoArray[n16] = activityInfo = PackageParser.generateActivityInfo(package_.activities.get(n8), n);
                n16 = n17;
            }
        }
        if ((n & 2) != 0 && (n7 = package_.receivers.size()) > 0) {
            if ((n & 0x200) != 0) {
                ActivityInfo[] activityInfoArray = new ActivityInfo[n7];
                packageInfo.receivers = activityInfoArray;
            } else {
                n8 = 0;
                for (int i = 0; i < n7; ++i) {
                    if (!package_.receivers.get((int)i).info.enabled) continue;
                    int n18 = n8 + 1;
                }
                ActivityInfo[] activityInfoArray = new ActivityInfo[n8];
                packageInfo.receivers = activityInfoArray;
            }
            int n19 = 0;
            for (n8 = 0; n8 < n7; ++n8) {
                ActivityInfo activityInfo;
                if (!package_.receivers.get((int)n8).info.enabled && (n & 0x200) == 0) continue;
                ActivityInfo[] activityInfoArray = packageInfo.receivers;
                int n20 = n19 + 1;
                activityInfoArray[n19] = activityInfo = PackageParser.generateActivityInfo(package_.receivers.get(n8), n);
                n19 = n20;
            }
        }
        if ((n & 4) != 0 && (n6 = package_.services.size()) > 0) {
            if ((n & 0x200) != 0) {
                ServiceInfo[] serviceInfoArray = new ServiceInfo[n6];
                packageInfo.services = serviceInfoArray;
            } else {
                n8 = 0;
                for (int i = 0; i < n6; ++i) {
                    if (!package_.services.get((int)i).info.enabled) continue;
                    int n21 = n8 + 1;
                }
                ServiceInfo[] serviceInfoArray = new ServiceInfo[n8];
                packageInfo.services = serviceInfoArray;
            }
            int n22 = 0;
            for (n5 = 0; n5 < n6; ++n5) {
                if (package_.services.get((int)n5).info.enabled || (n & 0x200) != 0) {
                    ServiceInfo serviceInfo;
                    ServiceInfo[] serviceInfoArray = packageInfo.services;
                    n8 = n22 + 1;
                    serviceInfoArray[n22] = serviceInfo = PackageParser.generateServiceInfo(package_.services.get(n5), n);
                } else {
                    n8 = n22;
                }
                n22 = n8;
            }
        }
        if ((n & 8) != 0 && (n4 = package_.providers.size()) > 0) {
            if ((n & 0x200) != 0) {
                ProviderInfo[] providerInfoArray = new ProviderInfo[n4];
                packageInfo.providers = providerInfoArray;
            } else {
                n8 = 0;
                for (int i = 0; i < n4; ++i) {
                    if (!package_.providers.get((int)i).info.enabled) continue;
                    int n23 = n8 + 1;
                }
                ProviderInfo[] providerInfoArray = new ProviderInfo[n8];
                packageInfo.providers = providerInfoArray;
            }
            int n24 = 0;
            for (n5 = 0; n5 < n4; ++n5) {
                if (package_.providers.get((int)n5).info.enabled || (n & 0x200) != 0) {
                    ProviderInfo providerInfo;
                    ProviderInfo[] providerInfoArray = packageInfo.providers;
                    n8 = n24 + 1;
                    providerInfoArray[n24] = providerInfo = PackageParser.generateProviderInfo(package_.providers.get(n5), n);
                } else {
                    n8 = n24;
                }
                n24 = n8;
            }
        }
        if ((n & 0x10) != 0 && (n3 = package_.instrumentation.size()) > 0) {
            InstrumentationInfo[] instrumentationInfoArray = new InstrumentationInfo[n3];
            packageInfo.instrumentation = instrumentationInfoArray;
            for (n5 = 0; n5 < n3; ++n5) {
                InstrumentationInfo instrumentationInfo;
                InstrumentationInfo[] instrumentationInfoArray2 = packageInfo.instrumentation;
                instrumentationInfoArray2[n5] = instrumentationInfo = PackageParser.generateInstrumentationInfo(package_.instrumentation.get(n5), n);
            }
        }
        if ((n & 0x1000) != 0) {
            int n25;
            int n26 = package_.permissions.size();
            if (n26 > 0) {
                PermissionInfo[] permissionInfoArray = new PermissionInfo[n26];
                packageInfo.permissions = permissionInfoArray;
                for (n5 = 0; n5 < n26; ++n5) {
                    PermissionInfo permissionInfo;
                    PermissionInfo[] permissionInfoArray2 = packageInfo.permissions;
                    permissionInfoArray2[n5] = permissionInfo = PackageParser.generatePermissionInfo(package_.permissions.get(n5), n);
                }
            }
            if ((n25 = package_.requestedPermissions.size()) > 0) {
                String[] stringArray = new String[n25];
                packageInfo.requestedPermissions = stringArray;
                for (n5 = 0; n5 < n25; ++n5) {
                    String string5;
                    String[] stringArray2 = packageInfo.requestedPermissions;
                    stringArray2[n5] = string5 = package_.requestedPermissions.get(n5);
                }
            }
        }
        if ((n & 0x40) != 0 && (n2 = package_.mSignatures != null ? package_.mSignatures.length : 0) > 0) {
            Signature[] signatureArray = new Signature[n2];
            packageInfo.signatures = signatureArray;
            Signature[] signatureArray2 = package_.mSignatures;
            Signature[] signatureArray3 = packageInfo.signatures;
            System.arraycopy(signatureArray2, 0, signatureArray3, 0, n2);
        }
        return packageInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PermissionGroupInfo generatePermissionGroupInfo(PermissionGroup permissionGroup, int n) {
        Bundle bundle;
        if (permissionGroup == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return permissionGroup.info;
        }
        PermissionGroupInfo permissionGroupInfo = permissionGroup.info;
        PermissionGroupInfo permissionGroupInfo2 = new PermissionGroupInfo(permissionGroupInfo);
        permissionGroupInfo2.metaData = bundle = permissionGroup.metaData;
        return permissionGroupInfo2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PermissionInfo generatePermissionInfo(Permission permission2, int n) {
        Bundle bundle;
        if (permission2 == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return permission2.info;
        }
        PermissionInfo permissionInfo = permission2.info;
        PermissionInfo permissionInfo2 = new PermissionInfo(permissionInfo);
        permissionInfo2.metaData = bundle = permission2.metaData;
        return permissionInfo2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ProviderInfo generateProviderInfo(Provider provider, int n) {
        ApplicationInfo applicationInfo;
        Bundle bundle;
        if (provider == null) {
            return null;
        }
        Package package_ = provider.owner;
        Bundle bundle2 = provider.metaData;
        if (!PackageParser.copyNeeded(n, package_, bundle2)) {
            if ((n & 0x800) != 0) return provider.info;
            if (provider.info.uriPermissionPatterns == null) {
                return provider.info;
            }
        }
        ProviderInfo providerInfo = provider.info;
        ProviderInfo providerInfo2 = new ProviderInfo(providerInfo);
        providerInfo2.metaData = bundle = provider.metaData;
        if ((n & 0x800) == 0) {
            providerInfo2.uriPermissionPatterns = null;
        }
        providerInfo2.applicationInfo = applicationInfo = PackageParser.generateApplicationInfo(provider.owner, n);
        return providerInfo2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ServiceInfo generateServiceInfo(Service service, int n) {
        ApplicationInfo applicationInfo;
        Bundle bundle;
        if (service == null) {
            return null;
        }
        Package package_ = service.owner;
        Bundle bundle2 = service.metaData;
        if (!PackageParser.copyNeeded(n, package_, bundle2)) {
            return service.info;
        }
        ServiceInfo serviceInfo = service.info;
        ServiceInfo serviceInfo2 = new ServiceInfo(serviceInfo);
        serviceInfo2.metaData = bundle = service.metaData;
        serviceInfo2.applicationInfo = applicationInfo = PackageParser.generateApplicationInfo(service.owner, n);
        return serviceInfo2;
    }

    private static final boolean isPackageFilename(String string2) {
        return string2.endsWith(".apk");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Certificate[] loadCertificates(JarFile jarFile, JarEntry jarEntry, byte[] byArray) {
        try {
            int n;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while (((InputStream)bufferedInputStream).read(byArray, 0, n = byArray.length) != -1) {
            }
            ((InputStream)bufferedInputStream).close();
            if (jarEntry == null) return null;
            Certificate[] certificateArray = jarEntry.getCertificates();
            return certificateArray;
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder().append("Exception reading ");
            String string2 = jarEntry.getName();
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" in ");
            String string3 = jarFile.getName();
            String string4 = stringBuilder2.append(string3).toString();
            int n = Log.w(TAG, string4, iOException);
            return null;
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder().append("Exception reading ");
            String string5 = jarEntry.getName();
            StringBuilder stringBuilder3 = stringBuilder.append(string5).append(" in ");
            String string6 = jarFile.getName();
            String string7 = stringBuilder3.append(string6).toString();
            int n = Log.w(TAG, string7, runtimeException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Activity parseActivity(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray, boolean bl) throws XmlPullParserException, IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        String string2;
        String string3;
        boolean bl2;
        int n9;
        TypedArray typedArray;
        boolean bl3;
        boolean bl4;
        int n10;
        int n11;
        TypedArray typedArray2;
        boolean bl5;
        int n12;
        TypedArray typedArray3;
        boolean bl6;
        int n13;
        TypedArray typedArray4;
        boolean bl7;
        int n14;
        TypedArray typedArray5;
        boolean bl8;
        int n15;
        TypedArray typedArray6;
        boolean bl9;
        int n16;
        TypedArray typedArray7;
        boolean bl10;
        int n17;
        TypedArray typedArray8;
        String string4;
        int n18;
        Activity activity;
        int n19;
        TypedArray typedArray9;
        int[] nArray = R.styleable.AndroidManifestActivity;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray10 = resources2.obtainAttributes(attributeSet2, nArray2);
        if (this.mParseActivityArgs == null) {
            ParseComponentArgs parseComponentArgs;
            String[] stringArray2 = this.mSeparateProcesses;
            Package package_2 = package_;
            String[] stringArray3 = stringArray;
            this.mParseActivityArgs = parseComponentArgs = new ParseComponentArgs(package_2, stringArray3, 3, 1, 2, 0, stringArray2, 7, 17, 5);
        }
        ParseComponentArgs parseComponentArgs = this.mParseActivityArgs;
        String string5 = bl ? "<receiver>" : "<activity>";
        parseComponentArgs.tag = string5;
        ParseComponentArgs parseComponentArgs2 = this.mParseActivityArgs;
        parseComponentArgs2.sa = typedArray9 = typedArray10;
        ParseComponentArgs parseComponentArgs3 = this.mParseActivityArgs;
        parseComponentArgs3.flags = n19 = n;
        ParseComponentArgs parseComponentArgs4 = this.mParseActivityArgs;
        ActivityInfo activityInfo = new ActivityInfo();
        Activity activity2 = activity;
        ParseComponentArgs parseComponentArgs5 = parseComponentArgs4;
        ActivityInfo activityInfo2 = activityInfo;
        activity2(parseComponentArgs5, activityInfo2);
        if (stringArray[0] != null) {
            typedArray10.recycle();
            return null;
        }
        TypedArray typedArray11 = typedArray10;
        int n20 = 6;
        boolean bl11 = typedArray11.hasValue(n20);
        if (bl11) {
            boolean bl12;
            ActivityInfo activityInfo3 = activity.info;
            TypedArray typedArray12 = typedArray10;
            int n21 = 6;
            boolean bl13 = false;
            activityInfo3.exported = bl12 = typedArray12.getBoolean(n21, bl13);
        }
        ActivityInfo activityInfo4 = activity.info;
        TypedArray typedArray13 = typedArray10;
        int n22 = 0;
        int n23 = 0;
        activityInfo4.theme = n18 = typedArray13.getResourceId(n22, n23);
        TypedArray typedArray14 = typedArray10;
        int n24 = 4;
        int n25 = 0;
        String string6 = typedArray14.getNonConfigurationString(n24, n25);
        if (string6 == null) {
            String string7;
            ActivityInfo activityInfo5 = activity.info;
            activityInfo5.permission = string7 = package_.applicationInfo.permission;
        } else {
            ActivityInfo activityInfo6 = activity.info;
            String string8 = string6.length() > 0 ? string6.toString().intern() : null;
            activityInfo6.permission = string8;
        }
        TypedArray typedArray15 = typedArray10;
        int n26 = 8;
        int n27 = 0;
        String string9 = typedArray15.getNonConfigurationString(n26, n27);
        ActivityInfo activityInfo7 = activity.info;
        String string10 = package_.applicationInfo.packageName;
        String string11 = package_.applicationInfo.taskAffinity;
        String string12 = string10;
        String string13 = string11;
        String string14 = string9;
        String[] stringArray4 = stringArray;
        activityInfo7.taskAffinity = string4 = PackageParser.buildTaskAffinityName(string12, string13, string14, stringArray4);
        activity.info.flags = 0;
        TypedArray typedArray16 = typedArray10;
        int n28 = 9;
        boolean bl14 = false;
        if (typedArray16.getBoolean(n28, bl14)) {
            int n29;
            ActivityInfo activityInfo8 = activity.info;
            activityInfo8.flags = n29 = activityInfo8.flags | 1;
        }
        if ((typedArray8 = typedArray10).getBoolean(n17 = 10, bl10 = false)) {
            int n30;
            ActivityInfo activityInfo9 = activity.info;
            activityInfo9.flags = n30 = activityInfo9.flags | 2;
        }
        if ((typedArray7 = typedArray10).getBoolean(n16 = 11, bl9 = false)) {
            int n31;
            ActivityInfo activityInfo10 = activity.info;
            activityInfo10.flags = n31 = activityInfo10.flags | 4;
        }
        if ((typedArray6 = typedArray10).getBoolean(n15 = 21, bl8 = false)) {
            int n32;
            ActivityInfo activityInfo11 = activity.info;
            activityInfo11.flags = n32 = activityInfo11.flags | 0x80;
        }
        if ((typedArray5 = typedArray10).getBoolean(n14 = 18, bl7 = false)) {
            int n33;
            ActivityInfo activityInfo12 = activity.info;
            activityInfo12.flags = n33 = activityInfo12.flags | 8;
        }
        if ((typedArray4 = typedArray10).getBoolean(n13 = 12, bl6 = false)) {
            int n34;
            ActivityInfo activityInfo13 = activity.info;
            activityInfo13.flags = n34 = activityInfo13.flags | 0x10;
        }
        if ((typedArray3 = typedArray10).getBoolean(n12 = 13, bl5 = false)) {
            int n35;
            ActivityInfo activityInfo14 = activity.info;
            activityInfo14.flags = n35 = activityInfo14.flags | 0x20;
        }
        if ((typedArray2 = typedArray10).getBoolean(n11 = (n10 = 19), bl4 = (bl3 = (package_.applicationInfo.flags & 0x20) != 0))) {
            int n36;
            ActivityInfo activityInfo15 = activity.info;
            activityInfo15.flags = n36 = activityInfo15.flags | 0x40;
        }
        if ((typedArray = typedArray10).getBoolean(n9 = 22, bl2 = false)) {
            int n37;
            ActivityInfo activityInfo16 = activity.info;
            activityInfo16.flags = n37 = activityInfo16.flags | 0x100;
        }
        if (!bl) {
            int n38;
            int n39;
            int n40;
            int n41;
            ActivityInfo activityInfo17 = activity.info;
            TypedArray typedArray17 = typedArray10;
            int n42 = 14;
            int n43 = 0;
            activityInfo17.launchMode = n41 = typedArray17.getInt(n42, n43);
            ActivityInfo activityInfo18 = activity.info;
            TypedArray typedArray18 = typedArray10;
            int n44 = 15;
            int n45 = -1;
            activityInfo18.screenOrientation = n40 = typedArray18.getInt(n44, n45);
            ActivityInfo activityInfo19 = activity.info;
            TypedArray typedArray19 = typedArray10;
            int n46 = 16;
            int n47 = 0;
            activityInfo19.configChanges = n39 = typedArray19.getInt(n46, n47);
            ActivityInfo activityInfo20 = activity.info;
            TypedArray typedArray20 = typedArray10;
            int n48 = 20;
            int n49 = 0;
            activityInfo20.softInputMode = n38 = typedArray20.getInt(n48, n49);
        } else {
            activity.info.launchMode = 0;
            activity.info.configChanges = 0;
        }
        typedArray10.recycle();
        if (bl && (package_.applicationInfo.flags & 0x8000000) != 0 && (string3 = activity.info.processName) == (string2 = package_.packageName)) {
            stringArray[0] = "Heavy-weight applications can not have receivers in main process";
        }
        if (stringArray[0] != null) {
            return null;
        }
        int n50 = xmlPullParser.getDepth();
        while ((n8 = (n7 = xmlPullParser.next())) != (n6 = 1) && ((n5 = n7) != (n4 = 3) || (n3 = xmlPullParser.getDepth()) > (n2 = n50))) {
            int n51;
            int n52;
            int n53 = n7;
            int n54 = 3;
            if (n53 == n54 || (n52 = n7) == (n51 = 4)) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ActivityIntentInfo activityIntentInfo;
                ActivityIntentInfo activityIntentInfo2 = activityIntentInfo;
                Activity activity3 = activity;
                activityIntentInfo2(activity3);
                boolean bl15 = !bl;
                PackageParser packageParser = this;
                Resources resources3 = resources;
                XmlPullParser xmlPullParser2 = xmlPullParser;
                AttributeSet attributeSet3 = attributeSet;
                int n55 = n;
                String[] stringArray5 = stringArray;
                if (!packageParser.parseIntent(resources3, xmlPullParser2, attributeSet3, n55, activityIntentInfo, stringArray5, bl15)) {
                    return null;
                }
                if (activityIntentInfo.countActions() == 0) {
                    StringBuilder stringBuilder = new StringBuilder().append("No actions in intent filter at ");
                    String string15 = this.mArchiveSourcePath;
                    StringBuilder stringBuilder2 = stringBuilder.append(string15).append(" ");
                    String string16 = xmlPullParser.getPositionDescription();
                    String string17 = stringBuilder2.append(string16).toString();
                    int n56 = Log.w(TAG, string17);
                    continue;
                }
                boolean bl16 = activity.intents.add(activityIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                Bundle bundle2;
                Bundle bundle3 = activity.metaData;
                PackageParser packageParser = this;
                Resources resources4 = resources;
                XmlPullParser xmlPullParser3 = xmlPullParser;
                AttributeSet attributeSet4 = attributeSet;
                String[] stringArray6 = stringArray;
                activity.metaData = bundle2 = (bundle = packageParser.parseMetaData(resources4, xmlPullParser3, attributeSet4, bundle3, stringArray6));
                if (bundle != null) continue;
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Problem in package ");
            String string18 = this.mArchiveSourcePath;
            String string19 = stringBuilder.append(string18).append(":").toString();
            int n57 = Log.w(TAG, string19);
            if (bl) {
                StringBuilder stringBuilder3 = new StringBuilder().append("Unknown element under <receiver>: ");
                String string20 = xmlPullParser.getName();
                StringBuilder stringBuilder4 = stringBuilder3.append(string20).append(" at ");
                String string21 = this.mArchiveSourcePath;
                StringBuilder stringBuilder5 = stringBuilder4.append(string21).append(" ");
                String string22 = xmlPullParser.getPositionDescription();
                String string23 = stringBuilder5.append(string22).toString();
                int n58 = Log.w(TAG, string23);
            } else {
                StringBuilder stringBuilder6 = new StringBuilder().append("Unknown element under <activity>: ");
                String string24 = xmlPullParser.getName();
                StringBuilder stringBuilder7 = stringBuilder6.append(string24).append(" at ");
                String string25 = this.mArchiveSourcePath;
                StringBuilder stringBuilder8 = stringBuilder7.append(string25).append(" ");
                String string26 = xmlPullParser.getPositionDescription();
                String string27 = stringBuilder8.append(string26).toString();
                int n59 = Log.w(TAG, string27);
            }
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (bl11) return activity;
        ActivityInfo activityInfo21 = activity.info;
        boolean bl17 = activity.intents.size() > 0;
        activityInfo21.exported = bl17;
        return activity;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Activity parseActivityAlias(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        TypedArray typedArray;
        String string2;
        Activity activity;
        int n11;
        String string3;
        int n12;
        String string4;
        int n13;
        CharSequence charSequence;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        String string5;
        int n19;
        int n20;
        int n21;
        TypedArray typedArray2;
        int n22;
        int n23;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray = R.styleable.AndroidManifestActivityAlias;
        int[] nArray2 = nArray;
        TypedArray typedArray3 = resources2.obtainAttributes(attributeSet2, nArray2);
        TypedArray typedArray4 = typedArray3;
        String string6 = typedArray4.getNonConfigurationString(n23 = 7, n22 = 0);
        if (string6 == null) {
            stringArray[0] = "<activity-alias> does not specify android:targetActivity";
            typedArray3.recycle();
            return null;
        }
        String string7 = package_.applicationInfo.packageName;
        String string8 = string6;
        String[] stringArray2 = stringArray;
        if ((string6 = PackageParser.buildClassName(string7, string8, stringArray2)) == null) {
            typedArray3.recycle();
            return null;
        }
        if (this.mParseActivityAliasArgs == null) {
            ParseComponentArgs parseComponentArgs;
            String[] stringArray3 = this.mSeparateProcesses;
            Package package_2 = package_;
            String[] stringArray4 = stringArray;
            this.mParseActivityAliasArgs = parseComponentArgs = new ParseComponentArgs(package_2, stringArray4, 2, 0, 1, 0, stringArray3, 0, 6, 4);
            this.mParseActivityAliasArgs.tag = "<activity-alias>";
        }
        ParseComponentArgs parseComponentArgs = this.mParseActivityAliasArgs;
        parseComponentArgs.sa = typedArray2 = typedArray3;
        ParseComponentArgs parseComponentArgs2 = this.mParseActivityAliasArgs;
        parseComponentArgs2.flags = n21 = n;
        Activity activity2 = null;
        int n24 = package_.activities.size();
        int n25 = 0;
        while ((n20 = n25) < (n19 = n24)) {
            ArrayList<Activity> arrayList = package_.activities;
            int n26 = n25++;
            Activity activity3 = arrayList.get(n26);
            String string9 = string6;
            String string10 = activity3.info.name;
            String string11 = string10;
            if (!string9.equals(string11)) continue;
            activity2 = activity3;
            break;
        }
        if (activity2 == null) {
            String string12;
            StringBuilder stringBuilder = new StringBuilder().append("<activity-alias> target activity ");
            String string13 = string6;
            stringArray[0] = string12 = stringBuilder.append(string13).append(" not found in manifest").toString();
            typedArray3.recycle();
            return null;
        }
        ActivityInfo activityInfo = new ActivityInfo();
        activityInfo.targetActivity = string5 = string6;
        activityInfo.configChanges = n18 = activity2.info.configChanges;
        activityInfo.flags = n17 = activity2.info.flags;
        activityInfo.icon = n16 = activity2.info.icon;
        activityInfo.logo = n15 = activity2.info.logo;
        activityInfo.labelRes = n14 = activity2.info.labelRes;
        activityInfo.nonLocalizedLabel = charSequence = activity2.info.nonLocalizedLabel;
        activityInfo.launchMode = n13 = activity2.info.launchMode;
        activityInfo.processName = string4 = activity2.info.processName;
        if (activityInfo.descriptionRes == 0) {
            int n27;
            activityInfo.descriptionRes = n27 = activity2.info.descriptionRes;
        }
        activityInfo.screenOrientation = n12 = activity2.info.screenOrientation;
        activityInfo.taskAffinity = string3 = activity2.info.taskAffinity;
        activityInfo.theme = n11 = activity2.info.theme;
        ParseComponentArgs parseComponentArgs3 = this.mParseActivityAliasArgs;
        Activity activity4 = activity;
        ParseComponentArgs parseComponentArgs4 = parseComponentArgs3;
        ActivityInfo activityInfo2 = activityInfo;
        activity4(parseComponentArgs4, activityInfo2);
        if (stringArray[0] != null) {
            typedArray3.recycle();
            return null;
        }
        TypedArray typedArray5 = typedArray3;
        int n28 = 5;
        boolean bl = typedArray5.hasValue(n28);
        if (bl) {
            boolean bl2;
            ActivityInfo activityInfo3 = activity.info;
            TypedArray typedArray6 = typedArray3;
            int n29 = 5;
            boolean bl3 = false;
            activityInfo3.exported = bl2 = typedArray6.getBoolean(n29, bl3);
        }
        if ((string2 = (typedArray = typedArray3).getNonConfigurationString(n10 = 3, n9 = 0)) != null) {
            ActivityInfo activityInfo4 = activity.info;
            String string14 = string2.length() > 0 ? string2.toString().intern() : null;
            activityInfo4.permission = string14;
        }
        typedArray3.recycle();
        if (stringArray[0] != null) {
            return null;
        }
        int n30 = xmlPullParser.getDepth();
        while ((n8 = (n7 = xmlPullParser.next())) != (n6 = 1) && ((n5 = n7) != (n4 = 3) || (n3 = xmlPullParser.getDepth()) > (n2 = n30))) {
            int n31;
            int n32;
            int n33 = n7;
            int n34 = 3;
            if (n33 == n34 || (n32 = n7) == (n31 = 4)) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ActivityIntentInfo activityIntentInfo;
                ActivityIntentInfo activityIntentInfo2 = activityIntentInfo;
                Activity activity5 = activity;
                activityIntentInfo2(activity5);
                PackageParser packageParser = this;
                Resources resources3 = resources;
                XmlPullParser xmlPullParser2 = xmlPullParser;
                AttributeSet attributeSet3 = attributeSet;
                int n35 = n;
                String[] stringArray5 = stringArray;
                if (!packageParser.parseIntent(resources3, xmlPullParser2, attributeSet3, n35, activityIntentInfo, stringArray5, true)) {
                    return null;
                }
                if (activityIntentInfo.countActions() == 0) {
                    StringBuilder stringBuilder = new StringBuilder().append("No actions in intent filter at ");
                    String string15 = this.mArchiveSourcePath;
                    StringBuilder stringBuilder2 = stringBuilder.append(string15).append(" ");
                    String string16 = xmlPullParser.getPositionDescription();
                    String string17 = stringBuilder2.append(string16).toString();
                    int n36 = Log.w(TAG, string17);
                    continue;
                }
                boolean bl4 = activity.intents.add(activityIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                Bundle bundle2;
                Bundle bundle3 = activity.metaData;
                PackageParser packageParser = this;
                Resources resources4 = resources;
                XmlPullParser xmlPullParser3 = xmlPullParser;
                AttributeSet attributeSet4 = attributeSet;
                String[] stringArray6 = stringArray;
                activity.metaData = bundle2 = (bundle = packageParser.parseMetaData(resources4, xmlPullParser3, attributeSet4, bundle3, stringArray6));
                if (bundle != null) continue;
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unknown element under <activity-alias>: ");
            String string18 = xmlPullParser.getName();
            StringBuilder stringBuilder3 = stringBuilder.append(string18).append(" at ");
            String string19 = this.mArchiveSourcePath;
            StringBuilder stringBuilder4 = stringBuilder3.append(string19).append(" ");
            String string20 = xmlPullParser.getPositionDescription();
            String string21 = stringBuilder4.append(string20).toString();
            int n37 = Log.w(TAG, string21);
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (bl) return activity;
        ActivityInfo activityInfo5 = activity.info;
        boolean bl5 = activity.intents.size() > 0;
        activityInfo5.exported = bl5;
        return activity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseAllMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String string2, Component component, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1) {
            if (n == 3) {
                if (xmlPullParser.getDepth() <= n2) return true;
            }
            if (n == 3 || n == 4) continue;
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                Bundle bundle2 = component.metaData;
                PackageParser packageParser = this;
                Resources resources2 = resources;
                XmlPullParser xmlPullParser2 = xmlPullParser;
                AttributeSet attributeSet2 = attributeSet;
                String[] stringArray2 = stringArray;
                component.metaData = bundle = packageParser.parseMetaData(resources2, xmlPullParser2, attributeSet2, bundle2, stringArray2);
                if (bundle != null) continue;
                return false;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unknown element under ").append(string2).append(": ");
            String string3 = xmlPullParser.getName();
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" at ");
            String string4 = this.mArchiveSourcePath;
            StringBuilder stringBuilder3 = stringBuilder2.append(string4).append(" ");
            String string5 = xmlPullParser.getPositionDescription();
            String string6 = stringBuilder3.append(string5).toString();
            int n3 = Log.w(TAG, string6);
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseApplication(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        int n3;
        int n4;
        String string2;
        String string3;
        String string4;
        int n5;
        int n6;
        TypedArray typedArray;
        String string5;
        boolean bl;
        int n7;
        TypedArray typedArray2;
        boolean bl2;
        int n8;
        TypedArray typedArray3;
        boolean bl3;
        int n9;
        TypedArray typedArray4;
        boolean bl4;
        int n10;
        TypedArray typedArray5;
        boolean bl5;
        int n11;
        TypedArray typedArray6;
        boolean bl6;
        int n12;
        TypedArray typedArray7;
        boolean bl7;
        int n13;
        TypedArray typedArray8;
        boolean bl8;
        int n14;
        TypedArray typedArray9;
        int n15;
        int n16;
        int n17;
        int n18;
        TypedArray typedArray10;
        TypedValue typedValue;
        boolean bl9;
        int n19;
        TypedArray typedArray11;
        int n20;
        int n21;
        TypedArray typedArray12;
        String string6;
        int n22;
        int n23;
        ApplicationInfo applicationInfo = package_.applicationInfo;
        String string7 = package_.applicationInfo.packageName;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray = R.styleable.AndroidManifestApplication;
        int[] nArray2 = nArray;
        TypedArray typedArray13 = resources2.obtainAttributes(attributeSet2, nArray2);
        TypedArray typedArray14 = typedArray13;
        String string8 = typedArray14.getNonConfigurationString(n23 = 3, n22 = 0);
        if (string8 != null) {
            String string9;
            String string10 = string7;
            String string11 = string8;
            String[] stringArray2 = stringArray;
            applicationInfo.className = string9 = PackageParser.buildClassName(string10, string11, stringArray2);
            if (applicationInfo.className == null) {
                int n24;
                typedArray13.recycle();
                this.mParseError = n24 = 65428;
                return false;
            }
        }
        if ((string6 = (typedArray12 = typedArray13).getNonConfigurationString(n21 = 4, n20 = 0)) != null) {
            String string12;
            String string13 = string7;
            String string14 = string6;
            String[] stringArray3 = stringArray;
            applicationInfo.manageSpaceActivityName = string12 = PackageParser.buildClassName(string13, string14, stringArray3);
        }
        if ((typedArray11 = typedArray13).getBoolean(n19 = 17, bl9 = true)) {
            int n25;
            applicationInfo.flags = n25 = applicationInfo.flags | 0x8000;
            TypedArray typedArray15 = typedArray13;
            int n26 = 16;
            int n27 = 0;
            String string15 = typedArray15.getNonConfigurationString(n26, n27);
            if (string15 != null) {
                boolean bl10;
                int n28;
                TypedArray typedArray16;
                String string16;
                String string17 = string7;
                String string18 = string15;
                String[] stringArray4 = stringArray;
                applicationInfo.backupAgentName = string16 = PackageParser.buildClassName(string17, string18, stringArray4);
                TypedArray typedArray17 = typedArray13;
                int n29 = 18;
                boolean bl11 = true;
                if (typedArray17.getBoolean(n29, bl11)) {
                    int n30;
                    applicationInfo.flags = n30 = applicationInfo.flags | 0x10000;
                }
                if ((typedArray16 = typedArray13).getBoolean(n28 = 21, bl10 = false)) {
                    int n31;
                    applicationInfo.flags = n31 = applicationInfo.flags | 0x20000;
                }
            }
        }
        if ((typedValue = (typedArray10 = typedArray13).peekValue(n18 = 1)) != null) {
            int n32;
            int n33;
            applicationInfo.labelRes = n33 = (n32 = typedValue.resourceId);
            if (n32 == 0) {
                CharSequence charSequence;
                applicationInfo.nonLocalizedLabel = charSequence = typedValue.coerceToString();
            }
        }
        TypedArray typedArray18 = typedArray13;
        int n34 = 2;
        int n35 = 0;
        applicationInfo.icon = n17 = typedArray18.getResourceId(n34, n35);
        TypedArray typedArray19 = typedArray13;
        int n36 = 0;
        int n37 = 0;
        applicationInfo.theme = n16 = typedArray19.getResourceId(n36, n37);
        TypedArray typedArray20 = typedArray13;
        int n38 = 13;
        int n39 = 0;
        applicationInfo.descriptionRes = n15 = typedArray20.getResourceId(n38, n39);
        if ((n & 1) != 0 && (typedArray9 = typedArray13).getBoolean(n14 = 8, bl8 = false)) {
            int n40;
            applicationInfo.flags = n40 = applicationInfo.flags | 8;
        }
        if ((n & 0x10) != 0) {
            int n41;
            applicationInfo.flags = n41 = applicationInfo.flags | 0x20000000;
        }
        if ((n & 0x20) != 0) {
            int n42;
            applicationInfo.flags = n42 = applicationInfo.flags | 0x40000;
        }
        if ((typedArray8 = typedArray13).getBoolean(n13 = 10, bl7 = false)) {
            int n43;
            applicationInfo.flags = n43 = applicationInfo.flags | 2;
        }
        if ((typedArray7 = typedArray13).getBoolean(n12 = 20, bl6 = false)) {
            int n44;
            applicationInfo.flags = n44 = applicationInfo.flags | 0x4000;
        }
        if ((typedArray6 = typedArray13).getBoolean(n11 = 7, bl5 = true)) {
            int n45;
            applicationInfo.flags = n45 = applicationInfo.flags | 4;
        }
        if ((typedArray5 = typedArray13).getBoolean(n10 = 14, bl4 = false)) {
            int n46;
            applicationInfo.flags = n46 = applicationInfo.flags | 0x20;
        }
        if ((typedArray4 = typedArray13).getBoolean(n9 = 5, bl3 = true)) {
            int n47;
            applicationInfo.flags = n47 = applicationInfo.flags | 0x40;
        }
        if ((typedArray3 = typedArray13).getBoolean(n8 = 15, bl2 = false)) {
            int n48;
            applicationInfo.flags = n48 = applicationInfo.flags | 0x100;
        }
        if ((typedArray2 = typedArray13).getBoolean(n7 = 22, bl = false)) {
            int n49;
            applicationInfo.flags = n49 = applicationInfo.flags | 0x40000000;
        }
        String string19 = (string5 = (typedArray = typedArray13).getNonConfigurationString(n6 = 6, n5 = 0)) != null && string5.length() > 0 ? string5.intern() : null;
        applicationInfo.permission = string4 = string19;
        if (package_.applicationInfo.targetSdkVersion >= 8) {
            TypedArray typedArray21 = typedArray13;
            int n50 = 12;
            int n51 = 0;
            string3 = typedArray21.getNonConfigurationString(n50, n51);
        } else {
            TypedArray typedArray22 = typedArray13;
            int n52 = 12;
            string3 = typedArray22.getNonResourceString(n52);
        }
        String string20 = applicationInfo.packageName;
        String string21 = applicationInfo.packageName;
        String string22 = string20;
        String string23 = string21;
        String string24 = string3;
        String[] stringArray5 = stringArray;
        applicationInfo.taskAffinity = string2 = PackageParser.buildTaskAffinityName(string22, string23, string24, stringArray5);
        if (stringArray[0] == null) {
            boolean bl12;
            String string25;
            String string26;
            if (package_.applicationInfo.targetSdkVersion >= 8) {
                TypedArray typedArray23 = typedArray13;
                int n53 = 11;
                int n54 = 0;
                string26 = typedArray23.getNonConfigurationString(n53, n54);
            } else {
                TypedArray typedArray24 = typedArray13;
                int n55 = 11;
                string26 = typedArray24.getNonResourceString(n55);
            }
            String string27 = applicationInfo.packageName;
            String[] stringArray6 = this.mSeparateProcesses;
            int n56 = n;
            String[] stringArray7 = stringArray;
            applicationInfo.processName = string25 = PackageParser.buildProcessName(string27, null, string26, n56, stringArray6, stringArray7);
            TypedArray typedArray25 = typedArray13;
            int n57 = 9;
            boolean bl13 = true;
            applicationInfo.enabled = bl12 = typedArray25.getBoolean(n57, bl13);
        }
        typedArray13.recycle();
        if (stringArray[0] != null) {
            int n58;
            this.mParseError = n58 = 65428;
            return false;
        }
        int n59 = xmlPullParser.getDepth();
        while ((n4 = (n3 = xmlPullParser.next())) != (n2 = 1)) {
            Activity activity;
            String string28;
            int n60;
            int n61;
            int n62;
            int n63;
            int n64 = n3;
            int n65 = 3;
            if (n64 == n65) {
                int n66;
                int n67 = xmlPullParser.getDepth();
                if (n67 <= (n66 = n59)) return true;
            }
            if ((n63 = n3) == (n62 = 3) || (n61 = n3) == (n60 = 4)) continue;
            String string29 = xmlPullParser.getName();
            String string30 = string29;
            if (string30.equals(string28 = "activity")) {
                PackageParser packageParser = this;
                Package package_2 = package_;
                Resources resources3 = resources;
                XmlPullParser xmlPullParser2 = xmlPullParser;
                AttributeSet attributeSet3 = attributeSet;
                int n68 = n;
                String[] stringArray8 = stringArray;
                activity = packageParser.parseActivity(package_2, resources3, xmlPullParser2, attributeSet3, n68, stringArray8, false);
                if (activity == null) {
                    int n69;
                    this.mParseError = n69 = 65428;
                    return false;
                }
                boolean bl14 = package_.activities.add(activity);
                continue;
            }
            String string31 = string29;
            String string32 = "receiver";
            if (string31.equals(string32)) {
                PackageParser packageParser = this;
                Package package_3 = package_;
                Resources resources4 = resources;
                XmlPullParser xmlPullParser3 = xmlPullParser;
                AttributeSet attributeSet4 = attributeSet;
                int n70 = n;
                String[] stringArray9 = stringArray;
                activity = packageParser.parseActivity(package_3, resources4, xmlPullParser3, attributeSet4, n70, stringArray9, true);
                if (activity == null) {
                    int n71;
                    this.mParseError = n71 = 65428;
                    return false;
                }
                boolean bl15 = package_.receivers.add(activity);
                continue;
            }
            String string33 = string29;
            String string34 = "service";
            if (string33.equals(string34)) {
                Service service = this.parseService(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (service == null) {
                    int n72;
                    this.mParseError = n72 = 65428;
                    return false;
                }
                ArrayList<Service> arrayList = package_.services;
                Service service2 = service;
                boolean bl16 = arrayList.add(service2);
                continue;
            }
            String string35 = string29;
            String string36 = "provider";
            if (string35.equals(string36)) {
                Provider provider = this.parseProvider(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (provider == null) {
                    int n73;
                    this.mParseError = n73 = 65428;
                    return false;
                }
                ArrayList<Provider> arrayList = package_.providers;
                Provider provider2 = provider;
                boolean bl17 = arrayList.add(provider2);
                continue;
            }
            String string37 = string29;
            String string38 = "activity-alias";
            if (string37.equals(string38)) {
                activity = this.parseActivityAlias(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (activity == null) {
                    int n74;
                    this.mParseError = n74 = 65428;
                    return false;
                }
                boolean bl18 = package_.activities.add(activity);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                int n75;
                Bundle bundle;
                Bundle bundle2;
                Bundle bundle3 = package_.mAppMetaData;
                PackageParser packageParser = this;
                Resources resources5 = resources;
                XmlPullParser xmlPullParser4 = xmlPullParser;
                AttributeSet attributeSet5 = attributeSet;
                String[] stringArray10 = stringArray;
                package_.mAppMetaData = bundle2 = (bundle = packageParser.parseMetaData(resources5, xmlPullParser4, attributeSet5, bundle3, stringArray10));
                if (bundle != null) continue;
                this.mParseError = n75 = 65428;
                return false;
            }
            String string39 = string29;
            String string40 = "uses-library";
            if (string39.equals(string40)) {
                TypedArray typedArray26;
                int[] nArray3 = R.styleable.AndroidManifestUsesLibrary;
                Resources resources6 = resources;
                AttributeSet attributeSet6 = attributeSet;
                int[] nArray4 = nArray3;
                TypedArray typedArray27 = typedArray26 = resources6.obtainAttributes(attributeSet6, nArray4);
                int n76 = 0;
                String string41 = typedArray27.getNonResourceString(n76);
                TypedArray typedArray28 = typedArray26;
                int n77 = 1;
                boolean bl19 = true;
                boolean bl20 = typedArray28.getBoolean(n77, bl19);
                typedArray26.recycle();
                if (string41 != null) {
                    if (bl20) {
                        String string42;
                        ArrayList<String> arrayList;
                        if (package_.usesLibraries == null) {
                            ArrayList arrayList2 = new ArrayList();
                            package_.usesLibraries = arrayList2;
                        }
                        if (!(arrayList = package_.usesLibraries).contains(string42 = string41)) {
                            ArrayList<String> arrayList3 = package_.usesLibraries;
                            String string43 = string41.intern();
                            boolean bl21 = arrayList3.add(string43);
                        }
                    } else {
                        String string44;
                        ArrayList<String> arrayList;
                        if (package_.usesOptionalLibraries == null) {
                            ArrayList arrayList4 = new ArrayList();
                            package_.usesOptionalLibraries = arrayList4;
                        }
                        if (!(arrayList = package_.usesOptionalLibraries).contains(string44 = string41)) {
                            ArrayList<String> arrayList5 = package_.usesOptionalLibraries;
                            String string45 = string41.intern();
                            boolean bl22 = arrayList5.add(string45);
                        }
                    }
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            String string46 = string29;
            String string47 = "uses-package";
            if (string46.equals(string47)) {
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unknown element under <application>: ");
            String string48 = string29;
            StringBuilder stringBuilder2 = stringBuilder.append(string48).append(" at ");
            String string49 = this.mArchiveSourcePath;
            StringBuilder stringBuilder3 = stringBuilder2.append(string49).append(" ");
            String string50 = xmlPullParser.getPositionDescription();
            String string51 = stringBuilder3.append(string50).toString();
            int n78 = Log.w(TAG, string51);
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Instrumentation parseInstrumentation(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        boolean bl;
        boolean bl2;
        int[] nArray = R.styleable.AndroidManifestInstrumentation;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, nArray);
        if (this.mParseInstrumentationArgs == null) {
            ParsePackageItemArgs parsePackageItemArgs;
            Package package_2 = package_;
            String[] stringArray2 = stringArray;
            this.mParseInstrumentationArgs = parsePackageItemArgs = new ParsePackageItemArgs(package_2, stringArray2, 2, 0, 1, 0);
            this.mParseInstrumentationArgs.tag = "<instrumentation>";
        }
        this.mParseInstrumentationArgs.sa = typedArray;
        ParsePackageItemArgs parsePackageItemArgs = this.mParseInstrumentationArgs;
        InstrumentationInfo instrumentationInfo = new InstrumentationInfo();
        Instrumentation instrumentation = new Instrumentation(parsePackageItemArgs, instrumentationInfo);
        if (stringArray[0] != null) {
            typedArray.recycle();
            this.mParseError = 65428;
            return null;
        }
        String string2 = typedArray.getNonResourceString(3);
        InstrumentationInfo instrumentationInfo2 = instrumentation.info;
        String string3 = string2 != null ? string2.intern() : null;
        instrumentationInfo2.targetPackage = string3;
        InstrumentationInfo instrumentationInfo3 = instrumentation.info;
        instrumentationInfo3.handleProfiling = bl2 = typedArray.getBoolean(4, false);
        InstrumentationInfo instrumentationInfo4 = instrumentation.info;
        instrumentationInfo4.functionalTest = bl = typedArray.getBoolean(5, false);
        typedArray.recycle();
        if (instrumentation.info.targetPackage == null) {
            stringArray[0] = "<instrumentation> does not specify targetPackage";
            this.mParseError = 65428;
            return null;
        }
        PackageParser packageParser = this;
        Resources resources2 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        AttributeSet attributeSet2 = attributeSet;
        String[] stringArray3 = stringArray;
        if (!packageParser.parseAllMetaData(resources2, xmlPullParser2, attributeSet2, "<instrumentation>", instrumentation, stringArray3)) {
            this.mParseError = 65428;
            return null;
        }
        boolean bl3 = package_.instrumentation.add(instrumentation);
        return instrumentation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseIntent(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, IntentInfo intentInfo, String[] stringArray, boolean bl) throws XmlPullParserException, IOException {
        boolean bl2;
        int n2;
        int n3;
        int[] nArray = R.styleable.AndroidManifestIntentFilter;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray = resources2.obtainAttributes(attributeSet2, nArray2);
        int n4 = typedArray.getInt(2, 0);
        IntentInfo intentInfo2 = intentInfo;
        int n5 = n4;
        intentInfo2.setPriority(n5);
        TypedValue typedValue = typedArray.peekValue(0);
        if (typedValue != null) {
            int n6;
            int n7;
            intentInfo.labelRes = n7 = (n6 = typedValue.resourceId);
            if (n6 == 0) {
                CharSequence charSequence;
                intentInfo.nonLocalizedLabel = charSequence = typedValue.coerceToString();
            }
        }
        intentInfo.icon = n3 = typedArray.getResourceId(1, 0);
        typedArray.recycle();
        int n8 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n8)) {
            String string2;
            if (n2 == 3 || n2 == 4) continue;
            String string3 = xmlPullParser.getName();
            if (string3.equals("action")) {
                AttributeSet attributeSet3 = attributeSet;
                String string4 = ANDROID_RESOURCES;
                String string5 = "name";
                string2 = attributeSet3.getAttributeValue(string4, string5);
                if (string2 == null || string2 == "") {
                    stringArray[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                IntentInfo intentInfo3 = intentInfo;
                String string6 = string2;
                intentInfo3.addAction(string6);
                continue;
            }
            if (string3.equals("category")) {
                AttributeSet attributeSet4 = attributeSet;
                String string7 = ANDROID_RESOURCES;
                String string8 = "name";
                string2 = attributeSet4.getAttributeValue(string7, string8);
                if (string2 == null || string2 == "") {
                    stringArray[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                IntentInfo intentInfo4 = intentInfo;
                String string9 = string2;
                intentInfo4.addCategory(string9);
                continue;
            }
            if (string3.equals("data")) {
                String string10;
                String string11;
                String string12;
                String string13;
                Resources resources3 = resources;
                AttributeSet attributeSet5 = attributeSet;
                int[] nArray3 = R.styleable.AndroidManifestData;
                int[] nArray4 = nArray3;
                typedArray = resources3.obtainAttributes(attributeSet5, nArray4);
                String string14 = typedArray.getNonConfigurationString(0, 0);
                if (string14 != null) {
                    try {
                        IntentInfo intentInfo5 = intentInfo;
                        String string15 = string14;
                        intentInfo5.addDataType(string15);
                    }
                    catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
                        String string24;
                        stringArray[0] = string24 = malformedMimeTypeException.toString();
                        typedArray.recycle();
                        return false;
                    }
                }
                if ((string13 = typedArray.getNonConfigurationString(1, 0)) != null) {
                    IntentInfo intentInfo6 = intentInfo;
                    String string16 = string13;
                    intentInfo6.addDataScheme(string16);
                }
                String string17 = typedArray.getNonConfigurationString(2, 0);
                String string18 = typedArray.getNonConfigurationString(3, 0);
                if (string17 != null) {
                    IntentInfo intentInfo7 = intentInfo;
                    String string19 = string17;
                    String string20 = string18;
                    intentInfo7.addDataAuthority(string19, string20);
                }
                if ((string12 = typedArray.getNonConfigurationString(4, 0)) != null) {
                    IntentInfo intentInfo8 = intentInfo;
                    String string21 = string12;
                    int n9 = 0;
                    intentInfo8.addDataPath(string21, n9);
                }
                if ((string11 = typedArray.getNonConfigurationString(5, 0)) != null) {
                    IntentInfo intentInfo9 = intentInfo;
                    String string22 = string11;
                    int n10 = 1;
                    intentInfo9.addDataPath(string22, n10);
                }
                if ((string10 = typedArray.getNonConfigurationString(6, 0)) != null) {
                    IntentInfo intentInfo10 = intentInfo;
                    String string23 = string10;
                    int n11 = 2;
                    intentInfo10.addDataPath(string23, n11);
                }
                typedArray.recycle();
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unknown element under <intent-filter>: ");
            String string25 = xmlPullParser.getName();
            StringBuilder stringBuilder2 = stringBuilder.append(string25).append(" at ");
            String string26 = this.mArchiveSourcePath;
            StringBuilder stringBuilder3 = stringBuilder2.append(string26).append(" ");
            String string27 = xmlPullParser.getPositionDescription();
            String string28 = stringBuilder3.append(string27).toString();
            int n12 = Log.w(TAG, string28);
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        IntentInfo intentInfo11 = intentInfo;
        String string29 = "android.intent.category.DEFAULT";
        intentInfo.hasDefault = bl2 = intentInfo11.hasCategory(string29);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Bundle parseMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Bundle bundle, String[] stringArray) throws XmlPullParserException, IOException {
        TypedArray typedArray;
        block10: {
            block12: {
                TypedValue typedValue;
                String string2;
                block14: {
                    void var13_17;
                    block13: {
                        void var13_14;
                        block11: {
                            int[] nArray = R.styleable.AndroidManifestMetaData;
                            typedArray = resources.obtainAttributes(attributeSet, nArray);
                            if (bundle == null) {
                                bundle = new Bundle();
                            }
                            if ((string2 = typedArray.getNonConfigurationString(0, 0)) == null) {
                                stringArray[0] = "<meta-data> requires an android:name attribute";
                                typedArray.recycle();
                                return null;
                            }
                            string2 = string2.intern();
                            typedValue = typedArray.peekValue(2);
                            if (typedValue == null || typedValue.resourceId == 0) break block11;
                            int n = typedValue.resourceId;
                            bundle.putInt(string2, n);
                            break block10;
                        }
                        typedValue = typedArray.peekValue(1);
                        if (typedValue == null) break block12;
                        if (typedValue.type != 3) break block13;
                        CharSequence charSequence = typedValue.coerceToString();
                        if (charSequence != null) {
                            String string3 = ((Object)charSequence).toString().intern();
                        } else {
                            Object var13_15 = null;
                        }
                        bundle.putString(string2, (String)var13_14);
                        break block10;
                    }
                    if (typedValue.type != 18) break block14;
                    if (typedValue.data != 0) {
                        Object var13_16 = null;
                    } else {
                        Object var13_18 = null;
                    }
                    bundle.putBoolean(string2, (boolean)var13_17);
                    break block10;
                }
                if (typedValue.type >= 16 && typedValue.type <= 31) {
                    int n = typedValue.data;
                    bundle.putInt(string2, n);
                    break block10;
                } else if (typedValue.type == 4) {
                    float f = typedValue.getFloat();
                    bundle.putFloat(string2, f);
                    break block10;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("<meta-data> only supports string, integer, float, color, boolean, and resource reference types: ");
                    String string4 = xmlPullParser.getName();
                    StringBuilder stringBuilder2 = stringBuilder.append(string4).append(" at ");
                    String string5 = this.mArchiveSourcePath;
                    StringBuilder stringBuilder3 = stringBuilder2.append(string5).append(" ");
                    String string6 = xmlPullParser.getPositionDescription();
                    String string7 = stringBuilder3.append(string6).toString();
                    int n = Log.w(TAG, string7);
                }
                break block10;
            }
            stringArray[0] = "<meta-data> requires an android:value or android:resource attribute";
            bundle = null;
        }
        typedArray.recycle();
        XmlUtils.skipCurrentTag(xmlPullParser);
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Package parsePackage(Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        TypedArray typedArray;
        String string2;
        String string3;
        int n13;
        TypedArray typedArray2;
        Package package_;
        XmlResourceParser xmlResourceParser2 = xmlResourceParser;
        Object var6_6 = null;
        this.mParseInstrumentationArgs = var6_6;
        Object var7_7 = null;
        this.mParseActivityArgs = var7_7;
        Object var8_8 = null;
        this.mParseServiceArgs = var8_8;
        Object var9_9 = null;
        this.mParseProviderArgs = var9_9;
        XmlResourceParser xmlResourceParser3 = xmlResourceParser;
        XmlResourceParser xmlResourceParser4 = xmlResourceParser2;
        int n14 = n;
        String[] stringArray2 = stringArray;
        String string4 = PackageParser.parsePackageName(xmlResourceParser3, xmlResourceParser4, n14, stringArray2);
        if (string4 == null) {
            int n15;
            this.mParseError = n15 = 65430;
            return null;
        }
        Package package_2 = package_;
        String string5 = string4;
        package_2(string5);
        boolean bl = false;
        int[] nArray = R.styleable.AndroidManifest;
        Resources resources2 = resources;
        XmlResourceParser xmlResourceParser5 = xmlResourceParser2;
        int[] nArray2 = nArray;
        TypedArray typedArray3 = typedArray2 = resources2.obtainAttributes(xmlResourceParser5, nArray2);
        int n16 = 1;
        int n17 = 0;
        package_.mVersionCode = n13 = typedArray3.getInteger(n16, n17);
        TypedArray typedArray4 = typedArray2;
        int n18 = 2;
        int n19 = 0;
        package_.mVersionName = string3 = typedArray4.getNonConfigurationString(n18, n19);
        if (package_.mVersionName != null) {
            String string6;
            package_.mVersionName = string6 = package_.mVersionName.intern();
        }
        if ((string2 = (typedArray = typedArray2).getNonConfigurationString(n12 = 0, n11 = 0)) != null && string2.length() > 0) {
            int n20;
            String string7;
            String string8;
            String string9;
            String string10 = string2;
            boolean bl2 = true;
            String string11 = PackageParser.validateName(string10, bl2);
            if (string11 != null && !(string9 = "android").equals(string8 = string4)) {
                int n21;
                String string12;
                StringBuilder stringBuilder = new StringBuilder().append("<manifest> specifies bad sharedUserId name \"");
                String string13 = string2;
                StringBuilder stringBuilder2 = stringBuilder.append(string13).append("\": ");
                String string14 = string11;
                stringArray[0] = string12 = stringBuilder2.append(string14).toString();
                this.mParseError = n21 = 65429;
                return null;
            }
            package_.mSharedUserId = string7 = string2.intern();
            TypedArray typedArray5 = typedArray2;
            int n22 = 3;
            int n23 = 0;
            package_.mSharedUserLabel = n20 = typedArray5.getResourceId(n22, n23);
        }
        typedArray2.recycle();
        TypedArray typedArray6 = typedArray2;
        int n24 = 4;
        int n25 = -1;
        package_.installLocation = n10 = typedArray6.getInteger(n24, n25);
        ApplicationInfo applicationInfo = package_.applicationInfo;
        applicationInfo.installLocation = n9 = package_.installLocation;
        int n26 = 1;
        int n27 = 1;
        int n28 = 1;
        int n29 = 1;
        int n30 = 1;
        int n31 = 1;
        int n32 = xmlResourceParser.getDepth();
        while ((n8 = (n7 = xmlResourceParser.next())) != (n6 = 1) && ((n5 = n7) != (n4 = 3) || (n3 = xmlResourceParser.getDepth()) > (n2 = n32))) {
            String string15;
            String string16;
            int n33;
            int n34;
            int n35 = n7;
            int n36 = 3;
            if (n35 == n36 || (n34 = n7) == (n33 = 4)) continue;
            String string17 = xmlResourceParser.getName();
            String string18 = string17;
            if (string18.equals(string16 = "application")) {
                if (bl) {
                    int n37 = Log.w(TAG, "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(xmlResourceParser);
                    continue;
                }
                bl = true;
                PackageParser packageParser = this;
                Resources resources3 = resources;
                XmlResourceParser xmlResourceParser6 = xmlResourceParser;
                int n38 = n;
                String[] stringArray3 = stringArray;
                if (packageParser.parseApplication(package_, resources3, xmlResourceParser6, xmlResourceParser2, n38, stringArray3)) continue;
                return null;
            }
            String string19 = string17;
            String string20 = "permission-group";
            if (string19.equals(string20)) {
                PackageParser packageParser = this;
                Resources resources4 = resources;
                XmlResourceParser xmlResourceParser7 = xmlResourceParser;
                String[] stringArray4 = stringArray;
                if (packageParser.parsePermissionGroup(package_, resources4, xmlResourceParser7, xmlResourceParser2, stringArray4) != null) continue;
                return null;
            }
            String string21 = string17;
            String string22 = "permission";
            if (string21.equals(string22)) {
                PackageParser packageParser = this;
                Resources resources5 = resources;
                XmlResourceParser xmlResourceParser8 = xmlResourceParser;
                String[] stringArray5 = stringArray;
                if (packageParser.parsePermission(package_, resources5, xmlResourceParser8, xmlResourceParser2, stringArray5) != null) continue;
                return null;
            }
            String string23 = string17;
            String string24 = "permission-tree";
            if (string23.equals(string24)) {
                PackageParser packageParser = this;
                Resources resources6 = resources;
                XmlResourceParser xmlResourceParser9 = xmlResourceParser;
                String[] stringArray6 = stringArray;
                if (packageParser.parsePermissionTree(package_, resources6, xmlResourceParser9, xmlResourceParser2, stringArray6) != null) continue;
                return null;
            }
            String string25 = string17;
            String string26 = "uses-permission";
            if (string25.equals(string26)) {
                String string27;
                ArrayList<String> arrayList;
                TypedArray typedArray7;
                int[] nArray3 = R.styleable.AndroidManifestUsesPermission;
                Resources resources7 = resources;
                XmlResourceParser xmlResourceParser10 = xmlResourceParser2;
                int[] nArray4 = nArray3;
                TypedArray typedArray8 = typedArray7 = resources7.obtainAttributes(xmlResourceParser10, nArray4);
                int n39 = 0;
                string15 = typedArray8.getNonResourceString(n39);
                typedArray7.recycle();
                if (string15 != null && !(arrayList = package_.requestedPermissions).contains(string27 = string15)) {
                    ArrayList<String> arrayList2 = package_.requestedPermissions;
                    String string28 = string15.intern();
                    boolean bl3 = arrayList2.add(string28);
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string29 = string17;
            String string30 = "uses-configuration";
            if (string29.equals(string30)) {
                int n40;
                int n41;
                int n42;
                ConfigurationInfo configurationInfo = new ConfigurationInfo();
                int[] nArray5 = R.styleable.AndroidManifestUsesConfiguration;
                Resources resources8 = resources;
                XmlResourceParser xmlResourceParser11 = xmlResourceParser2;
                int[] nArray6 = nArray5;
                TypedArray typedArray9 = typedArray2 = resources8.obtainAttributes(xmlResourceParser11, nArray6);
                int n43 = 0;
                int n44 = 0;
                configurationInfo.reqTouchScreen = n42 = typedArray9.getInt(n43, n44);
                TypedArray typedArray10 = typedArray2;
                int n45 = 1;
                int n46 = 0;
                configurationInfo.reqKeyboardType = n41 = typedArray10.getInt(n45, n46);
                TypedArray typedArray11 = typedArray2;
                int n47 = 2;
                boolean bl4 = false;
                if (typedArray11.getBoolean(n47, bl4)) {
                    int n48;
                    configurationInfo.reqInputFeatures = n48 = configurationInfo.reqInputFeatures | 1;
                }
                TypedArray typedArray12 = typedArray2;
                int n49 = 3;
                int n50 = 0;
                configurationInfo.reqNavigation = n40 = typedArray12.getInt(n49, n50);
                TypedArray typedArray13 = typedArray2;
                int n51 = 4;
                boolean bl5 = false;
                if (typedArray13.getBoolean(n51, bl5)) {
                    int n52;
                    configurationInfo.reqInputFeatures = n52 = configurationInfo.reqInputFeatures | 2;
                }
                typedArray2.recycle();
                boolean bl6 = package_.configPreferences.add(configurationInfo);
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string31 = string17;
            String string32 = "uses-feature";
            if (string31.equals(string32)) {
                boolean bl7;
                int n53;
                TypedArray typedArray14;
                String string33;
                FeatureInfo featureInfo = new FeatureInfo();
                int[] nArray7 = R.styleable.AndroidManifestUsesFeature;
                Resources resources9 = resources;
                XmlResourceParser xmlResourceParser12 = xmlResourceParser2;
                int[] nArray8 = nArray7;
                TypedArray typedArray15 = typedArray2 = resources9.obtainAttributes(xmlResourceParser12, nArray8);
                int n54 = 0;
                featureInfo.name = string33 = typedArray15.getNonResourceString(n54);
                if (featureInfo.name == null) {
                    int n55;
                    TypedArray typedArray16 = typedArray2;
                    int n56 = 1;
                    int n57 = 0;
                    featureInfo.reqGlEsVersion = n55 = typedArray16.getInt(n56, n57);
                }
                if ((typedArray14 = typedArray2).getBoolean(n53 = 2, bl7 = true)) {
                    int n58;
                    featureInfo.flags = n58 = featureInfo.flags | 1;
                }
                typedArray2.recycle();
                if (package_.reqFeatures == null) {
                    ArrayList arrayList = new ArrayList();
                    package_.reqFeatures = arrayList;
                }
                boolean bl8 = package_.reqFeatures.add(featureInfo);
                if (featureInfo.name == null) {
                    int n59;
                    ConfigurationInfo configurationInfo = new ConfigurationInfo();
                    configurationInfo.reqGlEsVersion = n59 = featureInfo.reqGlEsVersion;
                    boolean bl9 = package_.configPreferences.add(configurationInfo);
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string34 = string17;
            String string35 = "uses-sdk";
            if (string34.equals(string35)) {
                if (SDK_VERSION > 0) {
                    int n60;
                    TypedArray typedArray17;
                    TypedValue typedValue;
                    int[] nArray9 = R.styleable.AndroidManifestUsesSdk;
                    Resources resources10 = resources;
                    XmlResourceParser xmlResourceParser13 = xmlResourceParser2;
                    int[] nArray10 = nArray9;
                    typedArray2 = resources10.obtainAttributes(xmlResourceParser13, nArray10);
                    int n61 = 0;
                    String string36 = null;
                    int n62 = 0;
                    String string37 = null;
                    TypedArray typedArray18 = typedArray2;
                    int n63 = 0;
                    TypedValue typedValue2 = typedArray18.peekValue(n63);
                    if (typedValue2 != null) {
                        if (typedValue2.type == 3 && typedValue2.string != null) {
                            string37 = string36 = ((Object)typedValue2.string).toString();
                        } else {
                            n62 = n61 = typedValue2.data;
                        }
                    }
                    if ((typedValue = (typedArray17 = typedArray2).peekValue(n60 = 1)) != null) {
                        if (typedValue.type == 3 && typedValue.string != null) {
                            string37 = string36 = ((Object)typedValue.string).toString();
                        } else {
                            n62 = typedValue.data;
                        }
                    }
                    typedArray2.recycle();
                    if (string36 != null) {
                        String string38 = string36;
                        String string39 = SDK_CODENAME;
                        String string40 = string39;
                        if (!string38.equals(string40)) {
                            int n64;
                            if (SDK_CODENAME != null) {
                                String string41;
                                StringBuilder stringBuilder = new StringBuilder().append("Requires development platform ");
                                String string42 = string36;
                                StringBuilder stringBuilder3 = stringBuilder.append(string42).append(" (current platform is ");
                                String string43 = SDK_CODENAME;
                                stringArray[0] = string41 = stringBuilder3.append(string43).append(")").toString();
                            } else {
                                String string44;
                                StringBuilder stringBuilder = new StringBuilder().append("Requires development platform ");
                                String string45 = string36;
                                stringArray[0] = string44 = stringBuilder.append(string45).append(" but this is a release platform.").toString();
                            }
                            this.mParseError = n64 = 65524;
                            return null;
                        }
                    } else {
                        int n65 = n61;
                        int n66 = SDK_VERSION;
                        int n67 = n66;
                        if (n65 > n67) {
                            int n68;
                            String string46;
                            StringBuilder stringBuilder = new StringBuilder().append("Requires newer sdk version #");
                            int n69 = n61;
                            StringBuilder stringBuilder4 = stringBuilder.append(n69).append(" (current version is #");
                            int n70 = SDK_VERSION;
                            stringArray[0] = string46 = stringBuilder4.append(n70).append(")").toString();
                            this.mParseError = n68 = 65524;
                            return null;
                        }
                    }
                    if (string37 != null) {
                        String string47 = string37;
                        String string48 = SDK_CODENAME;
                        String string49 = string48;
                        if (!string47.equals(string49)) {
                            int n71;
                            if (SDK_CODENAME != null) {
                                String string50;
                                StringBuilder stringBuilder = new StringBuilder().append("Requires development platform ");
                                String string51 = string37;
                                StringBuilder stringBuilder5 = stringBuilder.append(string51).append(" (current platform is ");
                                String string52 = SDK_CODENAME;
                                stringArray[0] = string50 = stringBuilder5.append(string52).append(")").toString();
                            } else {
                                String string53;
                                StringBuilder stringBuilder = new StringBuilder().append("Requires development platform ");
                                String string54 = string37;
                                stringArray[0] = string53 = stringBuilder.append(string54).append(" but this is a release platform.").toString();
                            }
                            this.mParseError = n71 = 65524;
                            return null;
                        }
                        package_.applicationInfo.targetSdkVersion = 10000;
                    } else {
                        int n72;
                        ApplicationInfo applicationInfo2 = package_.applicationInfo;
                        applicationInfo2.targetSdkVersion = n72 = n62;
                    }
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string55 = string17;
            String string56 = "supports-screens";
            if (string55.equals(string56)) {
                TypedArray typedArray19;
                int[] nArray11 = R.styleable.AndroidManifestSupportsScreens;
                Resources resources11 = resources;
                XmlResourceParser xmlResourceParser14 = xmlResourceParser2;
                int[] nArray12 = nArray11;
                TypedArray typedArray20 = typedArray19 = resources11.obtainAttributes(xmlResourceParser14, nArray12);
                int n73 = 1;
                int n74 = n26;
                n26 = typedArray20.getInteger(n73, n74);
                TypedArray typedArray21 = typedArray19;
                int n75 = 2;
                int n76 = n27;
                n27 = typedArray21.getInteger(n75, n76);
                TypedArray typedArray22 = typedArray19;
                int n77 = 3;
                int n78 = n28;
                n28 = typedArray22.getInteger(n77, n78);
                TypedArray typedArray23 = typedArray19;
                int n79 = 5;
                int n80 = n29;
                n29 = typedArray23.getInteger(n79, n80);
                TypedArray typedArray24 = typedArray19;
                int n81 = 4;
                int n82 = n30;
                n30 = typedArray24.getInteger(n81, n82);
                TypedArray typedArray25 = typedArray19;
                int n83 = 0;
                int n84 = n31;
                n31 = typedArray25.getInteger(n83, n84);
                typedArray19.recycle();
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string57 = string17;
            String string58 = "protected-broadcast";
            if (string57.equals(string58)) {
                TypedArray typedArray26;
                int[] nArray13 = R.styleable.AndroidManifestProtectedBroadcast;
                Resources resources12 = resources;
                XmlResourceParser xmlResourceParser15 = xmlResourceParser2;
                int[] nArray14 = nArray13;
                TypedArray typedArray27 = typedArray26 = resources12.obtainAttributes(xmlResourceParser15, nArray14);
                int n85 = 0;
                string15 = typedArray27.getNonResourceString(n85);
                typedArray26.recycle();
                if (string15 != null && (n & 1) != 0) {
                    String string59;
                    ArrayList<String> arrayList;
                    if (package_.protectedBroadcasts == null) {
                        ArrayList arrayList3 = new ArrayList();
                        package_.protectedBroadcasts = arrayList3;
                    }
                    if (!(arrayList = package_.protectedBroadcasts).contains(string59 = string15)) {
                        ArrayList<String> arrayList4 = package_.protectedBroadcasts;
                        String string60 = string15.intern();
                        boolean bl10 = arrayList4.add(string60);
                    }
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string61 = string17;
            String string62 = "instrumentation";
            if (string61.equals(string62)) {
                PackageParser packageParser = this;
                Resources resources13 = resources;
                XmlResourceParser xmlResourceParser16 = xmlResourceParser;
                String[] stringArray7 = stringArray;
                if (packageParser.parseInstrumentation(package_, resources13, xmlResourceParser16, xmlResourceParser2, stringArray7) != null) continue;
                return null;
            }
            String string63 = string17;
            String string64 = "original-package";
            if (string63.equals(string64)) {
                int n86;
                int n87;
                String string65 = package_.packageName;
                Resources resources14 = resources;
                XmlResourceParser xmlResourceParser17 = xmlResourceParser2;
                int[] nArray15 = R.styleable.AndroidManifestOriginalPackage;
                int[] nArray16 = nArray15;
                typedArray2 = resources14.obtainAttributes(xmlResourceParser17, nArray16);
                TypedArray typedArray28 = typedArray2;
                String string66 = typedArray28.getNonConfigurationString(n87 = 0, n86 = 0);
                String string67 = string66;
                if (!string65.equals(string67)) {
                    if (package_.mOriginalPackages == null) {
                        String string68;
                        ArrayList arrayList = new ArrayList();
                        package_.mOriginalPackages = arrayList;
                        package_.mRealPackage = string68 = package_.packageName;
                    }
                    ArrayList<String> arrayList = package_.mOriginalPackages;
                    String string69 = string66;
                    boolean bl11 = arrayList.add(string69);
                }
                typedArray2.recycle();
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string70 = string17;
            String string71 = "adopt-permissions";
            if (string70.equals(string71)) {
                TypedArray typedArray29;
                int[] nArray17 = R.styleable.AndroidManifestOriginalPackage;
                Resources resources15 = resources;
                XmlResourceParser xmlResourceParser18 = xmlResourceParser2;
                int[] nArray18 = nArray17;
                TypedArray typedArray30 = typedArray29 = resources15.obtainAttributes(xmlResourceParser18, nArray18);
                int n88 = 0;
                int n89 = 0;
                string15 = typedArray30.getNonConfigurationString(n88, n89);
                typedArray29.recycle();
                if (string15 != null) {
                    if (package_.mAdoptPermissions == null) {
                        ArrayList arrayList = new ArrayList();
                        package_.mAdoptPermissions = arrayList;
                    }
                    ArrayList<String> arrayList = package_.mAdoptPermissions;
                    String string72 = string15;
                    boolean bl12 = arrayList.add(string72);
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string73 = string17;
            String string74 = "uses-gl-texture";
            if (string73.equals(string74)) {
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string75 = string17;
            String string76 = "compatible-screens";
            if (string75.equals(string76)) {
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            String string77 = string17;
            String string78 = "eat-comment";
            if (string77.equals(string78)) {
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unknown element under <manifest>: ");
            String string79 = xmlResourceParser.getName();
            StringBuilder stringBuilder6 = stringBuilder.append(string79).append(" at ");
            String string80 = this.mArchiveSourcePath;
            StringBuilder stringBuilder7 = stringBuilder6.append(string80).append(" ");
            String string81 = xmlResourceParser.getPositionDescription();
            String string82 = stringBuilder7.append(string81).toString();
            int n90 = Log.w(TAG, string82);
            XmlUtils.skipCurrentTag(xmlResourceParser);
        }
        if (!bl && package_.instrumentation.size() == 0) {
            int n91;
            stringArray[0] = "<manifest> does not contain an <application> or <instrumentation>";
            this.mParseError = n91 = 65427;
        }
        int n92 = NEW_PERMISSIONS.length;
        StringBuilder stringBuilder = null;
        int n93 = 0;
        while (true) {
            NewPermissionInfo newPermissionInfo;
            block70: {
                int n94;
                block69: {
                    int n95;
                    int n96;
                    if ((n96 = ++n93) >= (n95 = n92)) break block69;
                    newPermissionInfo = NEW_PERMISSIONS[n93];
                    int n97 = package_.applicationInfo.targetSdkVersion;
                    int n98 = newPermissionInfo.sdkVersion;
                    if (n97 < n98) break block70;
                }
                if (stringBuilder != null) {
                    String string83 = stringBuilder.toString();
                    int n99 = Log.i(TAG, string83);
                }
                if (n26 < 0 || n26 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
                    int n100;
                    ApplicationInfo applicationInfo3 = package_.applicationInfo;
                    applicationInfo3.flags = n100 = applicationInfo3.flags | 0x200;
                }
                if (n27 != 0) {
                    int n101;
                    ApplicationInfo applicationInfo4 = package_.applicationInfo;
                    applicationInfo4.flags = n101 = applicationInfo4.flags | 0x400;
                }
                if (n28 < 0 || n28 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
                    int n102;
                    ApplicationInfo applicationInfo5 = package_.applicationInfo;
                    applicationInfo5.flags = n102 = applicationInfo5.flags | 0x800;
                }
                if (n29 < 0 || n29 > 0 && package_.applicationInfo.targetSdkVersion >= 9) {
                    int n103;
                    ApplicationInfo applicationInfo6 = package_.applicationInfo;
                    applicationInfo6.flags = n103 = applicationInfo6.flags | 0x80000;
                }
                if (n30 < 0 || n30 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
                    int n104;
                    ApplicationInfo applicationInfo7 = package_.applicationInfo;
                    applicationInfo7.flags = n104 = applicationInfo7.flags | 0x1000;
                }
                if (n31 >= 0) {
                    if (n31 <= 0) return package_;
                    if (package_.applicationInfo.targetSdkVersion < 4) return package_;
                }
                ApplicationInfo applicationInfo8 = package_.applicationInfo;
                applicationInfo8.flags = n94 = applicationInfo8.flags | 0x2000;
                return package_;
            }
            ArrayList<String> arrayList = package_.requestedPermissions;
            String string84 = newPermissionInfo.name;
            if (arrayList.contains(string84)) continue;
            if (stringBuilder == null) {
                StringBuilder stringBuilder8 = stringBuilder;
                int n105 = 128;
                stringBuilder8(n105);
                String string85 = package_.packageName;
                StringBuilder stringBuilder9 = stringBuilder;
                String string86 = string85;
                StringBuilder stringBuilder10 = stringBuilder9.append(string86);
                StringBuilder stringBuilder11 = stringBuilder;
                String string87 = ": compat added ";
                StringBuilder stringBuilder12 = stringBuilder11.append(string87);
            } else {
                StringBuilder stringBuilder13 = stringBuilder;
                char c = ' ';
                StringBuilder stringBuilder14 = stringBuilder13.append(c);
            }
            String string88 = newPermissionInfo.name;
            StringBuilder stringBuilder15 = stringBuilder;
            String string89 = string88;
            StringBuilder stringBuilder16 = stringBuilder15.append(string89);
            ArrayList<String> arrayList5 = package_.requestedPermissions;
            String string90 = newPermissionInfo.name;
            boolean bl13 = arrayList5.add(string90);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parsePackageItemInfo(Package package_, PackageItemInfo packageItemInfo, String[] stringArray, String string2, TypedArray typedArray, int n, int n2, int n3, int n4) {
        String string3;
        TypedValue typedValue;
        String string4;
        String string5 = typedArray.getNonConfigurationString(n, 0);
        if (string5 == null) {
            String string6;
            stringArray[0] = string6 = string2 + " does not specify android:name";
            return false;
        }
        packageItemInfo.name = string4 = PackageParser.buildClassName(package_.applicationInfo.packageName, string5, stringArray);
        if (packageItemInfo.name == null) {
            return false;
        }
        int n5 = typedArray.getResourceId(n3, 0);
        if (n5 != 0) {
            packageItemInfo.icon = n5;
            packageItemInfo.nonLocalizedLabel = null;
        }
        if ((typedValue = typedArray.peekValue(n2)) != null) {
            int n6;
            packageItemInfo.labelRes = n6 = typedValue.resourceId;
            if (n6 == 0) {
                CharSequence charSequence;
                packageItemInfo.nonLocalizedLabel = charSequence = typedValue.coerceToString();
            }
        }
        packageItemInfo.packageName = string3 = package_.packageName;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static PackageLite parsePackageLite(String var0, int var1_1) {
        block18: {
            var2_2 = null;
            var3_3 = new AssetManager();
            var4_4 = var3_3.addAssetPath(var0);
            var7_7 = var6_6 = (var5_5 = var3_3.openXmlResourceParser(var4_4, "AndroidManifest.xml"));
            var8_8 = new String[1];
            var9_9 = null;
            try {
                var9_9 = var10_10 = PackageParser.parsePackageLite(var6_6, var7_7, var1_1, var8_8);
                if (var6_6 != null) {
                    var6_6.close();
                }
                if (var3_3 != null) {
                    var3_3.close();
                }
lbl15:
                // 7 sources

                while (var9_9 == null) {
                    var11_11 = new StringBuilder().append("parsePackageLite error: ");
                }
                break block18;
            }
            catch (IOException var20_22) {
                var21_24 = Log.w("PackageParser", var0, var20_22);
                ** GOTO lbl15
            }
            catch (XmlPullParserException var20_23) {
                var22_25 = Log.w("PackageParser", var0, var20_23);
                ** GOTO lbl15
                {
                    catch (Throwable var23_26) {
                        throw var23_26;
                    }
                }
            }
            finally {
                if (var6_6 != null) {
                    var6_6.close();
                }
                if (var3_3 == null) ** GOTO lbl15
                var3_3.close();
                ** GOTO lbl15
            }
            {
                var12_12 = var8_8[0];
                var13_13 = var11_11.append(var12_12).toString();
                var14_14 = Log.e("PackageParser", var13_13);
                var15_15 = var3_3;
                var16_16 = null;
lbl23:
                // 3 sources

                return var16_16;
                break;
            }
            catch (Exception var17_17) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    var18_20 = "Unable to read AndroidManifest.xml of " + var0;
                    var19_21 = Log.w("PackageParser", var18_20, (Throwable)var17_18);
                    var16_16 = null;
                    ** GOTO lbl23
                    break;
                }
            }
        }
        var24_27 = var3_3;
        var16_16 = var9_9;
        ** while (true)
        catch (Exception var17_19) {
            var2_2 = var3_3;
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PackageLite parsePackageLite(XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws IOException, XmlPullParserException {
        int n2;
        while ((n2 = xmlPullParser.next()) != 2 && n2 != 1) {
        }
        if (n2 != 2) {
            stringArray[0] = "No start tag found";
            return null;
        }
        if ((n & 2) != 0) {
            // empty if block
        }
        if (!xmlPullParser.getName().equals("manifest")) {
            stringArray[0] = "No <manifest> tag";
            return null;
        }
        String string2 = attributeSet.getAttributeValue(null, "package");
        if (string2 == null || string2.length() == 0) {
            stringArray[0] = "<manifest> does not specify package";
            return null;
        }
        String string3 = PackageParser.validateName(string2, true);
        if (string3 != null && !"android".equals(string2)) {
            String string4;
            stringArray[0] = string4 = "<manifest> specifies bad package name \"" + string2 + "\": " + string3;
            return null;
        }
        int n3 = -1;
        int n4 = 0;
        while (true) {
            block11: {
                block10: {
                    int n5;
                    if (n4 >= (n5 = attributeSet.getAttributeCount())) break block10;
                    if (!attributeSet.getAttributeName(n4).equals("installLocation")) break block11;
                    n3 = attributeSet.getAttributeIntValue(n4, -1);
                }
                String string5 = string2.intern();
                return new PackageLite(string5, n3);
            }
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parsePackageName(XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws IOException, XmlPullParserException {
        String string2;
        int n2;
        while ((n2 = xmlPullParser.next()) != 2 && n2 != 1) {
        }
        if (n2 != 2) {
            stringArray[0] = "No start tag found";
            return null;
        }
        if ((n & 2) != 0) {
            // empty if block
        }
        if (!xmlPullParser.getName().equals("manifest")) {
            stringArray[0] = "No <manifest> tag";
            return null;
        }
        String string3 = attributeSet.getAttributeValue(null, "package");
        if (string3 == null || string3.length() == 0) {
            stringArray[0] = "<manifest> does not specify package";
            return null;
        }
        String string4 = PackageParser.validateName(string3, true);
        if (string4 == null) return string3.intern();
        if ("android".equals(string3)) return string3.intern();
        stringArray[0] = string2 = "<manifest> specifies bad package name \"" + string3 + "\": " + string4;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Permission parsePermission(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2;
        String string2;
        Permission permission2;
        Permission permission3 = permission2;
        Package package_2 = package_;
        permission3(package_2);
        int[] nArray = R.styleable.AndroidManifestPermission;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray = resources2.obtainAttributes(attributeSet2, nArray2);
        PermissionInfo permissionInfo = permission2.info;
        PackageParser packageParser = this;
        Package package_3 = package_;
        String[] stringArray2 = stringArray;
        if (!packageParser.parsePackageItemInfo(package_3, permissionInfo, stringArray2, "<permission>", typedArray, 2, 0, 1, 0)) {
            int n3;
            typedArray.recycle();
            this.mParseError = n3 = 65428;
            return null;
        }
        PermissionInfo permissionInfo2 = permission2.info;
        permissionInfo2.group = string2 = typedArray.getNonResourceString(4);
        if (permission2.info.group != null) {
            String string3;
            PermissionInfo permissionInfo3 = permission2.info;
            permissionInfo3.group = string3 = permission2.info.group.intern();
        }
        PermissionInfo permissionInfo4 = permission2.info;
        permissionInfo4.descriptionRes = n2 = typedArray.getResourceId(5, 0);
        PermissionInfo permissionInfo5 = permission2.info;
        permissionInfo5.protectionLevel = n = typedArray.getInt(3, 0);
        typedArray.recycle();
        if (permission2.info.protectionLevel == -1) {
            int n4;
            stringArray[0] = "<permission> does not specify protectionLevel";
            this.mParseError = n4 = 65428;
            return null;
        }
        PackageParser packageParser2 = this;
        Resources resources3 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        AttributeSet attributeSet3 = attributeSet;
        String[] stringArray3 = stringArray;
        if (!packageParser2.parseAllMetaData(resources3, xmlPullParser2, attributeSet3, "<permission>", permission2, stringArray3)) {
            int n5;
            this.mParseError = n5 = 65428;
            return null;
        }
        boolean bl = package_.permissions.add(permission2);
        return permission2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PermissionGroup parsePermissionGroup(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        PermissionGroup permissionGroup;
        PermissionGroup permissionGroup2 = permissionGroup;
        Package package_2 = package_;
        permissionGroup2(package_2);
        int[] nArray = R.styleable.AndroidManifestPermissionGroup;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray = resources2.obtainAttributes(attributeSet2, nArray2);
        PermissionGroupInfo permissionGroupInfo = permissionGroup.info;
        PackageParser packageParser = this;
        Package package_3 = package_;
        String[] stringArray2 = stringArray;
        if (!packageParser.parsePackageItemInfo(package_3, permissionGroupInfo, stringArray2, "<permission-group>", typedArray, 2, 0, 1, 0)) {
            int n2;
            typedArray.recycle();
            this.mParseError = n2 = 65428;
            return null;
        }
        PermissionGroupInfo permissionGroupInfo2 = permissionGroup.info;
        permissionGroupInfo2.descriptionRes = n = typedArray.getResourceId(3, 0);
        typedArray.recycle();
        PackageParser packageParser2 = this;
        Resources resources3 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        AttributeSet attributeSet3 = attributeSet;
        String[] stringArray3 = stringArray;
        if (!packageParser2.parseAllMetaData(resources3, xmlPullParser2, attributeSet3, "<permission-group>", permissionGroup, stringArray3)) {
            int n3;
            this.mParseError = n3 = 65428;
            return null;
        }
        boolean bl = package_.permissionGroups.add(permissionGroup);
        return permissionGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Permission parsePermissionTree(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        Permission permission2;
        Permission permission3 = permission2;
        Package package_2 = package_;
        permission3(package_2);
        int[] nArray = R.styleable.AndroidManifestPermissionTree;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray = resources2.obtainAttributes(attributeSet2, nArray2);
        PermissionInfo permissionInfo = permission2.info;
        PackageParser packageParser = this;
        Package package_3 = package_;
        String[] stringArray2 = stringArray;
        if (!packageParser.parsePackageItemInfo(package_3, permissionInfo, stringArray2, "<permission-tree>", typedArray, 2, 0, 1, 0)) {
            int n;
            typedArray.recycle();
            this.mParseError = n = 65428;
            return null;
        }
        typedArray.recycle();
        int n = permission2.info.name.indexOf(46);
        if (n > 0) {
            String string2 = permission2.info.name;
            int n2 = n + 1;
            n = string2.indexOf(46, n2);
        }
        if (n < 0) {
            int n3;
            String string3;
            StringBuilder stringBuilder = new StringBuilder().append("<permission-tree> name has less than three segments: ");
            String string4 = permission2.info.name;
            stringArray[0] = string3 = stringBuilder.append(string4).toString();
            this.mParseError = n3 = 65428;
            return null;
        }
        permission2.info.descriptionRes = 0;
        permission2.info.protectionLevel = 0;
        permission2.tree = true;
        PackageParser packageParser2 = this;
        Resources resources3 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        AttributeSet attributeSet3 = attributeSet;
        String[] stringArray3 = stringArray;
        if (!packageParser2.parseAllMetaData(resources3, xmlPullParser2, attributeSet3, "<permission-tree>", permission2, stringArray3)) {
            int n4;
            this.mParseError = n4 = 65428;
            return null;
        }
        boolean bl = package_.permissions.add(permission2);
        return permission2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Provider parseProvider(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        String string2;
        String string3;
        String string4;
        int n2;
        boolean bl;
        boolean bl2;
        int n3;
        int n4;
        TypedArray typedArray;
        String string5;
        boolean bl3;
        boolean bl4;
        int n5;
        TypedArray typedArray2;
        int[] nArray = R.styleable.AndroidManifestProvider;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray3 = resources2.obtainAttributes(attributeSet2, nArray2);
        if (this.mParseProviderArgs == null) {
            ParseComponentArgs parseComponentArgs;
            String[] stringArray2 = this.mSeparateProcesses;
            Package package_2 = package_;
            String[] stringArray3 = stringArray;
            this.mParseProviderArgs = parseComponentArgs = new ParseComponentArgs(package_2, stringArray3, 2, 0, 1, 0, stringArray2, 8, 14, 6);
            this.mParseProviderArgs.tag = "<provider>";
        }
        ParseComponentArgs parseComponentArgs = this.mParseProviderArgs;
        parseComponentArgs.sa = typedArray2 = typedArray3;
        ParseComponentArgs parseComponentArgs2 = this.mParseProviderArgs;
        parseComponentArgs2.flags = n5 = n;
        ParseComponentArgs parseComponentArgs3 = this.mParseProviderArgs;
        ProviderInfo providerInfo = new ProviderInfo();
        Provider provider = new Provider(parseComponentArgs3, providerInfo);
        if (stringArray[0] != null) {
            typedArray3.recycle();
            return null;
        }
        ProviderInfo providerInfo2 = provider.info;
        TypedArray typedArray4 = typedArray3;
        int n6 = 7;
        boolean bl5 = true;
        providerInfo2.exported = bl4 = typedArray4.getBoolean(n6, bl5);
        TypedArray typedArray5 = typedArray3;
        int n7 = 10;
        int n8 = 0;
        String string6 = typedArray5.getNonConfigurationString(n7, n8);
        ProviderInfo providerInfo3 = provider.info;
        TypedArray typedArray6 = typedArray3;
        int n9 = 11;
        boolean bl6 = false;
        providerInfo3.isSyncable = bl3 = typedArray6.getBoolean(n9, bl6);
        TypedArray typedArray7 = typedArray3;
        int n10 = 3;
        int n11 = 0;
        String string7 = typedArray7.getNonConfigurationString(n10, n11);
        TypedArray typedArray8 = typedArray3;
        int n12 = 4;
        int n13 = 0;
        String string8 = typedArray8.getNonConfigurationString(n12, n13);
        if (string8 == null) {
            string8 = string7;
        }
        if (string8 == null) {
            String string9;
            ProviderInfo providerInfo4 = provider.info;
            providerInfo4.readPermission = string9 = package_.applicationInfo.permission;
        } else {
            ProviderInfo providerInfo5 = provider.info;
            String string10 = string8.length() > 0 ? string8.toString().intern() : null;
            providerInfo5.readPermission = string10;
        }
        if ((string5 = (typedArray = typedArray3).getNonConfigurationString(n4 = 5, n3 = 0)) == null) {
            string5 = string7;
        }
        if (string5 == null) {
            String string11;
            ProviderInfo providerInfo6 = provider.info;
            providerInfo6.writePermission = string11 = package_.applicationInfo.permission;
        } else {
            ProviderInfo providerInfo7 = provider.info;
            String string12 = string5.length() > 0 ? string5.toString().intern() : null;
            providerInfo7.writePermission = string12;
        }
        ProviderInfo providerInfo8 = provider.info;
        TypedArray typedArray9 = typedArray3;
        int n14 = 13;
        boolean bl7 = false;
        providerInfo8.grantUriPermissions = bl2 = typedArray9.getBoolean(n14, bl7);
        ProviderInfo providerInfo9 = provider.info;
        TypedArray typedArray10 = typedArray3;
        int n15 = 9;
        boolean bl8 = false;
        providerInfo9.multiprocess = bl = typedArray10.getBoolean(n15, bl8);
        ProviderInfo providerInfo10 = provider.info;
        TypedArray typedArray11 = typedArray3;
        int n16 = 12;
        int n17 = 0;
        providerInfo10.initOrder = n2 = typedArray11.getInt(n16, n17);
        typedArray3.recycle();
        if ((package_.applicationInfo.flags & 0x8000000) != 0 && (string4 = provider.info.processName) == (string3 = package_.packageName)) {
            stringArray[0] = "Heavy-weight applications can not have providers in main process";
            return null;
        }
        if (string6 == null) {
            stringArray[0] = "<provider> does not incude authorities attribute";
            return null;
        }
        ProviderInfo providerInfo11 = provider.info;
        providerInfo11.authority = string2 = string6.intern();
        PackageParser packageParser = this;
        Resources resources3 = resources;
        XmlPullParser xmlPullParser2 = xmlPullParser;
        AttributeSet attributeSet3 = attributeSet;
        String[] stringArray4 = stringArray;
        if (packageParser.parseProviderTags(resources3, xmlPullParser2, attributeSet3, provider, stringArray4)) return provider;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseProviderTags(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Provider provider, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2;
        int n3;
        int n4 = xmlPullParser.getDepth();
        while ((n3 = (n2 = xmlPullParser.next())) != (n = 1)) {
            PatternMatcher patternMatcher;
            TypedArray typedArray;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = n2;
            int n10 = 3;
            if (n9 == n10) {
                if (xmlPullParser.getDepth() <= n4) return true;
            }
            if ((n8 = n2) == (n7 = 3) || (n6 = n2) == (n5 = 4)) continue;
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                Bundle bundle2;
                Bundle bundle3 = provider.metaData;
                PackageParser packageParser = this;
                Resources resources2 = resources;
                XmlPullParser xmlPullParser2 = xmlPullParser;
                AttributeSet attributeSet2 = attributeSet;
                String[] stringArray2 = stringArray;
                provider.metaData = bundle2 = (bundle = packageParser.parseMetaData(resources2, xmlPullParser2, attributeSet2, bundle3, stringArray2));
                if (bundle != null) continue;
                return false;
            }
            if (xmlPullParser.getName().equals("grant-uri-permission")) {
                int n11;
                int n12;
                TypedArray typedArray2;
                String string2;
                int n13;
                int n14;
                TypedArray typedArray3;
                String string3;
                int[] nArray = R.styleable.AndroidManifestGrantUriPermission;
                Resources resources3 = resources;
                AttributeSet attributeSet3 = attributeSet;
                int[] nArray2 = nArray;
                typedArray = resources3.obtainAttributes(attributeSet3, nArray2);
                patternMatcher = null;
                TypedArray typedArray4 = typedArray;
                int n15 = 0;
                int n16 = 0;
                String string4 = typedArray4.getNonConfigurationString(n15, n16);
                if (string4 != null) {
                    PatternMatcher patternMatcher2 = patternMatcher;
                    String string5 = string4;
                    int n17 = 0;
                    patternMatcher2(string5, n17);
                }
                if ((string3 = (typedArray3 = typedArray).getNonConfigurationString(n14 = 1, n13 = 0)) != null) {
                    PatternMatcher patternMatcher3 = patternMatcher;
                    String string6 = string3;
                    int n18 = 1;
                    patternMatcher3(string6, n18);
                }
                if ((string2 = (typedArray2 = typedArray).getNonConfigurationString(n12 = 2, n11 = 0)) != null) {
                    PatternMatcher patternMatcher4 = patternMatcher;
                    String string7 = string2;
                    int n19 = 2;
                    patternMatcher4(string7, n19);
                }
                typedArray.recycle();
                if (patternMatcher != null) {
                    if (provider.info.uriPermissionPatterns == null) {
                        ProviderInfo providerInfo = provider.info;
                        PatternMatcher[] patternMatcherArray = new PatternMatcher[1];
                        providerInfo.uriPermissionPatterns = patternMatcherArray;
                        provider.info.uriPermissionPatterns[0] = patternMatcher;
                    } else {
                        int n20 = provider.info.uriPermissionPatterns.length;
                        PatternMatcher[] patternMatcherArray = new PatternMatcher[n20 + 1];
                        System.arraycopy(provider.info.uriPermissionPatterns, 0, patternMatcherArray, 0, n20);
                        patternMatcherArray[n20] = patternMatcher;
                        provider.info.uriPermissionPatterns = patternMatcherArray;
                    }
                    provider.info.grantUriPermissions = true;
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Unknown element under <path-permission>: ");
                String string8 = xmlPullParser.getName();
                StringBuilder stringBuilder2 = stringBuilder.append(string8).append(" at ");
                String string9 = this.mArchiveSourcePath;
                StringBuilder stringBuilder3 = stringBuilder2.append(string9).append(" ");
                String string10 = xmlPullParser.getPositionDescription();
                String string11 = stringBuilder3.append(string10).toString();
                int n21 = Log.w(TAG, string11);
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            if (xmlPullParser.getName().equals("path-permission")) {
                int n22;
                int n23;
                TypedArray typedArray5;
                String string12;
                int n24;
                int n25;
                TypedArray typedArray6;
                String string13;
                int n26;
                int n27;
                TypedArray typedArray7;
                String string14;
                int[] nArray = R.styleable.AndroidManifestPathPermission;
                Resources resources4 = resources;
                AttributeSet attributeSet4 = attributeSet;
                int[] nArray3 = nArray;
                typedArray = resources4.obtainAttributes(attributeSet4, nArray3);
                patternMatcher = null;
                TypedArray typedArray8 = typedArray;
                int n28 = 0;
                int n29 = 0;
                String string15 = typedArray8.getNonConfigurationString(n28, n29);
                TypedArray typedArray9 = typedArray;
                int n30 = 1;
                int n31 = 0;
                String string16 = typedArray9.getNonConfigurationString(n30, n31);
                if (string16 == null) {
                    string16 = string15;
                }
                if ((string14 = (typedArray7 = typedArray).getNonConfigurationString(n27 = 2, n26 = 0)) == null) {
                    string14 = string15;
                }
                boolean bl = false;
                if (string16 != null) {
                    string16 = string16.intern();
                    bl = true;
                }
                if (string14 != null) {
                    string14 = string14.intern();
                    bl = true;
                }
                if (!bl) {
                    StringBuilder stringBuilder = new StringBuilder().append("No readPermission or writePermssion for <path-permission>: ");
                    String string17 = xmlPullParser.getName();
                    StringBuilder stringBuilder4 = stringBuilder.append(string17).append(" at ");
                    String string18 = this.mArchiveSourcePath;
                    StringBuilder stringBuilder5 = stringBuilder4.append(string18).append(" ");
                    String string19 = xmlPullParser.getPositionDescription();
                    String string20 = stringBuilder5.append(string19).toString();
                    int n32 = Log.w(TAG, string20);
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                TypedArray typedArray10 = typedArray;
                int n33 = 3;
                int n34 = 0;
                String string21 = typedArray10.getNonConfigurationString(n33, n34);
                if (string21 != null) {
                    PatternMatcher patternMatcher5 = patternMatcher;
                    String string22 = string21;
                    int n35 = 0;
                    String string23 = string16;
                    String string24 = string14;
                    ((PathPermission)patternMatcher5)(string22, n35, string23, string24);
                }
                if ((string13 = (typedArray6 = typedArray).getNonConfigurationString(n25 = 4, n24 = 0)) != null) {
                    PatternMatcher patternMatcher6 = patternMatcher;
                    String string25 = string13;
                    int n36 = 1;
                    String string26 = string16;
                    String string27 = string14;
                    ((PathPermission)patternMatcher6)(string25, n36, string26, string27);
                }
                if ((string12 = (typedArray5 = typedArray).getNonConfigurationString(n23 = 5, n22 = 0)) != null) {
                    PatternMatcher patternMatcher7 = patternMatcher;
                    String string28 = string12;
                    int n37 = 2;
                    String string29 = string16;
                    String string30 = string14;
                    ((PathPermission)patternMatcher7)(string28, n37, string29, string30);
                }
                typedArray.recycle();
                if (patternMatcher != null) {
                    if (provider.info.pathPermissions == null) {
                        ProviderInfo providerInfo = provider.info;
                        PathPermission[] pathPermissionArray = new PathPermission[1];
                        providerInfo.pathPermissions = pathPermissionArray;
                        provider.info.pathPermissions[0] = patternMatcher;
                    } else {
                        int n38 = provider.info.pathPermissions.length;
                        PathPermission[] pathPermissionArray = new PathPermission[n38 + 1];
                        System.arraycopy(provider.info.pathPermissions, 0, pathPermissionArray, 0, n38);
                        pathPermissionArray[n38] = patternMatcher;
                        provider.info.pathPermissions = pathPermissionArray;
                    }
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder().append("No path, pathPrefix, or pathPattern for <path-permission>: ");
                String string31 = xmlPullParser.getName();
                StringBuilder stringBuilder6 = stringBuilder.append(string31).append(" at ");
                String string32 = this.mArchiveSourcePath;
                StringBuilder stringBuilder7 = stringBuilder6.append(string32).append(" ");
                String string33 = xmlPullParser.getPositionDescription();
                String string34 = stringBuilder7.append(string33).toString();
                int n39 = Log.w(TAG, string34);
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unknown element under <provider>: ");
            String string35 = xmlPullParser.getName();
            StringBuilder stringBuilder8 = stringBuilder.append(string35).append(" at ");
            String string36 = this.mArchiveSourcePath;
            StringBuilder stringBuilder9 = stringBuilder8.append(string36).append(" ");
            String string37 = xmlPullParser.getPositionDescription();
            String string38 = stringBuilder9.append(string37).toString();
            int n40 = Log.w(TAG, string38);
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Service parseService(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string2;
        String string3;
        int n7;
        int n8;
        TypedArray typedArray;
        String string4;
        Service service;
        int n9;
        TypedArray typedArray2;
        int[] nArray = R.styleable.AndroidManifestService;
        Resources resources2 = resources;
        AttributeSet attributeSet2 = attributeSet;
        int[] nArray2 = nArray;
        TypedArray typedArray3 = resources2.obtainAttributes(attributeSet2, nArray2);
        if (this.mParseServiceArgs == null) {
            ParseComponentArgs parseComponentArgs;
            String[] stringArray2 = this.mSeparateProcesses;
            Package package_2 = package_;
            String[] stringArray3 = stringArray;
            this.mParseServiceArgs = parseComponentArgs = new ParseComponentArgs(package_2, stringArray3, 2, 0, 1, 0, stringArray2, 6, 7, 4);
            this.mParseServiceArgs.tag = "<service>";
        }
        ParseComponentArgs parseComponentArgs = this.mParseServiceArgs;
        parseComponentArgs.sa = typedArray2 = typedArray3;
        ParseComponentArgs parseComponentArgs2 = this.mParseServiceArgs;
        parseComponentArgs2.flags = n9 = n;
        ParseComponentArgs parseComponentArgs3 = this.mParseServiceArgs;
        ServiceInfo serviceInfo = new ServiceInfo();
        Service service2 = service;
        ParseComponentArgs parseComponentArgs4 = parseComponentArgs3;
        ServiceInfo serviceInfo2 = serviceInfo;
        service2(parseComponentArgs4, serviceInfo2);
        if (stringArray[0] != null) {
            typedArray3.recycle();
            return null;
        }
        TypedArray typedArray4 = typedArray3;
        int n10 = 5;
        boolean bl = typedArray4.hasValue(n10);
        if (bl) {
            boolean bl2;
            ServiceInfo serviceInfo3 = service.info;
            TypedArray typedArray5 = typedArray3;
            int n11 = 5;
            boolean bl3 = false;
            serviceInfo3.exported = bl2 = typedArray5.getBoolean(n11, bl3);
        }
        if ((string4 = (typedArray = typedArray3).getNonConfigurationString(n8 = 3, n7 = 0)) == null) {
            String string5;
            ServiceInfo serviceInfo4 = service.info;
            serviceInfo4.permission = string5 = package_.applicationInfo.permission;
        } else {
            ServiceInfo serviceInfo5 = service.info;
            String string6 = string4.length() > 0 ? string4.toString().intern() : null;
            serviceInfo5.permission = string6;
        }
        typedArray3.recycle();
        if ((package_.applicationInfo.flags & 0x8000000) != 0 && (string3 = service.info.processName) == (string2 = package_.packageName)) {
            stringArray[0] = "Heavy-weight applications can not have services in main process";
            return null;
        }
        int n12 = xmlPullParser.getDepth();
        while ((n6 = (n5 = xmlPullParser.next())) != (n4 = 1) && ((n3 = n5) != (n2 = 3) || xmlPullParser.getDepth() > n12)) {
            int n13;
            int n14;
            int n15 = n5;
            int n16 = 3;
            if (n15 == n16 || (n14 = n5) == (n13 = 4)) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ServiceIntentInfo serviceIntentInfo;
                ServiceIntentInfo serviceIntentInfo2 = serviceIntentInfo;
                Service service3 = service;
                serviceIntentInfo2(service3);
                PackageParser packageParser = this;
                Resources resources3 = resources;
                XmlPullParser xmlPullParser2 = xmlPullParser;
                AttributeSet attributeSet3 = attributeSet;
                int n17 = n;
                String[] stringArray4 = stringArray;
                if (!packageParser.parseIntent(resources3, xmlPullParser2, attributeSet3, n17, serviceIntentInfo, stringArray4, false)) {
                    return null;
                }
                boolean bl4 = service.intents.add(serviceIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                Bundle bundle2;
                Bundle bundle3 = service.metaData;
                PackageParser packageParser = this;
                Resources resources4 = resources;
                XmlPullParser xmlPullParser3 = xmlPullParser;
                AttributeSet attributeSet4 = attributeSet;
                String[] stringArray5 = stringArray;
                service.metaData = bundle2 = (bundle = packageParser.parseMetaData(resources4, xmlPullParser3, attributeSet4, bundle3, stringArray5));
                if (bundle != null) continue;
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unknown element under <service>: ");
            String string7 = xmlPullParser.getName();
            StringBuilder stringBuilder2 = stringBuilder.append(string7).append(" at ");
            String string8 = this.mArchiveSourcePath;
            StringBuilder stringBuilder3 = stringBuilder2.append(string8).append(" ");
            String string9 = xmlPullParser.getPositionDescription();
            String string10 = stringBuilder3.append(string9).toString();
            int n18 = Log.w(TAG, string10);
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (bl) return service;
        ServiceInfo serviceInfo6 = service.info;
        boolean bl5 = service.intents.size() > 0;
        serviceInfo6.exported = bl5;
        return service;
    }

    public static void setCompatibilityModeEnabled(boolean bl) {
        sCompatibilityModeEnabled = bl;
    }

    public static Signature stringToSignature(String string2) {
        int n = string2.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byte by;
            byArray[i] = by = (byte)string2.charAt(i);
        }
        return new Signature(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String validateName(String string2, boolean bl) {
        int n = string2.length();
        boolean bl2 = false;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                bl3 = false;
                continue;
            }
            if (!bl3 && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c != '.') {
                return "bad character '" + c + "'";
            }
            bl2 = true;
            bl3 = true;
        }
        if (bl2) return null;
        if (!bl) return null;
        return "must have at least one '.' separator";
    }

    /*
     * Exception decompiling
     */
    public boolean collectCertificates(Package var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 257->260)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getParseError() {
        return this.mParseError;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Package parsePackage(File file, String string2, DisplayMetrics displayMetrics, int n) {
        String string3;
        String string4;
        Object object;
        String string5;
        int n2;
        this.mParseError = n2 = 1;
        this.mArchiveSourcePath = string5 = file.getPath();
        if (!file.isFile()) {
            int n3;
            StringBuilder stringBuilder = new StringBuilder().append("Skipping dir: ");
            String string6 = this.mArchiveSourcePath;
            String string7 = stringBuilder.append(string6).toString();
            int n4 = Log.w(TAG, string7);
            this.mParseError = n3 = 65436;
            return null;
        }
        if (!PackageParser.isPackageFilename(file.getName()) && (n & 4) != 0) {
            int n5;
            if ((n & 1) == 0) {
                StringBuilder stringBuilder = new StringBuilder().append("Skipping non-package file: ");
                String string8 = this.mArchiveSourcePath;
                String string9 = stringBuilder.append(string8).toString();
                int n6 = Log.w(TAG, string9);
            }
            this.mParseError = n5 = 65436;
            return null;
        }
        if ((n & 2) != 0) {
            StringBuilder stringBuilder = new StringBuilder().append("Scanning package: ");
            String string10 = this.mArchiveSourcePath;
            String string11 = stringBuilder.append(string10).toString();
            int n7 = Log.d(TAG, string11);
        }
        XmlResourceParser xmlResourceParser = null;
        AssetManager assetManager = null;
        boolean bl = true;
        AssetManager assetManager2 = new AssetManager();
        {
            catch (Exception exception) {}
        }
        try {
            String string12 = this.mArchiveSourcePath;
            int n8 = assetManager2.addAssetPath(string12);
            if (n8 != 0) {
                object = assetManager2.openXmlResourceParser(n8, "AndroidManifest.xml");
                xmlResourceParser = object;
                bl = false;
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Failed adding asset path:");
                String string13 = this.mArchiveSourcePath;
                String string14 = stringBuilder.append(string13).toString();
                int n9 = Log.w(TAG, string14);
            }
            assetManager = assetManager2;
        }
        catch (Exception exception) {
            void var34_35;
            assetManager = assetManager2;
            StringBuilder stringBuilder = new StringBuilder().append("Unable to read AndroidManifest.xml of ");
            String string15 = this.mArchiveSourcePath;
            String string16 = stringBuilder.append(string15).toString();
            String string17 = TAG;
            String string18 = string16;
            void var40_42 = var34_35;
            int n10 = Log.w(string17, string18, (Throwable)var40_42);
        }
        if (bl) {
            int n11;
            if (assetManager != null) {
                assetManager.close();
            }
            this.mParseError = n11 = 65435;
            return null;
        }
        String[] stringArray = new String[1];
        Object object2 = null;
        Throwable throwable = null;
        try {
            Resources resources;
            Resources resources2 = resources;
            AssetManager assetManager3 = assetManager;
            DisplayMetrics displayMetrics2 = displayMetrics;
            Configuration configuration = null;
            resources2(assetManager3, displayMetrics2, configuration);
            PackageParser packageParser = this;
            Resources resources3 = resources;
            XmlResourceParser xmlResourceParser2 = xmlResourceParser;
            int n12 = n;
            String[] stringArray2 = stringArray;
            object2 = object = packageParser.parsePackage(resources3, xmlResourceParser2, n12, stringArray2);
        }
        catch (Exception exception) {
            int n13;
            this.mParseError = n13 = 65434;
        }
        if (object2 == null) {
            int n14;
            if (throwable != null) {
                String string19 = this.mArchiveSourcePath;
                String string20 = TAG;
                String string21 = string19;
                Throwable throwable2 = throwable;
                int n15 = Log.w(string20, string21, throwable2);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string22 = this.mArchiveSourcePath;
                StringBuilder stringBuilder2 = stringBuilder.append(string22).append(" (at ");
                String string23 = xmlResourceParser.getPositionDescription();
                StringBuilder stringBuilder3 = stringBuilder2.append(string23).append("): ");
                String string24 = stringArray[0];
                String string25 = stringBuilder3.append(string24).toString();
                int n16 = Log.w(TAG, string25);
            }
            xmlResourceParser.close();
            assetManager.close();
            int n17 = this.mParseError;
            int n18 = 1;
            if (n17 != n18) return null;
            this.mParseError = n14 = 65428;
            return null;
        }
        xmlResourceParser.close();
        assetManager.close();
        ((Package)object2).mPath = string4 = string2;
        ((Package)object2).mScanPath = string3 = this.mArchiveSourcePath;
        ((Package)object2).mSignatures = null;
        return object2;
    }

    public void setSeparateProcesses(String[] stringArray) {
        this.mSeparateProcesses = stringArray;
    }

    public static final class ServiceIntentInfo
    extends IntentInfo {
        public final Service service;

        public ServiceIntentInfo(Service service) {
            this.service = service;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("ServiceIntentInfo{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.service.info.name;
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static final class ActivityIntentInfo
    extends IntentInfo {
        public final Activity activity;

        public ActivityIntentInfo(Activity activity) {
            this.activity = activity;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("ActivityIntentInfo{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.activity.info.name;
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static class IntentInfo
    extends IntentFilter {
        public boolean hasDefault;
        public int icon;
        public int labelRes;
        public int logo;
        public CharSequence nonLocalizedLabel;
    }

    public static final class Instrumentation
    extends Component {
        public final InstrumentationInfo info;

        public Instrumentation(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            super(parsePackageItemArgs, instrumentationInfo);
            this.info = instrumentationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("Instrumentation{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.getComponentShortName();
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static final class Provider
    extends Component {
        public final ProviderInfo info;
        public boolean syncable;

        public Provider(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            super(parseComponentArgs, providerInfo);
            ApplicationInfo applicationInfo;
            ProviderInfo providerInfo2 = this.info = providerInfo;
            providerInfo2.applicationInfo = applicationInfo = parseComponentArgs.owner.applicationInfo;
            this.syncable = false;
        }

        public Provider(Provider provider) {
            super(provider);
            boolean bl;
            ProviderInfo providerInfo;
            this.info = providerInfo = provider.info;
            this.syncable = bl = provider.syncable;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("Provider{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.info.name;
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static final class Service
    extends Component<ServiceIntentInfo> {
        public final ServiceInfo info;

        public Service(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            super(parseComponentArgs, serviceInfo);
            ApplicationInfo applicationInfo;
            ServiceInfo serviceInfo2 = this.info = serviceInfo;
            serviceInfo2.applicationInfo = applicationInfo = parseComponentArgs.owner.applicationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("Service{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.getComponentShortName();
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static final class Activity
    extends Component<ActivityIntentInfo> {
        public final ActivityInfo info;

        public Activity(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            super(parseComponentArgs, activityInfo);
            ApplicationInfo applicationInfo;
            ActivityInfo activityInfo2 = this.info = activityInfo;
            activityInfo2.applicationInfo = applicationInfo = parseComponentArgs.owner.applicationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("Activity{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.getComponentShortName();
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static final class PermissionGroup
    extends Component<IntentInfo> {
        public final PermissionGroupInfo info;

        public PermissionGroup(Package package_) {
            super(package_);
            PermissionGroupInfo permissionGroupInfo;
            this.info = permissionGroupInfo = new PermissionGroupInfo();
        }

        public PermissionGroup(Package package_, PermissionGroupInfo permissionGroupInfo) {
            super(package_);
            this.info = permissionGroupInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("PermissionGroup{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.info.name;
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static final class Permission
    extends Component<IntentInfo> {
        public PermissionGroup group;
        public final PermissionInfo info;
        public boolean tree;

        public Permission(Package package_) {
            super(package_);
            PermissionInfo permissionInfo;
            this.info = permissionInfo = new PermissionInfo();
        }

        public Permission(Package package_, PermissionInfo permissionInfo) {
            super(package_);
            this.info = permissionInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("Permission{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.info.name;
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static class Component<II extends IntentInfo> {
        public final String className;
        ComponentName componentName;
        String componentShortName;
        public final ArrayList<II> intents;
        public Bundle metaData;
        public final Package owner;

        public Component(Component<II> component) {
            String string2;
            ComponentName componentName;
            String string3;
            ArrayList<II> arrayList;
            Package package_;
            this.owner = package_ = component.owner;
            this.intents = arrayList = component.intents;
            this.className = string3 = component.className;
            this.componentName = componentName = component.componentName;
            this.componentShortName = string2 = component.componentShortName;
        }

        public Component(Package package_) {
            this.owner = package_;
            this.intents = null;
            this.className = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Component(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this((ParsePackageItemArgs)parseComponentArgs, (PackageItemInfo)componentInfo);
            boolean bl;
            if (parseComponentArgs.outError[0] != null) {
                return;
            }
            if (parseComponentArgs.processRes != 0) {
                String string2;
                String string3;
                if (this.owner.applicationInfo.targetSdkVersion >= 8) {
                    TypedArray typedArray = parseComponentArgs.sa;
                    int n = parseComponentArgs.processRes;
                    string3 = typedArray.getNonConfigurationString(n, 0);
                } else {
                    TypedArray typedArray = parseComponentArgs.sa;
                    int n = parseComponentArgs.processRes;
                    string3 = typedArray.getNonResourceString(n);
                }
                String string4 = this.owner.applicationInfo.packageName;
                String string5 = this.owner.applicationInfo.processName;
                int n = parseComponentArgs.flags;
                String[] stringArray = parseComponentArgs.sepProcesses;
                String[] stringArray2 = parseComponentArgs.outError;
                componentInfo.processName = string2 = PackageParser.buildProcessName(string4, string5, string3, n, stringArray, stringArray2);
            }
            if (parseComponentArgs.descriptionRes != 0) {
                int n;
                TypedArray typedArray = parseComponentArgs.sa;
                int n2 = parseComponentArgs.descriptionRes;
                componentInfo.descriptionRes = n = typedArray.getResourceId(n2, 0);
            }
            TypedArray typedArray = parseComponentArgs.sa;
            int n = parseComponentArgs.enabledRes;
            componentInfo.enabled = bl = typedArray.getBoolean(n, true);
        }

        public Component(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            String string2;
            int n;
            TypedArray typedArray;
            TypedValue typedValue;
            String string3;
            String string4;
            Package package_;
            this.owner = package_ = parsePackageItemArgs.owner;
            ArrayList arrayList = new ArrayList(0);
            this.intents = arrayList;
            TypedArray typedArray2 = parsePackageItemArgs.sa;
            int n2 = parsePackageItemArgs.nameRes;
            String string5 = typedArray2.getNonConfigurationString(n2, 0);
            if (string5 == null) {
                String string6;
                this.className = null;
                String[] stringArray = parsePackageItemArgs.outError;
                StringBuilder stringBuilder = new StringBuilder();
                String string7 = parsePackageItemArgs.tag;
                stringArray[0] = string6 = stringBuilder.append(string7).append(" does not specify android:name").toString();
                return;
            }
            String string8 = this.owner.applicationInfo.packageName;
            String[] stringArray = parsePackageItemArgs.outError;
            packageItemInfo.name = string4 = PackageParser.buildClassName(string8, string5, stringArray);
            if (packageItemInfo.name == null) {
                String string9;
                this.className = null;
                String[] stringArray2 = parsePackageItemArgs.outError;
                StringBuilder stringBuilder = new StringBuilder();
                String string10 = parsePackageItemArgs.tag;
                stringArray2[0] = string9 = stringBuilder.append(string10).append(" does not have valid android:name").toString();
                return;
            }
            this.className = string3 = packageItemInfo.name;
            TypedArray typedArray3 = parsePackageItemArgs.sa;
            int n3 = parsePackageItemArgs.iconRes;
            int n4 = typedArray3.getResourceId(n3, 0);
            if (n4 != 0) {
                packageItemInfo.icon = n4;
                packageItemInfo.nonLocalizedLabel = null;
            }
            if ((typedValue = (typedArray = parsePackageItemArgs.sa).peekValue(n = parsePackageItemArgs.labelRes)) != null) {
                int n5;
                packageItemInfo.labelRes = n5 = typedValue.resourceId;
                if (n5 == 0) {
                    CharSequence charSequence;
                    packageItemInfo.nonLocalizedLabel = charSequence = typedValue.coerceToString();
                }
            }
            packageItemInfo.packageName = string2 = this.owner.packageName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ComponentName getComponentName() {
            ComponentName componentName;
            if (this.componentName != null) {
                return this.componentName;
            }
            if (this.className == null) return this.componentName;
            String string2 = this.owner.applicationInfo.packageName;
            String string3 = this.className;
            this.componentName = componentName = new ComponentName(string2, string3);
            return this.componentName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getComponentShortName() {
            String string2;
            if (this.componentShortName != null) {
                return this.componentShortName;
            }
            ComponentName componentName = this.getComponentName();
            if (componentName == null) return this.componentShortName;
            this.componentShortName = string2 = componentName.flattenToShortString();
            return this.componentShortName;
        }

        public void setPackageName(String string2) {
            this.componentName = null;
            this.componentShortName = null;
        }
    }

    public static final class Package {
        public final ArrayList<Activity> activities;
        public final ApplicationInfo applicationInfo;
        public final ArrayList<ConfigurationInfo> configPreferences;
        public int installLocation;
        public final ArrayList<Instrumentation> instrumentation;
        public ArrayList<String> mAdoptPermissions;
        public Bundle mAppMetaData;
        public boolean mDidDexOpt;
        public Object mExtras;
        public boolean mOperationPending;
        public ArrayList<String> mOriginalPackages;
        public String mPath;
        public int mPreferredOrder;
        public String mRealPackage;
        public String mScanPath;
        public int mSetEnabled;
        public String mSharedUserId;
        public int mSharedUserLabel;
        public Signature[] mSignatures;
        public int mVersionCode;
        public String mVersionName;
        public String packageName;
        public final ArrayList<PermissionGroup> permissionGroups;
        public final ArrayList<Permission> permissions;
        public ArrayList<String> protectedBroadcasts;
        public final ArrayList<Provider> providers;
        public final ArrayList<Activity> receivers;
        public ArrayList<FeatureInfo> reqFeatures;
        public final ArrayList<String> requestedPermissions;
        public final ArrayList<Service> services;
        public ArrayList<String> usesLibraries;
        public String[] usesLibraryFiles;
        public ArrayList<String> usesOptionalLibraries;

        public Package(String string2) {
            ApplicationInfo applicationInfo;
            this.applicationInfo = applicationInfo = new ApplicationInfo();
            ArrayList arrayList = new ArrayList(0);
            this.permissions = arrayList;
            ArrayList arrayList2 = new ArrayList(0);
            this.permissionGroups = arrayList2;
            ArrayList arrayList3 = new ArrayList(0);
            this.activities = arrayList3;
            ArrayList arrayList4 = new ArrayList(0);
            this.receivers = arrayList4;
            ArrayList arrayList5 = new ArrayList(0);
            this.providers = arrayList5;
            ArrayList arrayList6 = new ArrayList(0);
            this.services = arrayList6;
            ArrayList arrayList7 = new ArrayList(0);
            this.instrumentation = arrayList7;
            ArrayList arrayList8 = new ArrayList();
            this.requestedPermissions = arrayList8;
            this.usesLibraries = null;
            this.usesOptionalLibraries = null;
            this.usesLibraryFiles = null;
            this.mOriginalPackages = null;
            this.mRealPackage = null;
            this.mAdoptPermissions = null;
            this.mAppMetaData = null;
            this.mPreferredOrder = 0;
            this.mSetEnabled = 0;
            ArrayList arrayList9 = new ArrayList();
            this.configPreferences = arrayList9;
            this.reqFeatures = null;
            this.packageName = string2;
            this.applicationInfo.packageName = string2;
            this.applicationInfo.uid = -1;
        }

        public void setPackageName(String string2) {
            this.packageName = string2;
            this.applicationInfo.packageName = string2;
            for (int i = this.permissions.size() - 1; i >= 0; i += -1) {
                this.permissions.get(i).setPackageName(string2);
            }
            for (int i = this.permissionGroups.size() - 1; i >= 0; i += -1) {
                this.permissionGroups.get(i).setPackageName(string2);
            }
            for (int i = this.activities.size() - 1; i >= 0; i += -1) {
                this.activities.get(i).setPackageName(string2);
            }
            for (int i = this.receivers.size() - 1; i >= 0; i += -1) {
                this.receivers.get(i).setPackageName(string2);
            }
            for (int i = this.providers.size() - 1; i >= 0; i += -1) {
                this.providers.get(i).setPackageName(string2);
            }
            for (int i = this.services.size() - 1; i >= 0; i += -1) {
                this.services.get(i).setPackageName(string2);
            }
            int n = this.instrumentation.size() - 1;
            while (n >= 0) {
                this.instrumentation.get(n).setPackageName(string2);
                n += -1;
            }
            return;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("Package{");
            String string2 = Integer.toHexString(System.identityHashCode(this));
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            String string3 = this.packageName;
            return stringBuilder2.append(string3).append("}").toString();
        }
    }

    public static class PackageLite {
        public int installLocation;
        public String mScanPath;
        public String packageName;

        public PackageLite(String string2, int n) {
            this.packageName = string2;
            this.installLocation = n;
        }
    }

    static class ParseComponentArgs
    extends ParsePackageItemArgs {
        final int descriptionRes;
        final int enabledRes;
        int flags;
        final int processRes;
        final String[] sepProcesses;

        ParseComponentArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, String[] stringArray2, int n5, int n6, int n7) {
            super(package_, stringArray, n, n2, n3, n4);
            this.sepProcesses = stringArray2;
            this.processRes = n5;
            this.descriptionRes = n6;
            this.enabledRes = n7;
        }
    }

    static class ParsePackageItemArgs {
        final int iconRes;
        final int labelRes;
        final int logoRes;
        final int nameRes;
        final String[] outError;
        final Package owner;
        TypedArray sa;
        String tag;

        ParsePackageItemArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4) {
            this.owner = package_;
            this.outError = stringArray;
            this.nameRes = n;
            this.labelRes = n2;
            this.iconRes = n3;
            this.logoRes = n4;
        }
    }

    public static class NewPermissionInfo {
        public final int fileVersion;
        public final String name;
        public final int sdkVersion;

        public NewPermissionInfo(String string2, int n, int n2) {
            this.name = string2;
            this.sdkVersion = n;
            this.fileVersion = n2;
        }
    }
}

