/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.FastXmlSerializer;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public abstract class RegisteredServicesCache<V> {
    private static final String TAG = "PackageManager";
    private final String mAttributesName;
    public final Context mContext;
    private Handler mHandler;
    private final String mInterfaceName;
    private RegisteredServicesCacheListener<V> mListener;
    private final String mMetaDataName;
    private HashMap<V, Integer> mPersistentServices;
    private final AtomicFile mPersistentServicesFile;
    private boolean mPersistentServicesFileDidNotExist;
    private final AtomicReference<BroadcastReceiver> mReceiver;
    private final XmlSerializerAndParser<V> mSerializerAndParser;
    private Map<V, ServiceInfo<V>> mServices;
    private final Object mServicesLock;

    public RegisteredServicesCache(Context context, String string2, String string3, String string4, XmlSerializerAndParser<V> xmlSerializerAndParser) {
        AtomicFile atomicFile;
        Object object;
        this.mServicesLock = object = new Object();
        this.mContext = context;
        this.mInterfaceName = string2;
        this.mMetaDataName = string3;
        this.mAttributesName = string4;
        this.mSerializerAndParser = xmlSerializerAndParser;
        File file = Environment.getDataDirectory();
        File file2 = new File(file, "system");
        File file3 = new File(file2, "registered_services");
        String string5 = string2 + ".xml";
        File file4 = new File(file3, string5);
        this.mPersistentServicesFile = atomicFile = new AtomicFile(file4);
        this.generateServicesMap();
        BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                RegisteredServicesCache.this.generateServicesMap();
            }
        };
        AtomicReference<1> atomicReference = new AtomicReference<1>(broadcastReceiver);
        this.mReceiver = atomicReference;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        Intent intent = this.mContext.registerReceiver(broadcastReceiver, intentFilter);
        IntentFilter intentFilter2 = new IntentFilter();
        intentFilter2.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        intentFilter2.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        Intent intent2 = this.mContext.registerReceiver(broadcastReceiver, intentFilter2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsType(ArrayList<ServiceInfo<V>> arrayList, V v) {
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            if (arrayList.get((int)n).type.equals(v)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsTypeAndUid(ArrayList<ServiceInfo<V>> arrayList, V v, int n) {
        int n2 = 0;
        int n3 = arrayList.size();
        while (n2 < n3) {
            ServiceInfo<V> serviceInfo = arrayList.get(n2);
            if (serviceInfo.type.equals(v) && serviceInfo.uid != n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inSystemImage(int n) {
        String[] stringArray = this.mContext.getPackageManager().getPackagesForUid(n);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            try {
                int n4 = this.mContext.getPackageManager().getPackageInfo((String)string2, (int)0).applicationInfo.flags;
                if ((n4 & 1) != 0) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void notifyListener(final V v, final boolean bl) {
        if (Log.isLoggable(TAG, 2)) {
            StringBuilder stringBuilder = new StringBuilder().append("notifyListener: ").append(v).append(" is ");
            String string2 = bl ? "removed" : "added";
            String string3 = stringBuilder.append(string2).toString();
            int n = Log.d(TAG, string3);
        }
        // MONITORENTER : this
        RegisteredServicesCacheListener<V> registeredServicesCacheListener = this.mListener;
        Handler handler = this.mHandler;
        // MONITOREXIT : this
        if (registeredServicesCacheListener == null) {
            return;
        }
        final RegisteredServicesCacheListener<V> registeredServicesCacheListener2 = registeredServicesCacheListener;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RegisteredServicesCacheListener registeredServicesCacheListener = registeredServicesCacheListener2;
                Object object = v;
                boolean bl2 = bl;
                registeredServicesCacheListener.onServiceChanged(object, bl2);
            }
        };
        boolean bl2 = handler.post(runnable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServiceInfo<V> parseServiceInfo(ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        XmlResourceParser xmlResourceParser;
        ComponentName componentName;
        android.content.pm.ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        String string2 = serviceInfo.packageName;
        String string3 = serviceInfo.name;
        ComponentName componentName2 = componentName;
        String string4 = string2;
        String string5 = string3;
        componentName2(string4, string5);
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            ServiceInfo serviceInfo2;
            AttributeSet attributeSet;
            String string6;
            String string7;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            block9: {
                String string8 = this.mMetaDataName;
                android.content.pm.ServiceInfo serviceInfo3 = serviceInfo;
                PackageManager packageManager2 = packageManager;
                String string9 = string8;
                xmlResourceParser = serviceInfo3.loadXmlMetaData(packageManager2, string9);
                if (xmlResourceParser != null) break block9;
                StringBuilder stringBuilder = new StringBuilder().append("No ");
                String string10 = this.mMetaDataName;
                String string11 = stringBuilder.append(string10).append(" meta-data").toString();
                throw new XmlPullParserException(string11);
            }
            AttributeSet attributeSet2 = Xml.asAttributeSet(xmlResourceParser);
            while ((n5 = (n4 = xmlResourceParser.next())) != (n3 = 1) && (n2 = n4) != (n = 2)) {
            }
            String string12 = this.mAttributesName;
            String string13 = xmlResourceParser.getName();
            String string14 = string13;
            if (!string12.equals(string14)) {
                StringBuilder stringBuilder = new StringBuilder().append("Meta-data does not start with ");
                String string15 = this.mAttributesName;
                String string16 = stringBuilder.append(string15).append(" tag").toString();
                throw new XmlPullParserException(string16);
            }
            RegisteredServicesCache registeredServicesCache = this;
            PackageManager packageManager3 = packageManager;
            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
            ApplicationInfo applicationInfo2 = applicationInfo;
            Resources resources = packageManager3.getResourcesForApplication(applicationInfo2);
            Resources resources2 = resources;
            V v = registeredServicesCache.parseServiceAttributes(resources2, string7 = (string6 = serviceInfo.packageName), attributeSet = attributeSet2);
            V v2 = v;
            if (v2 == null) {
                serviceInfo2 = null;
                if (xmlResourceParser == null) return serviceInfo2;
                xmlResourceParser.close();
                return serviceInfo2;
            }
            try {
                int n6 = resolveInfo.serviceInfo.applicationInfo.uid;
                ServiceInfo serviceInfo4 = serviceInfo2;
                V v3 = v2;
                ComponentName componentName3 = componentName;
                int n7 = n6;
                1 var52_52 = null;
                serviceInfo4(v3, componentName3, n7);
                if (xmlResourceParser == null) return serviceInfo2;
                xmlResourceParser.close();
                return serviceInfo2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            StringBuilder stringBuilder = new StringBuilder().append("Unable to load resources for pacakge ");
            String string17 = serviceInfo.packageName;
            String string18 = stringBuilder.append(string17).toString();
            throw new XmlPullParserException(string18);
        }
        catch (Throwable throwable) {
            if (xmlResourceParser == null) throw throwable;
            xmlResourceParser.close();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private void readPersistentServicesLocked() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePersistentServicesLocked() {
        FastXmlSerializer fastXmlSerializer;
        FileOutputStream fileOutputStream;
        if (this.mSerializerAndParser == null) {
            return;
        }
        try {
            fileOutputStream = this.mPersistentServicesFile.startWrite();
            fastXmlSerializer = new FastXmlSerializer();
            fastXmlSerializer.setOutput(fileOutputStream, "utf-8");
            Boolean bl = true;
            fastXmlSerializer.startDocument(null, bl);
            fastXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            XmlSerializer xmlSerializer = fastXmlSerializer.startTag(null, "services");
            for (Map.Entry<V, Integer> entry : this.mPersistentServices.entrySet()) {
                XmlSerializer xmlSerializer2 = fastXmlSerializer.startTag(null, "service");
                String string2 = Integer.toString(entry.getValue());
                XmlSerializer xmlSerializer3 = fastXmlSerializer.attribute(null, "uid", string2);
                XmlSerializerAndParser<V> xmlSerializerAndParser = this.mSerializerAndParser;
                V v = entry.getKey();
                xmlSerializerAndParser.writeAsXml(v, fastXmlSerializer);
                XmlSerializer xmlSerializer4 = fastXmlSerializer.endTag(null, "service");
            }
        }
        catch (IOException iOException) {
            int n = Log.w(TAG, "Error writing accounts", iOException);
            if (fileOutputStream == null) {
                return;
            }
            this.mPersistentServicesFile.failWrite(fileOutputStream);
            return;
        }
        String string3 = null;
        {
            XmlSerializer xmlSerializer = fastXmlSerializer.endTag(string3, "services");
            fastXmlSerializer.endDocument();
            this.mPersistentServicesFile.finishWrite(fileOutputStream);
            return;
        }
    }

    public void close() {
        BroadcastReceiver broadcastReceiver = this.mReceiver.getAndSet(null);
        if (broadcastReceiver == null) {
            return;
        }
        this.mContext.unregisterReceiver(broadcastReceiver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Map<V, ServiceInfo<V>> map;
        Object object = this.mServicesLock;
        synchronized (object) {
            map = this.mServices;
        }
        StringBuilder stringBuilder = new StringBuilder().append("RegisteredServicesCache: ");
        int n = map.size();
        String string2 = stringBuilder.append(n).append(" services").toString();
        printWriter.println(string2);
        Iterator<ServiceInfo<V>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ServiceInfo<V> serviceInfo = iterator.next();
            String string3 = "  " + serviceInfo;
            printWriter.println(string3);
        }
        return;
    }

    protected void finalize() throws Throwable {
        if (this.mReceiver.get() != null) {
            int n = Log.e(TAG, "RegisteredServicesCache finalized without being closed");
        }
        this.close();
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void generateServicesMap() {
        PackageManager packageManager = this.mContext.getPackageManager();
        ArrayList<ServiceInfo<V>> arrayList = new ArrayList<ServiceInfo<V>>();
        String string2 = this.mInterfaceName;
        Intent intent = new Intent(string2);
        for (ResolveInfo resolveInfo : packageManager.queryIntentServices(intent, 128)) {
            try {
                ServiceInfo<V> serviceInfo = this.parseServiceInfo(resolveInfo);
                if (serviceInfo == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unable to load service info ");
                    String string3 = resolveInfo.toString();
                    String string4 = stringBuilder.append(string3).toString();
                    int n = Log.w(TAG, string4);
                }
                boolean bl = arrayList.add(serviceInfo);
            }
            catch (XmlPullParserException xmlPullParserException) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to load service info ");
                String string5 = resolveInfo.toString();
                String string6 = stringBuilder.append(string5).toString();
                int n = Log.w(TAG, string6, xmlPullParserException);
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to load service info ");
                String string7 = resolveInfo.toString();
                String string8 = stringBuilder.append(string7).toString();
                int n = Log.w(TAG, string8, iOException);
            }
        }
        Object object = this.mServicesLock;
        synchronized (object) {
            if (Log.isLoggable(TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("generateServicesMap: ");
                String string9 = this.mInterfaceName;
                String string10 = stringBuilder.append(string9).toString();
                int n = Log.d(TAG, string10);
            }
            if (this.mPersistentServices == null) {
                this.readPersistentServicesLocked();
            }
            HashMap<V, ServiceInfo<V>> hashMap = Maps.newHashMap();
            this.mServices = hashMap;
            boolean bl = false;
            if (Log.isLoggable(TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("found ");
                int n = arrayList.size();
                String string11 = stringBuilder.append(n).append(" services").toString();
                int n2 = Log.d(TAG, string11);
            }
            for (ServiceInfo serviceInfo : arrayList) {
                int n;
                Object v;
                int n3;
                HashMap<V, Integer> hashMap2 = this.mPersistentServices;
                Object v2 = serviceInfo.type;
                Integer n4 = hashMap2.get(v2);
                if (n4 == null) {
                    if (Log.isLoggable(TAG, 2)) {
                        String string12 = "encountered new type: " + serviceInfo;
                        int n5 = Log.d(TAG, string12);
                    }
                    bl = true;
                    Map<ServiceInfo, ServiceInfo<ServiceInfo>> map = this.mServices;
                    Object v3 = serviceInfo.type;
                    ServiceInfo serviceInfo2 = map.put((ServiceInfo)v3, serviceInfo);
                    HashMap<Integer, Integer> hashMap3 = this.mPersistentServices;
                    Object v4 = serviceInfo.type;
                    Integer n6 = serviceInfo.uid;
                    Integer n7 = hashMap3.put((Integer)v4, n6);
                    if (this.mPersistentServicesFileDidNotExist) continue;
                    Object v5 = serviceInfo.type;
                    this.notifyListener(v5, false);
                    continue;
                }
                int n8 = n4;
                if (n8 != (n3 = serviceInfo.uid)) {
                    if (Log.isLoggable(TAG, 2)) {
                        String string13 = "encountered existing type with the same uid: " + serviceInfo;
                        int n9 = Log.d(TAG, string13);
                    }
                    Map<ServiceInfo, ServiceInfo<ServiceInfo>> map = this.mServices;
                    Object v6 = serviceInfo.type;
                    ServiceInfo serviceInfo3 = map.put((ServiceInfo)v6, serviceInfo);
                    continue;
                }
                int n10 = serviceInfo.uid;
                if (this.inSystemImage(n10) || !this.containsTypeAndUid(arrayList, v = serviceInfo.type, n = n4.intValue())) {
                    if (Log.isLoggable(TAG, 2)) {
                        int n11 = serviceInfo.uid;
                        if (this.inSystemImage(n11)) {
                            String string14 = "encountered existing type with a new uid but from the system: " + serviceInfo;
                            int n12 = Log.d(TAG, string14);
                        } else {
                            String string15 = "encountered existing type with a new uid but existing was removed: " + serviceInfo;
                            int n13 = Log.d(TAG, string15);
                        }
                    }
                    bl = true;
                    Map<ServiceInfo, ServiceInfo<ServiceInfo>> map = this.mServices;
                    Object v7 = serviceInfo.type;
                    ServiceInfo serviceInfo4 = map.put((ServiceInfo)v7, serviceInfo);
                    HashMap<Integer, Integer> hashMap4 = this.mPersistentServices;
                    Object v8 = serviceInfo.type;
                    Integer n14 = serviceInfo.uid;
                    Integer n15 = hashMap4.put((Integer)v8, n14);
                    Object v9 = serviceInfo.type;
                    this.notifyListener(v9, false);
                    continue;
                }
                if (!Log.isLoggable(TAG, 2)) continue;
                String string16 = "encountered existing type with a new uid, ignoring: " + serviceInfo;
                int n16 = Log.d(TAG, string16);
            }
            ArrayList<ResolveInfo> arrayList2 = Lists.newArrayList();
            for (ResolveInfo resolveInfo : this.mPersistentServices.keySet()) {
                if (this.containsType(arrayList, resolveInfo)) continue;
                boolean bl2 = arrayList2.add(resolveInfo);
            }
            for (ResolveInfo resolveInfo : arrayList2) {
                Integer n = this.mPersistentServices.remove(resolveInfo);
                bl = true;
                this.notifyListener(resolveInfo, true);
            }
            if (bl) {
                if (Log.isLoggable(TAG, 2)) {
                    int n = Log.d(TAG, "writing updated list of persistent services");
                }
                this.writePersistentServicesLocked();
            } else if (Log.isLoggable(TAG, 2)) {
                int n = Log.d(TAG, "persistent services did not change, so not writing anything");
            }
            this.mPersistentServicesFileDidNotExist = false;
            return;
        }
    }

    public Collection<ServiceInfo<V>> getAllServices() {
        Object object = this.mServicesLock;
        synchronized (object) {
            Collection<ServiceInfo<V>> collection = Collections.unmodifiableCollection(this.mServices.values());
            return collection;
        }
    }

    public RegisteredServicesCacheListener<V> getListener() {
        synchronized (this) {
            RegisteredServicesCacheListener<V> registeredServicesCacheListener = this.mListener;
            return registeredServicesCacheListener;
        }
    }

    public ServiceInfo<V> getServiceInfo(V v) {
        Object object = this.mServicesLock;
        synchronized (object) {
            ServiceInfo<V> serviceInfo = this.mServices.get(v);
            return serviceInfo;
        }
    }

    public abstract V parseServiceAttributes(Resources var1, String var2, AttributeSet var3);

    public void setListener(RegisteredServicesCacheListener<V> registeredServicesCacheListener, Handler handler) {
        if (handler == null) {
            Looper looper = this.mContext.getMainLooper();
            handler = new Handler(looper);
        }
        synchronized (this) {
            this.mHandler = handler;
            this.mListener = registeredServicesCacheListener;
            return;
        }
    }

    public static class ServiceInfo<V> {
        public final ComponentName componentName;
        public final V type;
        public final int uid;

        private ServiceInfo(V v, ComponentName componentName, int n) {
            this.type = v;
            this.componentName = componentName;
            this.uid = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("ServiceInfo: ");
            V v = this.type;
            StringBuilder stringBuilder2 = stringBuilder.append(v).append(", ");
            ComponentName componentName = this.componentName;
            StringBuilder stringBuilder3 = stringBuilder2.append(componentName).append(", uid ");
            int n = this.uid;
            return stringBuilder3.append(n).toString();
        }
    }
}

