/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class AssetFileDescriptor
implements Parcelable {
    public static final Parcelable.Creator<AssetFileDescriptor> CREATOR = new Parcelable.Creator<AssetFileDescriptor>(){

        @Override
        public AssetFileDescriptor createFromParcel(Parcel parcel) {
            return new AssetFileDescriptor(parcel);
        }

        public AssetFileDescriptor[] newArray(int n) {
            return new AssetFileDescriptor[n];
        }
    };
    public static final long UNKNOWN_LENGTH = 255L;
    private final ParcelFileDescriptor mFd;
    private final long mLength;
    private final long mStartOffset;

    AssetFileDescriptor(Parcel parcel) {
        long l;
        long l2;
        ParcelFileDescriptor parcelFileDescriptor;
        this.mFd = parcelFileDescriptor = ParcelFileDescriptor.CREATOR.createFromParcel(parcel);
        this.mStartOffset = l2 = parcel.readLong();
        this.mLength = l = parcel.readLong();
    }

    public AssetFileDescriptor(ParcelFileDescriptor parcelFileDescriptor, long l, long l2) {
        if (l2 < 0L && l != 0L) {
            throw new IllegalArgumentException("startOffset must be 0 when using UNKNOWN_LENGTH");
        }
        this.mFd = parcelFileDescriptor;
        this.mStartOffset = l;
        this.mLength = l2;
    }

    public static AssetFileDescriptor fromMemoryFile(MemoryFile memoryFile) throws IOException {
        ParcelFileDescriptor parcelFileDescriptor = memoryFile.getParcelFileDescriptor();
        long l = memoryFile.length();
        return new AssetFileDescriptor(parcelFileDescriptor, 0L, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMemoryFile() throws IOException {
        try {
            boolean bl = MemoryFile.isMemoryFile(this.mFd.getFileDescriptor());
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void close() throws IOException {
        this.mFd.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileInputStream createInputStream() throws IOException {
        void var7_7;
        if (this.isMemoryFile()) {
            if (this.mLength > Integer.MAX_VALUE) {
                StringBuilder stringBuilder = new StringBuilder().append("File length too large for a memory file: ");
                long l = this.mLength;
                String string2 = stringBuilder.append(l).toString();
                throw new IOException(string2);
            }
            ParcelFileDescriptor parcelFileDescriptor = this.mFd;
            int n = (int)this.mLength;
            AutoCloseMemoryFileInputStream autoCloseMemoryFileInputStream = new AutoCloseMemoryFileInputStream(parcelFileDescriptor, n);
            return var7_7;
        }
        if (this.mLength < 0L) {
            ParcelFileDescriptor parcelFileDescriptor = this.mFd;
            ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
            return var7_7;
        }
        AutoCloseInputStream autoCloseInputStream = new AutoCloseInputStream(this);
        return var7_7;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileOutputStream createOutputStream() throws IOException {
        void var2_3;
        if (this.mLength < 0L) {
            ParcelFileDescriptor parcelFileDescriptor = this.mFd;
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            return var2_3;
        }
        AutoCloseOutputStream autoCloseOutputStream = new AutoCloseOutputStream(this);
        return var2_3;
    }

    @Override
    public int describeContents() {
        return this.mFd.describeContents();
    }

    public long getDeclaredLength() {
        return this.mLength;
    }

    public FileDescriptor getFileDescriptor() {
        return this.mFd.getFileDescriptor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.mLength >= 0L) {
            return this.mLength;
        }
        long l = this.mFd.getStatSize();
        if (l < 0L) return 65535L;
        return l;
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        return this.mFd;
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("{AssetFileDescriptor: ");
        ParcelFileDescriptor parcelFileDescriptor = this.mFd;
        StringBuilder stringBuilder2 = stringBuilder.append(parcelFileDescriptor).append(" start=");
        long l = this.mStartOffset;
        StringBuilder stringBuilder3 = stringBuilder2.append(l).append(" len=");
        long l2 = this.mLength;
        return stringBuilder3.append(l2).append("}").toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.mFd.writeToParcel(parcel, n);
        long l = this.mStartOffset;
        parcel.writeLong(l);
        long l2 = this.mLength;
        parcel.writeLong(l2);
    }

    public static class AutoCloseOutputStream
    extends ParcelFileDescriptor.AutoCloseOutputStream {
        private long mRemaining;

        public AutoCloseOutputStream(AssetFileDescriptor assetFileDescriptor) throws IOException {
            long l;
            ParcelFileDescriptor parcelFileDescriptor = assetFileDescriptor.getParcelFileDescriptor();
            super(parcelFileDescriptor);
            ParcelFileDescriptor parcelFileDescriptor2 = assetFileDescriptor.getParcelFileDescriptor();
            long l2 = assetFileDescriptor.getStartOffset();
            if (parcelFileDescriptor2.seekTo(l2) < 0L) {
                throw new IOException("Unable to seek");
            }
            this.mRemaining = l = (long)((int)assetFileDescriptor.getLength());
        }

        @Override
        public void write(int n) throws IOException {
            if (this.mRemaining >= 0L) {
                long l;
                if (this.mRemaining == 0L) {
                    return;
                }
                super.write(n);
                this.mRemaining = l = this.mRemaining - 1L;
                return;
            }
            super.write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            if (this.mRemaining >= 0L) {
                long l;
                if (this.mRemaining == 0L) {
                    return;
                }
                int n = byArray.length;
                long l2 = n;
                long l3 = this.mRemaining;
                if (l2 > l3) {
                    n = (int)this.mRemaining;
                }
                super.write(byArray);
                long l4 = this.mRemaining;
                long l5 = n;
                this.mRemaining = l = l4 - l5;
                return;
            }
            super.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.mRemaining >= 0L) {
                long l;
                if (this.mRemaining == 0L) {
                    return;
                }
                long l2 = n2;
                long l3 = this.mRemaining;
                if (l2 > l3) {
                    n2 = (int)this.mRemaining;
                }
                super.write(byArray, n, n2);
                long l4 = this.mRemaining;
                long l5 = n2;
                this.mRemaining = l = l4 - l5;
                return;
            }
            super.write(byArray, n, n2);
        }
    }

    private static class AutoCloseMemoryFileInputStream
    extends FileInputStream {
        private MemoryFile mFile;
        private ParcelFileDescriptor mParcelFd;
        private InputStream mStream;

        public AutoCloseMemoryFileInputStream(ParcelFileDescriptor parcelFileDescriptor, int n) throws IOException {
            InputStream inputStream;
            MemoryFile memoryFile;
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            super(fileDescriptor);
            this.mParcelFd = parcelFileDescriptor;
            FileDescriptor fileDescriptor2 = parcelFileDescriptor.getFileDescriptor();
            this.mFile = memoryFile = new MemoryFile(fileDescriptor2, n, "r");
            this.mStream = inputStream = this.mFile.getInputStream();
        }

        @Override
        public int available() throws IOException {
            return this.mStream.available();
        }

        @Override
        public void close() throws IOException {
            this.mParcelFd.close();
            this.mFile.close();
            this.mStream.close();
        }

        @Override
        public FileChannel getChannel() {
            return null;
        }

        @Override
        public int read() throws IOException {
            return this.mStream.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.mStream.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.mStream.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.mStream.skip(l);
        }
    }

    public static class AutoCloseInputStream
    extends ParcelFileDescriptor.AutoCloseInputStream {
        private long mRemaining;

        public AutoCloseInputStream(AssetFileDescriptor assetFileDescriptor) throws IOException {
            long l;
            ParcelFileDescriptor parcelFileDescriptor = assetFileDescriptor.getParcelFileDescriptor();
            super(parcelFileDescriptor);
            long l2 = assetFileDescriptor.getStartOffset();
            long l3 = super.skip(l2);
            this.mRemaining = l = (long)((int)assetFileDescriptor.getLength());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int available() throws IOException {
            if (this.mRemaining < 0L) return super.available();
            if (this.mRemaining >= Integer.MAX_VALUE) return Integer.MAX_VALUE;
            return (int)this.mRemaining;
        }

        @Override
        public void mark(int n) {
            if (this.mRemaining >= 0L) {
                return;
            }
            super.mark(n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean markSupported() {
            if (this.mRemaining < 0L) return super.markSupported();
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            long l;
            if (this.mRemaining < 0L) return super.read();
            if (this.mRemaining == 0L) {
                return -1;
            }
            int n = super.read();
            if (n < 0) return n;
            this.mRemaining = l = this.mRemaining - 1L;
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] byArray) throws IOException {
            long l;
            int n;
            if (this.mRemaining < 0L) return super.read(byArray);
            if (this.mRemaining == 0L) {
                return -1;
            }
            int n2 = byArray.length;
            long l2 = n2;
            long l3 = this.mRemaining;
            if (l2 > l3) {
                n2 = (int)this.mRemaining;
            }
            if ((n = super.read(byArray, 0, n2)) < 0) return n;
            long l4 = this.mRemaining;
            long l5 = n;
            this.mRemaining = l = l4 - l5;
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            long l;
            int n3;
            if (this.mRemaining < 0L) return super.read(byArray, n, n2);
            if (this.mRemaining == 0L) {
                return -1;
            }
            long l2 = n2;
            long l3 = this.mRemaining;
            if (l2 > l3) {
                n2 = (int)this.mRemaining;
            }
            if ((n3 = super.read(byArray, n, n2)) < 0) return n3;
            long l4 = this.mRemaining;
            long l5 = n3;
            this.mRemaining = l = l4 - l5;
            return n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void reset() throws IOException {
            synchronized (this) {
                block6: {
                    long l = this.mRemaining;
                    if (l < 0L) break block6;
                    return;
                }
                super.reset();
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long skip(long l) throws IOException {
            long l2;
            long l3;
            if (this.mRemaining < 0L) return super.skip(l);
            if (this.mRemaining == 0L) {
                return 65535L;
            }
            long l4 = this.mRemaining;
            if (l > l4) {
                l = this.mRemaining;
            }
            if ((l3 = super.skip(l)) < 0L) return l3;
            this.mRemaining = l2 = this.mRemaining - l3;
            return l3;
        }
    }
}

