/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.TypedValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public final class AssetManager {
    public static final int ACCESS_BUFFER = 3;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_UNKNOWN = 0;
    private static final boolean DEBUG_REFS = false;
    static final int STYLE_ASSET_COOKIE = 2;
    static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    static final int STYLE_DATA = 1;
    static final int STYLE_DENSITY = 5;
    static final int STYLE_NUM_ENTRIES = 6;
    static final int STYLE_RESOURCE_ID = 3;
    static final int STYLE_TYPE = 0;
    private static final String TAG = "AssetManager";
    private static final boolean localLOGV;
    private static final Object sSync;
    private static AssetManager sSystem;
    private int mNObject;
    private int mNumRefs;
    private int mObject;
    private final long[] mOffsets;
    private boolean mOpen;
    private HashMap<Integer, RuntimeException> mRefStacks;
    private StringBlock[] mStringBlocks;
    private final TypedValue mValue;

    static {
        sSync = new Object();
        sSystem = null;
    }

    public AssetManager() {
        TypedValue typedValue;
        this.mValue = typedValue = new TypedValue();
        Object var2_2 = null;
        this.mOffsets = var2_2;
        this.mStringBlocks = null;
        this.mNumRefs = 1;
        this.mOpen = true;
        synchronized (this) {
            this.init();
            AssetManager.ensureSystemAssets();
            return;
        }
    }

    private AssetManager(boolean bl) {
        TypedValue typedValue;
        this.mValue = typedValue = new TypedValue();
        Object var3_3 = null;
        this.mOffsets = var3_3;
        this.mStringBlocks = null;
        this.mNumRefs = 1;
        this.mOpen = true;
        this.init();
    }

    static final native boolean applyStyle(int var0, int var1, int var2, int var3, int[] var4, int[] var5, int[] var6);

    static final native void applyThemeStyle(int var0, int var1, boolean var2);

    static final native void copyTheme(int var0, int var1);

    private final void decRefsLocked(int n) {
        int n2;
        this.mNumRefs = n2 = this.mNumRefs - 1;
        if (this.mNumRefs != 0) {
            return;
        }
        this.destroy();
    }

    private final native void deleteTheme(int var1);

    private final native void destroy();

    private final native void destroyAsset(int var1);

    static final native void dumpTheme(int var0, int var1, String var2, String var3);

    private static void ensureSystemAssets() {
        Object object = sSync;
        synchronized (object) {
            if (sSystem == null) {
                AssetManager assetManager = new AssetManager(true);
                assetManager.makeStringBlocks(false);
                sSystem = assetManager;
            }
            return;
        }
    }

    private final native int[] getArrayStringInfo(int var1);

    private final native String[] getArrayStringResource(int var1);

    public static final native String getAssetAllocations();

    private final native long getAssetLength(int var1);

    private final native long getAssetRemainingLength(int var1);

    public static final native int getGlobalAssetCount();

    public static final native int getGlobalAssetManagerCount();

    private final native int getNativeStringBlock(int var1);

    private final native int getStringBlockCount();

    public static AssetManager getSystem() {
        AssetManager.ensureSystemAssets();
        return sSystem;
    }

    private final void incRefsLocked(int n) {
        int n2;
        this.mNumRefs = n2 = this.mNumRefs + 1;
    }

    private final native void init();

    private final native int loadResourceBagValue(int var1, int var2, TypedValue var3, boolean var4);

    private final native int loadResourceValue(int var1, TypedValue var2, boolean var3);

    static final native int loadThemeAttributeValue(int var0, int var1, TypedValue var2, boolean var3);

    /*
     * Enabled aggressive block sorting
     */
    private final void makeStringBlocks(boolean bl) {
        int n = bl ? AssetManager.sSystem.mStringBlocks.length : 0;
        int n2 = this.getStringBlockCount();
        StringBlock[] stringBlockArray = new StringBlock[n2];
        this.mStringBlocks = stringBlockArray;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 < n) {
                StringBlock stringBlock;
                StringBlock[] stringBlockArray2 = this.mStringBlocks;
                stringBlockArray2[n3] = stringBlock = AssetManager.sSystem.mStringBlocks[n3];
            } else {
                StringBlock stringBlock;
                StringBlock[] stringBlockArray3 = this.mStringBlocks;
                int n4 = this.getNativeStringBlock(n3);
                stringBlockArray3[n3] = stringBlock = new StringBlock(n4, true);
            }
            ++n3;
        }
        return;
    }

    private final native int newTheme();

    private final native int openAsset(String var1, int var2);

    private final native ParcelFileDescriptor openAssetFd(String var1, long[] var2) throws IOException;

    private native ParcelFileDescriptor openNonAssetFdNative(int var1, String var2, long[] var3) throws IOException;

    private final native int openNonAssetNative(int var1, String var2, int var3);

    private final native int openXmlAssetNative(int var1, String var2);

    private final native int readAsset(int var1, byte[] var2, int var3, int var4);

    private final native int readAssetChar(int var1);

    private final native long seekAsset(int var1, long var2, int var4);

    public final native int addAssetPath(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int[] addAssetPaths(String[] stringArray) {
        int n;
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        while (n2 < (n = stringArray.length)) {
            int n3;
            String string2 = stringArray[n2];
            nArray[n2] = n3 = this.addAssetPath(string2);
            ++n2;
        }
        return nArray;
    }

    public void close() {
        synchronized (this) {
            if (this.mOpen) {
                this.mOpen = false;
                int n = this.hashCode();
                this.decRefsLocked(n);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int createTheme() {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int n = this.newTheme();
            this.incRefsLocked(n);
            return n;
        }
    }

    final void ensureStringBlocks() {
        if (this.mStringBlocks != null) {
            return;
        }
        synchronized (this) {
            if (this.mStringBlocks == null) {
                this.makeStringBlocks(true);
            }
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
            return;
        }
        finally {
            super.finalize();
        }
    }

    final native int[] getArrayIntResource(int var1);

    final native int getArraySize(int var1);

    public final native String getCookieName(int var1);

    public final native String[] getLocales();

    final CharSequence getPooledString(int n, int n2) {
        StringBlock[] stringBlockArray = this.mStringBlocks;
        int n3 = n - 1;
        return stringBlockArray[n3].get(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final CharSequence getResourceBagText(int n, int n2) {
        synchronized (this) {
            TypedValue typedValue = this.mValue;
            int n3 = this.loadResourceBagValue(n, n2, typedValue, true);
            if (n3 < 0) {
                return null;
            }
            if (typedValue.type != 3) return typedValue.coerceToString();
            StringBlock stringBlock = this.mStringBlocks[n3];
            int n4 = typedValue.data;
            return stringBlock.get(n4);
        }
    }

    final native String getResourceEntryName(int var1);

    final native int getResourceIdentifier(String var1, String var2, String var3);

    final native String getResourceName(int var1);

    final native String getResourcePackageName(int var1);

    final String[] getResourceStringArray(int n) {
        return this.getArrayStringResource(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final CharSequence getResourceText(int n) {
        synchronized (this) {
            TypedValue typedValue = this.mValue;
            int n2 = this.loadResourceValue(n, typedValue, true);
            if (n2 < 0) {
                return null;
            }
            if (typedValue.type != 3) return typedValue.coerceToString();
            StringBlock stringBlock = this.mStringBlocks[n2];
            int n3 = typedValue.data;
            return stringBlock.get(n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final CharSequence[] getResourceTextArray(int n) {
        int[] nArray = this.getArrayStringInfo(n);
        int n2 = nArray.length;
        CharSequence[] charSequenceArray = new CharSequence[n2 / 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = nArray[n3];
            int n6 = n3 + 1;
            int n7 = nArray[n6];
            CharSequence charSequence = n7 >= 0 ? this.mStringBlocks[n5].get(n7) : null;
            charSequenceArray[n4] = charSequence;
            n3 += 2;
            ++n4;
        }
        return charSequenceArray;
    }

    final native String getResourceTypeName(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean getResourceValue(int n, TypedValue typedValue, boolean bl) {
        CharSequence charSequence;
        int n2 = this.loadResourceValue(n, typedValue, bl);
        if (n2 < 0) return false;
        if (typedValue.type != 3) {
            return true;
        }
        StringBlock stringBlock = this.mStringBlocks[n2];
        int n3 = typedValue.data;
        typedValue.string = charSequence = stringBlock.get(n3);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean getThemeValue(int n, int n2, TypedValue typedValue, boolean bl) {
        CharSequence charSequence;
        int n3 = AssetManager.loadThemeAttributeValue(n, n2, typedValue, bl);
        if (n3 < 0) return false;
        if (typedValue.type != 3) {
            return true;
        }
        StringBlock[] stringBlockArray = this.mStringBlocks;
        if (stringBlockArray == null) {
            this.ensureStringBlocks();
        }
        StringBlock stringBlock = stringBlockArray[n3];
        int n4 = typedValue.data;
        typedValue.string = charSequence = stringBlock.get(n4);
        return true;
    }

    public final native boolean isUpToDate();

    public final native String[] list(String var1) throws IOException;

    public final InputStream open(String string2) throws IOException {
        return this.open(string2, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream open(String string2, int n) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int n2 = this.openAsset(string2, n);
            if (n2 != 0) {
                AssetInputStream assetInputStream = new AssetInputStream(n2);
                int n3 = assetInputStream.hashCode();
                this.incRefsLocked(n3);
                return assetInputStream;
            }
        }
        String string3 = "Asset file: " + string2;
        throw new FileNotFoundException(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AssetFileDescriptor openFd(String string2) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long[] lArray = this.mOffsets;
            ParcelFileDescriptor parcelFileDescriptor = this.openAssetFd(string2, lArray);
            if (parcelFileDescriptor != null) {
                long l = this.mOffsets[0];
                long l2 = this.mOffsets[1];
                return new AssetFileDescriptor(parcelFileDescriptor, l, l2);
            }
        }
        String string3 = "Asset file: " + string2;
        throw new FileNotFoundException(string3);
    }

    public final InputStream openNonAsset(int n, String string2) throws IOException {
        return this.openNonAsset(n, string2, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream openNonAsset(int n, String string2, int n2) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int n3 = this.openNonAssetNative(n, string2, n2);
            if (n3 != 0) {
                AssetInputStream assetInputStream = new AssetInputStream(n3);
                int n4 = assetInputStream.hashCode();
                this.incRefsLocked(n4);
                return assetInputStream;
            }
        }
        String string3 = "Asset absolute file: " + string2;
        throw new FileNotFoundException(string3);
    }

    public final InputStream openNonAsset(String string2) throws IOException {
        return this.openNonAsset(0, string2, 2);
    }

    public final InputStream openNonAsset(String string2, int n) throws IOException {
        return this.openNonAsset(0, string2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AssetFileDescriptor openNonAssetFd(int n, String string2) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long[] lArray = this.mOffsets;
            ParcelFileDescriptor parcelFileDescriptor = this.openNonAssetFdNative(n, string2, lArray);
            if (parcelFileDescriptor != null) {
                long l = this.mOffsets[0];
                long l2 = this.mOffsets[1];
                return new AssetFileDescriptor(parcelFileDescriptor, l, l2);
            }
        }
        String string3 = "Asset absolute file: " + string2;
        throw new FileNotFoundException(string3);
    }

    public final AssetFileDescriptor openNonAssetFd(String string2) throws IOException {
        return this.openNonAssetFd(0, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final XmlBlock openXmlBlockAsset(int n, String string2) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int n2 = this.openXmlAssetNative(n, string2);
            if (n2 != 0) {
                XmlBlock xmlBlock = new XmlBlock(this, n2);
                int n3 = xmlBlock.hashCode();
                this.incRefsLocked(n3);
                return xmlBlock;
            }
        }
        String string3 = "Asset XML file: " + string2;
        throw new FileNotFoundException(string3);
    }

    final XmlBlock openXmlBlockAsset(String string2) throws IOException {
        return this.openXmlBlockAsset(0, string2);
    }

    public final XmlResourceParser openXmlResourceParser(int n, String string2) throws IOException {
        XmlBlock xmlBlock = this.openXmlBlockAsset(n, string2);
        XmlResourceParser xmlResourceParser = xmlBlock.newParser();
        xmlBlock.close();
        return xmlResourceParser;
    }

    public final XmlResourceParser openXmlResourceParser(String string2) throws IOException {
        return this.openXmlResourceParser(0, string2);
    }

    final void releaseTheme(int n) {
        synchronized (this) {
            this.deleteTheme(n);
            this.decRefsLocked(n);
            return;
        }
    }

    final native int retrieveArray(int var1, int[] var2);

    final native boolean retrieveAttributes(int var1, int[] var2, int[] var3, int[] var4);

    public final native void setConfiguration(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    public final native void setLocale(String var1);

    void xmlBlockGone(int n) {
        synchronized (this) {
            this.decRefsLocked(n);
            return;
        }
    }

    public final class AssetInputStream
    extends InputStream {
        private int mAsset;
        private long mLength;
        private long mMarkPos;

        private AssetInputStream(int n) {
            long l;
            this.mAsset = n;
            this.mLength = l = AssetManager.this.getAssetLength(n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final int available() throws IOException {
            AssetManager assetManager = AssetManager.this;
            int n = this.mAsset;
            long l = assetManager.getAssetRemainingLength(n);
            if (l <= Integer.MAX_VALUE) return (int)l;
            return Integer.MAX_VALUE;
        }

        @Override
        public final void close() throws IOException {
            AssetManager assetManager = AssetManager.this;
            synchronized (assetManager) {
                if (this.mAsset != 0) {
                    AssetManager assetManager2 = AssetManager.this;
                    int n = this.mAsset;
                    assetManager2.destroyAsset(n);
                    this.mAsset = 0;
                    AssetManager assetManager3 = AssetManager.this;
                    int n2 = this.hashCode();
                    assetManager3.decRefsLocked(n2);
                }
                return;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public final int getAssetInt() {
            return this.mAsset;
        }

        @Override
        public final void mark(int n) {
            long l;
            AssetManager assetManager = AssetManager.this;
            int n2 = this.mAsset;
            this.mMarkPos = l = assetManager.seekAsset(n2, 0L, 0);
        }

        @Override
        public final boolean markSupported() {
            return true;
        }

        @Override
        public final int read() throws IOException {
            AssetManager assetManager = AssetManager.this;
            int n = this.mAsset;
            return assetManager.readAssetChar(n);
        }

        @Override
        public final int read(byte[] byArray) throws IOException {
            AssetManager assetManager = AssetManager.this;
            int n = this.mAsset;
            int n2 = byArray.length;
            return assetManager.readAsset(n, byArray, 0, n2);
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws IOException {
            AssetManager assetManager = AssetManager.this;
            int n3 = this.mAsset;
            return assetManager.readAsset(n3, byArray, n, n2);
        }

        @Override
        public final void reset() throws IOException {
            AssetManager assetManager = AssetManager.this;
            int n = this.mAsset;
            long l = this.mMarkPos;
            long l2 = assetManager.seekAsset(n, l, -1);
        }

        @Override
        public final long skip(long l) throws IOException {
            long l2;
            AssetManager assetManager = AssetManager.this;
            int n = this.mAsset;
            long l3 = assetManager.seekAsset(n, 0L, 0);
            long l4 = l3 + l;
            if (l4 > (l2 = this.mLength)) {
                l = this.mLength - l3;
            }
            if (l > 0L) {
                AssetManager assetManager2 = AssetManager.this;
                int n2 = this.mAsset;
                long l5 = assetManager2.seekAsset(n2, l, 0);
            }
            return l;
        }
    }
}

