/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.StateSet;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorStateList
implements Parcelable {
    public static final Parcelable.Creator<ColorStateList> CREATOR;
    private static final int[][] EMPTY;
    private static final SparseArray<WeakReference<ColorStateList>> sCache;
    private int[] mColors;
    private int mDefaultColor = -65536;
    private int[][] mStateSpecs;

    static {
        int[] nArray = new int[1];
        int[] nArray2 = new int[]{};
        nArray[0] = (int)nArray2;
        EMPTY = (int[][])nArray;
        sCache = new SparseArray();
        CREATOR = new Parcelable.Creator<ColorStateList>(){

            @Override
            public ColorStateList createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    int[] nArray2 = parcel.createIntArray();
                    nArray[i] = (int)nArray2;
                }
                int[] nArray3 = parcel.createIntArray();
                return new ColorStateList((int[][])nArray, nArray3);
            }

            public ColorStateList[] newArray(int n) {
                return new ColorStateList[n];
            }
        };
    }

    private ColorStateList() {
    }

    public ColorStateList(int[][] nArray, int[] nArray2) {
        int n;
        this.mStateSpecs = nArray;
        this.mColors = nArray2;
        if (nArray.length <= 0) {
            return;
        }
        this.mDefaultColor = n = nArray2[0];
        int n2 = 0;
        int n3;
        while (n2 < (n3 = nArray.length)) {
            if (nArray[n2].length == 0) {
                int n4;
                this.mDefaultColor = n4 = nArray2[n2];
            }
            ++n2;
        }
        return;
    }

    public static ColorStateList createFromXml(Resources resources, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        AttributeSet attributeSet = Xml.asAttributeSet(xmlPullParser);
        while ((n = xmlPullParser.next()) != 2 && n != 1) {
        }
        if (n != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return ColorStateList.createFromXmlInner(resources, xmlPullParser, attributeSet);
    }

    private static ColorStateList createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        String string2 = xmlPullParser.getName();
        if (string2.equals("selector")) {
            ColorStateList colorStateList = new ColorStateList();
            colorStateList.inflate(resources, xmlPullParser, attributeSet);
            return colorStateList;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = xmlPullParser.getPositionDescription();
        String string4 = stringBuilder.append(string3).append(": invalid drawable tag ").append(string2).toString();
        throw new XmlPullParserException(string4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getDepth() + 1;
        int n2 = 20;
        int n3 = 0;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        block0: while (true) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if ((n9 = (n8 = xmlPullParser.next())) != (n7 = 1) && ((n6 = xmlPullParser.getDepth()) >= n || (n5 = n8) != (n4 = 3))) {
                int n10 = n8;
                int n11 = 2;
                if (n10 != n11 || n6 > n || !xmlPullParser.getName().equals("item")) continue;
            } else {
                int[] nArray3 = new int[n3];
                this.mColors = nArray3;
                int[] nArray4 = new int[n3];
                this.mStateSpecs = (int[][])nArray4;
                int[] nArray5 = this.mColors;
                int[] nArray6 = nArray;
                int n12 = 0;
                int[] nArray7 = nArray5;
                int n13 = 0;
                int n14 = n3;
                System.arraycopy(nArray6, n12, nArray7, n13, n14);
                int[][] nArray8 = this.mStateSpecs;
                int[] nArray9 = nArray2;
                int n15 = 0;
                int[][] nArray10 = nArray8;
                int n16 = 0;
                int n17 = n3;
                System.arraycopy(nArray9, n15, nArray10, n16, n17);
                return;
            }
            int n18 = 0;
            int n19 = -65536;
            boolean bl = false;
            int n20 = attributeSet.getAttributeCount();
            int[] nArray11 = new int[n20];
            int n21 = 0;
            int n22 = 0;
            while (true) {
                int n23;
                int n24;
                AttributeSet attributeSet2;
                int n25;
                int n26;
                int n27;
                if ((n27 = ++n21) >= (n26 = n20) || (n25 = (attributeSet2 = attributeSet).getAttributeNameResource(n24 = n21)) == 0) {
                    int n28;
                    int n29;
                    int[] nArray12 = nArray11;
                    int n30 = n22;
                    int[] nArray13 = StateSet.trimStateSet(nArray12, n30);
                    if (n18 != 0) {
                        Resources resources2 = resources;
                        int n31 = n18;
                        n19 = resources2.getColor(n31);
                    } else if (!bl) {
                        StringBuilder stringBuilder = new StringBuilder();
                        String string2 = xmlPullParser.getPositionDescription();
                        String string3 = stringBuilder.append(string2).append(": <item> tag requires a 'android:color' attribute.").toString();
                        throw new XmlPullParserException(string3);
                    }
                    if (n3 == 0 || nArray13.length == 0) {
                        int n32;
                        this.mDefaultColor = n32 = n19;
                    }
                    if ((n29 = n3 + 1) >= (n28 = n2)) {
                        n2 = ArrayUtils.idealIntArraySize(n3 + 1);
                        int[] nArray14 = new int[n2];
                        int[] nArray15 = nArray;
                        int n33 = 0;
                        int[] nArray16 = nArray14;
                        int n34 = 0;
                        int n35 = n3;
                        System.arraycopy(nArray15, n33, nArray16, n34, n35);
                        int[] nArray17 = new int[n2];
                        int[] nArray18 = nArray2;
                        int n36 = 0;
                        int[] nArray19 = nArray17;
                        int n37 = 0;
                        int n38 = n3;
                        System.arraycopy(nArray18, n36, nArray19, n37, n38);
                        nArray = nArray14;
                        nArray2 = nArray17;
                    }
                    nArray[n3] = n19;
                    nArray2[n3] = (int)nArray13;
                    ++n3;
                    continue block0;
                }
                int n39 = n25;
                int n40 = 16843173;
                if (n39 == n40) {
                    AttributeSet attributeSet3 = attributeSet;
                    int n41 = n21;
                    int n42 = 0;
                    n18 = attributeSet3.getAttributeResourceValue(n41, n42);
                    if (n18 == 0) {
                        AttributeSet attributeSet4 = attributeSet;
                        int n43 = n21;
                        int n44 = n19;
                        n19 = attributeSet4.getAttributeIntValue(n43, n44);
                        bl = true;
                        n23 = n22;
                    } else {
                        n23 = n22;
                    }
                } else {
                    n23 = n22 + 1;
                    AttributeSet attributeSet5 = attributeSet;
                    int n45 = n21;
                    boolean bl2 = false;
                    int n46 = attributeSet5.getAttributeBooleanValue(n45, bl2) ? n25 : -n25;
                    nArray11[n22] = n46;
                }
                n22 = n23;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColorStateList valueOf(int n) {
        SparseArray<WeakReference<ColorStateList>> sparseArray = sCache;
        synchronized (sparseArray) {
            WeakReference<ColorStateList> weakReference = sCache.get(n);
            ColorStateList colorStateList = weakReference != null ? (ColorStateList)weakReference.get() : null;
            if (colorStateList != null) {
                return colorStateList;
            }
            int[][] nArray = EMPTY;
            int[] nArray2 = new int[]{n};
            ColorStateList colorStateList2 = new ColorStateList(nArray, nArray2);
            SparseArray<WeakReference<ColorStateList>> sparseArray2 = sCache;
            WeakReference<ColorStateList> weakReference2 = new WeakReference<ColorStateList>(colorStateList2);
            sparseArray2.put(n, weakReference2);
            return colorStateList2;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getColorForState(int[] nArray, int n) {
        int n2 = this.mStateSpecs.length;
        int n3 = 0;
        while (n3 < n2) {
            if (StateSet.stateSetMatches(this.mStateSpecs[n3], nArray)) {
                return this.mColors[n3];
            }
            ++n3;
        }
        return n;
    }

    public int getDefaultColor() {
        return this.mDefaultColor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStateful() {
        if (this.mStateSpecs.length <= 1) return false;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("ColorStateList{mStateSpecs=");
        String string2 = Arrays.deepToString((Object[])this.mStateSpecs);
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("mColors=");
        String string3 = Arrays.toString(this.mColors);
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append("mDefaultColor=");
        int n = this.mDefaultColor;
        return stringBuilder3.append(n).append('}').toString();
    }

    public ColorStateList withAlpha(int n) {
        int[] nArray = new int[this.mColors.length];
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = this.mColors[i] & 0xFFFFFF;
            int n5 = n << 24;
            nArray[i] = n3 = n4 | n5;
        }
        int[][] nArray2 = this.mStateSpecs;
        return new ColorStateList(nArray2, nArray);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mStateSpecs.length;
        parcel.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            int[] nArray = this.mStateSpecs[i];
            parcel.writeIntArray(nArray);
        }
        int[] nArray = this.mColors;
        parcel.writeIntArray(nArray);
    }
}

