/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ApplicationInfo;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.WindowManager;

public class CompatibilityInfo {
    private static final int CONFIGURED_EXPANDABLE = 4;
    private static final int CONFIGURED_LARGE_SCREENS = 16;
    private static final int CONFIGURED_XLARGE_SCREENS = 64;
    private static final boolean DBG = false;
    public static final CompatibilityInfo DEFAULT_COMPATIBILITY_INFO = new CompatibilityInfo(){

        @Override
        public void setExpandable(boolean bl) {
            throw new UnsupportedOperationException("trying to change default compatibility info");
        }
    };
    public static final int DEFAULT_PORTRAIT_HEIGHT = 480;
    public static final int DEFAULT_PORTRAIT_WIDTH = 320;
    private static final int EXPANDABLE = 2;
    private static final int LARGE_SCREENS = 8;
    private static final int SCALING_REQUIRED = 1;
    private static final String TAG = "CompatibilityInfo";
    private static final int XLARGE_SCREENS = 32;
    public final int appFlags;
    public final int applicationDensity;
    public final float applicationInvertedScale;
    public final float applicationScale;
    private int mCompatibilityFlags;

    private CompatibilityInfo() {
        int n = DisplayMetrics.DENSITY_DEVICE;
        CompatibilityInfo compatibilityInfo = this;
        float f = 1.0f;
        compatibilityInfo(531968, 6, n, 1.0f, f);
    }

    private CompatibilityInfo(int n, int n2, int n3, float f, float f2) {
        this.appFlags = n;
        this.mCompatibilityFlags = n2;
        this.applicationDensity = n3;
        this.applicationScale = f;
        this.applicationInvertedScale = f2;
    }

    public CompatibilityInfo(ApplicationInfo applicationInfo) {
        int n;
        float f;
        float f2;
        int n2;
        this.appFlags = n2 = applicationInfo.flags;
        if ((applicationInfo.flags & 0x800) != 0) {
            int n3;
            this.mCompatibilityFlags = n3 = this.mCompatibilityFlags | 0x7E;
        }
        if ((applicationInfo.flags & 0x80000) != 0) {
            int n4;
            this.mCompatibilityFlags = n4 = this.mCompatibilityFlags | 0x66;
        }
        if ((applicationInfo.flags & 0x1000) != 0) {
            int n5;
            this.mCompatibilityFlags = n5 = this.mCompatibilityFlags | 6;
        }
        if ((applicationInfo.flags & 0x2000) != 0) {
            int n6;
            this.applicationDensity = n6 = DisplayMetrics.DENSITY_DEVICE;
            this.applicationScale = 1.0f;
            this.applicationInvertedScale = 1.0f;
            return;
        }
        this.applicationDensity = 160;
        float f3 = this.applicationScale = (f2 = (float)DisplayMetrics.DENSITY_DEVICE / 160.0f);
        this.applicationInvertedScale = f = 1.0f / f3;
        this.mCompatibilityFlags = n = this.mCompatibilityFlags | 1;
    }

    public static void updateCompatibleScreenFrame(DisplayMetrics displayMetrics, int n, Rect rect) {
        int n2 = displayMetrics.widthPixels;
        float f = displayMetrics.density;
        int n3 = (int)(480.0f * f + 0.5f);
        float f2 = displayMetrics.density;
        int n4 = (int)(320.0f * f2 + 0.5f);
        if (n == 2) {
            int n5 = (n2 - n3) / 2;
            int n6 = n5 + n3;
            rect.set(n5, 0, n6, n4);
            return;
        }
        int n7 = (n2 - n4) / 2;
        int n8 = n7 + n4;
        rect.set(n7, 0, n8, n3);
    }

    public CompatibilityInfo copy() {
        int n = this.appFlags;
        int n2 = this.mCompatibilityFlags;
        int n3 = this.applicationDensity;
        float f = this.applicationScale;
        float f2 = this.applicationInvertedScale;
        return new CompatibilityInfo(n, n2, n3, f, f2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Translator getTranslator() {
        if (!this.isScalingRequired()) return null;
        return new Translator(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConfiguredExpandable() {
        if ((this.mCompatibilityFlags & 4) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConfiguredLargeScreens() {
        if ((this.mCompatibilityFlags & 0x10) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConfiguredXLargeScreens() {
        if ((this.mCompatibilityFlags & 0x40) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isScalingRequired() {
        if ((this.mCompatibilityFlags & 1) == 0) return false;
        return true;
    }

    public void setExpandable(boolean bl) {
        int n;
        if (bl) {
            int n2;
            this.mCompatibilityFlags = n2 = this.mCompatibilityFlags | 2;
            return;
        }
        this.mCompatibilityFlags = n = this.mCompatibilityFlags & 0xFFFFFFFD;
    }

    public void setLargeScreens(boolean bl) {
        int n;
        if (bl) {
            int n2;
            this.mCompatibilityFlags = n2 = this.mCompatibilityFlags | 8;
            return;
        }
        this.mCompatibilityFlags = n = this.mCompatibilityFlags & 0xFFFFFFF7;
    }

    public void setXLargeScreens(boolean bl) {
        int n;
        if (bl) {
            int n2;
            this.mCompatibilityFlags = n2 = this.mCompatibilityFlags | 0x20;
            return;
        }
        this.mCompatibilityFlags = n = this.mCompatibilityFlags & 0xFFFFFFDF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supportsScreen() {
        if ((this.mCompatibilityFlags & 0xA) != 10) return false;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("CompatibilityInfo{scale=");
        float f = this.applicationScale;
        StringBuilder stringBuilder2 = stringBuilder.append(f).append(", supports screen=");
        boolean bl = this.supportsScreen();
        return stringBuilder2.append(bl).append("}").toString();
    }

    public class Translator {
        public final float applicationInvertedScale;
        public final float applicationScale;
        private Rect mContentInsetsBuffer;
        private Rect mVisibleInsetsBuffer;
        final /* synthetic */ CompatibilityInfo this$0;

        Translator(CompatibilityInfo compatibilityInfo) {
            float f = compatibilityInfo.applicationScale;
            float f2 = compatibilityInfo.applicationInvertedScale;
            this(compatibilityInfo, f, f2);
        }

        Translator(CompatibilityInfo compatibilityInfo, float f, float f2) {
            this.this$0 = compatibilityInfo;
            this.mContentInsetsBuffer = null;
            this.mVisibleInsetsBuffer = null;
            this.applicationScale = f;
            this.applicationInvertedScale = f2;
        }

        public Rect getTranslatedContentInsets(Rect rect) {
            if (this.mContentInsetsBuffer == null) {
                Rect rect2;
                this.mContentInsetsBuffer = rect2 = new Rect();
            }
            this.mContentInsetsBuffer.set(rect);
            Rect rect3 = this.mContentInsetsBuffer;
            this.translateRectInAppWindowToScreen(rect3);
            return this.mContentInsetsBuffer;
        }

        public Rect getTranslatedVisbileInsets(Rect rect) {
            if (this.mVisibleInsetsBuffer == null) {
                Rect rect2;
                this.mVisibleInsetsBuffer = rect2 = new Rect();
            }
            this.mVisibleInsetsBuffer.set(rect);
            Rect rect3 = this.mVisibleInsetsBuffer;
            this.translateRectInAppWindowToScreen(rect3);
            return this.mVisibleInsetsBuffer;
        }

        public void translateCanvas(Canvas canvas) {
            if (this.applicationScale == 1.5f) {
                canvas.translate(0.0026143792f, 0.0026143792f);
            }
            float f = this.applicationScale;
            float f2 = this.applicationScale;
            canvas.scale(f, f2);
        }

        public void translateEventInScreenToAppWindow(MotionEvent motionEvent) {
            float f = this.applicationInvertedScale;
            motionEvent.scale(f);
        }

        public void translateLayoutParamsInAppWindowToScreen(WindowManager.LayoutParams layoutParams) {
            float f = this.applicationScale;
            layoutParams.scale(f);
        }

        public void translateRectInAppWindowToScreen(Rect rect) {
            float f = this.applicationScale;
            rect.scale(f);
        }

        public void translateRectInScreenToAppWinFrame(Rect rect) {
            float f = this.applicationInvertedScale;
            rect.scale(f);
        }

        public void translateRectInScreenToAppWindow(Rect rect) {
            float f = this.applicationInvertedScale;
            rect.scale(f);
        }

        public void translateRegionInWindowToScreen(Region region) {
            float f = this.applicationScale;
            region.scale(f);
        }

        public void translateWindowLayout(WindowManager.LayoutParams layoutParams) {
            float f = this.applicationScale;
            layoutParams.scale(f);
        }
    }
}

