/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;

public final class Configuration
implements Parcelable,
Comparable<Configuration> {
    public static final Parcelable.Creator<Configuration> CREATOR = new Parcelable.Creator<Configuration>(){

        @Override
        public Configuration createFromParcel(Parcel parcel) {
            return new Configuration(parcel);
        }

        public Configuration[] newArray(int n) {
            return new Configuration[n];
        }
    };
    public static final int HARDKEYBOARDHIDDEN_NO = 1;
    public static final int HARDKEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int HARDKEYBOARDHIDDEN_YES = 2;
    public static final int KEYBOARDHIDDEN_NO = 1;
    public static final int KEYBOARDHIDDEN_SOFT = 3;
    public static final int KEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int KEYBOARDHIDDEN_YES = 2;
    public static final int KEYBOARD_12KEY = 3;
    public static final int KEYBOARD_NOKEYS = 1;
    public static final int KEYBOARD_QWERTY = 2;
    public static final int KEYBOARD_UNDEFINED = 0;
    public static final int NAVIGATIONHIDDEN_NO = 1;
    public static final int NAVIGATIONHIDDEN_UNDEFINED = 0;
    public static final int NAVIGATIONHIDDEN_YES = 2;
    public static final int NAVIGATION_DPAD = 2;
    public static final int NAVIGATION_NONAV = 1;
    public static final int NAVIGATION_TRACKBALL = 3;
    public static final int NAVIGATION_UNDEFINED = 0;
    public static final int NAVIGATION_WHEEL = 4;
    public static final int ORIENTATION_LANDSCAPE = 2;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_SQUARE = 3;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int SCREENLAYOUT_COMPAT_NEEDED = 0x10000000;
    public static final int SCREENLAYOUT_LONG_MASK = 48;
    public static final int SCREENLAYOUT_LONG_NO = 16;
    public static final int SCREENLAYOUT_LONG_UNDEFINED = 0;
    public static final int SCREENLAYOUT_LONG_YES = 32;
    public static final int SCREENLAYOUT_SIZE_LARGE = 3;
    public static final int SCREENLAYOUT_SIZE_MASK = 15;
    public static final int SCREENLAYOUT_SIZE_NORMAL = 2;
    public static final int SCREENLAYOUT_SIZE_SMALL = 1;
    public static final int SCREENLAYOUT_SIZE_UNDEFINED = 0;
    public static final int SCREENLAYOUT_SIZE_XLARGE = 4;
    public static final int TOUCHSCREEN_FINGER = 3;
    public static final int TOUCHSCREEN_NOTOUCH = 1;
    public static final int TOUCHSCREEN_STYLUS = 2;
    public static final int TOUCHSCREEN_UNDEFINED = 0;
    public static final int UI_MODE_NIGHT_MASK = 48;
    public static final int UI_MODE_NIGHT_NO = 16;
    public static final int UI_MODE_NIGHT_UNDEFINED = 0;
    public static final int UI_MODE_NIGHT_YES = 32;
    public static final int UI_MODE_TYPE_CAR = 3;
    public static final int UI_MODE_TYPE_DESK = 2;
    public static final int UI_MODE_TYPE_MASK = 15;
    public static final int UI_MODE_TYPE_NORMAL = 1;
    public static final int UI_MODE_TYPE_UNDEFINED;
    public float fontScale;
    public int hardKeyboardHidden;
    public int keyboard;
    public int keyboardHidden;
    public Locale locale;
    public int mcc;
    public int mnc;
    public int navigation;
    public int navigationHidden;
    public int orientation;
    public int screenLayout;
    public int seq;
    public int touchscreen;
    public int uiMode;
    public boolean userSetLocale;

    public Configuration() {
        this.setToDefaults();
    }

    public Configuration(Configuration configuration) {
        this.setTo(configuration);
    }

    private Configuration(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean needNewResources(int n, int n2) {
        if (((0x40000000 | n2) & n) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Configuration configuration) {
        int n;
        int n2;
        float f = this.fontScale;
        float f2 = configuration.fontScale;
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        int n3 = this.mcc;
        int n4 = configuration.mcc;
        int n5 = n3 - n4;
        if (n5 != 0) {
            return n5;
        }
        int n6 = this.mnc;
        int n7 = configuration.mnc;
        n5 = n6 - n7;
        if (n5 != 0) {
            return n5;
        }
        if (this.locale == null) {
            if (configuration.locale != null) {
                return 1;
            }
        } else {
            String string2;
            String string3;
            String string4;
            if (configuration.locale == null) {
                return -1;
            }
            String string5 = this.locale.getLanguage();
            n5 = string5.compareTo(string4 = configuration.locale.getLanguage());
            if (n5 != 0) {
                return n5;
            }
            String string6 = this.locale.getCountry();
            n5 = string6.compareTo(string3 = configuration.locale.getCountry());
            if (n5 != 0) {
                return n5;
            }
            String string7 = this.locale.getVariant();
            n5 = string7.compareTo(string2 = configuration.locale.getVariant());
            if (n5 != 0) {
                return n5;
            }
        }
        if ((n5 = (n2 = this.touchscreen) - (n = configuration.touchscreen)) != 0) {
            return n5;
        }
        int n8 = this.keyboard;
        int n9 = configuration.keyboard;
        n5 = n8 - n9;
        if (n5 != 0) {
            return n5;
        }
        int n10 = this.keyboardHidden;
        int n11 = configuration.keyboardHidden;
        n5 = n10 - n11;
        if (n5 != 0) {
            return n5;
        }
        int n12 = this.hardKeyboardHidden;
        int n13 = configuration.hardKeyboardHidden;
        n5 = n12 - n13;
        if (n5 != 0) {
            return n5;
        }
        int n14 = this.navigation;
        int n15 = configuration.navigation;
        n5 = n14 - n15;
        if (n5 != 0) {
            return n5;
        }
        int n16 = this.navigationHidden;
        int n17 = configuration.navigationHidden;
        n5 = n16 - n17;
        if (n5 != 0) {
            return n5;
        }
        int n18 = this.orientation;
        int n19 = configuration.orientation;
        n5 = n18 - n19;
        if (n5 != 0) {
            return n5;
        }
        int n20 = this.screenLayout;
        int n21 = configuration.screenLayout;
        n5 = n20 - n21;
        if (n5 != 0) {
            return n5;
        }
        int n22 = this.uiMode;
        int n23 = configuration.uiMode;
        return n22 - n23;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int diff(Configuration configuration) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        Locale locale;
        Locale locale2;
        int n19;
        int n20;
        int n21;
        int n22;
        float f;
        float f2;
        int n23 = 0;
        if (configuration.fontScale > 0.0f && (f2 = this.fontScale) != (f = configuration.fontScale)) {
            n23 = 0 | 0x40000000;
        }
        if (configuration.mcc != 0 && (n22 = this.mcc) != (n21 = configuration.mcc)) {
            n23 |= 1;
        }
        if (configuration.mnc != 0 && (n20 = this.mnc) != (n19 = configuration.mnc)) {
            n23 |= 2;
        }
        if (!(configuration.locale == null || this.locale != null && (locale2 = this.locale).equals(locale = configuration.locale))) {
            n23 |= 4;
        }
        if (configuration.touchscreen != 0 && (n18 = this.touchscreen) != (n17 = configuration.touchscreen)) {
            n23 |= 8;
        }
        if (configuration.keyboard != 0 && (n16 = this.keyboard) != (n15 = configuration.keyboard)) {
            n23 |= 0x10;
        }
        if (configuration.keyboardHidden != 0 && (n14 = this.keyboardHidden) != (n13 = configuration.keyboardHidden)) {
            n23 |= 0x20;
        }
        if (configuration.hardKeyboardHidden != 0 && (n12 = this.hardKeyboardHidden) != (n11 = configuration.hardKeyboardHidden)) {
            n23 |= 0x20;
        }
        if (configuration.navigation != 0 && (n10 = this.navigation) != (n9 = configuration.navigation)) {
            n23 |= 0x40;
        }
        if (configuration.navigationHidden != 0 && (n8 = this.navigationHidden) != (n7 = configuration.navigationHidden)) {
            n23 |= 0x20;
        }
        if (configuration.orientation != 0 && (n6 = this.orientation) != (n5 = configuration.orientation)) {
            n23 |= 0x80;
        }
        if (configuration.screenLayout != 0 && (n4 = this.screenLayout) != (n3 = configuration.screenLayout)) {
            n23 |= 0x100;
        }
        if (configuration.uiMode != 0 && (n2 = this.uiMode) != (n = configuration.uiMode)) {
            n23 |= 0x200;
        }
        return n23;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Configuration configuration) {
        if (configuration == null) {
            return false;
        }
        if (configuration == this) {
            return true;
        }
        if (this.compareTo(configuration) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        try {
            Configuration configuration = (Configuration)object;
            boolean bl = this.equals(configuration);
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = (int)this.fontScale;
        int n2 = this.mcc;
        int n3 = n + n2;
        int n4 = this.mnc;
        int n5 = n3 + n4;
        int n6 = this.locale != null ? this.locale.hashCode() : 0;
        int n7 = n5 + n6;
        int n8 = this.touchscreen;
        int n9 = n7 + n8;
        int n10 = this.keyboard;
        int n11 = n9 + n10;
        int n12 = this.keyboardHidden;
        int n13 = n11 + n12;
        int n14 = this.hardKeyboardHidden;
        int n15 = n13 + n14;
        int n16 = this.navigation;
        int n17 = n15 + n16;
        int n18 = this.navigationHidden;
        int n19 = n17 + n18;
        int n20 = this.orientation;
        int n21 = n19 + n20;
        int n22 = this.screenLayout;
        int n23 = n21 + n22;
        int n24 = this.uiMode;
        return n23 + n24;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOtherSeqNewer(Configuration configuration) {
        if (configuration == null) {
            return false;
        }
        if (configuration.seq == 0) {
            return true;
        }
        if (this.seq == 0) {
            return true;
        }
        int n = configuration.seq;
        int n2 = this.seq;
        int n3 = n - n2;
        if (n3 > 65536) {
            return false;
        }
        if (n3 <= 0) return false;
        return true;
    }

    @Deprecated
    public void makeDefault() {
        this.setToDefaults();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readFromParcel(Parcel parcel) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        float f;
        this.fontScale = f = parcel.readFloat();
        this.mcc = n12 = parcel.readInt();
        this.mnc = n11 = parcel.readInt();
        if (parcel.readInt() != 0) {
            Locale locale;
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            this.locale = locale = new Locale(string2, string3, string4);
        }
        boolean bl = parcel.readInt() == 1;
        this.userSetLocale = bl;
        this.touchscreen = n10 = parcel.readInt();
        this.keyboard = n9 = parcel.readInt();
        this.keyboardHidden = n8 = parcel.readInt();
        this.hardKeyboardHidden = n7 = parcel.readInt();
        this.navigation = n6 = parcel.readInt();
        this.navigationHidden = n5 = parcel.readInt();
        this.orientation = n4 = parcel.readInt();
        this.screenLayout = n3 = parcel.readInt();
        this.uiMode = n2 = parcel.readInt();
        this.seq = n = parcel.readInt();
    }

    public void setTo(Configuration configuration) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl;
        int n11;
        int n12;
        float f;
        this.fontScale = f = configuration.fontScale;
        this.mcc = n12 = configuration.mcc;
        this.mnc = n11 = configuration.mnc;
        if (configuration.locale != null) {
            Locale locale;
            this.locale = locale = (Locale)configuration.locale.clone();
        }
        this.userSetLocale = bl = configuration.userSetLocale;
        this.touchscreen = n10 = configuration.touchscreen;
        this.keyboard = n9 = configuration.keyboard;
        this.keyboardHidden = n8 = configuration.keyboardHidden;
        this.hardKeyboardHidden = n7 = configuration.hardKeyboardHidden;
        this.navigation = n6 = configuration.navigation;
        this.navigationHidden = n5 = configuration.navigationHidden;
        this.orientation = n4 = configuration.orientation;
        this.screenLayout = n3 = configuration.screenLayout;
        this.uiMode = n2 = configuration.uiMode;
        this.seq = n = configuration.seq;
    }

    public void setToDefaults() {
        this.fontScale = 1.0f;
        this.mnc = 0;
        this.mcc = 0;
        this.locale = null;
        this.userSetLocale = false;
        this.touchscreen = 0;
        this.keyboard = 0;
        this.keyboardHidden = 0;
        this.hardKeyboardHidden = 0;
        this.navigation = 0;
        this.navigationHidden = 0;
        this.orientation = 0;
        this.screenLayout = 0;
        this.uiMode = 0;
        this.seq = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        StringBuilder stringBuilder2 = stringBuilder.append("{ scale=");
        float f = this.fontScale;
        StringBuilder stringBuilder3 = stringBuilder.append(f);
        StringBuilder stringBuilder4 = stringBuilder.append(" imsi=");
        int n = this.mcc;
        StringBuilder stringBuilder5 = stringBuilder.append(n);
        StringBuilder stringBuilder6 = stringBuilder.append("/");
        int n2 = this.mnc;
        StringBuilder stringBuilder7 = stringBuilder.append(n2);
        StringBuilder stringBuilder8 = stringBuilder.append(" loc=");
        Locale locale = this.locale;
        StringBuilder stringBuilder9 = stringBuilder.append(locale);
        StringBuilder stringBuilder10 = stringBuilder.append(" touch=");
        int n3 = this.touchscreen;
        StringBuilder stringBuilder11 = stringBuilder.append(n3);
        StringBuilder stringBuilder12 = stringBuilder.append(" keys=");
        int n4 = this.keyboard;
        StringBuilder stringBuilder13 = stringBuilder.append(n4);
        StringBuilder stringBuilder14 = stringBuilder.append("/");
        int n5 = this.keyboardHidden;
        StringBuilder stringBuilder15 = stringBuilder.append(n5);
        StringBuilder stringBuilder16 = stringBuilder.append("/");
        int n6 = this.hardKeyboardHidden;
        StringBuilder stringBuilder17 = stringBuilder.append(n6);
        StringBuilder stringBuilder18 = stringBuilder.append(" nav=");
        int n7 = this.navigation;
        StringBuilder stringBuilder19 = stringBuilder.append(n7);
        StringBuilder stringBuilder20 = stringBuilder.append("/");
        int n8 = this.navigationHidden;
        StringBuilder stringBuilder21 = stringBuilder.append(n8);
        StringBuilder stringBuilder22 = stringBuilder.append(" orien=");
        int n9 = this.orientation;
        StringBuilder stringBuilder23 = stringBuilder.append(n9);
        StringBuilder stringBuilder24 = stringBuilder.append(" layout=");
        int n10 = this.screenLayout;
        StringBuilder stringBuilder25 = stringBuilder.append(n10);
        StringBuilder stringBuilder26 = stringBuilder.append(" uiMode=");
        int n11 = this.uiMode;
        StringBuilder stringBuilder27 = stringBuilder.append(n11);
        if (this.seq != 0) {
            StringBuilder stringBuilder28 = stringBuilder.append(" seq=");
            int n12 = this.seq;
            StringBuilder stringBuilder29 = stringBuilder.append(n12);
        }
        StringBuilder stringBuilder30 = stringBuilder.append('}');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int updateFrom(Configuration configuration) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        Locale locale;
        Locale locale2;
        int n19;
        int n20;
        int n21;
        int n22;
        float f;
        float f2;
        int n23 = 0;
        if (configuration.fontScale > 0.0f && (f2 = this.fontScale) != (f = configuration.fontScale)) {
            float f3;
            n23 = 0 | 0x40000000;
            this.fontScale = f3 = configuration.fontScale;
        }
        if (configuration.mcc != 0 && (n22 = this.mcc) != (n21 = configuration.mcc)) {
            int n24;
            n23 |= 1;
            this.mcc = n24 = configuration.mcc;
        }
        if (configuration.mnc != 0 && (n20 = this.mnc) != (n19 = configuration.mnc)) {
            int n25;
            n23 |= 2;
            this.mnc = n25 = configuration.mnc;
        }
        if (!(configuration.locale == null || this.locale != null && (locale2 = this.locale).equals(locale = configuration.locale))) {
            n23 |= 4;
            Locale locale3 = configuration.locale != null ? (Locale)configuration.locale.clone() : null;
            this.locale = locale3;
        }
        if (configuration.userSetLocale && (!this.userSetLocale || (n23 & 4) != 0)) {
            this.userSetLocale = true;
            n23 |= 4;
        }
        if (configuration.touchscreen != 0 && (n18 = this.touchscreen) != (n17 = configuration.touchscreen)) {
            int n26;
            n23 |= 8;
            this.touchscreen = n26 = configuration.touchscreen;
        }
        if (configuration.keyboard != 0 && (n16 = this.keyboard) != (n15 = configuration.keyboard)) {
            int n27;
            n23 |= 0x10;
            this.keyboard = n27 = configuration.keyboard;
        }
        if (configuration.keyboardHidden != 0 && (n14 = this.keyboardHidden) != (n13 = configuration.keyboardHidden)) {
            int n28;
            n23 |= 0x20;
            this.keyboardHidden = n28 = configuration.keyboardHidden;
        }
        if (configuration.hardKeyboardHidden != 0 && (n12 = this.hardKeyboardHidden) != (n11 = configuration.hardKeyboardHidden)) {
            int n29;
            n23 |= 0x20;
            this.hardKeyboardHidden = n29 = configuration.hardKeyboardHidden;
        }
        if (configuration.navigation != 0 && (n10 = this.navigation) != (n9 = configuration.navigation)) {
            int n30;
            n23 |= 0x40;
            this.navigation = n30 = configuration.navigation;
        }
        if (configuration.navigationHidden != 0 && (n8 = this.navigationHidden) != (n7 = configuration.navigationHidden)) {
            int n31;
            n23 |= 0x20;
            this.navigationHidden = n31 = configuration.navigationHidden;
        }
        if (configuration.orientation != 0 && (n6 = this.orientation) != (n5 = configuration.orientation)) {
            int n32;
            n23 |= 0x80;
            this.orientation = n32 = configuration.orientation;
        }
        if (configuration.screenLayout != 0 && (n4 = this.screenLayout) != (n3 = configuration.screenLayout)) {
            int n33;
            n23 |= 0x100;
            this.screenLayout = n33 = configuration.screenLayout;
        }
        if (configuration.uiMode != 0 && (n2 = this.uiMode) != (n = configuration.uiMode)) {
            n23 |= 0x200;
            if ((configuration.uiMode & 0xF) != 0) {
                int n34;
                int n35 = this.uiMode & 0xFFFFFFF0;
                int n36 = configuration.uiMode & 0xF;
                this.uiMode = n34 = n35 | n36;
            }
            if ((configuration.uiMode & 0x30) != 0) {
                int n37;
                int n38 = this.uiMode & 0xFFFFFFCF;
                int n39 = configuration.uiMode & 0x30;
                this.uiMode = n37 = n38 | n39;
            }
        }
        if (configuration.seq != 0) {
            int n40;
            this.seq = n40 = configuration.seq;
        }
        return n23;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        float f = this.fontScale;
        parcel.writeFloat(f);
        int n2 = this.mcc;
        parcel.writeInt(n2);
        int n3 = this.mnc;
        parcel.writeInt(n3);
        if (this.locale == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(1);
            String string2 = this.locale.getLanguage();
            parcel.writeString(string2);
            String string3 = this.locale.getCountry();
            parcel.writeString(string3);
            String string4 = this.locale.getVariant();
            parcel.writeString(string4);
        }
        if (this.userSetLocale) {
            parcel.writeInt(1);
        } else {
            parcel.writeInt(0);
        }
        int n4 = this.touchscreen;
        parcel.writeInt(n4);
        int n5 = this.keyboard;
        parcel.writeInt(n5);
        int n6 = this.keyboardHidden;
        parcel.writeInt(n6);
        int n7 = this.hardKeyboardHidden;
        parcel.writeInt(n7);
        int n8 = this.navigation;
        parcel.writeInt(n8);
        int n9 = this.navigationHidden;
        parcel.writeInt(n9);
        int n10 = this.orientation;
        parcel.writeInt(n10);
        int n11 = this.screenLayout;
        parcel.writeInt(n11);
        int n12 = this.uiMode;
        parcel.writeInt(n12);
        int n13 = this.seq;
        parcel.writeInt(n13);
    }
}

