/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import java.util.Locale;

abstract class PluralRules {
    static final int ID_OTHER = 0x1000004;
    static final int QUANTITY_FEW = 8;
    static final int QUANTITY_MANY = 16;
    static final int QUANTITY_ONE = 2;
    static final int QUANTITY_OTHER = 0;
    static final int QUANTITY_TWO = 4;
    static final int QUANTITY_ZERO = 1;
    private static PluralRules cs;
    private static PluralRules en;

    PluralRules() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final int attrForQuantity(int n) {
        switch (n) {
            default: {
                return 0x1000004;
            }
            case 1: {
                return 0x1000005;
            }
            case 2: {
                return 0x1000006;
            }
            case 4: {
                return 0x1000007;
            }
            case 8: {
                return 0x1000008;
            }
            case 16: 
        }
        return 0x1000009;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final PluralRules ruleForLocale(Locale locale) {
        String string2 = locale.getLanguage();
        if ("cs".equals(string2)) {
            if (cs != null) return cs;
            cs = new cs();
            return cs;
        }
        if (en != null) return en;
        en = new en();
        return en;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final String stringForQuantity(int n) {
        switch (n) {
            default: {
                return "other";
            }
            case 1: {
                return "zero";
            }
            case 2: {
                return "one";
            }
            case 4: {
                return "two";
            }
            case 8: {
                return "few";
            }
            case 16: 
        }
        return "many";
    }

    final int attrForNumber(int n) {
        return PluralRules.attrForQuantity(this.quantityForNumber(n));
    }

    abstract int quantityForNumber(int var1);

    private static class en
    extends PluralRules {
        private en() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        int quantityForNumber(int n) {
            if (n != 1) return 0;
            return 2;
        }
    }

    private static class cs
    extends PluralRules {
        private cs() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        int quantityForNumber(int n) {
            if (n == 1) {
                return 2;
            }
            if (n < 2) return 0;
            if (n > 4) return 0;
            return 8;
        }
    }
}

