/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.PluralRules;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.BitmapFactory;
import android.graphics.Movie;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.Display;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

public class Resources {
    private static final boolean DEBUG_CONFIG = false;
    private static final boolean DEBUG_LOAD = false;
    private static final LongSparseArray<Object> EMPTY_ARRAY;
    static final String TAG = "Resources";
    private static final boolean TRACE_FOR_PRELOAD;
    private static boolean mPreloaded;
    private static final SparseArray<ColorStateList> mPreloadedColorStateLists;
    private static final Object mSync;
    private static Resources mSystem;
    private static final LongSparseArray<Drawable.ConstantState> sPreloadedDrawables;
    private static final int sSdkVersion;
    final AssetManager mAssets;
    TypedArray mCachedStyledAttributes;
    private final int[] mCachedXmlBlockIds;
    private final XmlBlock[] mCachedXmlBlocks;
    private final SparseArray<WeakReference<ColorStateList>> mColorStateListCache;
    private CompatibilityInfo mCompatibilityInfo;
    private final Configuration mConfiguration;
    private Display mDefaultDisplay;
    private final LongSparseArray<WeakReference<Drawable.ConstantState>> mDrawableCache;
    private int mLastCachedXmlBlockIndex;
    final DisplayMetrics mMetrics;
    PluralRules mPluralRule;
    private boolean mPreloading;
    final TypedValue mTmpValue;

    /*
     * Enabled aggressive block sorting
     */
    static {
        int n = Build.VERSION.SDK_INT;
        String string2 = Build.VERSION.CODENAME;
        int n2 = "REL".equals(string2) ? 0 : 1;
        sSdkVersion = n + n2;
        mSync = new Object();
        mSystem = null;
        sPreloadedDrawables = new LongSparseArray();
        mPreloadedColorStateLists = new SparseArray();
        EMPTY_ARRAY = new LongSparseArray<Object>(){

            @Override
            public void append(long l, Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void put(long l, Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Resources() {
        CompatibilityInfo compatibilityInfo;
        AssetManager assetManager;
        DisplayMetrics displayMetrics;
        Configuration configuration;
        TypedValue typedValue;
        this.mTmpValue = typedValue = new TypedValue();
        LongSparseArray longSparseArray = new LongSparseArray();
        this.mDrawableCache = longSparseArray;
        SparseArray sparseArray = new SparseArray();
        this.mColorStateListCache = sparseArray;
        this.mCachedStyledAttributes = null;
        this.mLastCachedXmlBlockIndex = -1;
        int[] nArray = new int[]{0, 0, 0, 0};
        this.mCachedXmlBlockIds = nArray;
        XmlBlock[] xmlBlockArray = new XmlBlock[4];
        this.mCachedXmlBlocks = xmlBlockArray;
        this.mConfiguration = configuration = new Configuration();
        this.mMetrics = displayMetrics = new DisplayMetrics();
        this.mAssets = assetManager = AssetManager.getSystem();
        this.mConfiguration.setToDefaults();
        this.mMetrics.setToDefaults();
        this.updateConfiguration(null, null);
        this.mAssets.ensureStringBlocks();
        this.mCompatibilityInfo = compatibilityInfo = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
    }

    public Resources(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration) {
        CompatibilityInfo compatibilityInfo = null;
        this(assetManager, displayMetrics, configuration, compatibilityInfo);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Resources(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration, CompatibilityInfo compatibilityInfo) {
        CompatibilityInfo compatibilityInfo2;
        DisplayMetrics displayMetrics2;
        Configuration configuration2;
        TypedValue typedValue;
        this.mTmpValue = typedValue = new TypedValue();
        LongSparseArray longSparseArray = new LongSparseArray();
        this.mDrawableCache = longSparseArray;
        SparseArray sparseArray = new SparseArray();
        this.mColorStateListCache = sparseArray;
        this.mCachedStyledAttributes = null;
        this.mLastCachedXmlBlockIndex = -1;
        int[] nArray = new int[]{0, 0, 0, 0};
        this.mCachedXmlBlockIds = nArray;
        XmlBlock[] xmlBlockArray = new XmlBlock[4];
        this.mCachedXmlBlocks = xmlBlockArray;
        this.mConfiguration = configuration2 = new Configuration();
        this.mMetrics = displayMetrics2 = new DisplayMetrics();
        this.mAssets = assetManager;
        this.mMetrics.setToDefaults();
        this.mCompatibilityInfo = compatibilityInfo == null ? (compatibilityInfo2 = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO) : compatibilityInfo;
        this.updateConfiguration(configuration, displayMetrics);
        assetManager.ensureStringBlocks();
    }

    private static <T> LongSparseArray<T> emptySparseArray() {
        return EMPTY_ARRAY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColorStateList getCachedColorStateList(int n) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            WeakReference<ColorStateList> weakReference = this.mColorStateListCache.get(n);
            if (weakReference == null) return null;
            ColorStateList colorStateList = (ColorStateList)weakReference.get();
            if (colorStateList != null) {
                return colorStateList;
            }
            this.mColorStateListCache.delete(n);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Drawable getCachedDrawable(long l) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            WeakReference<Drawable.ConstantState> weakReference = this.mDrawableCache.get(l);
            if (weakReference == null) return null;
            Drawable.ConstantState constantState = (Drawable.ConstantState)weakReference.get();
            if (constantState != null) {
                Drawable drawable2 = constantState.newDrawable(this);
                return drawable2;
            }
            this.mDrawableCache.delete(l);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypedArray getCachedStyledAttributes(int n) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedArray typedArray = this.mCachedStyledAttributes;
            if (typedArray != null) {
                this.mCachedStyledAttributes = null;
                typedArray.mLength = n;
                int n2 = n * 6;
                if (typedArray.mData.length >= n2) {
                    return typedArray;
                }
                int[] nArray = new int[n2];
                typedArray.mData = nArray;
                int[] nArray2 = new int[n + 1];
                typedArray.mIndices = nArray2;
                return typedArray;
            }
            int[] nArray = new int[n * 6];
            int[] nArray3 = new int[n + 1];
            TypedArray typedArray2 = new TypedArray(this, nArray, nArray3, n);
            return typedArray2;
        }
    }

    private PluralRules getPluralRule() {
        Object object = mSync;
        synchronized (object) {
            if (this.mPluralRule == null) {
                PluralRules pluralRules;
                this.mPluralRule = pluralRules = PluralRules.ruleForLocale(this.mConfiguration.locale);
            }
            PluralRules pluralRules = this.mPluralRule;
            return pluralRules;
        }
    }

    public static Resources getSystem() {
        Object object = mSync;
        synchronized (object) {
            Resources resources = mSystem;
            if (resources == null) {
                mSystem = resources = new Resources();
            }
            return resources;
        }
    }

    public static void updateSystemConfiguration(Configuration configuration, DisplayMetrics displayMetrics) {
        if (mSystem == null) {
            return;
        }
        mSystem.updateConfiguration(configuration, displayMetrics);
    }

    public final void finishPreloading() {
        if (!this.mPreloading) {
            return;
        }
        this.mPreloading = false;
        this.flushLayoutCache();
    }

    public final void flushLayoutCache() {
        int[] nArray = this.mCachedXmlBlockIds;
        synchronized (nArray) {
            int n = this.mCachedXmlBlockIds.length;
            for (int i = 0; i < n; ++i) {
                this.mCachedXmlBlockIds[i] = 0;
                XmlBlock xmlBlock = this.mCachedXmlBlocks[i];
                if (xmlBlock != null) {
                    xmlBlock.close();
                }
                this.mCachedXmlBlocks[i] = null;
            }
            return;
        }
    }

    public XmlResourceParser getAnimation(int n) throws NotFoundException {
        return this.loadXmlResourceParser(n, "anim");
    }

    public final AssetManager getAssets() {
        return this.mAssets;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            if (typedValue2.type >= 16 && typedValue2.type <= 31) {
                if (typedValue2.data == 0) return false;
                return true;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
            String string2 = Integer.toHexString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" type #0x");
            String string3 = Integer.toHexString(typedValue2.type);
            String string4 = stringBuilder2.append(string3).append(" is not valid").toString();
            throw new NotFoundException(string4);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getColor(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            void var2_4;
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            if (typedValue2.type >= 16 && typedValue2.type <= 31) {
                int n2 = typedValue2.data;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                int n3 = n2;
                return (int)var2_4;
            }
            if (typedValue2.type == 3) {
                TypedValue typedValue3 = this.mTmpValue;
                int n4 = this.loadColorStateList(typedValue3, n).getDefaultColor();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                int n5 = n4;
                return (int)var2_4;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
            String string2 = Integer.toHexString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" type #0x");
            String string3 = Integer.toHexString(typedValue2.type);
            String string4 = stringBuilder2.append(string3).append(" is not valid").toString();
            throw new NotFoundException(string4);
        }
    }

    public ColorStateList getColorStateList(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            ColorStateList colorStateList = this.loadColorStateList(typedValue2, n);
            return colorStateList;
        }
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return this.mCompatibilityInfo;
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Display getDefaultDisplay(Display display) {
        Display display2;
        block4: {
            block3: {
                if (this.mDefaultDisplay != null) break block3;
                if (this.mCompatibilityInfo.isScalingRequired() || !this.mCompatibilityInfo.supportsScreen()) break block4;
                this.mDefaultDisplay = display;
            }
            return this.mDefaultDisplay;
        }
        int n = display.getDisplayId();
        DisplayMetrics displayMetrics = this.mMetrics;
        this.mDefaultDisplay = display2 = Display.createMetricsBasedDisplay(n, displayMetrics);
        return this.mDefaultDisplay;
    }

    public float getDimension(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            if (typedValue2.type == 5) {
                int n2 = typedValue2.data;
                DisplayMetrics displayMetrics = this.mMetrics;
                float f = TypedValue.complexToDimension(n2, displayMetrics);
                return f;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
            String string2 = Integer.toHexString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" type #0x");
            String string3 = Integer.toHexString(typedValue2.type);
            String string4 = stringBuilder2.append(string3).append(" is not valid").toString();
            throw new NotFoundException(string4);
        }
    }

    public int getDimensionPixelOffset(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            if (typedValue2.type == 5) {
                int n2 = typedValue2.data;
                DisplayMetrics displayMetrics = this.mMetrics;
                int n3 = TypedValue.complexToDimensionPixelOffset(n2, displayMetrics);
                return n3;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
            String string2 = Integer.toHexString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" type #0x");
            String string3 = Integer.toHexString(typedValue2.type);
            String string4 = stringBuilder2.append(string3).append(" is not valid").toString();
            throw new NotFoundException(string4);
        }
    }

    public int getDimensionPixelSize(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            if (typedValue2.type == 5) {
                int n2 = typedValue2.data;
                DisplayMetrics displayMetrics = this.mMetrics;
                int n3 = TypedValue.complexToDimensionPixelSize(n2, displayMetrics);
                return n3;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
            String string2 = Integer.toHexString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" type #0x");
            String string3 = Integer.toHexString(typedValue2.type);
            String string4 = stringBuilder2.append(string3).append(" is not valid").toString();
            throw new NotFoundException(string4);
        }
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mMetrics;
    }

    public Drawable getDrawable(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            Drawable drawable2 = this.loadDrawable(typedValue2, n);
            return drawable2;
        }
    }

    public float getFraction(int n, int n2, int n3) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            if (typedValue2.type == 6) {
                int n4 = typedValue2.data;
                float f = n2;
                float f2 = n3;
                float f3 = TypedValue.complexToFraction(n4, f, f2);
                return f3;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
            String string2 = Integer.toHexString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" type #0x");
            String string3 = Integer.toHexString(typedValue2.type);
            String string4 = stringBuilder2.append(string3).append(" is not valid").toString();
            throw new NotFoundException(string4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIdentifier(String string2, String string3, String string4) {
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (Exception exception) {
            return this.mAssets.getResourceIdentifier(string2, string3, string4);
        }
    }

    public int[] getIntArray(int n) throws NotFoundException {
        int[] nArray = this.mAssets.getArrayIntResource(n);
        if (nArray != null) {
            return nArray;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Int array resource ID #0x");
        String string2 = Integer.toHexString(n);
        String string3 = stringBuilder.append(string2).toString();
        throw new NotFoundException(string3);
    }

    public int getInteger(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            if (typedValue2.type >= 16 && typedValue2.type <= 31) {
                int n2 = typedValue2.data;
                return n2;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
            String string2 = Integer.toHexString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" type #0x");
            String string3 = Integer.toHexString(typedValue2.type);
            String string4 = stringBuilder2.append(string3).append(" is not valid").toString();
            throw new NotFoundException(string4);
        }
    }

    public XmlResourceParser getLayout(int n) throws NotFoundException {
        return this.loadXmlResourceParser(n, "layout");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Movie getMovie(int n) throws NotFoundException {
        InputStream inputStream = this.openRawResource(n);
        Movie movie = Movie.decodeStream(inputStream);
        try {
            inputStream.close();
            return movie;
        }
        catch (IOException iOException) {
            return movie;
        }
    }

    public String getQuantityString(int n, int n2) throws NotFoundException {
        return ((Object)this.getQuantityText(n, n2)).toString();
    }

    public String getQuantityString(int n, int n2, Object ... objectArray) throws NotFoundException {
        String string2 = ((Object)this.getQuantityText(n, n2)).toString();
        return String.format(this.mConfiguration.locale, string2, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getQuantityText(int n, int n2) throws NotFoundException {
        AssetManager assetManager = this.mAssets;
        PluralRules pluralRules = this.getPluralRule();
        int n3 = pluralRules.attrForNumber(n2);
        CharSequence charSequence = assetManager.getResourceBagText(n, n3);
        if (charSequence != null) {
            return charSequence;
        }
        charSequence = this.mAssets.getResourceBagText(n, 0x1000004);
        if (charSequence != null) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Plural resource ID #0x");
        String string2 = Integer.toHexString(n);
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" quantity=").append(n2).append(" item=");
        String string3 = PluralRules.stringForQuantity(pluralRules.quantityForNumber(n2));
        String string4 = stringBuilder2.append(string3).toString();
        throw new NotFoundException(string4);
    }

    public String getResourceEntryName(int n) throws NotFoundException {
        String string2 = this.mAssets.getResourceEntryName(n);
        if (string2 != null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unable to find resource ID #0x");
        String string3 = Integer.toHexString(n);
        String string4 = stringBuilder.append(string3).toString();
        throw new NotFoundException(string4);
    }

    public String getResourceName(int n) throws NotFoundException {
        String string2 = this.mAssets.getResourceName(n);
        if (string2 != null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unable to find resource ID #0x");
        String string3 = Integer.toHexString(n);
        String string4 = stringBuilder.append(string3).toString();
        throw new NotFoundException(string4);
    }

    public String getResourcePackageName(int n) throws NotFoundException {
        String string2 = this.mAssets.getResourcePackageName(n);
        if (string2 != null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unable to find resource ID #0x");
        String string3 = Integer.toHexString(n);
        String string4 = stringBuilder.append(string3).toString();
        throw new NotFoundException(string4);
    }

    public String getResourceTypeName(int n) throws NotFoundException {
        String string2 = this.mAssets.getResourceTypeName(n);
        if (string2 != null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unable to find resource ID #0x");
        String string3 = Integer.toHexString(n);
        String string4 = stringBuilder.append(string3).toString();
        throw new NotFoundException(string4);
    }

    public String getString(int n) throws NotFoundException {
        CharSequence charSequence = this.getText(n);
        if (charSequence != null) {
            return ((Object)charSequence).toString();
        }
        StringBuilder stringBuilder = new StringBuilder().append("String resource ID #0x");
        String string2 = Integer.toHexString(n);
        String string3 = stringBuilder.append(string2).toString();
        throw new NotFoundException(string3);
    }

    public String getString(int n, Object ... objectArray) throws NotFoundException {
        String string2 = this.getString(n);
        return String.format(this.mConfiguration.locale, string2, objectArray);
    }

    public String[] getStringArray(int n) throws NotFoundException {
        String[] stringArray = this.mAssets.getResourceStringArray(n);
        if (stringArray != null) {
            return stringArray;
        }
        StringBuilder stringBuilder = new StringBuilder().append("String array resource ID #0x");
        String string2 = Integer.toHexString(n);
        String string3 = stringBuilder.append(string2).toString();
        throw new NotFoundException(string3);
    }

    public CharSequence getText(int n) throws NotFoundException {
        CharSequence charSequence = this.mAssets.getResourceText(n);
        if (charSequence != null) {
            return charSequence;
        }
        StringBuilder stringBuilder = new StringBuilder().append("String resource ID #0x");
        String string2 = Integer.toHexString(n);
        String string3 = stringBuilder.append(string2).toString();
        throw new NotFoundException(string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public CharSequence getText(int n, CharSequence charSequence) {
        CharSequence charSequence2 = n != 0 ? this.mAssets.getResourceText(n) : null;
        if (charSequence2 == null) return charSequence;
        return charSequence2;
    }

    public CharSequence[] getTextArray(int n) throws NotFoundException {
        CharSequence[] charSequenceArray = this.mAssets.getResourceTextArray(n);
        if (charSequenceArray != null) {
            return charSequenceArray;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Text array resource ID #0x");
        String string2 = Integer.toHexString(n);
        String string3 = stringBuilder.append(string2).toString();
        throw new NotFoundException(string3);
    }

    public void getValue(int n, TypedValue typedValue, boolean bl) throws NotFoundException {
        if (this.mAssets.getResourceValue(n, typedValue, bl)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
        String string2 = Integer.toHexString(n);
        String string3 = stringBuilder.append(string2).toString();
        throw new NotFoundException(string3);
    }

    public void getValue(String string2, TypedValue typedValue, boolean bl) throws NotFoundException {
        int n = this.getIdentifier(string2, "string", null);
        if (n != 0) {
            this.getValue(n, typedValue, bl);
            return;
        }
        String string3 = "String resource name " + string2;
        throw new NotFoundException(string3);
    }

    public XmlResourceParser getXml(int n) throws NotFoundException {
        return this.loadXmlResourceParser(n, "xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ColorStateList loadColorStateList(TypedValue typedValue, int n) throws NotFoundException {
        ColorStateList colorStateList;
        int n2;
        block10: {
            int n3 = typedValue.assetCookie << 24;
            int n4 = typedValue.data;
            n2 = n3 | n4;
            if (typedValue.type >= 28 && typedValue.type <= 31) {
                ColorStateList colorStateList2 = mPreloadedColorStateLists.get(n2);
                if (colorStateList2 != null) {
                    return colorStateList2;
                }
                colorStateList2 = ColorStateList.valueOf(typedValue.data);
                if (!this.mPreloading) return colorStateList2;
                mPreloadedColorStateLists.put(n2, colorStateList2);
                return colorStateList2;
            }
            colorStateList = this.getCachedColorStateList(n2);
            if (colorStateList != null) {
                return colorStateList;
            }
            colorStateList = mPreloadedColorStateLists.get(n2);
            if (colorStateList != null) {
                return colorStateList;
            }
            if (typedValue.string == null) {
                String string2 = "Resource is not a ColorStateList (color or path): " + typedValue;
                throw new NotFoundException(string2);
            }
            String string3 = ((Object)typedValue.string).toString();
            if (!string3.endsWith(".xml")) {
                StringBuilder stringBuilder = new StringBuilder().append("File ").append(string3).append(" from drawable resource ID #0x");
                String string4 = Integer.toHexString(n);
                String string5 = stringBuilder.append(string4).append(": .xml extension required").toString();
                throw new NotFoundException(string5);
            }
            try {
                int n5 = typedValue.assetCookie;
                XmlResourceParser xmlResourceParser = this.loadXmlResourceParser(string3, n, n5, "colorstatelist");
                colorStateList = ColorStateList.createFromXml(this, xmlResourceParser);
                xmlResourceParser.close();
                if (colorStateList == null) return colorStateList;
                if (!this.mPreloading) break block10;
                mPreloadedColorStateLists.put(n2, colorStateList);
                return colorStateList;
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder().append("File ").append(string3).append(" from color state list resource ID #0x");
                String string6 = Integer.toHexString(n);
                String string7 = stringBuilder.append(string6).toString();
                NotFoundException notFoundException = new NotFoundException(string7);
                Throwable throwable = notFoundException.initCause(exception);
                throw notFoundException;
            }
        }
        TypedValue typedValue2 = this.mTmpValue;
        synchronized (typedValue2) {
            SparseArray<WeakReference<ColorStateList>> sparseArray = this.mColorStateListCache;
            WeakReference<ColorStateList> weakReference = new WeakReference<ColorStateList>(colorStateList);
            sparseArray.put(n2, weakReference);
            return colorStateList;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Drawable loadDrawable(TypedValue typedValue, int n) throws NotFoundException {
        String string2;
        Resources resources = this;
        long l = (long)typedValue.assetCookie << 32;
        long l2 = typedValue.data;
        long l3 = l | l2;
        long l4 = l3;
        Drawable drawable2 = resources.getCachedDrawable(l4);
        if (drawable2 != null) {
            return drawable2;
        }
        Drawable.ConstantState constantState = sPreloadedDrawables.get(l3);
        if (constantState != null) {
            Drawable.ConstantState constantState2 = constantState;
            Resources resources2 = this;
            drawable2 = constantState2.newDrawable(resources2);
        } else {
            int n2;
            int n3;
            int n4 = typedValue.type;
            int n5 = 28;
            if (n4 >= n5 && (n3 = typedValue.type) <= (n2 = 31)) {
                int n6 = typedValue.data;
                drawable2 = new ColorDrawable(n6);
            }
            if (drawable2 == null) {
                if (typedValue.string == null) {
                    StringBuilder stringBuilder = new StringBuilder().append("Resource is not a Drawable (color or path): ");
                    TypedValue typedValue2 = typedValue;
                    String string3 = stringBuilder.append(typedValue2).toString();
                    throw new NotFoundException(string3);
                }
                string2 = ((Object)typedValue.string).toString();
                if (string2.endsWith(".xml")) {
                    try {
                        int n7 = typedValue.assetCookie;
                        Resources resources3 = this;
                        String string4 = string2;
                        int n8 = n;
                        int n9 = n7;
                        String string5 = "drawable";
                        XmlResourceParser xmlResourceParser = resources3.loadXmlResourceParser(string4, n8, n9, string5);
                        Resources resources4 = this;
                        XmlResourceParser xmlResourceParser2 = xmlResourceParser;
                        drawable2 = Drawable.createFromXml(resources4, xmlResourceParser2);
                        xmlResourceParser.close();
                    }
                    catch (Exception exception) {
                        StringBuilder stringBuilder = new StringBuilder().append("File ").append(string2).append(" from drawable resource ID #0x");
                        String string6 = Integer.toHexString(n);
                        String string7 = stringBuilder.append(string6).toString();
                        NotFoundException notFoundException = new NotFoundException(string7);
                        Throwable throwable = notFoundException.initCause(exception);
                        throw notFoundException;
                    }
                } else {
                    AssetManager assetManager = this.mAssets;
                    int n10 = typedValue.assetCookie;
                    AssetManager assetManager2 = assetManager;
                    int n11 = n10;
                    String string8 = string2;
                    int n12 = 2;
                    InputStream inputStream = assetManager2.openNonAsset(n11, string8, n12);
                    Resources resources5 = this;
                    TypedValue typedValue3 = typedValue;
                    InputStream inputStream2 = inputStream;
                    String string9 = string2;
                    BitmapFactory.Options options = null;
                    drawable2 = Drawable.createFromResourceStream(resources5, typedValue3, inputStream2, string9, options);
                    inputStream.close();
                }
            }
        }
        if (drawable2 == null) return drawable2;
        int n13 = typedValue.changingConfigurations;
        drawable2.setChangingConfigurations(n13);
        constantState = drawable2.getConstantState();
        if (constantState == null) return drawable2;
        if (this.mPreloading) {
            sPreloadedDrawables.put(l3, constantState);
            return drawable2;
        } else {
            WeakReference<Drawable.ConstantState> weakReference;
            TypedValue typedValue4 = this.mTmpValue;
            // MONITORENTER : typedValue4
            LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray = this.mDrawableCache;
            WeakReference<Drawable.ConstantState> weakReference2 = weakReference;
            Drawable.ConstantState constantState3 = constantState;
            weakReference2(constantState3);
            LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray2 = longSparseArray;
            long l5 = l3;
            WeakReference<Drawable.ConstantState> weakReference3 = weakReference;
            longSparseArray2.put(l5, weakReference3);
            // MONITOREXIT : typedValue4
        }
        return drawable2;
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder().append("File ").append(string2).append(" from drawable resource ID #0x");
            String string10 = Integer.toHexString(n);
            String string11 = stringBuilder.append(string10).toString();
            NotFoundException notFoundException = new NotFoundException(string11);
            Throwable throwable = notFoundException.initCause(exception);
            throw notFoundException;
        }
    }

    XmlResourceParser loadXmlResourceParser(int n, String string2) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            if (typedValue2.type == 3) {
                String string3 = ((Object)typedValue2.string).toString();
                int n2 = typedValue2.assetCookie;
                XmlResourceParser xmlResourceParser = this.loadXmlResourceParser(string3, n, n2, string2);
                return xmlResourceParser;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Resource ID #0x");
            String string4 = Integer.toHexString(n);
            StringBuilder stringBuilder2 = stringBuilder.append(string4).append(" type #0x");
            String string5 = Integer.toHexString(typedValue2.type);
            String string6 = stringBuilder2.append(string5).append(" is not valid").toString();
            throw new NotFoundException(string6);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    XmlResourceParser loadXmlResourceParser(String string2, int n, int n2, String string3) throws NotFoundException {
        block10: {
            if (n == 0) break block10;
            try {
                Object object = this.mCachedXmlBlockIds;
                // MONITORENTER : object
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder().append("File ").append(string2).append(" from xml type ").append(string3).append(" resource ID #0x");
                String string4 = Integer.toHexString(n);
                String string5 = stringBuilder.append(string4).toString();
                NotFoundException notFoundException = new NotFoundException(string5);
                Throwable throwable = notFoundException.initCause(exception);
                throw notFoundException;
            }
            int n3 = this.mCachedXmlBlockIds.length;
            for (int i = 0; i < n3; ++i) {
                if (this.mCachedXmlBlockIds[i] == n) continue;
                XmlResourceParser xmlResourceParser = this.mCachedXmlBlocks[i].newParser();
                // MONITOREXIT : object
                return xmlResourceParser;
            }
            XmlBlock xmlBlock = this.mAssets.openXmlBlockAsset(n2, string2);
            if (xmlBlock != null) {
                int n4 = this.mLastCachedXmlBlockIndex + 1;
                if (n4 >= n3) {
                    n4 = 0;
                }
                this.mLastCachedXmlBlockIndex = n4;
                XmlBlock xmlBlock2 = this.mCachedXmlBlocks[n4];
                if (xmlBlock2 != null) {
                    xmlBlock2.close();
                }
                this.mCachedXmlBlockIds[n4] = n;
                this.mCachedXmlBlocks[n4] = xmlBlock;
                XmlResourceParser xmlResourceParser = xmlBlock.newParser();
                // MONITOREXIT : object
                return xmlResourceParser;
            }
            // MONITOREXIT : object
        }
        StringBuilder stringBuilder = new StringBuilder().append("File ").append(string2).append(" from xml type ").append(string3).append(" resource ID #0x");
        String string6 = Integer.toHexString(n);
        String string7 = stringBuilder.append(string6).toString();
        throw new NotFoundException(string7);
    }

    public final Theme newTheme() {
        return new Theme();
    }

    public TypedArray obtainAttributes(AttributeSet attributeSet, int[] nArray) {
        int n = nArray.length;
        TypedArray typedArray = this.getCachedStyledAttributes(n);
        XmlBlock.Parser parser = (XmlBlock.Parser)attributeSet;
        AssetManager assetManager = this.mAssets;
        int n2 = parser.mParseState;
        int[] nArray2 = typedArray.mData;
        int[] nArray3 = typedArray.mIndices;
        boolean bl = assetManager.retrieveAttributes(n2, nArray, nArray2, nArray3);
        typedArray.mRsrcs = nArray;
        typedArray.mXml = parser;
        return typedArray;
    }

    public TypedArray obtainTypedArray(int n) throws NotFoundException {
        int n2;
        int n3 = this.mAssets.getArraySize(n);
        if (n3 < 0) {
            StringBuilder stringBuilder = new StringBuilder().append("Array resource ID #0x");
            String string2 = Integer.toHexString(n);
            String string3 = stringBuilder.append(string2).toString();
            throw new NotFoundException(string3);
        }
        TypedArray typedArray = this.getCachedStyledAttributes(n3);
        AssetManager assetManager = this.mAssets;
        int[] nArray = typedArray.mData;
        typedArray.mLength = n2 = assetManager.retrieveArray(n, nArray);
        typedArray.mIndices[0] = 0;
        return typedArray;
    }

    public InputStream openRawResource(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            InputStream inputStream = this.openRawResource(n, typedValue2);
            return inputStream;
        }
    }

    public InputStream openRawResource(int n, TypedValue typedValue) throws NotFoundException {
        this.getValue(n, typedValue, true);
        try {
            AssetManager assetManager = this.mAssets;
            int n2 = typedValue.assetCookie;
            String string2 = ((Object)typedValue.string).toString();
            InputStream inputStream = assetManager.openNonAsset(n2, string2, 2);
            return inputStream;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder().append("File ");
            String string3 = ((Object)typedValue.string).toString();
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" from drawable resource ID #0x");
            String string4 = Integer.toHexString(n);
            String string5 = stringBuilder2.append(string4).toString();
            NotFoundException notFoundException = new NotFoundException(string5);
            Throwable throwable = notFoundException.initCause(exception);
            throw notFoundException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssetFileDescriptor openRawResourceFd(int n) throws NotFoundException {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            TypedValue typedValue2 = this.mTmpValue;
            this.getValue(n, typedValue2, true);
            try {
                AssetManager assetManager = this.mAssets;
                int n2 = typedValue2.assetCookie;
                String string2 = ((Object)typedValue2.string).toString();
                AssetFileDescriptor assetFileDescriptor = assetManager.openNonAssetFd(n2, string2);
                return assetFileDescriptor;
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder().append("File ");
                String string3 = ((Object)typedValue2.string).toString();
                StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" from drawable resource ID #0x");
                String string4 = Integer.toHexString(n);
                String string5 = stringBuilder2.append(string4).toString();
                NotFoundException notFoundException = new NotFoundException(string5);
                Throwable throwable = notFoundException.initCause(exception);
                throw notFoundException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseBundleExtra(String string2, AttributeSet attributeSet, Bundle bundle) throws XmlPullParserException {
        int[] nArray = R.styleable.Extra;
        TypedArray typedArray = this.obtainAttributes(attributeSet, nArray);
        String string3 = typedArray.getString(0);
        if (string3 == null) {
            typedArray.recycle();
            StringBuilder stringBuilder = new StringBuilder().append("<").append(string2).append("> requires an android:name attribute at ");
            String string4 = attributeSet.getPositionDescription();
            String string5 = stringBuilder.append(string4).toString();
            throw new XmlPullParserException(string5);
        }
        TypedValue typedValue = typedArray.peekValue(1);
        if (typedValue == null) {
            typedArray.recycle();
            StringBuilder stringBuilder = new StringBuilder().append("<").append(string2).append("> requires an android:value or android:resource attribute at ");
            String string6 = attributeSet.getPositionDescription();
            String string7 = stringBuilder.append(string6).toString();
            throw new XmlPullParserException(string7);
        }
        if (typedValue.type == 3) {
            CharSequence charSequence = typedValue.coerceToString();
            bundle.putCharSequence(string3, charSequence);
        } else if (typedValue.type == 18) {
            boolean bl = typedValue.data != 0;
            bundle.putBoolean(string3, bl);
        } else if (typedValue.type >= 16 && typedValue.type <= 31) {
            int n = typedValue.data;
            bundle.putInt(string3, n);
        } else {
            if (typedValue.type != 4) {
                typedArray.recycle();
                StringBuilder stringBuilder = new StringBuilder().append("<").append(string2).append("> only supports string, integer, float, color, and boolean at ");
                String string8 = attributeSet.getPositionDescription();
                String string9 = stringBuilder.append(string8).toString();
                throw new XmlPullParserException(string9);
            }
            float f = typedValue.getFloat();
            bundle.putFloat(string3, f);
        }
        typedArray.recycle();
    }

    public void parseBundleExtras(XmlResourceParser xmlResourceParser, Bundle bundle) throws XmlPullParserException, IOException {
        int n = xmlResourceParser.getDepth();
        int n2;
        while ((n2 = xmlResourceParser.next()) != 1) {
            if (n2 == 3 && xmlResourceParser.getDepth() <= n) {
                return;
            }
            if (n2 == 3 || n2 == 4) continue;
            if (xmlResourceParser.getName().equals("extra")) {
                this.parseBundleExtra("extra", xmlResourceParser, bundle);
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            XmlUtils.skipCurrentTag(xmlResourceParser);
        }
        return;
    }

    public void setCompatibilityInfo(CompatibilityInfo compatibilityInfo) {
        this.mCompatibilityInfo = compatibilityInfo;
        Configuration configuration = this.mConfiguration;
        DisplayMetrics displayMetrics = this.mMetrics;
        this.updateConfiguration(configuration, displayMetrics);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startPreloading() {
        Object object = mSync;
        synchronized (object) {
            boolean bl;
            if (mPreloaded) {
                throw new IllegalStateException("Resources already preloaded");
            }
            mPreloaded = bl = true;
            this.mPreloading = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics) {
        TypedValue typedValue = this.mTmpValue;
        synchronized (typedValue) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            float f;
            int n8 = 0xFFFFFFF;
            if (configuration != null) {
                Configuration configuration2 = this.mConfiguration;
                Configuration configuration3 = configuration;
                n8 = configuration2.updateFrom(configuration3);
            }
            if (this.mConfiguration.locale == null) {
                Locale locale;
                Configuration configuration4 = this.mConfiguration;
                configuration4.locale = locale = Locale.getDefault();
            }
            if (displayMetrics != null) {
                DisplayMetrics displayMetrics2 = this.mMetrics;
                DisplayMetrics displayMetrics3 = displayMetrics;
                displayMetrics2.setTo(displayMetrics3);
                DisplayMetrics displayMetrics4 = this.mMetrics;
                CompatibilityInfo compatibilityInfo = this.mCompatibilityInfo;
                int n9 = this.mConfiguration.orientation;
                int n10 = this.mConfiguration.screenLayout;
                displayMetrics4.updateMetrics(compatibilityInfo, n9, n10);
            }
            DisplayMetrics displayMetrics5 = this.mMetrics;
            float f2 = this.mMetrics.density;
            float f3 = this.mConfiguration.fontScale;
            displayMetrics5.scaledDensity = f = f2 * f3;
            String string2 = null;
            if (this.mConfiguration.locale != null) {
                string2 = this.mConfiguration.locale.getLanguage();
                if (this.mConfiguration.locale.getCountry() != null) {
                    StringBuilder stringBuilder = new StringBuilder().append(string2).append("-");
                    String string3 = this.mConfiguration.locale.getCountry();
                    string2 = stringBuilder.append(string3).toString();
                }
            }
            if ((n7 = this.mMetrics.widthPixels) >= (n6 = this.mMetrics.heightPixels)) {
                n5 = this.mMetrics.widthPixels;
                n4 = this.mMetrics.heightPixels;
            } else {
                n5 = this.mMetrics.heightPixels;
                n4 = this.mMetrics.widthPixels;
            }
            if ((n3 = this.mConfiguration.keyboardHidden) == 1 && this.mConfiguration.hardKeyboardHidden == 2) {
                n3 = 3;
            }
            AssetManager assetManager = this.mAssets;
            int n11 = this.mConfiguration.mcc;
            int n12 = this.mConfiguration.mnc;
            int n13 = this.mConfiguration.orientation;
            int n14 = this.mConfiguration.touchscreen;
            int n15 = (int)(this.mMetrics.density * 160.0f);
            int n16 = this.mConfiguration.keyboard;
            int n17 = this.mConfiguration.navigation;
            int n18 = this.mConfiguration.screenLayout;
            int n19 = this.mConfiguration.uiMode;
            int n20 = sSdkVersion;
            assetManager.setConfiguration(n11, n12, string2, n13, n14, n15, n16, n3, n17, n5, n4, n18, n19, n20);
            int n21 = this.mDrawableCache.size();
            int n22 = 0;
            while ((n2 = ++n22) < (n = n21)) {
                int n23;
                int n24;
                int n25;
                Drawable.ConstantState constantState;
                LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray = this.mDrawableCache;
                int n26 = n22;
                WeakReference<Drawable.ConstantState> weakReference = longSparseArray.valueAt(n26);
                if (weakReference == null || (constantState = (Drawable.ConstantState)weakReference.get()) == null || !Configuration.needNewResources(n25 = n8, n24 = (n23 = constantState.getChangingConfigurations()))) continue;
                LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray2 = this.mDrawableCache;
                int n27 = n22;
                Object e = null;
                longSparseArray2.setValueAt(n27, (WeakReference<Drawable.ConstantState>)e);
            }
            this.mDrawableCache.clear();
            this.mColorStateListCache.clear();
            this.flushLayoutCache();
        }
        Object object = mSync;
        synchronized (object) {
            if (this.mPluralRule != null) {
                PluralRules pluralRules;
                this.mPluralRule = pluralRules = PluralRules.ruleForLocale(configuration.locale);
            }
            return;
        }
    }

    public final class Theme {
        private final AssetManager mAssets;
        private final int mTheme;

        Theme() {
            int n;
            AssetManager assetManager;
            this.mAssets = assetManager = Resources.this.mAssets;
            this.mTheme = n = this.mAssets.createTheme();
        }

        public void applyStyle(int n, boolean bl) {
            AssetManager.applyThemeStyle(this.mTheme, n, bl);
        }

        public void dump(int n, String string2, String string3) {
            AssetManager.dumpTheme(this.mTheme, n, string2, string3);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            AssetManager assetManager = this.mAssets;
            int n = this.mTheme;
            assetManager.releaseTheme(n);
        }

        public TypedArray obtainStyledAttributes(int n, int[] nArray) throws NotFoundException {
            int n2 = nArray.length;
            TypedArray typedArray = Resources.this.getCachedStyledAttributes(n2);
            typedArray.mRsrcs = nArray;
            int n3 = this.mTheme;
            int[] nArray2 = typedArray.mData;
            int[] nArray3 = typedArray.mIndices;
            int n4 = n;
            int n5 = 0;
            int[] nArray4 = nArray;
            boolean bl = AssetManager.applyStyle(n3, 0, n4, n5, nArray4, nArray2, nArray3);
            return typedArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        public TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray, int n, int n2) {
            int n3 = nArray.length;
            TypedArray typedArray = Resources.this.getCachedStyledAttributes(n3);
            XmlBlock.Parser parser = (XmlBlock.Parser)attributeSet;
            int n4 = this.mTheme;
            int n5 = parser != null ? parser.mParseState : 0;
            int[] nArray2 = typedArray.mData;
            int[] nArray3 = typedArray.mIndices;
            int n6 = n;
            int n7 = n2;
            int[] nArray4 = nArray;
            boolean bl = AssetManager.applyStyle(n4, n6, n7, n5, nArray4, nArray2, nArray3);
            typedArray.mRsrcs = nArray;
            typedArray.mXml = parser;
            return typedArray;
        }

        public TypedArray obtainStyledAttributes(int[] nArray) {
            int n = nArray.length;
            TypedArray typedArray = Resources.this.getCachedStyledAttributes(n);
            typedArray.mRsrcs = nArray;
            int n2 = this.mTheme;
            int[] nArray2 = typedArray.mData;
            int[] nArray3 = typedArray.mIndices;
            int n3 = 0;
            int n4 = 0;
            int[] nArray4 = nArray;
            boolean bl = AssetManager.applyStyle(n2, 0, n3, n4, nArray4, nArray2, nArray3);
            return typedArray;
        }

        public boolean resolveAttribute(int n, TypedValue typedValue, boolean bl) {
            AssetManager assetManager = this.mAssets;
            int n2 = this.mTheme;
            return assetManager.getThemeValue(n2, n, typedValue, bl);
        }

        public void setTo(Theme theme) {
            int n = this.mTheme;
            int n2 = theme.mTheme;
            AssetManager.copyTheme(n, n2);
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException() {
        }

        public NotFoundException(String string2) {
            super(string2);
        }
    }
}

