/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlBlock;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import java.util.Arrays;

public class TypedArray {
    int[] mData;
    int[] mIndices;
    int mLength;
    private final Resources mResources;
    int[] mRsrcs;
    private TypedValue mValue;
    XmlBlock.Parser mXml;

    TypedArray(Resources resources, int[] nArray, int[] nArray2, int n) {
        TypedValue typedValue;
        this.mValue = typedValue = new TypedValue();
        this.mResources = resources;
        this.mData = nArray;
        this.mIndices = nArray2;
        this.mLength = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean getValueAt(int n, TypedValue typedValue) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = this.mData;
        int n7 = n + 0;
        int n8 = nArray[n7];
        if (n8 == 0) {
            return false;
        }
        typedValue.type = n8;
        int n9 = n + 1;
        typedValue.data = n6 = nArray[n9];
        int n10 = n + 2;
        typedValue.assetCookie = n5 = nArray[n10];
        int n11 = n + 3;
        typedValue.resourceId = n4 = nArray[n11];
        int n12 = n + 4;
        typedValue.changingConfigurations = n3 = nArray[n12];
        int n13 = n + 5;
        typedValue.density = n2 = nArray[n13];
        CharSequence charSequence = n8 == 3 ? this.loadStringValueAt(n) : null;
        typedValue.string = charSequence;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence loadStringValueAt(int n) {
        int[] nArray = this.mData;
        int n2 = n + 2;
        int n3 = nArray[n2];
        if (n3 < 0) {
            if (this.mXml == null) return null;
            XmlBlock.Parser parser = this.mXml;
            int n4 = n + 1;
            int n5 = nArray[n4];
            return parser.getPooledString(n5);
        }
        AssetManager assetManager = this.mResources.mAssets;
        int n6 = n + 1;
        int n7 = nArray[n6];
        return assetManager.getPooledString(n3, n7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(int n, boolean bl) {
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = n2 + 0;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return bl;
        }
        if (n4 >= 16 && n4 <= 31) {
            int n5 = n2 + 1;
            if (nArray[n5] == 0) return false;
            return true;
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n2, typedValue)) {
            String string2 = "Converting to boolean: " + typedValue;
            int n6 = Log.w("Resources", string2);
            return XmlUtils.convertValueToBoolean(typedValue.coerceToString(), bl);
        }
        StringBuilder stringBuilder = new StringBuilder().append("getBoolean of bad type: 0x");
        String string3 = Integer.toHexString(n4);
        String string4 = stringBuilder.append(string3).toString();
        int n7 = Log.w("Resources", string4);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getColor(int n, int n2) {
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = n3 + 0;
        int n5 = nArray[n4];
        if (n5 == 0) {
            return n2;
        }
        if (n5 >= 16 && n5 <= 31) {
            int n6 = n3 + 1;
            return nArray[n6];
        }
        if (n5 == 3) {
            TypedValue typedValue = this.mValue;
            if (!this.getValueAt(n3, typedValue)) return n2;
            Resources resources = this.mResources;
            int n7 = typedValue.resourceId;
            return resources.loadColorStateList(typedValue, n7).getDefaultColor();
        }
        StringBuilder stringBuilder = new StringBuilder().append("Can't convert to color: type=0x");
        String string2 = Integer.toHexString(n5);
        String string3 = stringBuilder.append(string2).toString();
        throw new UnsupportedOperationException(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ColorStateList getColorStateList(int n) {
        int n2 = n * 6;
        TypedValue typedValue = this.mValue;
        if (!this.getValueAt(n2, typedValue)) return null;
        Resources resources = this.mResources;
        int n3 = typedValue.resourceId;
        return resources.loadColorStateList(typedValue, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getDimension(int n, float f) {
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = n2 + 0;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return f;
        }
        if (n4 == 5) {
            int n5 = n2 + 1;
            int n6 = nArray[n5];
            DisplayMetrics displayMetrics = this.mResources.mMetrics;
            return TypedValue.complexToDimension(n6, displayMetrics);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Can't convert to dimension: type=0x");
        String string2 = Integer.toHexString(n4);
        String string3 = stringBuilder.append(string2).toString();
        throw new UnsupportedOperationException(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDimensionPixelOffset(int n, int n2) {
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = n3 + 0;
        int n5 = nArray[n4];
        if (n5 == 0) {
            return n2;
        }
        if (n5 == 5) {
            int n6 = n3 + 1;
            int n7 = nArray[n6];
            DisplayMetrics displayMetrics = this.mResources.mMetrics;
            return TypedValue.complexToDimensionPixelOffset(n7, displayMetrics);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Can't convert to dimension: type=0x");
        String string2 = Integer.toHexString(n5);
        String string3 = stringBuilder.append(string2).toString();
        throw new UnsupportedOperationException(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDimensionPixelSize(int n, int n2) {
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = n3 + 0;
        int n5 = nArray[n4];
        if (n5 == 0) {
            return n2;
        }
        if (n5 == 5) {
            int n6 = n3 + 1;
            int n7 = nArray[n6];
            DisplayMetrics displayMetrics = this.mResources.mMetrics;
            return TypedValue.complexToDimensionPixelSize(n7, displayMetrics);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Can't convert to dimension: type=0x");
        String string2 = Integer.toHexString(n5);
        String string3 = stringBuilder.append(string2).toString();
        throw new UnsupportedOperationException(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getDrawable(int n) {
        int n2 = n * 6;
        TypedValue typedValue = this.mValue;
        if (!this.getValueAt(n2, typedValue)) return null;
        Resources resources = this.mResources;
        int n3 = typedValue.resourceId;
        return resources.loadDrawable(typedValue, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloat(int n, float f) {
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = n2 + 0;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return f;
        }
        if (n4 == 4) {
            int n5 = n2 + 1;
            return Float.intBitsToFloat(nArray[n5]);
        }
        if (n4 >= 16 && n4 <= 31) {
            int n6 = n2 + 1;
            return nArray[n6];
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n2, typedValue)) {
            String string2 = "Converting to float: " + typedValue;
            int n7 = Log.w("Resources", string2);
            CharSequence charSequence = typedValue.coerceToString();
            if (charSequence != null) {
                return Float.parseFloat(((Object)charSequence).toString());
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("getFloat of bad type: 0x");
        String string3 = Integer.toHexString(n4);
        String string4 = stringBuilder.append(string3).toString();
        int n8 = Log.w("Resources", string4);
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFraction(int n, int n2, int n3, float f) {
        int[] nArray = this.mData;
        int n4 = n * 6;
        int n5 = n4 + 0;
        int n6 = nArray[n5];
        if (n6 == 0) {
            return f;
        }
        if (n6 == 6) {
            int n7 = n4 + 1;
            int n8 = nArray[n7];
            float f2 = n2;
            float f3 = n3;
            return TypedValue.complexToFraction(n8, f2, f3);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Can't convert to fraction: type=0x");
        String string2 = Integer.toHexString(n6);
        String string3 = stringBuilder.append(string2).toString();
        throw new UnsupportedOperationException(string3);
    }

    public int getIndex(int n) {
        int[] nArray = this.mIndices;
        int n2 = n + 1;
        return nArray[n2];
    }

    public int getIndexCount() {
        return this.mIndices[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(int n, int n2) {
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = n3 + 0;
        int n5 = nArray[n4];
        if (n5 == 0) {
            return n2;
        }
        if (n5 >= 16 && n5 <= 31) {
            int n6 = n3 + 1;
            return nArray[n6];
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n3, typedValue)) {
            String string2 = "Converting to int: " + typedValue;
            int n7 = Log.w("Resources", string2);
            return XmlUtils.convertValueToInt(typedValue.coerceToString(), n2);
        }
        StringBuilder stringBuilder = new StringBuilder().append("getInt of bad type: 0x");
        String string3 = Integer.toHexString(n5);
        String string4 = stringBuilder.append(string3).toString();
        int n8 = Log.w("Resources", string4);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInteger(int n, int n2) {
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = n3 + 0;
        int n5 = nArray[n4];
        if (n5 == 0) {
            return n2;
        }
        if (n5 >= 16 && n5 <= 31) {
            int n6 = n3 + 1;
            return nArray[n6];
        }
        StringBuilder stringBuilder = new StringBuilder().append("Can't convert to integer: type=0x");
        String string2 = Integer.toHexString(n5);
        String string3 = stringBuilder.append(string2).toString();
        throw new UnsupportedOperationException(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLayoutDimension(int n, int n2) {
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = n3 + 0;
        int n5 = nArray[n4];
        if (n5 >= 16 && n5 <= 31) {
            int n6 = n3 + 1;
            return nArray[n6];
        }
        if (n5 != 5) return n2;
        int n7 = n3 + 1;
        int n8 = nArray[n7];
        DisplayMetrics displayMetrics = this.mResources.mMetrics;
        return TypedValue.complexToDimensionPixelSize(n8, displayMetrics);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLayoutDimension(int n, String string2) {
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = n2 + 0;
        int n4 = nArray[n3];
        if (n4 >= 16 && n4 <= 31) {
            int n5 = n2 + 1;
            return nArray[n5];
        }
        if (n4 == 5) {
            int n6 = n2 + 1;
            int n7 = nArray[n6];
            DisplayMetrics displayMetrics = this.mResources.mMetrics;
            return TypedValue.complexToDimensionPixelSize(n7, displayMetrics);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = this.getPositionDescription();
        String string4 = stringBuilder.append(string3).append(": You must supply a ").append(string2).append(" attribute.").toString();
        throw new RuntimeException(string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNonConfigurationString(int n, int n2) {
        int n3 = n * 6;
        int[] nArray = this.mData;
        int n4 = n3 + 0;
        int n5 = nArray[n4];
        int n6 = n3 + 4;
        int n7 = nArray[n6];
        int n8 = ~n2;
        if ((n7 & n8) != 0) {
            return null;
        }
        if (n5 == 0) {
            return null;
        }
        if (n5 == 3) {
            return ((Object)this.loadStringValueAt(n3)).toString();
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n3, typedValue)) {
            String string2 = "Converting to string: " + typedValue;
            int n9 = Log.w("Resources", string2);
            CharSequence charSequence = typedValue.coerceToString();
            if (charSequence == null) return null;
            return ((Object)charSequence).toString();
        }
        StringBuilder stringBuilder = new StringBuilder().append("getString of bad type: 0x");
        String string3 = Integer.toHexString(n5);
        String string4 = stringBuilder.append(string3).toString();
        int n10 = Log.w("Resources", string4);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNonResourceString(int n) {
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = n2 + 0;
        if (nArray[n3] != 3) return null;
        int n4 = n2 + 2;
        if (nArray[n4] >= 0) return null;
        XmlBlock.Parser parser = this.mXml;
        int n5 = n2 + 1;
        int n6 = nArray[n5];
        return ((Object)parser.getPooledString(n6)).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPositionDescription() {
        if (this.mXml == null) return "<internal>";
        return this.mXml.getPositionDescription();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getResourceId(int n, int n2) {
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = n3 + 0;
        if (nArray[n4] == 0) return n2;
        int n5 = n3 + 3;
        int n6 = nArray[n5];
        if (n6 == 0) return n2;
        return n6;
    }

    public Resources getResources() {
        return this.mResources;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString(int n) {
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = n2 + 0;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return null;
        }
        if (n4 == 3) {
            return ((Object)this.loadStringValueAt(n2)).toString();
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n2, typedValue)) {
            String string2 = "Converting to string: " + typedValue;
            int n5 = Log.w("Resources", string2);
            CharSequence charSequence = typedValue.coerceToString();
            if (charSequence == null) return null;
            return ((Object)charSequence).toString();
        }
        StringBuilder stringBuilder = new StringBuilder().append("getString of bad type: 0x");
        String string3 = Integer.toHexString(n4);
        String string4 = stringBuilder.append(string3).toString();
        int n6 = Log.w("Resources", string4);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getText(int n) {
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = n2 + 0;
        int n4 = nArray[n3];
        if (n4 == 0) {
            return null;
        }
        if (n4 == 3) {
            return this.loadStringValueAt(n2);
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n2, typedValue)) {
            String string2 = "Converting to string: " + typedValue;
            int n5 = Log.w("Resources", string2);
            return typedValue.coerceToString();
        }
        StringBuilder stringBuilder = new StringBuilder().append("getString of bad type: 0x");
        String string3 = Integer.toHexString(n4);
        String string4 = stringBuilder.append(string3).toString();
        int n6 = Log.w("Resources", string4);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence[] getTextArray(int n) {
        int n2 = n * 6;
        TypedValue typedValue = this.mValue;
        if (!this.getValueAt(n2, typedValue)) return null;
        Resources resources = this.mResources;
        int n3 = typedValue.resourceId;
        return resources.getTextArray(n3);
    }

    public boolean getValue(int n, TypedValue typedValue) {
        int n2 = n * 6;
        return this.getValueAt(n2, typedValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasValue(int n) {
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = n2 + 0;
        if (nArray[n3] == 0) return false;
        return true;
    }

    public int length() {
        return this.mLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypedValue peekValue(int n) {
        int n2 = n * 6;
        TypedValue typedValue = this.mValue;
        if (!this.getValueAt(n2, typedValue)) return null;
        return typedValue;
    }

    public void recycle() {
        TypedValue typedValue = this.mResources.mTmpValue;
        synchronized (typedValue) {
            int n;
            int n2;
            TypedArray typedArray = this.mResources.mCachedStyledAttributes;
            if (typedArray == null || (n2 = typedArray.mData.length) < (n = this.mData.length)) {
                this.mXml = null;
                this.mResources.mCachedStyledAttributes = this;
            }
            return;
        }
    }

    public String toString() {
        return Arrays.toString(this.mData);
    }
}

