/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetManager;
import android.content.res.StringBlock;
import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParserException;

final class XmlBlock {
    private static final boolean DEBUG;
    private final AssetManager mAssets;
    private final int mNative;
    private boolean mOpen = true;
    private int mOpenCount = 1;
    private final StringBlock mStrings;

    XmlBlock(AssetManager assetManager, int n) {
        StringBlock stringBlock;
        this.mAssets = assetManager;
        this.mNative = n;
        int n2 = XmlBlock.nativeGetStringBlock(n);
        this.mStrings = stringBlock = new StringBlock(n2, false);
    }

    public XmlBlock(byte[] byArray) {
        StringBlock stringBlock;
        int n;
        this.mAssets = null;
        int n2 = byArray.length;
        this.mNative = n = XmlBlock.nativeCreate(byArray, 0, n2);
        int n3 = XmlBlock.nativeGetStringBlock(this.mNative);
        this.mStrings = stringBlock = new StringBlock(n3, false);
    }

    public XmlBlock(byte[] byArray, int n, int n2) {
        StringBlock stringBlock;
        int n3;
        this.mAssets = null;
        this.mNative = n3 = XmlBlock.nativeCreate(byArray, n, n2);
        int n4 = XmlBlock.nativeGetStringBlock(this.mNative);
        this.mStrings = stringBlock = new StringBlock(n4, false);
    }

    static /* synthetic */ int access$008(XmlBlock xmlBlock) {
        int n;
        int n2 = xmlBlock.mOpenCount;
        xmlBlock.mOpenCount = n = n2 + 1;
        return n2;
    }

    private void decOpenCountLocked() {
        int n;
        this.mOpenCount = n = this.mOpenCount - 1;
        if (this.mOpenCount != 0) {
            return;
        }
        XmlBlock.nativeDestroy(this.mNative);
        if (this.mAssets == null) {
            return;
        }
        AssetManager assetManager = this.mAssets;
        int n2 = this.hashCode();
        assetManager.xmlBlockGone(n2);
    }

    private static final native int nativeCreate(byte[] var0, int var1, int var2);

    private static final native int nativeCreateParseState(int var0);

    private static final native void nativeDestroy(int var0);

    private static final native void nativeDestroyParseState(int var0);

    private static final native int nativeGetAttributeCount(int var0);

    private static final native int nativeGetAttributeData(int var0, int var1);

    private static final native int nativeGetAttributeDataType(int var0, int var1);

    private static final native int nativeGetAttributeIndex(int var0, String var1, String var2);

    private static final native int nativeGetAttributeName(int var0, int var1);

    private static final native int nativeGetAttributeNamespace(int var0, int var1);

    private static final native int nativeGetAttributeResource(int var0, int var1);

    private static final native int nativeGetAttributeStringValue(int var0, int var1);

    private static final native int nativeGetClassAttribute(int var0);

    private static final native int nativeGetIdAttribute(int var0);

    private static final native int nativeGetLineNumber(int var0);

    private static final native int nativeGetName(int var0);

    private static final native int nativeGetNamespace(int var0);

    private static final native int nativeGetStringBlock(int var0);

    private static final native int nativeGetStyleAttribute(int var0);

    private static final native int nativeGetText(int var0);

    private static final native int nativeNext(int var0);

    public void close() {
        synchronized (this) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decOpenCountLocked();
            }
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XmlResourceParser newParser() {
        synchronized (this) {
            if (this.mNative == 0) return null;
            int n = XmlBlock.nativeCreateParseState(this.mNative);
            return new Parser(n, this);
        }
    }

    final class Parser
    implements XmlResourceParser {
        private final XmlBlock mBlock;
        private boolean mDecNextDepth = false;
        private int mDepth = 0;
        private int mEventType = 0;
        int mParseState;
        private boolean mStarted = false;

        Parser(int n, XmlBlock xmlBlock2) {
            this.mParseState = n;
            this.mBlock = xmlBlock2;
            int n2 = XmlBlock.access$008(xmlBlock2);
        }

        @Override
        public void close() {
            XmlBlock xmlBlock = this.mBlock;
            synchronized (xmlBlock) {
                if (this.mParseState != 0) {
                    XmlBlock.nativeDestroyParseState(this.mParseState);
                    this.mParseState = 0;
                    this.mBlock.decOpenCountLocked();
                }
                return;
            }
        }

        @Override
        public void defineEntityReplacementText(String string2, String string3) throws XmlPullParserException {
            throw new XmlPullParserException("defineEntityReplacementText() not supported");
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean getAttributeBooleanValue(int n, boolean bl) {
            int n2 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            if (n2 < 16) return bl;
            if (n2 > 31) return bl;
            if (XmlBlock.nativeGetAttributeData(this.mParseState, n) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean getAttributeBooleanValue(String string2, String string3, boolean bl) {
            int n = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n < 0) return bl;
            return this.getAttributeBooleanValue(n, bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeCount() {
            if (this.mEventType != 2) return -1;
            return XmlBlock.nativeGetAttributeCount(this.mParseState);
        }

        @Override
        public float getAttributeFloatValue(int n, float f) {
            if (XmlBlock.nativeGetAttributeDataType(this.mParseState, n) == 4) {
                return Float.intBitsToFloat(XmlBlock.nativeGetAttributeData(this.mParseState, n));
            }
            throw new RuntimeException("not a float!");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public float getAttributeFloatValue(String string2, String string3, float f) {
            int n = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n < 0) return f;
            return this.getAttributeFloatValue(n, f);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeIntValue(int n, int n2) {
            int n3 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            if (n3 < 16) return n2;
            if (n3 > 31) return n2;
            return XmlBlock.nativeGetAttributeData(this.mParseState, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeIntValue(String string2, String string3, int n) {
            int n2 = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n2 < 0) return n;
            return this.getAttributeIntValue(n2, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeListValue(int n, String[] stringArray, int n2) {
            int n3 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            int n4 = XmlBlock.nativeGetAttributeData(this.mParseState, n);
            if (n3 != 3) return n4;
            return XmlUtils.convertValueToList(XmlBlock.this.mStrings.get(n4), stringArray, n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeListValue(String string2, String string3, String[] stringArray, int n) {
            int n2 = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n2 < 0) return n;
            return this.getAttributeListValue(n2, stringArray, n);
        }

        @Override
        public String getAttributeName(int n) {
            int n2 = XmlBlock.nativeGetAttributeName(this.mParseState, n);
            if (n2 >= 0) {
                return ((Object)XmlBlock.this.mStrings.get(n2)).toString();
            }
            String string2 = String.valueOf(n);
            throw new IndexOutOfBoundsException(string2);
        }

        @Override
        public int getAttributeNameResource(int n) {
            return XmlBlock.nativeGetAttributeResource(this.mParseState, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getAttributeNamespace(int n) {
            int n2 = XmlBlock.nativeGetAttributeNamespace(this.mParseState, n);
            if (n2 >= 0) {
                return ((Object)XmlBlock.this.mStrings.get(n2)).toString();
            }
            if (n2 == -1) {
                return "";
            }
            String string2 = String.valueOf(n);
            throw new IndexOutOfBoundsException(string2);
        }

        @Override
        public String getAttributePrefix(int n) {
            throw new RuntimeException("getAttributePrefix not supported");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeResourceValue(int n, int n2) {
            if (XmlBlock.nativeGetAttributeDataType(this.mParseState, n) != 1) return n2;
            return XmlBlock.nativeGetAttributeData(this.mParseState, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeResourceValue(String string2, String string3, int n) {
            int n2 = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n2 < 0) return n;
            return this.getAttributeResourceValue(n2, n);
        }

        @Override
        public String getAttributeType(int n) {
            return "CDATA";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeUnsignedIntValue(int n, int n2) {
            int n3 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            if (n3 < 16) return n2;
            if (n3 > 31) return n2;
            return XmlBlock.nativeGetAttributeData(this.mParseState, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getAttributeUnsignedIntValue(String string2, String string3, int n) {
            int n2 = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n2 < 0) return n;
            return this.getAttributeUnsignedIntValue(n2, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getAttributeValue(int n) {
            int n2 = XmlBlock.nativeGetAttributeStringValue(this.mParseState, n);
            if (n2 >= 0) {
                return ((Object)XmlBlock.this.mStrings.get(n2)).toString();
            }
            int n3 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            if (n3 == 0) {
                String string2 = String.valueOf(n);
                throw new IndexOutOfBoundsException(string2);
            }
            int n4 = XmlBlock.nativeGetAttributeData(this.mParseState, n);
            return TypedValue.coerceToString(n3, n4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getAttributeValue(String string2, String string3) {
            int n = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n < 0) return null;
            return this.getAttributeValue(n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getClassAttribute() {
            int n = XmlBlock.nativeGetClassAttribute(this.mParseState);
            if (n < 0) return null;
            return ((Object)XmlBlock.this.mStrings.get(n)).toString();
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getDepth() {
            return this.mDepth;
        }

        @Override
        public int getEventType() throws XmlPullParserException {
            return this.mEventType;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean getFeature(String string2) {
            if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string2)) {
                return true;
            }
            if (!"http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(string2)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getIdAttribute() {
            int n = XmlBlock.nativeGetIdAttribute(this.mParseState);
            if (n < 0) return null;
            return ((Object)XmlBlock.this.mStrings.get(n)).toString();
        }

        @Override
        public int getIdAttributeResourceValue(int n) {
            return this.getAttributeResourceValue(null, "id", n);
        }

        @Override
        public String getInputEncoding() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return XmlBlock.nativeGetLineNumber(this.mParseState);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getName() {
            int n = XmlBlock.nativeGetName(this.mParseState);
            if (n < 0) return null;
            return ((Object)XmlBlock.this.mStrings.get(n)).toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getNamespace() {
            int n = XmlBlock.nativeGetNamespace(this.mParseState);
            if (n < 0) return "";
            return ((Object)XmlBlock.this.mStrings.get(n)).toString();
        }

        @Override
        public String getNamespace(String string2) {
            throw new RuntimeException("getNamespace() not supported");
        }

        @Override
        public int getNamespaceCount(int n) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespaceCount() not supported");
        }

        @Override
        public String getNamespacePrefix(int n) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespacePrefix() not supported");
        }

        @Override
        public String getNamespaceUri(int n) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespaceUri() not supported");
        }

        final CharSequence getPooledString(int n) {
            return XmlBlock.this.mStrings.get(n);
        }

        @Override
        public String getPositionDescription() {
            StringBuilder stringBuilder = new StringBuilder().append("Binary XML file line #");
            int n = this.getLineNumber();
            return stringBuilder.append(n).toString();
        }

        @Override
        public String getPrefix() {
            throw new RuntimeException("getPrefix not supported");
        }

        @Override
        public Object getProperty(String string2) {
            return null;
        }

        @Override
        public int getStyleAttribute() {
            return XmlBlock.nativeGetStyleAttribute(this.mParseState);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getText() {
            int n = XmlBlock.nativeGetText(this.mParseState);
            if (n < 0) return null;
            return ((Object)XmlBlock.this.mStrings.get(n)).toString();
        }

        @Override
        public char[] getTextCharacters(int[] nArray) {
            String string2 = this.getText();
            char[] cArray = null;
            if (string2 != null) {
                int n;
                nArray[0] = 0;
                nArray[1] = n = string2.length();
                cArray = new char[string2.length()];
                int n2 = string2.length();
                string2.getChars(0, n2, cArray, 0);
            }
            return cArray;
        }

        @Override
        public boolean isAttributeDefault(int n) {
            return false;
        }

        @Override
        public boolean isEmptyElementTag() throws XmlPullParserException {
            return false;
        }

        @Override
        public boolean isWhitespace() throws XmlPullParserException {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int next() throws XmlPullParserException, IOException {
            if (!this.mStarted) {
                this.mStarted = true;
                return 0;
            }
            if (this.mParseState == 0) {
                return 1;
            }
            int n = XmlBlock.nativeNext(this.mParseState);
            if (this.mDecNextDepth) {
                int n2;
                this.mDepth = n2 = this.mDepth - 1;
                this.mDecNextDepth = false;
            }
            switch (n) {
                case 2: {
                    int n3;
                    this.mDepth = n3 = this.mDepth + 1;
                }
                default: {
                    break;
                }
                case 3: {
                    this.mDecNextDepth = true;
                }
            }
            this.mEventType = n;
            if (n != 1) return n;
            this.close();
            return n;
        }

        @Override
        public int nextTag() throws XmlPullParserException, IOException {
            int n = this.next();
            if (n == 4 && this.isWhitespace()) {
                n = this.next();
            }
            if (n != 2 && n != 3) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.getPositionDescription();
                String string3 = stringBuilder.append(string2).append(": expected start or end tag").toString();
                throw new XmlPullParserException(string3, this, null);
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String nextText() throws XmlPullParserException, IOException {
            if (this.getEventType() != 2) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.getPositionDescription();
                String string3 = stringBuilder.append(string2).append(": parser must be on START_TAG to read next text").toString();
                throw new XmlPullParserException(string3, this, null);
            }
            int n = this.next();
            if (n == 4) {
                String string4 = this.getText();
                if (this.next() == 3) return string4;
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = this.getPositionDescription();
                String string6 = stringBuilder.append(string5).append(": event TEXT it must be immediately followed by END_TAG").toString();
                throw new XmlPullParserException(string6, this, null);
            }
            if (n == 3) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string7 = this.getPositionDescription();
            String string8 = stringBuilder.append(string7).append(": parser must be on START_TAG or TEXT to read text").toString();
            throw new XmlPullParserException(string8, this, null);
        }

        @Override
        public int nextToken() throws XmlPullParserException, IOException {
            return this.next();
        }

        @Override
        public void require(int n, String string2, String string3) throws XmlPullParserException, IOException {
            String string4;
            int n2 = this.getEventType();
            if (n != n2 && (string2 == null || string2.equals(string4 = this.getNamespace()))) {
                if (string3 == null) {
                    return;
                }
                String string5 = this.getName();
                if (string3.equals(string5)) {
                    return;
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append("expected ");
            String string6 = TYPES[n];
            StringBuilder stringBuilder2 = stringBuilder.append(string6);
            String string7 = this.getPositionDescription();
            String string8 = stringBuilder2.append(string7).toString();
            throw new XmlPullParserException(string8);
        }

        @Override
        public void setFeature(String string2, boolean bl) throws XmlPullParserException {
            if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string2) && bl) {
                return;
            }
            if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(string2) && bl) {
                return;
            }
            String string3 = "Unsupported feature: " + string2;
            throw new XmlPullParserException(string3);
        }

        @Override
        public void setInput(InputStream inputStream, String string2) throws XmlPullParserException {
            throw new XmlPullParserException("setInput() not supported");
        }

        @Override
        public void setInput(Reader reader) throws XmlPullParserException {
            throw new XmlPullParserException("setInput() not supported");
        }

        @Override
        public void setProperty(String string2, Object object) throws XmlPullParserException {
            throw new XmlPullParserException("setProperty() not supported");
        }
    }
}

