/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObservable;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCursor
implements CrossProcessCursor {
    private static final String TAG = "Cursor";
    protected boolean mClosed;
    ContentObservable mContentObservable;
    protected ContentResolver mContentResolver;
    protected Long mCurrentRowID;
    DataSetObservable mDataSetObservable;
    private Uri mNotifyUri;
    protected int mPos;
    protected int mRowIdColumnIndex;
    private ContentObserver mSelfObserver;
    private final Object mSelfObserverLock;
    private boolean mSelfObserverRegistered;
    protected HashMap<Long, Map<String, Object>> mUpdatedRows;

    public AbstractCursor() {
        Object object;
        ContentObservable contentObservable;
        DataSetObservable dataSetObservable;
        this.mDataSetObservable = dataSetObservable = new DataSetObservable();
        this.mContentObservable = contentObservable = new ContentObservable();
        this.mClosed = false;
        this.mSelfObserverLock = object = new Object();
        this.mPos = -1;
        this.mRowIdColumnIndex = -1;
        this.mCurrentRowID = null;
        HashMap hashMap = new HashMap();
        this.mUpdatedRows = hashMap;
    }

    @Override
    public void abortUpdates() {
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            this.mUpdatedRows.clear();
            return;
        }
    }

    protected void checkPosition() {
        int n;
        int n2;
        int n3 = this.mPos;
        if (-1 != n3 && (n2 = this.getCount()) != (n = this.mPos)) {
            return;
        }
        int n4 = this.mPos;
        int n5 = this.getCount();
        throw new CursorIndexOutOfBoundsException(n4, n5);
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.deactivateInternal();
    }

    @Override
    public boolean commitUpdates() {
        return this.commitUpdates(null);
    }

    @Override
    public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> map) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void copyStringToBuffer(int n, CharArrayBuffer charArrayBuffer) {
        int n2;
        int n3;
        int n4;
        String string2 = this.getString(n);
        if (string2 == null) {
            return;
        }
        char[] cArray = charArrayBuffer.data;
        if (cArray == null || (n4 = cArray.length) < (n3 = string2.length())) {
            char[] cArray2 = string2.toCharArray();
            charArrayBuffer.data = cArray2;
        } else {
            int n5 = string2.length();
            string2.getChars(0, n5, cArray, 0);
        }
        charArrayBuffer.sizeCopied = n2 = string2.length();
    }

    @Override
    public void deactivate() {
        this.deactivateInternal();
    }

    public void deactivateInternal() {
        if (this.mSelfObserver != null) {
            ContentResolver contentResolver = this.mContentResolver;
            ContentObserver contentObserver = this.mSelfObserver;
            contentResolver.unregisterContentObserver(contentObserver);
            this.mSelfObserverRegistered = false;
        }
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public boolean deleteRow() {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fillWindow(int var1_1, CursorWindow var2_2) {
        block10: {
            if (var1_1 < 0) {
                return;
            }
            var3_3 = this.getCount();
            if (var1_1 > var3_3) {
                return;
            }
            var2_2.acquireReference();
            try {
                var4_4 = this.mPos;
                this.mPos = var5_5 = var1_1 - 1;
                var2_2.clear();
                var2_2.setStartPosition(var1_1);
                var6_6 = this.getColumnCount();
                var7_7 = var2_2.setNumColumns(var6_6);
lbl14:
                // 4 sources

                while (this.moveToNext() && var2_2.allocRow()) {
                    break block10;
                }
                ** GOTO lbl-1000
            }
            catch (IllegalStateException var11_12) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_2.releaseReference();
                    return;
                }
            }
            catch (Throwable var13_13) {
                var2_2.releaseReference();
                throw var13_13;
            }
        }
        for (var8_8 = 0; var8_8 < var6_6; ++var8_8) {
            block11: {
                var9_9 = this.getString(var8_8);
                if (var9_9 == null) break block11;
                var10_10 = this.mPos;
                if (var2_2.putString(var9_9, var10_10, var8_8)) continue;
                var2_2.freeLastRow();
                ** GOTO lbl14
            }
            var12_11 = this.mPos;
            if (var2_2.putNull(var12_11, var8_8)) continue;
            var2_2.freeLastRow();
            ** GOTO lbl14
        }
        ** GOTO lbl14
lbl-1000:
        // 1 sources

        {
            this.mPos = var4_4;
            ** continue;
        }
    }

    protected void finalize() {
        if (this.mSelfObserver == null) {
            return;
        }
        if (!this.mSelfObserverRegistered) {
            return;
        }
        ContentResolver contentResolver = this.mContentResolver;
        ContentObserver contentObserver = this.mSelfObserver;
        contentResolver.unregisterContentObserver(contentObserver);
    }

    @Override
    public byte[] getBlob(int n) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getColumnIndex(String string2) {
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            Exception exception = new Exception();
            String string3 = "requesting column name with table name -- " + string2;
            int n2 = Log.e(TAG, string3, exception);
            int n3 = n + 1;
            string2 = string2.substring(n3);
        }
        String[] stringArray = this.getColumnNames();
        int n4 = stringArray.length;
        int n5 = 0;
        while (n5 < n4) {
            if (stringArray[n5].equalsIgnoreCase(string2)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    @Override
    public int getColumnIndexOrThrow(String string2) {
        int n = this.getColumnIndex(string2);
        if (n < 0) {
            String string3 = "column '" + string2 + "' does not exist";
            throw new IllegalArgumentException(string3);
        }
        return n;
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnNames()[n];
    }

    @Override
    public abstract String[] getColumnNames();

    @Override
    public abstract int getCount();

    protected DataSetObservable getDataSetObservable() {
        return this.mDataSetObservable;
    }

    @Override
    public abstract double getDouble(int var1);

    @Override
    public Bundle getExtras() {
        return Bundle.EMPTY;
    }

    @Override
    public abstract float getFloat(int var1);

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract long getLong(int var1);

    @Override
    public final int getPosition() {
        return this.mPos;
    }

    @Override
    public abstract short getShort(int var1);

    @Override
    public abstract String getString(int var1);

    protected Object getUpdatedField(int n) {
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        Long l = this.mCurrentRowID;
        Map<String, Object> map = hashMap.get(l);
        String string2 = this.getColumnNames()[n];
        return map.get(string2);
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return false;
    }

    @Override
    public CursorWindow getWindow() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasUpdates() {
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.mUpdatedRows.size() <= 0) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isAfterLast() {
        if (this.getCount() == 0) {
            return true;
        }
        int n = this.mPos;
        int n2 = this.getCount();
        if (n == n2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isBeforeFirst() {
        if (this.getCount() == 0) {
            return true;
        }
        if (this.mPos != -1) return false;
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isFieldUpdated(int n) {
        if (this.mRowIdColumnIndex == -1) return false;
        if (this.mUpdatedRows.size() <= 0) return false;
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        Long l = this.mCurrentRowID;
        Map<String, Object> map = hashMap.get(l);
        if (map == null) return false;
        String string2 = this.getColumnNames()[n];
        if (!map.containsKey(string2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isFirst() {
        if (this.mPos != 0) return false;
        if (this.getCount() == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean isLast() {
        int n = this.mPos;
        int n2 = this.getCount();
        int n3 = n2 - 1;
        if (n == n3) return false;
        if (n2 == 0) return false;
        return true;
    }

    @Override
    public abstract boolean isNull(int var1);

    @Override
    public final boolean move(int n) {
        int n2 = this.mPos + n;
        return this.moveToPosition(n2);
    }

    @Override
    public final boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    @Override
    public final boolean moveToLast() {
        int n = this.getCount() - 1;
        return this.moveToPosition(n);
    }

    @Override
    public final boolean moveToNext() {
        int n = this.mPos + 1;
        return this.moveToPosition(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean moveToPosition(int n) {
        Long l;
        boolean bl = false;
        int n2 = this.getCount();
        if (n >= n2) {
            this.mPos = n2;
            return bl;
        }
        if (n < 0) {
            this.mPos = -1;
            return bl;
        }
        int n3 = this.mPos;
        if (n != n3) {
            return true;
        }
        int n4 = this.mPos;
        boolean bl2 = this.onMove(n4, n);
        if (!bl2) {
            this.mPos = -1;
            return bl2;
        }
        this.mPos = n;
        if (this.mRowIdColumnIndex == -1) return bl2;
        int n5 = this.mRowIdColumnIndex;
        this.mCurrentRowID = l = Long.valueOf(this.getLong(n5));
        return bl2;
    }

    @Override
    public final boolean moveToPrevious() {
        int n = this.mPos - 1;
        return this.moveToPosition(n);
    }

    protected void notifyDataSetChange() {
        this.mDataSetObservable.notifyChanged();
    }

    protected void onChange(boolean bl) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mContentObservable.dispatchChange(bl);
            if (this.mNotifyUri != null && bl) {
                ContentResolver contentResolver = this.mContentResolver;
                Uri uri = this.mNotifyUri;
                ContentObserver contentObserver = this.mSelfObserver;
                contentResolver.notifyChange(uri, contentObserver);
            }
            return;
        }
    }

    @Override
    public boolean onMove(int n, int n2) {
        return true;
    }

    @Override
    public void registerContentObserver(ContentObserver contentObserver) {
        this.mContentObservable.registerObserver(contentObserver);
    }

    @Override
    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        this.mDataSetObservable.registerObserver(dataSetObserver);
    }

    @Override
    public boolean requery() {
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            ContentResolver contentResolver = this.mContentResolver;
            Uri uri = this.mNotifyUri;
            ContentObserver contentObserver = this.mSelfObserver;
            contentResolver.registerContentObserver(uri, true, contentObserver);
            this.mSelfObserverRegistered = true;
        }
        this.mDataSetObservable.notifyChanged();
        return true;
    }

    @Override
    public Bundle respond(Bundle bundle) {
        return Bundle.EMPTY;
    }

    @Override
    public void setNotificationUri(ContentResolver contentResolver, Uri uri) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUri = uri;
            this.mContentResolver = contentResolver;
            if (this.mSelfObserver != null) {
                ContentResolver contentResolver2 = this.mContentResolver;
                ContentObserver contentObserver = this.mSelfObserver;
                contentResolver2.unregisterContentObserver(contentObserver);
            }
            SelfContentObserver selfContentObserver = new SelfContentObserver(this);
            this.mSelfObserver = selfContentObserver;
            ContentResolver contentResolver3 = this.mContentResolver;
            Uri uri2 = this.mNotifyUri;
            ContentObserver contentObserver = this.mSelfObserver;
            contentResolver3.registerContentObserver(uri2, true, contentObserver);
            this.mSelfObserverRegistered = true;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supportsUpdates() {
        if (this.mRowIdColumnIndex == -1) return false;
        return true;
    }

    @Override
    public void unregisterContentObserver(ContentObserver contentObserver) {
        if (this.mClosed) {
            return;
        }
        this.mContentObservable.unregisterObserver(contentObserver);
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        this.mDataSetObservable.unregisterObserver(dataSetObserver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update(int n, Object object) {
        if (!this.supportsUpdates()) {
            return false;
        }
        int n2 = this.mRowIdColumnIndex;
        long l = this.getLong(n2);
        Long l2 = new Long(l);
        if (l2 == null) {
            StringBuilder stringBuilder = new StringBuilder().append("null rowid. mRowIdColumnIndex = ");
            int n3 = this.mRowIdColumnIndex;
            String string2 = stringBuilder.append(n3).toString();
            throw new IllegalStateException(string2);
        }
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            Map<String, Object> map = this.mUpdatedRows.get(l2);
            if (map == null) {
                map = new HashMap<String, Object>();
                Map<String, Object> map2 = this.mUpdatedRows.put(l2, map);
            }
            String string3 = this.getColumnNames()[n];
            Object object2 = map.put(string3, object);
            return true;
        }
    }

    @Override
    public boolean updateBlob(int n, byte[] byArray) {
        return this.update(n, byArray);
    }

    @Override
    public boolean updateDouble(int n, double d) {
        Double d2 = d;
        return this.update(n, d2);
    }

    @Override
    public boolean updateFloat(int n, float f) {
        Float f2 = Float.valueOf(f);
        return this.update(n, f2);
    }

    @Override
    public boolean updateInt(int n, int n2) {
        Integer n3 = n2;
        return this.update(n, n3);
    }

    @Override
    public boolean updateLong(int n, long l) {
        Long l2 = l;
        return this.update(n, l2);
    }

    @Override
    public boolean updateShort(int n, short s) {
        Short s2 = s;
        return this.update(n, s2);
    }

    @Override
    public boolean updateString(int n, String string2) {
        return this.update(n, string2);
    }

    @Override
    public boolean updateToNull(int n) {
        return this.update(n, null);
    }

    protected static class SelfContentObserver
    extends ContentObserver {
        WeakReference<AbstractCursor> mCursor;

        public SelfContentObserver(AbstractCursor abstractCursor) {
            super(null);
            WeakReference<AbstractCursor> weakReference = new WeakReference<AbstractCursor>(abstractCursor);
            this.mCursor = weakReference;
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean bl) {
            AbstractCursor abstractCursor = (AbstractCursor)this.mCursor.get();
            if (abstractCursor == null) {
                return;
            }
            abstractCursor.onChange(false);
        }
    }
}

