/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.CharArrayBuffer;
import android.database.CursorWindow;
import android.database.StaleDataException;
import java.util.HashMap;

public abstract class AbstractWindowedCursor
extends AbstractCursor {
    protected CursorWindow mWindow;

    @Override
    protected void checkPosition() {
        super.checkPosition();
        if (this.mWindow != null) {
            return;
        }
        throw new StaleDataException("Access closed cursor");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void copyStringToBuffer(int n, CharArrayBuffer charArrayBuffer) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(n)) {
                super.copyStringToBuffer(n, charArrayBuffer);
            }
        }
        CursorWindow cursorWindow = this.mWindow;
        int n2 = this.mPos;
        cursorWindow.copyStringToBuffer(n2, n, charArrayBuffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBlob(int n) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(n)) {
                byte[] byArray = (byte[])this.getUpdatedField(n);
                return (HashMap)byArray;
            }
        }
        CursorWindow cursorWindow = this.mWindow;
        int n2 = this.mPos;
        return (HashMap)cursorWindow.getBlob(n2, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public double getDouble(int n) {
        this.checkPosition();
        Object object = this.mUpdatedRows;
        synchronized (object) {
            if (this.isFieldUpdated(n)) {
                double d = ((Number)this.getUpdatedField(n)).doubleValue();
                return (double)((Object)d);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2 /* !! */ 
            CursorWindow cursorWindow = this.mWindow;
            int n2 = this.mPos;
            return (double)((Object)cursorWindow.getDouble(n2, n));
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getFloat(int n) {
        this.checkPosition();
        Object object = this.mUpdatedRows;
        synchronized (object) {
            if (this.isFieldUpdated(n)) {
                float f = ((Number)this.getUpdatedField(n)).floatValue();
                return (float)((Object)f);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2 /* !! */ 
            CursorWindow cursorWindow = this.mWindow;
            int n2 = this.mPos;
            return (float)((Object)cursorWindow.getFloat(n2, n));
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getInt(int n) {
        this.checkPosition();
        Object object = this.mUpdatedRows;
        synchronized (object) {
            if (this.isFieldUpdated(n)) {
                int n2 = ((Number)this.getUpdatedField(n)).intValue();
                return (int)((Object)n2);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2 /* !! */ 
            CursorWindow cursorWindow = this.mWindow;
            int n3 = this.mPos;
            return (int)((Object)cursorWindow.getInt(n3, n));
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLong(int n) {
        this.checkPosition();
        Object object = this.mUpdatedRows;
        synchronized (object) {
            if (this.isFieldUpdated(n)) {
                long l = ((Number)this.getUpdatedField(n)).longValue();
                return (long)((Object)l);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2 /* !! */ 
            CursorWindow cursorWindow = this.mWindow;
            int n2 = this.mPos;
            return (long)((Object)cursorWindow.getLong(n2, n));
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public short getShort(int n) {
        this.checkPosition();
        Object object = this.mUpdatedRows;
        synchronized (object) {
            if (this.isFieldUpdated(n)) {
                short s = ((Number)this.getUpdatedField(n)).shortValue();
                return (short)((Object)s);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2 /* !! */ 
            CursorWindow cursorWindow = this.mWindow;
            int n2 = this.mPos;
            return (short)((Object)cursorWindow.getShort(n2, n));
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString(int n) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (this.isFieldUpdated(n)) {
                String string2 = (String)this.getUpdatedField(n);
                return string2;
            }
        }
        CursorWindow cursorWindow = this.mWindow;
        int n2 = this.mPos;
        return cursorWindow.getString(n2, n);
    }

    @Override
    public CursorWindow getWindow() {
        return this.mWindow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasWindow() {
        if (this.mWindow == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBlob(int n) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            boolean bl;
            if (!this.isFieldUpdated(n)) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                CursorWindow cursorWindow = this.mWindow;
                int n2 = this.mPos;
                return cursorWindow.isBlob(n2, n);
            }
            Object object = this.getUpdatedField(n);
            if (object == null) return true;
            if (object instanceof byte[]) {
                return true;
            }
            Object var4_6 = null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFloat(int n) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            boolean bl;
            if (!this.isFieldUpdated(n)) {
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                CursorWindow cursorWindow = this.mWindow;
                int n2 = this.mPos;
                return cursorWindow.isFloat(n2, n);
            }
            Object object = this.getUpdatedField(n);
            if (object != null) {
                if (object instanceof Float) return true;
                if (object instanceof Double) {
                    return true;
                }
            }
            Object var4_6 = null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLong(int n) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            boolean bl;
            if (!this.isFieldUpdated(n)) {
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                CursorWindow cursorWindow = this.mWindow;
                int n2 = this.mPos;
                return cursorWindow.isLong(n2, n);
            }
            Object object = this.getUpdatedField(n);
            if (object != null) {
                if (object instanceof Integer) return true;
                if (object instanceof Long) {
                    return true;
                }
            }
            Object var4_6 = null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isNull(int n) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            boolean bl;
            if (!this.isFieldUpdated(n)) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                CursorWindow cursorWindow = this.mWindow;
                int n2 = this.mPos;
                return cursorWindow.isNull(n2, n);
            }
            if (this.getUpdatedField(n) == null) {
                return true;
            }
            Object var3_5 = null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isString(int n) {
        this.checkPosition();
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            boolean bl;
            if (!this.isFieldUpdated(n)) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                CursorWindow cursorWindow = this.mWindow;
                int n2 = this.mPos;
                return cursorWindow.isString(n2, n);
            }
            Object object = this.getUpdatedField(n);
            if (object == null) return true;
            if (object instanceof String) {
                return true;
            }
            Object var4_6 = null;
            return bl;
        }
    }

    public void setWindow(CursorWindow cursorWindow) {
        if (this.mWindow != null) {
            this.mWindow.close();
        }
        this.mWindow = cursorWindow;
    }
}

