/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public final class BulkCursorToCursorAdaptor
extends AbstractWindowedCursor {
    private static final String TAG = "BulkCursor";
    private IBulkCursor mBulkCursor;
    private String[] mColumns;
    private int mCount;
    private AbstractCursor.SelfContentObserver mObserverBridge;
    private boolean mWantsAllOnMoveCalls;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int findRowIdColumnIndex(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equals("_id")) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        super.close();
        try {
            this.mBulkCursor.close();
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Remote process exception when closing");
        }
        this.mWindow = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> map) {
        if (!this.supportsUpdates()) {
            int n = Log.e(TAG, "commitUpdates not supported on this cursor, did you include the _id column?");
            return false;
        }
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (map != null) {
                this.mUpdatedRows.putAll(map);
            }
            if (this.mUpdatedRows.size() <= 0) {
                return false;
            }
            try {
                IBulkCursor iBulkCursor = this.mBulkCursor;
                HashMap hashMap2 = this.mUpdatedRows;
                boolean bl = iBulkCursor.updateRows(hashMap2);
                if (!bl) return bl;
                this.mUpdatedRows.clear();
                this.onChange(true);
                return bl;
            }
            catch (RemoteException remoteException) {
                int n = Log.e(TAG, "Unable to commit updates because the remote process is dead");
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deactivate() {
        super.deactivate();
        try {
            this.mBulkCursor.deactivate();
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "Remote process exception when deactivating");
        }
        this.mWindow = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteRow() {
        try {
            int n;
            IBulkCursor iBulkCursor = this.mBulkCursor;
            int n2 = this.mPos;
            boolean bl = iBulkCursor.deleteRow(n2);
            if (!bl) return bl;
            this.mWindow = null;
            this.mCount = n = this.mBulkCursor.count();
            int n3 = this.mPos;
            int n4 = this.mCount;
            if (n3 < n4) {
                int n5 = this.mPos;
                this.mPos = -1;
                boolean bl2 = this.moveToPosition(n5);
            } else {
                int n6;
                this.mPos = n6 = this.mCount;
            }
            this.onChange(true);
            return bl;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Unable to delete row because the remote process is dead");
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getColumnNames() {
        if (this.mColumns != null) return this.mColumns;
        try {
            String[] stringArray = this.mBulkCursor.getColumnNames();
            this.mColumns = stringArray;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Unable to fetch column names because the remote process is dead");
            return null;
        }
        return this.mColumns;
    }

    @Override
    public int getCount() {
        return this.mCount;
    }

    @Override
    public Bundle getExtras() {
        try {
            Bundle bundle = this.mBulkCursor.getExtras();
            return bundle;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public IContentObserver getObserver() {
        synchronized (this) {
            IContentObserver iContentObserver;
            if (this.mObserverBridge == null) {
                AbstractCursor.SelfContentObserver selfContentObserver;
                this.mObserverBridge = selfContentObserver = new AbstractCursor.SelfContentObserver(this);
            }
            IContentObserver iContentObserver2 = iContentObserver = this.mObserverBridge.getContentObserver();
            return iContentObserver2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onMove(int n, int n2) {
        block7: {
            try {
                CursorWindow cursorWindow;
                if (this.mWindow != null) {
                    int n3;
                    int n4;
                    int n5;
                    int n6 = this.mWindow.getStartPosition();
                    if (n2 < n6 || n2 >= (n5 = (n4 = this.mWindow.getStartPosition()) + (n3 = this.mWindow.getNumRows()))) {
                        CursorWindow cursorWindow2;
                        this.mWindow = cursorWindow2 = this.mBulkCursor.getWindow(n2);
                        break block7;
                    }
                    if (this.mWantsAllOnMoveCalls) {
                        this.mBulkCursor.onMove(n2);
                    }
                    break block7;
                }
                this.mWindow = cursorWindow = this.mBulkCursor.getWindow(n2);
            }
            catch (RemoteException remoteException) {
                int n7 = Log.e(TAG, "Unable to get window because the remote process is dead");
                return false;
            }
        }
        if (this.mWindow != null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requery() {
        try {
            int n;
            int n2 = this.mCount;
            IBulkCursor iBulkCursor = this.mBulkCursor;
            IContentObserver iContentObserver = this.getObserver();
            CursorWindow cursorWindow = new CursorWindow(false);
            this.mCount = n = iBulkCursor.requery(iContentObserver, cursorWindow);
            if (this.mCount != -1) {
                this.mPos = -1;
                this.mWindow = null;
                boolean bl = super.requery();
                return true;
            }
            this.deactivate();
            return false;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to requery because the remote process exception ");
            String string2 = exception.getMessage();
            String string3 = stringBuilder.append(string2).toString();
            int n = Log.e(TAG, string3);
            this.deactivate();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Bundle respond(Bundle bundle) {
        try {
            Bundle bundle2 = this.mBulkCursor.respond(bundle);
            return bundle2;
        }
        catch (RemoteException remoteException) {
            int n = Log.w(TAG, "respond() threw RemoteException, returning an empty bundle.", remoteException);
            return Bundle.EMPTY;
        }
    }

    public void set(IBulkCursor iBulkCursor) {
        this.mBulkCursor = iBulkCursor;
        try {
            int n;
            boolean bl;
            int n2;
            this.mCount = n2 = this.mBulkCursor.count();
            this.mWantsAllOnMoveCalls = bl = this.mBulkCursor.getWantsAllOnMoveCalls();
            String[] stringArray = this.mBulkCursor.getColumnNames();
            this.mColumns = stringArray;
            this.mRowIdColumnIndex = n = BulkCursorToCursorAdaptor.findRowIdColumnIndex(this.mColumns);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "Setup failed because the remote process is dead");
            return;
        }
    }

    public void set(IBulkCursor iBulkCursor, int n, int n2) {
        this.mBulkCursor = iBulkCursor;
        this.mColumns = null;
        this.mCount = n;
        this.mRowIdColumnIndex = n2;
    }
}

