/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.IContentObserver;
import android.os.Handler;

public abstract class ContentObserver {
    private Object lock;
    Handler mHandler;
    private Transport mTransport;

    public ContentObserver(Handler handler) {
        Object object;
        this.lock = object = new Object();
        this.mHandler = handler;
    }

    public boolean deliverSelfNotifications() {
        return false;
    }

    public final void dispatchChange(boolean bl) {
        if (this.mHandler == null) {
            this.onChange(bl);
            return;
        }
        Handler handler = this.mHandler;
        NotificationRunnable notificationRunnable = new NotificationRunnable(bl);
        boolean bl2 = handler.post(notificationRunnable);
    }

    public IContentObserver getContentObserver() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTransport == null) {
                Transport transport;
                this.mTransport = transport = new Transport(this);
            }
            Transport transport = this.mTransport;
            return transport;
        }
    }

    public void onChange(boolean bl) {
    }

    public IContentObserver releaseContentObserver() {
        Object object = this.lock;
        synchronized (object) {
            Transport transport = this.mTransport;
            if (transport != null) {
                transport.releaseContentObserver();
                this.mTransport = null;
            }
            return transport;
        }
    }

    private static final class Transport
    extends IContentObserver.Stub {
        ContentObserver mContentObserver;

        public Transport(ContentObserver contentObserver) {
            this.mContentObserver = contentObserver;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean deliverSelfNotifications() {
            ContentObserver contentObserver = this.mContentObserver;
            if (contentObserver == null) return false;
            return contentObserver.deliverSelfNotifications();
        }

        @Override
        public void onChange(boolean bl) {
            ContentObserver contentObserver = this.mContentObserver;
            if (contentObserver == null) {
                return;
            }
            contentObserver.dispatchChange(bl);
        }

        public void releaseContentObserver() {
            this.mContentObserver = null;
        }
    }

    private final class NotificationRunnable
    implements Runnable {
        private boolean mSelf;

        public NotificationRunnable(boolean bl) {
            this.mSelf = bl;
        }

        @Override
        public void run() {
            ContentObserver contentObserver = ContentObserver.this;
            boolean bl = this.mSelf;
            contentObserver.onChange(bl);
        }
    }
}

