/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractWindowedCursor;
import android.database.BulkCursorNative;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.IContentObserver;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.Map;

public final class CursorToBulkCursorAdaptor
extends BulkCursorNative
implements IBinder.DeathRecipient {
    private static final String TAG = "Cursor";
    private final CrossProcessCursor mCursor;
    private ContentObserverProxy mObserver;
    private final String mProviderName;
    private final boolean mReadOnly;
    private CursorWindow mWindow;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CursorToBulkCursorAdaptor(Cursor cursor, IContentObserver iContentObserver, String string2, boolean bl, CursorWindow cursorWindow) {
        boolean bl2;
        try {
            CrossProcessCursor crossProcessCursor;
            this.mCursor = crossProcessCursor = (CrossProcessCursor)cursor;
            if (this.mCursor instanceof AbstractWindowedCursor) {
                AbstractWindowedCursor abstractWindowedCursor = (AbstractWindowedCursor)cursor;
                if (abstractWindowedCursor.hasWindow() && Log.isLoggable(TAG, 2)) {
                    String string3 = "Cross process cursor has a local window before setWindow in " + string2;
                    RuntimeException runtimeException = new RuntimeException();
                    int n = Log.v(TAG, string3, runtimeException);
                }
                abstractWindowedCursor.setWindow(cursorWindow);
            } else {
                this.mWindow = cursorWindow;
                this.mCursor.fillWindow(0, cursorWindow);
            }
            this.mProviderName = string2;
            bl2 = !bl;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Only CrossProcessCursor cursors are supported across process for now", classCastException);
        }
        this.mReadOnly = bl2;
        this.createAndRegisterObserverProxy(iContentObserver);
    }

    private void createAndRegisterObserverProxy(IContentObserver iContentObserver) {
        ContentObserverProxy contentObserverProxy;
        if (this.mObserver != null) {
            throw new IllegalStateException("an observer is already registered");
        }
        this.mObserver = contentObserverProxy = new ContentObserverProxy(iContentObserver, this);
        CrossProcessCursor crossProcessCursor = this.mCursor;
        ContentObserverProxy contentObserverProxy2 = this.mObserver;
        crossProcessCursor.registerContentObserver(contentObserverProxy2);
    }

    private void maybeUnregisterObserverProxy() {
        if (this.mObserver == null) {
            return;
        }
        CrossProcessCursor crossProcessCursor = this.mCursor;
        ContentObserverProxy contentObserverProxy = this.mObserver;
        crossProcessCursor.unregisterContentObserver(contentObserverProxy);
        boolean bl = this.mObserver.unlinkToDeath(this);
        this.mObserver = null;
    }

    @Override
    public void binderDied() {
        this.mCursor.close();
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.close();
    }

    @Override
    public void close() {
        this.maybeUnregisterObserverProxy();
        this.mCursor.close();
    }

    @Override
    public int count() {
        return this.mCursor.getCount();
    }

    @Override
    public void deactivate() {
        this.maybeUnregisterObserverProxy();
        this.mCursor.deactivate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteRow(int n) {
        if (this.mReadOnly) {
            StringBuilder stringBuilder = new StringBuilder().append("Permission Denial: modifying ");
            String string2 = this.mProviderName;
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" from pid=");
            int n2 = Binder.getCallingPid();
            StringBuilder stringBuilder3 = stringBuilder2.append(n2).append(", uid=");
            int n3 = Binder.getCallingUid();
            String string3 = stringBuilder3.append(n3).toString();
            int n4 = Log.w("ContentProvider", string3);
            return false;
        }
        if (this.mCursor.moveToPosition(n)) return this.mCursor.deleteRow();
        return false;
    }

    @Override
    public String[] getColumnNames() {
        return this.mCursor.getColumnNames();
    }

    @Override
    public Bundle getExtras() {
        return this.mCursor.getExtras();
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return this.mCursor.getWantsAllOnMoveCalls();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CursorWindow getWindow(int n) {
        boolean bl = this.mCursor.moveToPosition(n);
        if (this.mWindow == null) return ((AbstractWindowedCursor)this.mCursor).getWindow();
        int n2 = this.mWindow.getStartPosition();
        if (n >= n2) {
            int n3;
            int n4 = this.mWindow.getStartPosition();
            int n5 = n4 + (n3 = this.mWindow.getNumRows());
            if (n < n5) return this.mWindow;
        }
        CrossProcessCursor crossProcessCursor = this.mCursor;
        CursorWindow cursorWindow = this.mWindow;
        crossProcessCursor.fillWindow(n, cursorWindow);
        return this.mWindow;
    }

    @Override
    public void onMove(int n) {
        CrossProcessCursor crossProcessCursor = this.mCursor;
        int n2 = this.mCursor.getPosition();
        boolean bl = crossProcessCursor.onMove(n2, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int requery(IContentObserver iContentObserver, CursorWindow cursorWindow) {
        if (this.mWindow == null) {
            ((AbstractWindowedCursor)this.mCursor).setWindow(cursorWindow);
        }
        try {
            boolean bl = this.mCursor.requery();
            if (!bl) {
                return -1;
            }
        }
        catch (IllegalStateException illegalStateException) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = this.mProviderName;
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" Requery misuse db, mCursor isClosed:");
            boolean bl = this.mCursor.isClosed();
            String string3 = stringBuilder2.append(bl).toString();
            throw new IllegalStateException(string3, illegalStateException);
        }
        if (this.mWindow != null) {
            this.mCursor.fillWindow(0, cursorWindow);
            this.mWindow = cursorWindow;
        }
        this.maybeUnregisterObserverProxy();
        this.createAndRegisterObserverProxy(iContentObserver);
        return this.mCursor.getCount();
    }

    @Override
    public Bundle respond(Bundle bundle) {
        return this.mCursor.respond(bundle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean updateRows(Map<? extends Long, ? extends Map<String, Object>> map) {
        if (!this.mReadOnly) return this.mCursor.commitUpdates(map);
        StringBuilder stringBuilder = new StringBuilder().append("Permission Denial: modifying ");
        String string2 = this.mProviderName;
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" from pid=");
        int n = Binder.getCallingPid();
        StringBuilder stringBuilder3 = stringBuilder2.append(n).append(", uid=");
        int n2 = Binder.getCallingUid();
        String string3 = stringBuilder3.append(n2).toString();
        int n3 = Log.w("ContentProvider", string3);
        return false;
    }

    private static final class ContentObserverProxy
    extends ContentObserver {
        protected IContentObserver mRemote;

        public ContentObserverProxy(IContentObserver iContentObserver, IBinder.DeathRecipient deathRecipient) {
            super(null);
            this.mRemote = iContentObserver;
            try {
                iContentObserver.asBinder().linkToDeath(deathRecipient, 0);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean bl) {
            try {
                this.mRemote.onChange(bl);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient) {
            return this.mRemote.asBinder().unlinkToDeath(deathRecipient, 0);
        }
    }
}

