/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.CharArrayBuffer;
import android.database.sqlite.SQLiteClosable;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;

public class CursorWindow
extends SQLiteClosable
implements Parcelable {
    public static final Parcelable.Creator<CursorWindow> CREATOR = new Parcelable.Creator<CursorWindow>(){

        @Override
        public CursorWindow createFromParcel(Parcel parcel) {
            return new CursorWindow(parcel);
        }

        public CursorWindow[] newArray(int n) {
            return new CursorWindow[n];
        }
    };
    private int mStartPos;
    private int nWindow;

    private CursorWindow(Parcel parcel) {
        int n;
        IBinder iBinder = parcel.readStrongBinder();
        this.mStartPos = n = parcel.readInt();
        this.native_init(iBinder);
    }

    public CursorWindow(boolean bl) {
        this.mStartPos = 0;
        this.native_init(bl);
    }

    private native boolean allocRow_native();

    private native void close_native();

    private native char[] copyStringToBuffer_native(int var1, int var2, int var3, CharArrayBuffer var4);

    private native void freeLastRow_native();

    private native byte[] getBlob_native(int var1, int var2);

    private native double getDouble_native(int var1, int var2);

    private native long getLong_native(int var1, int var2);

    private native int getNumRows_native();

    private native String getString_native(int var1, int var2);

    private native boolean isBlob_native(int var1, int var2);

    private native boolean isFloat_native(int var1, int var2);

    private native boolean isInteger_native(int var1, int var2);

    private native boolean isNull_native(int var1, int var2);

    private native boolean isString_native(int var1, int var2);

    private native void native_clear();

    private native IBinder native_getBinder();

    private native void native_init(IBinder var1);

    private native void native_init(boolean var1);

    public static CursorWindow newFromParcel(Parcel parcel) {
        return CREATOR.createFromParcel(parcel);
    }

    private native boolean putBlob_native(byte[] var1, int var2, int var3);

    private native boolean putDouble_native(double var1, int var3, int var4);

    private native boolean putLong_native(long var1, int var3, int var4);

    private native boolean putNull_native(int var1, int var2);

    private native boolean putString_native(String var1, int var2, int var3);

    private native boolean setNumColumns_native(int var1);

    public boolean allocRow() {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            bl = bl2 = this.allocRow_native();
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public void clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            this.native_clear();
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void close() {
        this.releaseReference();
    }

    public void copyStringToBuffer(int n, int n2, CharArrayBuffer charArrayBuffer) {
        if (charArrayBuffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        if (charArrayBuffer.data == null) {
            char[] cArray = new char[64];
            charArrayBuffer.data = cArray;
        }
        this.acquireReference();
        try {
            int n3 = this.mStartPos;
            int n4 = n - n3;
            int n5 = charArrayBuffer.data.length;
            char[] cArray = this.copyStringToBuffer_native(n4, n2, n5, charArrayBuffer);
            if (cArray != null) {
                charArrayBuffer.data = cArray;
            }
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected void finalize() {
        this.close_native();
    }

    public void freeLastRow() {
        this.acquireReference();
        try {
            this.freeLastRow_native();
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public byte[] getBlob(int n, int n2) {
        byte[] byArray;
        this.acquireReference();
        try {
            byte[] byArray2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            byArray = byArray2 = this.getBlob_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return byArray;
    }

    public double getDouble(int n, int n2) {
        double d;
        this.acquireReference();
        try {
            double d2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            d = d2 = this.getDouble_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return d;
    }

    public float getFloat(int n, int n2) {
        double d;
        this.acquireReference();
        try {
            int n3 = this.mStartPos;
            int n4 = n - n3;
            d = this.getDouble_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        float f = (float)d;
        this.releaseReference();
        return f;
    }

    public int getInt(int n, int n2) {
        long l;
        this.acquireReference();
        try {
            int n3 = this.mStartPos;
            int n4 = n - n3;
            l = this.getLong_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        int n5 = (int)l;
        this.releaseReference();
        return n5;
    }

    public long getLong(int n, int n2) {
        long l;
        this.acquireReference();
        try {
            long l2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            l = l2 = this.getLong_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return l;
    }

    public int getNumRows() {
        int n;
        this.acquireReference();
        try {
            int n2;
            n = n2 = this.getNumRows_native();
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return n;
    }

    public short getShort(int n, int n2) {
        long l;
        this.acquireReference();
        try {
            int n3 = this.mStartPos;
            int n4 = n - n3;
            l = this.getLong_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        short s = (short)l;
        this.releaseReference();
        return s;
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public String getString(int n, int n2) {
        String string2;
        this.acquireReference();
        try {
            String string3;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            string2 = string3 = this.getString_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return string2;
    }

    public boolean isBlob(int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.isBlob_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean isFloat(int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.isFloat_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean isLong(int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.isInteger_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean isNull(int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.isNull_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean isString(int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.isString_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    @Override
    protected void onAllReferencesReleased() {
        this.close_native();
    }

    public boolean putBlob(byte[] byArray, int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.putBlob_native(byArray, n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean putDouble(double d, int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.putDouble_native(d, n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean putLong(long l, int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.putLong_native(l, n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean putNull(int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.putNull_native(n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean putString(String string2, int n, int n2) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            int n3 = this.mStartPos;
            int n4 = n - n3;
            bl = bl2 = this.putString_native(string2, n4, n2);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public boolean setNumColumns(int n) {
        boolean bl;
        this.acquireReference();
        try {
            boolean bl2;
            bl = bl2 = this.setNumColumns_native(n);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return bl;
    }

    public void setStartPosition(int n) {
        this.mStartPos = n;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        IBinder iBinder = this.native_getBinder();
        parcel.writeStrongBinder(iBinder);
        int n2 = this.mStartPos;
        parcel.writeInt(n2);
    }
}

