/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class DatabaseUtils {
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final String TAG = "DatabaseUtils";
    private static final String[] countProjection;
    private static Collator mColl;

    static {
        String[] stringArray = new String[]{"count(*)"};
        countProjection = stringArray;
        mColl = null;
    }

    public static void appendEscapedSQLString(StringBuilder stringBuilder, String string2) {
        StringBuilder stringBuilder2 = stringBuilder.append('\'');
        if (string2.indexOf(39) != -1) {
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c == '\'') {
                    StringBuilder stringBuilder3 = stringBuilder.append('\'');
                }
                StringBuilder stringBuilder4 = stringBuilder.append(c);
            }
        } else {
            StringBuilder stringBuilder5 = stringBuilder.append(string2);
        }
        StringBuilder stringBuilder6 = stringBuilder.append('\'');
    }

    public static final void appendValueToSql(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            StringBuilder stringBuilder2 = stringBuilder.append("NULL");
            return;
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                StringBuilder stringBuilder3 = stringBuilder.append('1');
                return;
            }
            StringBuilder stringBuilder4 = stringBuilder.append('0');
            return;
        }
        String string2 = object.toString();
        DatabaseUtils.appendEscapedSQLString(stringBuilder, string2);
    }

    public static void bindObjectToProgram(SQLiteProgram sQLiteProgram, int n, Object object) {
        if (object == null) {
            sQLiteProgram.bindNull(n);
            return;
        }
        if (object instanceof Double || object instanceof Float) {
            double d = ((Number)object).doubleValue();
            sQLiteProgram.bindDouble(n, d);
            return;
        }
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            sQLiteProgram.bindLong(n, l);
            return;
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                sQLiteProgram.bindLong(n, 1L);
                return;
            }
            sQLiteProgram.bindLong(n, 0L);
            return;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            sQLiteProgram.bindBlob(n, byArray);
            return;
        }
        String string2 = object.toString();
        sQLiteProgram.bindString(n, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String concatenateWhere(String string2, String string3) {
        if (TextUtils.isEmpty(string2)) {
            return string3;
        }
        if (!TextUtils.isEmpty(string3)) return "(" + string2 + ") AND (" + string3 + ")";
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void createDbFromSqlStatements(Context context, String string2, int n, String string3) {
        SQLiteDatabase sQLiteDatabase = context.openOrCreateDatabase(string2, 0, null);
        String[] stringArray = TextUtils.split(string3, ";\n");
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                sQLiteDatabase.setVersion(n);
                sQLiteDatabase.close();
                return;
            }
            String string4 = stringArray[n3];
            if (!TextUtils.isEmpty(string4)) {
                sQLiteDatabase.execSQL(string4);
            }
            ++n3;
        }
    }

    public static void cursorDoubleToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        int n = cursor.getColumnIndex(string2);
        if (!cursor.isNull(n)) {
            Double d = cursor.getDouble(n);
            contentValues.put(string3, d);
            return;
        }
        Double d = null;
        contentValues.put(string3, d);
    }

    public static void cursorDoubleToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndexOrThrow(string2);
        if (cursor.isNull(n)) {
            return;
        }
        Double d = cursor.getDouble(n);
        contentValues.put(string2, d);
    }

    public static void cursorDoubleToCursorValues(Cursor cursor, String string2, ContentValues contentValues) {
        DatabaseUtils.cursorDoubleToContentValues(cursor, string2, contentValues, string2);
    }

    public static void cursorFloatToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndexOrThrow(string2);
        if (cursor.isNull(n)) {
            return;
        }
        Float f = Float.valueOf(cursor.getFloat(n));
        contentValues.put(string2, f);
    }

    public static void cursorIntToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        DatabaseUtils.cursorIntToContentValues(cursor, string2, contentValues, string2);
    }

    public static void cursorIntToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        int n = cursor.getColumnIndex(string2);
        if (!cursor.isNull(n)) {
            Integer n2 = cursor.getInt(n);
            contentValues.put(string3, n2);
            return;
        }
        Integer n3 = null;
        contentValues.put(string3, n3);
    }

    public static void cursorIntToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndexOrThrow(string2);
        if (cursor.isNull(n)) {
            return;
        }
        Integer n2 = cursor.getInt(n);
        contentValues.put(string2, n2);
    }

    public static void cursorLongToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        DatabaseUtils.cursorLongToContentValues(cursor, string2, contentValues, string2);
    }

    public static void cursorLongToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        int n = cursor.getColumnIndex(string2);
        if (!cursor.isNull(n)) {
            Long l = cursor.getLong(n);
            contentValues.put(string3, l);
            return;
        }
        Long l = null;
        contentValues.put(string3, l);
    }

    public static void cursorLongToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndexOrThrow(string2);
        if (cursor.isNull(n)) {
            return;
        }
        Long l = cursor.getLong(n);
        contentValues.put(string2, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void cursorRowToContentValues(Cursor cursor, ContentValues contentValues) {
        AbstractWindowedCursor abstractWindowedCursor = cursor instanceof AbstractWindowedCursor ? (AbstractWindowedCursor)cursor : null;
        String[] stringArray = cursor.getColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (abstractWindowedCursor != null && abstractWindowedCursor.isBlob(n2)) {
                String string2 = stringArray[n2];
                byte[] byArray = cursor.getBlob(n2);
                contentValues.put(string2, byArray);
            } else {
                String string3 = stringArray[n2];
                String string4 = cursor.getString(n2);
                contentValues.put(string3, string4);
            }
            ++n2;
        }
        return;
    }

    public static void cursorShortToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndexOrThrow(string2);
        if (cursor.isNull(n)) {
            return;
        }
        Short s = cursor.getShort(n);
        contentValues.put(string2, s);
    }

    public static void cursorStringToContentValues(Cursor cursor, String string2, ContentValues contentValues) {
        DatabaseUtils.cursorStringToContentValues(cursor, string2, contentValues, string2);
    }

    public static void cursorStringToContentValues(Cursor cursor, String string2, ContentValues contentValues, String string3) {
        int n = cursor.getColumnIndexOrThrow(string2);
        String string4 = cursor.getString(n);
        contentValues.put(string3, string4);
    }

    public static void cursorStringToContentValuesIfPresent(Cursor cursor, ContentValues contentValues, String string2) {
        int n = cursor.getColumnIndexOrThrow(string2);
        if (cursor.isNull(n)) {
            return;
        }
        String string3 = cursor.getString(n);
        contentValues.put(string2, string3);
    }

    public static void cursorStringToInsertHelper(Cursor cursor, String string2, InsertHelper insertHelper, int n) {
        int n2 = cursor.getColumnIndexOrThrow(string2);
        String string3 = cursor.getString(n2);
        insertHelper.bind(n, string3);
    }

    public static void dumpCurrentRow(Cursor cursor) {
        PrintStream printStream = System.out;
        DatabaseUtils.dumpCurrentRow(cursor, printStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpCurrentRow(Cursor cursor, PrintStream printStream) {
        String[] stringArray = cursor.getColumnNames();
        StringBuilder stringBuilder = new StringBuilder().append("");
        int n = cursor.getPosition();
        String string2 = stringBuilder.append(n).append(" {").toString();
        printStream.println(string2);
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            String string3;
            if (n3 >= n2) {
                printStream.println("}");
                return;
            }
            try {
                String string4;
                string3 = string4 = cursor.getString(n3);
            }
            catch (SQLiteException sQLiteException) {
                string3 = "<unprintable>";
            }
            StringBuilder stringBuilder2 = new StringBuilder().append("   ");
            String string5 = stringArray[n3];
            String string6 = stringBuilder2.append(string5).append('=').append(string3).toString();
            printStream.println(string6);
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpCurrentRow(Cursor cursor, StringBuilder stringBuilder) {
        String[] stringArray = cursor.getColumnNames();
        StringBuilder stringBuilder2 = new StringBuilder().append("");
        int n = cursor.getPosition();
        String string2 = stringBuilder2.append(n).append(" {\n").toString();
        StringBuilder stringBuilder3 = stringBuilder.append(string2);
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            String string3;
            if (n3 >= n2) {
                StringBuilder stringBuilder4 = stringBuilder.append("}\n");
                return;
            }
            try {
                String string4;
                string3 = string4 = cursor.getString(n3);
            }
            catch (SQLiteException sQLiteException) {
                string3 = "<unprintable>";
            }
            StringBuilder stringBuilder5 = new StringBuilder().append("   ");
            String string5 = stringArray[n3];
            String string6 = stringBuilder5.append(string5).append('=').append(string3).append("\n").toString();
            StringBuilder stringBuilder6 = stringBuilder.append(string6);
            ++n3;
        }
    }

    public static String dumpCurrentRowToString(Cursor cursor) {
        StringBuilder stringBuilder = new StringBuilder();
        DatabaseUtils.dumpCurrentRow(cursor, stringBuilder);
        return stringBuilder.toString();
    }

    public static void dumpCursor(Cursor cursor) {
        PrintStream printStream = System.out;
        DatabaseUtils.dumpCursor(cursor, printStream);
    }

    public static void dumpCursor(Cursor cursor, PrintStream printStream) {
        String string2 = ">>>>> Dumping cursor " + cursor;
        printStream.println(string2);
        if (cursor != null) {
            int n = cursor.getPosition();
            boolean bl = cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                DatabaseUtils.dumpCurrentRow(cursor, printStream);
            }
            boolean bl2 = cursor.moveToPosition(n);
        }
        printStream.println("<<<<<");
    }

    public static void dumpCursor(Cursor cursor, StringBuilder stringBuilder) {
        String string2 = ">>>>> Dumping cursor " + cursor + "\n";
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        if (cursor != null) {
            int n = cursor.getPosition();
            boolean bl = cursor.moveToPosition(-1);
            while (cursor.moveToNext()) {
                DatabaseUtils.dumpCurrentRow(cursor, stringBuilder);
            }
            boolean bl2 = cursor.moveToPosition(n);
        }
        StringBuilder stringBuilder3 = stringBuilder.append("<<<<<\n");
    }

    public static String dumpCursorToString(Cursor cursor) {
        StringBuilder stringBuilder = new StringBuilder();
        DatabaseUtils.dumpCursor(cursor, stringBuilder);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCollationKey(String string2) {
        byte[] byArray = DatabaseUtils.getCollationKeyInBytes(string2);
        try {
            int n = DatabaseUtils.getKeyLen(byArray);
            return new String(byArray, 0, n, "ISO8859_1");
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static byte[] getCollationKeyInBytes(String string2) {
        if (mColl == null) {
            mColl = Collator.getInstance();
            mColl.setStrength(0);
        }
        return mColl.getCollationKey(string2).toByteArray();
    }

    public static String getHexCollationKey(String string2) {
        byte[] byArray = DatabaseUtils.getCollationKeyInBytes(string2);
        char[] cArray = Hex.encodeHex((byte[])byArray);
        int n = DatabaseUtils.getKeyLen(byArray) * 2;
        return new String(cArray, 0, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getKeyLen(byte[] byArray) {
        int n = byArray.length - 1;
        if (byArray[n] == null) return byArray.length - 1;
        return byArray.length;
    }

    public static long longForQuery(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        long l;
        SQLiteStatement sQLiteStatement = sQLiteDatabase.compileStatement(string2);
        try {
            long l2;
            l = l2 = DatabaseUtils.longForQuery(sQLiteStatement, stringArray);
        }
        catch (Throwable throwable) {
            sQLiteStatement.close();
            throw throwable;
        }
        sQLiteStatement.close();
        return l;
    }

    public static long longForQuery(SQLiteStatement sQLiteStatement, String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = i + 1;
                String string2 = stringArray[i];
                DatabaseUtils.bindObjectToProgram(sQLiteStatement, n2, string2);
            }
        }
        return sQLiteStatement.simpleQueryForLong();
    }

    public static long queryNumEntries(SQLiteDatabase sQLiteDatabase, String string2) {
        String[] stringArray = countProjection;
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        String string3 = string2;
        String[] stringArray2 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Cursor cursor = sQLiteDatabase2.query(string3, stringArray, null, stringArray2, string4, string5, string6);
        try {
            long l;
            boolean bl = cursor.moveToFirst();
            long l2 = l = cursor.getLong(0);
            cursor.close();
            return l2;
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
    }

    public static final void readExceptionFromParcel(Parcel parcel) {
        int n = parcel.readExceptionCode();
        if (n == 0) {
            return;
        }
        String string2 = parcel.readString();
        DatabaseUtils.readExceptionFromParcel(parcel, string2, n);
    }

    private static final void readExceptionFromParcel(Parcel parcel, String string2, int n) {
        switch (n) {
            default: {
                parcel.readException(n, string2);
                return;
            }
            case 2: {
                throw new IllegalArgumentException(string2);
            }
            case 3: {
                throw new UnsupportedOperationException(string2);
            }
            case 4: {
                throw new SQLiteAbortException(string2);
            }
            case 5: {
                throw new SQLiteConstraintException(string2);
            }
            case 6: {
                throw new SQLiteDatabaseCorruptException(string2);
            }
            case 7: {
                throw new SQLiteFullException(string2);
            }
            case 8: {
                throw new SQLiteDiskIOException(string2);
            }
            case 9: 
        }
        throw new SQLiteException(string2);
    }

    public static void readExceptionWithFileNotFoundExceptionFromParcel(Parcel parcel) throws FileNotFoundException {
        int n = parcel.readExceptionCode();
        if (n == 0) {
            return;
        }
        String string2 = parcel.readString();
        if (n == 1) {
            throw new FileNotFoundException(string2);
        }
        DatabaseUtils.readExceptionFromParcel(parcel, string2, n);
    }

    public static void readExceptionWithOperationApplicationExceptionFromParcel(Parcel parcel) throws OperationApplicationException {
        int n = parcel.readExceptionCode();
        if (n == 0) {
            return;
        }
        String string2 = parcel.readString();
        if (n == 10) {
            throw new OperationApplicationException(string2);
        }
        DatabaseUtils.readExceptionFromParcel(parcel, string2, n);
    }

    public static String sqlEscapeString(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        DatabaseUtils.appendEscapedSQLString(stringBuilder, string2);
        return stringBuilder.toString();
    }

    public static String stringForQuery(SQLiteDatabase sQLiteDatabase, String string2, String[] stringArray) {
        String string3;
        SQLiteStatement sQLiteStatement = sQLiteDatabase.compileStatement(string2);
        try {
            String string4;
            string3 = string4 = DatabaseUtils.stringForQuery(sQLiteStatement, stringArray);
        }
        catch (Throwable throwable) {
            sQLiteStatement.close();
            throw throwable;
        }
        sQLiteStatement.close();
        return string3;
    }

    public static String stringForQuery(SQLiteStatement sQLiteStatement, String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = i + 1;
                String string2 = stringArray[i];
                DatabaseUtils.bindObjectToProgram(sQLiteStatement, n2, string2);
            }
        }
        return sQLiteStatement.simpleQueryForString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void writeExceptionToParcel(Parcel parcel, Exception exception) {
        int n;
        boolean bl = true;
        if (exception instanceof FileNotFoundException) {
            n = 1;
            bl = false;
        } else if (exception instanceof IllegalArgumentException) {
            n = 2;
        } else if (exception instanceof UnsupportedOperationException) {
            n = 3;
        } else if (exception instanceof SQLiteAbortException) {
            n = 4;
        } else if (exception instanceof SQLiteConstraintException) {
            n = 5;
        } else if (exception instanceof SQLiteDatabaseCorruptException) {
            n = 6;
        } else if (exception instanceof SQLiteFullException) {
            n = 7;
        } else if (exception instanceof SQLiteDiskIOException) {
            n = 8;
        } else if (exception instanceof SQLiteException) {
            n = 9;
        } else {
            if (!(exception instanceof OperationApplicationException)) {
                parcel.writeException(exception);
                int n2 = Log.e(TAG, "Writing exception to parcel", exception);
                return;
            }
            n = 10;
        }
        parcel.writeInt(n);
        String string2 = exception.getMessage();
        parcel.writeString(string2);
        if (!bl) {
            return;
        }
        int n3 = Log.e(TAG, "Writing exception to parcel", exception);
    }

    public static class InsertHelper {
        public static final int TABLE_INFO_PRAGMA_COLUMNNAME_INDEX = 1;
        public static final int TABLE_INFO_PRAGMA_DEFAULT_INDEX = 4;
        private HashMap<String, Integer> mColumns;
        private final SQLiteDatabase mDb;
        private String mInsertSQL = null;
        private SQLiteStatement mInsertStatement = null;
        private SQLiteStatement mPreparedStatement = null;
        private SQLiteStatement mReplaceStatement = null;
        private final String mTableName;

        public InsertHelper(SQLiteDatabase sQLiteDatabase, String string2) {
            this.mDb = sQLiteDatabase;
            this.mTableName = string2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void buildSQL() throws SQLException {
            String string2;
            Cursor cursor;
            StringBuilder stringBuilder = new StringBuilder(128);
            StringBuilder stringBuilder2 = stringBuilder.append("INSERT INTO ");
            String string3 = this.mTableName;
            StringBuilder stringBuilder3 = stringBuilder.append(string3);
            StringBuilder stringBuilder4 = stringBuilder.append(" (");
            StringBuilder stringBuilder5 = new StringBuilder(128);
            StringBuilder stringBuilder6 = stringBuilder5.append("VALUES (");
            int n = 1;
            try {
                SQLiteDatabase sQLiteDatabase = this.mDb;
                StringBuilder stringBuilder7 = new StringBuilder().append("PRAGMA table_info(");
                String string4 = this.mTableName;
                String string5 = stringBuilder7.append(string4).append(")").toString();
                cursor = sQLiteDatabase.rawQuery(string5, null);
                int n2 = cursor.getCount();
                HashMap hashMap = new HashMap(n2);
                this.mColumns = hashMap;
                while (cursor.moveToNext()) {
                    int n3;
                    String string6 = cursor.getString(1);
                    String string7 = cursor.getString(4);
                    HashMap<String, Integer> hashMap2 = this.mColumns;
                    Integer n4 = n;
                    Integer n5 = hashMap2.put(string6, n4);
                    StringBuilder stringBuilder8 = stringBuilder.append("'");
                    StringBuilder stringBuilder9 = stringBuilder.append(string6);
                    StringBuilder stringBuilder10 = stringBuilder.append("'");
                    if (string7 == null) {
                        StringBuilder stringBuilder11 = stringBuilder5.append("?");
                    } else {
                        StringBuilder stringBuilder12 = stringBuilder5.append("COALESCE(?, ");
                        StringBuilder stringBuilder13 = stringBuilder5.append(string7);
                        StringBuilder stringBuilder14 = stringBuilder5.append(")");
                    }
                    String string8 = n != (n3 = cursor.getCount()) ? ") " : ", ";
                    StringBuilder stringBuilder15 = stringBuilder.append(string8);
                    int n6 = cursor.getCount();
                    string8 = n != n6 ? ");" : ", ";
                    StringBuilder stringBuilder16 = stringBuilder5.append(string8);
                    ++n;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            StringBuilder stringBuilder17 = stringBuilder.append(stringBuilder5);
            this.mInsertSQL = string2 = stringBuilder.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private SQLiteStatement getStatement(boolean bl) throws SQLException {
            SQLiteStatement sQLiteStatement;
            if (bl) {
                SQLiteStatement sQLiteStatement2;
                if (this.mReplaceStatement != null) return this.mReplaceStatement;
                if (this.mInsertSQL == null) {
                    this.buildSQL();
                }
                StringBuilder stringBuilder = new StringBuilder().append("INSERT OR REPLACE");
                String string2 = this.mInsertSQL.substring(6);
                String string3 = stringBuilder.append(string2).toString();
                this.mReplaceStatement = sQLiteStatement2 = this.mDb.compileStatement(string3);
                return this.mReplaceStatement;
            }
            if (this.mInsertStatement != null) return this.mInsertStatement;
            if (this.mInsertSQL == null) {
                this.buildSQL();
            }
            SQLiteDatabase sQLiteDatabase = this.mDb;
            String string4 = this.mInsertSQL;
            this.mInsertStatement = sQLiteStatement = sQLiteDatabase.compileStatement(string4);
            return this.mInsertStatement;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long insertInternal(ContentValues contentValues, boolean bl) {
            synchronized (this) {
                try {
                    SQLiteStatement sQLiteStatement = this.getStatement(bl);
                    sQLiteStatement.clearBindings();
                    Iterator<Map.Entry<String, Object>> iterator = contentValues.valueSet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Object> entry = iterator.next();
                        String string2 = entry.getKey();
                        int n = this.getColumnIndex(string2);
                        Object object = entry.getValue();
                        DatabaseUtils.bindObjectToProgram(sQLiteStatement, n, object);
                    }
                    long l = sQLiteStatement.executeInsert();
                    return l;
                }
                catch (SQLException sQLException) {
                    StringBuilder stringBuilder = new StringBuilder().append("Error inserting ").append(contentValues).append(" into table  ");
                    String string3 = this.mTableName;
                    String string4 = stringBuilder.append(string3).toString();
                    int n = Log.e(DatabaseUtils.TAG, string4, sQLException);
                    return 65535L;
                }
            }
        }

        public void bind(int n, double d) {
            this.mPreparedStatement.bindDouble(n, d);
        }

        public void bind(int n, float f) {
            SQLiteStatement sQLiteStatement = this.mPreparedStatement;
            double d = f;
            sQLiteStatement.bindDouble(n, d);
        }

        public void bind(int n, int n2) {
            SQLiteStatement sQLiteStatement = this.mPreparedStatement;
            long l = n2;
            sQLiteStatement.bindLong(n, l);
        }

        public void bind(int n, long l) {
            this.mPreparedStatement.bindLong(n, l);
        }

        public void bind(int n, String string2) {
            if (string2 == null) {
                this.mPreparedStatement.bindNull(n);
                return;
            }
            this.mPreparedStatement.bindString(n, string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void bind(int n, boolean bl) {
            SQLiteStatement sQLiteStatement = this.mPreparedStatement;
            long l = bl ? 1L : 0L;
            sQLiteStatement.bindLong(n, l);
        }

        public void bind(int n, byte[] byArray) {
            if (byArray == null) {
                this.mPreparedStatement.bindNull(n);
                return;
            }
            this.mPreparedStatement.bindBlob(n, byArray);
        }

        public void bindNull(int n) {
            this.mPreparedStatement.bindNull(n);
        }

        public void close() {
            if (this.mInsertStatement != null) {
                this.mInsertStatement.close();
                this.mInsertStatement = null;
            }
            if (this.mReplaceStatement != null) {
                this.mReplaceStatement.close();
                this.mReplaceStatement = null;
            }
            this.mInsertSQL = null;
            this.mColumns = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long execute() {
            long l;
            if (this.mPreparedStatement == null) {
                throw new IllegalStateException("you must prepare this inserter before calling execute");
            }
            try {
                long l2;
                l = l2 = this.mPreparedStatement.executeInsert();
                this.mPreparedStatement = null;
                return l;
            }
            catch (SQLException sQLException) {
                try {
                    StringBuilder stringBuilder = new StringBuilder().append("Error executing InsertHelper with table ");
                    String string2 = this.mTableName;
                    String string3 = stringBuilder.append(string2).toString();
                    int n = Log.e(DatabaseUtils.TAG, string3, sQLException);
                    l = 65535L;
                    this.mPreparedStatement = null;
                    return l;
                }
                catch (Throwable throwable) {
                    this.mPreparedStatement = null;
                    throw throwable;
                }
            }
        }

        public int getColumnIndex(String string2) {
            SQLiteStatement sQLiteStatement = this.getStatement(false);
            Integer n = this.mColumns.get(string2);
            if (n == null) {
                String string3 = "column '" + string2 + "' is invalid";
                throw new IllegalArgumentException(string3);
            }
            return n;
        }

        public long insert(ContentValues contentValues) {
            return this.insertInternal(contentValues, false);
        }

        public void prepareForInsert() {
            SQLiteStatement sQLiteStatement;
            this.mPreparedStatement = sQLiteStatement = this.getStatement(false);
            this.mPreparedStatement.clearBindings();
        }

        public void prepareForReplace() {
            SQLiteStatement sQLiteStatement;
            this.mPreparedStatement = sQLiteStatement = this.getStatement(true);
            this.mPreparedStatement.clearBindings();
        }

        public long replace(ContentValues contentValues) {
            return this.insertInternal(contentValues, true);
        }
    }
}

