/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.CursorIndexOutOfBoundsException;
import java.util.ArrayList;

public class MatrixCursor
extends AbstractCursor {
    private final int columnCount;
    private final String[] columnNames;
    private Object[] data;
    private int rowCount = 0;

    public MatrixCursor(String[] stringArray) {
        this(stringArray, 16);
    }

    public MatrixCursor(String[] stringArray, int n) {
        int n2;
        this.columnNames = stringArray;
        this.columnCount = n2 = stringArray.length;
        if (n < 1) {
            n = 1;
        }
        Object[] objectArray = new Object[this.columnCount * n];
        this.data = objectArray;
    }

    private void addRow(ArrayList<?> arrayList, int n) {
        int n2;
        int n3;
        int n4 = arrayList.size();
        if (n4 != (n3 = this.columnCount)) {
            StringBuilder stringBuilder = new StringBuilder().append("columnNames.length = ");
            int n5 = this.columnCount;
            String string2 = stringBuilder.append(n5).append(", columnValues.size() = ").append(n4).toString();
            throw new IllegalArgumentException(string2);
        }
        this.rowCount = n2 = this.rowCount + 1;
        Object[] objectArray = this.data;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = n + n6;
            Object obj = arrayList.get(n6);
            objectArray[n7] = obj;
            ++n6;
        }
        return;
    }

    private void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        Object[] objectArray = this.data;
        int n3 = this.data.length * 2;
        if (n3 < n) {
            n3 = n;
        }
        Object[] objectArray2 = new Object[n3];
        Object[] objectArray3 = this.data = objectArray2;
        int n4 = objectArray.length;
        System.arraycopy(objectArray, 0, objectArray3, 0, n4);
    }

    private Object get(int n) {
        int n2;
        if (n < 0 || n >= (n2 = this.columnCount)) {
            StringBuilder stringBuilder = new StringBuilder().append("Requested column: ").append(n).append(", # of columns: ");
            int n3 = this.columnCount;
            String string2 = stringBuilder.append(n3).toString();
            throw new CursorIndexOutOfBoundsException(string2);
        }
        if (this.mPos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first row.");
        }
        int n4 = this.mPos;
        int n5 = this.rowCount;
        if (n4 >= n5) {
            throw new CursorIndexOutOfBoundsException("After last row.");
        }
        Object[] objectArray = this.data;
        int n6 = this.mPos;
        int n7 = this.columnCount;
        int n8 = n6 * n7 + n;
        return objectArray[n8];
    }

    public void addRow(Iterable<?> iterable) {
        int n;
        int n2 = this.rowCount;
        int n3 = this.columnCount;
        int n4 = n2 * n3;
        int n5 = this.columnCount;
        int n6 = n4 + n5;
        this.ensureCapacity(n6);
        if (iterable instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)iterable;
            this.addRow(arrayList, n4);
            return;
        }
        int n7 = n4;
        Object[] objectArray = this.data;
        for (Object obj : iterable) {
            if (n7 != n6) {
                throw new IllegalArgumentException("columnValues.size() > columnNames.length");
            }
            int n8 = n7 + 1;
            objectArray[n7] = obj;
            n7 = n8;
        }
        if (n7 != n6) {
            throw new IllegalArgumentException("columnValues.size() < columnNames.length");
        }
        this.rowCount = n = this.rowCount + 1;
    }

    public void addRow(Object[] objectArray) {
        int n;
        int n2 = objectArray.length;
        int n3 = this.columnCount;
        if (n2 != n3) {
            StringBuilder stringBuilder = new StringBuilder().append("columnNames.length = ");
            int n4 = this.columnCount;
            StringBuilder stringBuilder2 = stringBuilder.append(n4).append(", columnValues.length = ");
            int n5 = objectArray.length;
            String string2 = stringBuilder2.append(n5).toString();
            throw new IllegalArgumentException(string2);
        }
        int n6 = this.rowCount;
        this.rowCount = n = n6 + 1;
        int n7 = this.columnCount;
        int n8 = n6 * n7;
        int n9 = this.columnCount + n8;
        this.ensureCapacity(n9);
        Object[] objectArray2 = this.data;
        int n10 = this.columnCount;
        System.arraycopy(objectArray, 0, objectArray2, n8, n10);
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getCount() {
        return this.rowCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double getDouble(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0.0;
        }
        if (!(object instanceof Number)) return Double.parseDouble(object.toString());
        return ((Number)object).doubleValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float getFloat(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0.0f;
        }
        if (!(object instanceof Number)) return Float.parseFloat(object.toString());
        return ((Number)object).floatValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getInt(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Number)) return Integer.parseInt(object.toString());
        return ((Number)object).intValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getLong(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0L;
        }
        if (!(object instanceof Number)) return Long.parseLong(object.toString());
        return ((Number)object).longValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public short getShort(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Number)) return Short.parseShort(object.toString());
        return ((Number)object).shortValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getString(int n) {
        Object object = this.get(n);
        if (object != null) return object.toString();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNull(int n) {
        if (this.get(n) != null) return false;
        return true;
    }

    public RowBuilder newRow() {
        int n;
        int n2 = this.rowCount = (n = this.rowCount + 1);
        int n3 = this.columnCount;
        int n4 = n2 * n3;
        this.ensureCapacity(n4);
        int n5 = this.columnCount;
        int n6 = n4 - n5;
        return new RowBuilder(n6, n4);
    }

    public class RowBuilder {
        private final int endIndex;
        private int index;

        RowBuilder(int n, int n2) {
            this.index = n;
            this.endIndex = n2;
        }

        public RowBuilder add(Object object) {
            int n;
            int n2 = this.index;
            int n3 = this.endIndex;
            if (n2 != n3) {
                throw new CursorIndexOutOfBoundsException("No more columns left.");
            }
            Object[] objectArray = MatrixCursor.this.data;
            int n4 = this.index;
            this.index = n = n4 + 1;
            objectArray[n4] = object;
            return this;
        }
    }
}

