/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;

public class MergeCursor
extends AbstractCursor {
    private Cursor mCursor;
    private Cursor[] mCursors;
    private DataSetObserver mObserver;

    /*
     * Enabled aggressive block sorting
     */
    public MergeCursor(Cursor[] cursorArray) {
        Cursor cursor;
        DataSetObserver dataSetObserver;
        this.mObserver = dataSetObserver = new DataSetObserver(){

            @Override
            public void onChanged() {
                MergeCursor.this.mPos = -1;
            }

            @Override
            public void onInvalidated() {
                MergeCursor.this.mPos = -1;
            }
        };
        this.mCursors = cursorArray;
        this.mCursor = cursor = cursorArray[0];
        int n = 0;
        int n2;
        while (n < (n2 = this.mCursors.length)) {
            if (this.mCursors[n] != null) {
                Cursor cursor2 = this.mCursors[n];
                DataSetObserver dataSetObserver2 = this.mObserver;
                cursor2.registerDataSetObserver(dataSetObserver2);
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void close() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                super.close();
                return;
            }
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].close();
            }
            ++n2;
        }
    }

    @Override
    public boolean commitUpdates() {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            boolean bl = this.mCursors[i].commitUpdates();
        }
        this.onChange(true);
        return true;
    }

    @Override
    public void deactivate() {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].deactivate();
        }
        super.deactivate();
    }

    @Override
    public boolean deleteRow() {
        return this.mCursor.deleteRow();
    }

    @Override
    public byte[] getBlob(int n) {
        return this.mCursor.getBlob(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getColumnNames() {
        if (this.mCursor == null) return new String[0];
        return this.mCursor.getColumnNames();
    }

    @Override
    public int getCount() {
        int n = 0;
        int n2 = this.mCursors.length;
        for (int i = 0; i < n2; ++i) {
            if (this.mCursors[i] == null) continue;
            int n3 = this.mCursors[i].getCount();
            n += n3;
        }
        return n;
    }

    @Override
    public double getDouble(int n) {
        return this.mCursor.getDouble(n);
    }

    @Override
    public float getFloat(int n) {
        return this.mCursor.getFloat(n);
    }

    @Override
    public int getInt(int n) {
        return this.mCursor.getInt(n);
    }

    @Override
    public long getLong(int n) {
        return this.mCursor.getLong(n);
    }

    @Override
    public short getShort(int n) {
        return this.mCursor.getShort(n);
    }

    @Override
    public String getString(int n) {
        return this.mCursor.getString(n);
    }

    @Override
    public boolean isNull(int n) {
        return this.mCursor.isNull(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onMove(int n, int n2) {
        this.mCursor = null;
        int n3 = 0;
        int n4 = this.mCursors.length;
        for (int i = 0; i < n4; ++i) {
            if (this.mCursors[i] == null) continue;
            int n5 = this.mCursors[i].getCount() + n3;
            if (n2 < n5) {
                Cursor cursor;
                this.mCursor = cursor = this.mCursors[i];
                break;
            }
            int n6 = this.mCursors[i].getCount();
            n3 += n6;
        }
        if (this.mCursor == null) return false;
        Cursor cursor = this.mCursor;
        int n7 = n2 - n3;
        return cursor.moveToPosition(n7);
    }

    @Override
    public void registerContentObserver(ContentObserver contentObserver) {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].registerContentObserver(contentObserver);
            }
            ++n2;
        }
        return;
    }

    @Override
    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].registerDataSetObserver(dataSetObserver);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requery() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null && !this.mCursors[n2].requery()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void unregisterContentObserver(ContentObserver contentObserver) {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].unregisterContentObserver(contentObserver);
            }
            ++n2;
        }
        return;
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].unregisterDataSetObserver(dataSetObserver);
            }
            ++n2;
        }
        return;
    }
}

