/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import java.util.ArrayList;

public abstract class Observable<T> {
    protected final ArrayList<T> mObservers;

    public Observable() {
        ArrayList arrayList = new ArrayList();
        this.mObservers = arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerObserver(T t) {
        if (t == null) {
            throw new IllegalArgumentException("The observer is null.");
        }
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            if (this.mObservers.contains(t)) {
                String string2 = "Observer " + t + " is already registered.";
                throw new IllegalStateException(string2);
            }
            boolean bl = this.mObservers.add(t);
            return;
        }
    }

    public void unregisterAll() {
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            this.mObservers.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterObserver(T t) {
        if (t == null) {
            throw new IllegalArgumentException("The observer is null.");
        }
        ArrayList<T> arrayList = this.mObservers;
        synchronized (arrayList) {
            int n = this.mObservers.indexOf(t);
            if (n == -1) {
                String string2 = "Observer " + t + " was not registered.";
                throw new IllegalStateException(string2);
            }
            T t2 = this.mObservers.remove(n);
            return;
        }
    }
}

