/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.CursorWindow;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteStatement;

public abstract class SQLiteClosable {
    private Object mLock;
    private int mReferenceCount = 1;

    public SQLiteClosable() {
        Object object;
        this.mLock = object = new Object();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getObjInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getClass().getName();
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        StringBuilder stringBuilder3 = stringBuilder.append(" (");
        if (this instanceof SQLiteDatabase) {
            StringBuilder stringBuilder4 = stringBuilder.append("database = ");
            String string3 = ((SQLiteDatabase)this).getPath();
            StringBuilder stringBuilder5 = stringBuilder.append(string3);
        } else if (this instanceof SQLiteProgram || this instanceof SQLiteStatement || this instanceof SQLiteQuery) {
            StringBuilder stringBuilder6 = stringBuilder.append("mSql = ");
            String string4 = ((SQLiteProgram)this).mSql;
            StringBuilder stringBuilder7 = stringBuilder.append(string4);
        } else if (this instanceof CursorWindow) {
            StringBuilder stringBuilder8 = stringBuilder.append("mStartPos = ");
            int n = ((CursorWindow)this).getStartPosition();
            StringBuilder stringBuilder9 = stringBuilder.append(n);
        }
        StringBuilder stringBuilder10 = stringBuilder.append(") ");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquireReference() {
        Object object = this.mLock;
        synchronized (object) {
            int n;
            if (this.mReferenceCount <= 0) {
                StringBuilder stringBuilder = new StringBuilder().append("attempt to re-open an already-closed object: ");
                String string2 = this.getObjInfo();
                String string3 = stringBuilder.append(string2).toString();
                throw new IllegalStateException(string3);
            }
            this.mReferenceCount = n = this.mReferenceCount + 1;
            return;
        }
    }

    protected abstract void onAllReferencesReleased();

    protected void onAllReferencesReleasedFromContainer() {
    }

    public void releaseReference() {
        Object object = this.mLock;
        synchronized (object) {
            int n;
            this.mReferenceCount = n = this.mReferenceCount - 1;
            if (this.mReferenceCount == 0) {
                this.onAllReferencesReleased();
            }
            return;
        }
    }

    public void releaseReferenceFromContainer() {
        Object object = this.mLock;
        synchronized (object) {
            int n;
            this.mReferenceCount = n = this.mReferenceCount - 1;
            if (this.mReferenceCount == 0) {
                this.onAllReferencesReleasedFromContainer();
            }
            return;
        }
    }
}

