/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.os.StrictMode;
import android.util.Log;

class SQLiteCompiledSql {
    private static final String TAG = "SQLiteCompiledSql";
    SQLiteDatabase mDatabase;
    private boolean mInUse = false;
    private String mSqlStmt = null;
    private Throwable mStackTrace = null;
    int nHandle = 0;
    int nStatement = 0;

    SQLiteCompiledSql(SQLiteDatabase sQLiteDatabase, String string2) {
        int n;
        Throwable throwable;
        if (!sQLiteDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string3 = sQLiteDatabase.getPath();
            String string4 = stringBuilder.append(string3).append(" already closed").toString();
            throw new IllegalStateException(string4);
        }
        this.mDatabase = sQLiteDatabase;
        this.mSqlStmt = string2;
        this.mStackTrace = throwable = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.nHandle = n = sQLiteDatabase.mNativeHandle;
        this.compile(string2, true);
    }

    private void compile(String string2, boolean bl) {
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string3 = this.mDatabase.getPath();
            String string4 = stringBuilder.append(string3).append(" already closed").toString();
            throw new IllegalStateException(string4);
        }
        if (!bl) {
            return;
        }
        this.mDatabase.lock();
        try {
            this.native_compile(string2);
            return;
        }
        finally {
            this.mDatabase.unlock();
        }
    }

    private final native void native_compile(String var1);

    private final native void native_finalize();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean acquire() {
        synchronized (this) {
            boolean bl;
            block4: {
                bl = this.mInUse;
                if (!bl) break block4;
                return false;
            }
            bl = true;
            this.mInUse = bl;
            if (!SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) return true;
            StringBuilder stringBuilder = new StringBuilder().append("Acquired DbObj (id#");
            int n = this.nStatement;
            String string2 = stringBuilder.append(n).append(") from DB cache").toString();
            int n2 = Log.v(TAG, string2);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        int n = 100;
        try {
            Object object = this.nStatement;
            if (object == null) {
                return;
            }
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                StringBuilder stringBuilder = new StringBuilder().append("** warning ** Finalized DbObj (id#");
                int n2 = this.nStatement;
                String string2 = stringBuilder.append(n2).append(")").toString();
                int n3 = Log.v(TAG, string2);
            }
            if (StrictMode.vmSqliteObjectLeaksEnabled()) {
                int n4 = this.mSqlStmt.length();
                object = new StringBuilder().append("Releasing statement in a finalizer. Please ensure that you explicitly call close() on your cursor: ");
                String string3 = this.mSqlStmt;
                int n5 = 0;
                if (n4 <= 100) {
                    n = n4;
                }
                String string4 = string3.substring(n5, n);
                String string5 = ((StringBuilder)object).append(string4).toString();
                Throwable throwable = this.mStackTrace;
                StrictMode.onSqliteObjectLeaked(string5, throwable);
            }
            this.releaseSqlStatement();
            return;
        }
        finally {
            super.finalize();
        }
    }

    void release() {
        synchronized (this) {
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                StringBuilder stringBuilder = new StringBuilder().append("Released DbObj (id#");
                int n = this.nStatement;
                String string2 = stringBuilder.append(n).append(") back to DB cache").toString();
                int n2 = Log.v(TAG, string2);
            }
            this.mInUse = false;
            return;
        }
    }

    void releaseSqlStatement() {
        if (this.nStatement == 0) {
            return;
        }
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            StringBuilder stringBuilder = new StringBuilder().append("closed and deallocated DbObj (id#");
            int n = this.nStatement;
            String string2 = stringBuilder.append(n).append(")").toString();
            int n2 = Log.v(TAG, string2);
        }
        try {
            this.mDatabase.lock();
            this.native_finalize();
            this.nStatement = 0;
            return;
        }
        finally {
            this.mDatabase.unlock();
        }
    }
}

