/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.DataSetObserver;
import android.database.SQLException;
import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteQuery;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class SQLiteCursor
extends AbstractWindowedCursor {
    static final int NO_COUNT = 255;
    static final String TAG = "Cursor";
    private Map<String, Integer> mColumnNameMap;
    private String[] mColumns;
    private int mCount = -1;
    private int mCursorState = 0;
    private SQLiteDatabase mDatabase;
    private SQLiteCursorDriver mDriver;
    private String mEditTable;
    private int mInitialRead;
    private ReentrantLock mLock = null;
    private int mMaxRead = Integer.MAX_VALUE;
    protected MainThreadNotificationHandler mNotificationHandler;
    private boolean mPendingData = false;
    private SQLiteQuery mQuery;
    private Throwable mStackTrace;

    public SQLiteCursor(SQLiteDatabase sQLiteDatabase, SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
        Throwable throwable;
        this.mInitialRead = Integer.MAX_VALUE;
        this.mStackTrace = throwable = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.mDatabase = sQLiteDatabase;
        this.mDriver = sQLiteCursorDriver;
        this.mEditTable = string2;
        this.mColumnNameMap = null;
        this.mQuery = sQLiteQuery;
        try {
            sQLiteDatabase.lock();
            int n = this.mQuery.columnCountLocked();
            String[] stringArray = new String[n];
            this.mColumns = stringArray;
            for (int i = 0; i < n; ++i) {
                String string3;
                this.mColumns[i] = string3 = this.mQuery.columnNameLocked(i);
                if (!"_id".equals(string3)) continue;
                this.mRowIdColumnIndex = i;
            }
        }
        catch (Throwable throwable2) {
            sQLiteDatabase.unlock();
            throw throwable2;
        }
        sQLiteDatabase.unlock();
    }

    static /* synthetic */ boolean access$002(SQLiteCursor sQLiteCursor, boolean bl) {
        sQLiteCursor.mPendingData = bl;
        return bl;
    }

    static /* synthetic */ CursorWindow access$100(SQLiteCursor sQLiteCursor) {
        return sQLiteCursor.mWindow;
    }

    static /* synthetic */ ReentrantLock access$200(SQLiteCursor sQLiteCursor) {
        return sQLiteCursor.mLock;
    }

    static /* synthetic */ int access$300(SQLiteCursor sQLiteCursor) {
        return sQLiteCursor.mCursorState;
    }

    static /* synthetic */ int access$400(SQLiteCursor sQLiteCursor) {
        return sQLiteCursor.mMaxRead;
    }

    static /* synthetic */ int access$500(SQLiteCursor sQLiteCursor) {
        return sQLiteCursor.mCount;
    }

    static /* synthetic */ int access$502(SQLiteCursor sQLiteCursor, int n) {
        sQLiteCursor.mCount = n;
        return n;
    }

    static /* synthetic */ int access$512(SQLiteCursor sQLiteCursor, int n) {
        int n2;
        sQLiteCursor.mCount = n2 = sQLiteCursor.mCount + n;
        return n2;
    }

    static /* synthetic */ SQLiteQuery access$600(SQLiteCursor sQLiteCursor) {
        return sQLiteCursor.mQuery;
    }

    private void deactivateCommon() {
        this.mCursorState = 0;
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.close();
        this.mWindow = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillWindow(int n) {
        int n2;
        int n3;
        if (this.mWindow == null) {
            CursorWindow cursorWindow;
            this.mWindow = cursorWindow = new CursorWindow(true);
        } else {
            int n4;
            this.mCursorState = n4 = this.mCursorState + 1;
            this.queryThreadLock();
            try {
                this.mWindow.clear();
            }
            finally {
                this.queryThreadUnlock();
            }
        }
        this.mWindow.setStartPosition(n);
        SQLiteQuery sQLiteQuery = this.mQuery;
        CursorWindow cursorWindow = this.mWindow;
        int n5 = this.mInitialRead;
        this.mCount = n3 = sQLiteQuery.fillWindow(cursorWindow, n5, 0);
        if (this.mCount != -1) {
            return;
        }
        this.mCount = n2 = this.mInitialRead + n;
        int n6 = this.mCursorState;
        QueryThread queryThread = new QueryThread(n6);
        new Thread(queryThread, "query thread").start();
    }

    private void queryThreadLock() {
        if (this.mLock == null) {
            return;
        }
        this.mLock.lock();
    }

    private void queryThreadUnlock() {
        if (this.mLock == null) {
            return;
        }
        this.mLock.unlock();
    }

    @Override
    public void close() {
        super.close();
        this.deactivateCommon();
        this.mQuery.close();
        this.mDriver.cursorClosed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> map) {
        if (!this.supportsUpdates()) {
            int n = Log.e(TAG, "commitUpdates not supported on this cursor, did you include the _id column?");
            return false;
        }
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (map != null) {
                HashMap hashMap2 = this.mUpdatedRows;
                Map<? extends Long, ? extends Map<String, Object>> map2 = map;
                hashMap2.putAll(map2);
            }
            if (this.mUpdatedRows.size() == 0) {
                return true;
            }
            this.mDatabase.beginTransaction();
            try {
                StringBuilder stringBuilder = new StringBuilder(128);
                for (Map.Entry entry : this.mUpdatedRows.entrySet()) {
                    Map map3 = (Map)entry.getValue();
                    Long l = (Long)entry.getKey();
                    if (l == null || map3 == null) {
                        String string2 = "null rowId or values found! rowId = " + l + ", values = " + map3;
                        throw new IllegalStateException(string2);
                    }
                    if (map3.size() == 0) continue;
                    long l2 = l;
                    Iterator iterator = map3.entrySet().iterator();
                    stringBuilder.setLength(0);
                    StringBuilder stringBuilder2 = new StringBuilder().append("UPDATE ");
                    String string3 = this.mEditTable;
                    String string4 = stringBuilder2.append(string3).append(" SET ").toString();
                    StringBuilder stringBuilder3 = stringBuilder.append(string4);
                    Object[] objectArray = new Object[map3.size()];
                    int n = 0;
                    while (iterator.hasNext()) {
                        Map.Entry entry2 = iterator.next();
                        String string5 = (String)entry2.getKey();
                        StringBuilder stringBuilder4 = stringBuilder;
                        String string6 = string5;
                        StringBuilder stringBuilder5 = stringBuilder4.append(string6);
                        StringBuilder stringBuilder6 = stringBuilder.append("=?");
                        Object v = entry2.getValue();
                        objectArray[n] = v;
                        if (iterator.hasNext()) {
                            StringBuilder stringBuilder7 = stringBuilder.append(", ");
                        }
                        ++n;
                    }
                    StringBuilder stringBuilder8 = new StringBuilder().append(" WHERE ");
                    String[] stringArray = this.mColumns;
                    int n2 = this.mRowIdColumnIndex;
                    String string7 = stringArray[n2];
                    String string8 = stringBuilder8.append(string7).append('=').append(l2).toString();
                    StringBuilder stringBuilder9 = stringBuilder.append(string8);
                    StringBuilder stringBuilder10 = stringBuilder.append(';');
                    SQLiteDatabase sQLiteDatabase = this.mDatabase;
                    String string9 = stringBuilder.toString();
                    sQLiteDatabase.execSQL(string9, objectArray);
                    SQLiteDatabase sQLiteDatabase2 = this.mDatabase;
                    String string10 = this.mEditTable;
                    sQLiteDatabase2.rowUpdated(string10, l2);
                }
                this.mDatabase.setTransactionSuccessful();
            }
            finally {
                this.mDatabase.endTransaction();
            }
            this.mUpdatedRows.clear();
        }
        SQLiteCursor sQLiteCursor = this;
        boolean bl = true;
        sQLiteCursor.onChange(bl);
        return true;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.deactivateCommon();
        this.mDriver.cursorDeactivated();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteRow() {
        boolean bl;
        this.checkPosition();
        if (this.mRowIdColumnIndex == -1 || this.mCurrentRowID == null) {
            int n = Log.e(TAG, "Could not delete row because either the row ID column is not available or ithas not been read.");
            return false;
        }
        this.mDatabase.lock();
        try {
            SQLiteDatabase sQLiteDatabase = this.mDatabase;
            String string2 = this.mEditTable;
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = this.mColumns;
            int n = this.mRowIdColumnIndex;
            String string3 = stringArray[n];
            String string4 = stringBuilder.append(string3).append("=?").toString();
            String string5 = this.mCurrentRowID.toString();
            String[] stringArray2 = new String[]{string5};
            int n2 = sQLiteDatabase.delete(string2, string4, stringArray2);
            bl = true;
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        int n = this.mPos;
        boolean bl2 = this.requery();
        boolean bl3 = this.moveToPosition(n);
        if (!bl) return false;
        this.onChange(true);
        return true;
        finally {
            this.mDatabase.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void finalize() {
        int n = 100;
        try {
            if (this.mWindow != null) {
                if (StrictMode.vmSqliteObjectLeaksEnabled()) {
                    int n2 = this.mQuery.mSql.length();
                    StringBuilder stringBuilder = new StringBuilder().append("Finalizing a Cursor that has not been deactivated or closed. database = ");
                    String string2 = this.mDatabase.getPath();
                    StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", table = ");
                    String string3 = this.mEditTable;
                    StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(", query = ");
                    String string4 = this.mQuery.mSql;
                    int n3 = 0;
                    if (n2 <= 100) {
                        n = n2;
                    }
                    String string5 = string4.substring(n3, n);
                    String string6 = stringBuilder3.append(string5).toString();
                    Throwable throwable = this.mStackTrace;
                    StrictMode.onSqliteObjectLeaked(string6, throwable);
                }
                this.close();
                SQLiteDebug.notifyActiveCursorFinalized();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getColumnIndex(String string2) {
        Integer n;
        int n2;
        if (this.mColumnNameMap == null) {
            String[] stringArray = this.mColumns;
            int n3 = stringArray.length;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n3, 1.0f);
            for (int i = 0; i < n3; ++i) {
                String string3 = stringArray[i];
                Integer n4 = i;
                Integer n5 = hashMap.put(string3, n4);
            }
            this.mColumnNameMap = hashMap;
        }
        if ((n2 = string2.lastIndexOf(46)) != -1) {
            Exception exception = new Exception();
            String string4 = "requesting column name with table name -- " + string2;
            int n6 = Log.e(TAG, string4, exception);
            int n7 = n2 + 1;
            string2 = string2.substring(n7);
        }
        if ((n = this.mColumnNameMap.get(string2)) == null) return -1;
        return n;
    }

    @Override
    public String[] getColumnNames() {
        return this.mColumns;
    }

    @Override
    public int getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    public SQLiteDatabase getDatabase() {
        return this.mDatabase;
    }

    @Override
    public boolean onMove(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.mWindow == null || n2 < (n6 = this.mWindow.getStartPosition()) || n2 >= (n5 = (n4 = this.mWindow.getStartPosition()) + (n3 = this.mWindow.getNumRows()))) {
            this.fillWindow(n2);
        }
        return true;
    }

    @Override
    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        int n;
        super.registerDataSetObserver(dataSetObserver);
        int n2 = this.mMaxRead;
        if (Integer.MAX_VALUE != n2 && Integer.MAX_VALUE != (n = this.mInitialRead)) {
            return;
        }
        if (this.mNotificationHandler != null) {
            return;
        }
        this.queryThreadLock();
        try {
            MainThreadNotificationHandler mainThreadNotificationHandler;
            this.mNotificationHandler = mainThreadNotificationHandler = new MainThreadNotificationHandler();
            if (this.mPendingData) {
                this.notifyDataSetChange();
                this.mPendingData = false;
            }
            return;
        }
        finally {
            this.queryThreadUnlock();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requery() {
        int n;
        if (this.isClosed()) {
            return false;
        }
        this.mDatabase.lock();
        if (this.mWindow != null) {
            this.mWindow.clear();
        }
        this.mPos = -1;
        this.mDriver.cursorRequeried(this);
        this.mCount = -1;
        this.mCursorState = n = this.mCursorState + 1;
        this.queryThreadLock();
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            this.mQuery.requery();
        }
        catch (Throwable throwable) {
            this.queryThreadUnlock();
            throw throwable;
        }
        try {
            this.queryThreadUnlock();
            boolean bl = super.requery();
            return bl;
        }
        finally {
            this.mDatabase.unlock();
        }
    }

    public void setLoadStyle(int n, int n2) {
        ReentrantLock reentrantLock;
        this.mMaxRead = n2;
        this.mInitialRead = n;
        this.mLock = reentrantLock = new ReentrantLock(true);
    }

    public void setSelectionArguments(String[] stringArray) {
        this.mDriver.setBindArguments(stringArray);
    }

    @Override
    public void setWindow(CursorWindow cursorWindow) {
        if (this.mWindow != null) {
            int n;
            this.mCursorState = n = this.mCursorState + 1;
            this.queryThreadLock();
            this.mWindow.close();
            this.mCount = -1;
        }
        this.mWindow = cursorWindow;
        return;
        finally {
            this.queryThreadUnlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supportsUpdates() {
        if (!super.supportsUpdates()) return false;
        if (TextUtils.isEmpty(this.mEditTable)) return false;
        return true;
    }

    protected class MainThreadNotificationHandler
    extends Handler {
        protected MainThreadNotificationHandler() {
        }

        @Override
        public void handleMessage(Message message) {
            SQLiteCursor.this.notifyDataSetChange();
        }
    }

    private final class QueryThread
    implements Runnable {
        private final int mThreadState;

        QueryThread(int n) {
            this.mThreadState = n;
        }

        private void sendMessage() {
            if (SQLiteCursor.this.mNotificationHandler != null) {
                boolean bl = SQLiteCursor.this.mNotificationHandler.sendEmptyMessage(1);
                boolean bl2 = SQLiteCursor.access$002(SQLiteCursor.this, false);
                return;
            }
            boolean bl = SQLiteCursor.access$002(SQLiteCursor.this, true);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block7: {
                var1_1 = SQLiteCursor.access$100(SQLiteCursor.this);
                Process.setThreadPriority(Process.myTid(), 10);
                while (true) {
                    SQLiteCursor.access$200(SQLiteCursor.this).lock();
                    var2_2 = SQLiteCursor.access$300(SQLiteCursor.this);
                    var3_3 = this.mThreadState;
                    if (var2_2 != var3_3) {
                        SQLiteCursor.access$200(SQLiteCursor.this).unlock();
                        return;
                    }
                    var4_4 = SQLiteCursor.access$600(SQLiteCursor.this);
                    var5_5 = SQLiteCursor.access$400(SQLiteCursor.this);
                    var6_6 = SQLiteCursor.access$500(SQLiteCursor.this);
                    var7_7 = var4_4.fillWindow(var1_1, var5_5, var6_6);
                    if (var7_7 == 0) break block7;
                    if (var7_7 != -1) break;
                    var8_8 = SQLiteCursor.this;
                    var9_9 = SQLiteCursor.access$400(SQLiteCursor.this);
                    var10_10 = SQLiteCursor.access$512(var8_8, var9_9);
                    this.sendMessage();
                    SQLiteCursor.access$200(SQLiteCursor.this).unlock();
                    continue;
                    break;
                }
                try {
                    var11_11 = SQLiteCursor.access$502(SQLiteCursor.this, var7_7);
                    this.sendMessage();
                }
                catch (Exception var13_13) {
                    var12_12 = SQLiteCursor.access$200(SQLiteCursor.this);
                }
                catch (Throwable var14_14) {
                    SQLiteCursor.access$200(SQLiteCursor.this).unlock();
                    throw var14_14;
                }
                var12_12 = SQLiteCursor.access$200(SQLiteCursor.this);
lbl27:
                // 3 sources

                while (true) {
                    var12_12.unlock();
                    return;
                }
            }
            var12_12 = SQLiteCursor.access$200(SQLiteCursor.this);
            ** while (true)
        }
    }
}

