/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.app.AppGlobals;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCompiledSql;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteDirectCursorDriver;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.Debug;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import com.google.android.collect.Maps;
import dalvik.system.BlockGuard;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class SQLiteDatabase
extends SQLiteClosable {
    private static final String COMMIT_SQL = "COMMIT;";
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_NONE = 0;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_ROLLBACK = 1;
    private static final String[] CONFLICT_VALUES;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    private static final Pattern EMAIL_IN_DB_PATTERN;
    private static final int EVENT_DB_CORRUPT = 75004;
    private static final int EVENT_DB_OPERATION = 52000;
    static final String GET_LOCK_LOG_PREFIX = "GETLOCK:";
    private static final int LOCK_ACQUIRED_WARNING_THREAD_TIME_IN_MS = 100;
    private static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS = 300;
    private static final int LOCK_ACQUIRED_WARNING_TIME_IN_MS_ALWAYS_PRINT = 2000;
    private static final int LOCK_WARNING_WINDOW_IN_MS = 20000;
    private static final String LOG_SLOW_QUERIES_PROPERTY = "db.log.slow_query_threshold";
    public static final int MAX_SQL_CACHE_SIZE = 250;
    private static final int MAX_WARNINGS_ON_CACHESIZE_CONDITION = 1;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int OPEN_READONLY = 1;
    public static final int OPEN_READWRITE = 0;
    private static final int OPEN_READ_MASK = 1;
    private static final int QUERY_LOG_SQL_LENGTH = 64;
    private static final int SLEEP_AFTER_YIELD_QUANTUM = 1000;
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    private static final String TAG = "Database";
    private static int sQueryLogTimeInMillis;
    private int mCacheFullWarnings;
    Map<String, SQLiteCompiledSql> mCompiledQueries;
    private CursorFactory mFactory;
    private int mFlags;
    private boolean mInnerTransactionIsSuccessful;
    private long mLastLockMessageTime;
    private String mLastSqlStatement;
    private final ReentrantLock mLock;
    private long mLockAcquiredThreadTime;
    private long mLockAcquiredWallTime;
    private boolean mLockingEnabled;
    private int mMaxSqlCacheSize;
    int mNativeHandle;
    private int mNumCacheHits;
    private int mNumCacheMisses;
    private String mPath;
    private String mPathForLogs;
    private WeakHashMap<SQLiteClosable, Object> mPrograms;
    private final Random mRandom;
    private final int mSlowQueryThreshold;
    private Throwable mStackTrace;
    private final Map<String, SyncUpdateInfo> mSyncUpdateInfo;
    int mTempTableSequence;
    private String mTimeClosed;
    private String mTimeOpened;
    private boolean mTransactionIsSuccessful;
    private SQLiteTransactionListener mTransactionListener;

    static {
        String[] stringArray = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
        CONFLICT_VALUES = stringArray;
        EMAIL_IN_DB_PATTERN = Pattern.compile("[\\w\\.\\-]+@[\\w\\.\\-]+");
        sQueryLogTimeInMillis = 0;
    }

    private SQLiteDatabase(String string2, CursorFactory cursorFactory, int n) {
        Throwable throwable;
        int n2;
        Random random;
        ReentrantLock reentrantLock;
        this.mLock = reentrantLock = new ReentrantLock(true);
        this.mLockAcquiredWallTime = 0L;
        this.mLockAcquiredThreadTime = 0L;
        this.mLastLockMessageTime = 0L;
        this.mRandom = random = new Random();
        this.mLastSqlStatement = null;
        this.mNativeHandle = 0;
        this.mTempTableSequence = 0;
        this.mPathForLogs = null;
        HashMap<String, SQLiteCompiledSql> hashMap = Maps.newHashMap();
        this.mCompiledQueries = hashMap;
        this.mMaxSqlCacheSize = 250;
        this.mTimeOpened = null;
        this.mTimeClosed = null;
        this.mStackTrace = null;
        this.mLockingEnabled = true;
        HashMap<String, SyncUpdateInfo> hashMap2 = new HashMap<String, SyncUpdateInfo>();
        this.mSyncUpdateInfo = hashMap2;
        if (string2 == null) {
            throw new IllegalArgumentException("path should not be null");
        }
        this.mFlags = n;
        this.mPath = string2;
        this.mSlowQueryThreshold = n2 = SystemProperties.getInt(LOG_SLOW_QUERIES_PROPERTY, -1);
        this.mStackTrace = throwable = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.mFactory = cursorFactory;
        String string3 = this.mPath;
        int n3 = this.mFlags;
        this.dbopen(string3, n3);
        if (SQLiteDebug.DEBUG_SQL_CACHE) {
            String string4;
            this.mTimeOpened = string4 = this.getTime();
        }
        WeakHashMap weakHashMap = new WeakHashMap();
        this.mPrograms = weakHashMap;
        try {
            Locale locale = Locale.getDefault();
            this.setLocale(locale);
            return;
        }
        catch (RuntimeException runtimeException) {
            int n4 = Log.e(TAG, "Failed to setLocale() when constructing, closing the database", runtimeException);
            this.dbclose();
            if (SQLiteDebug.DEBUG_SQL_CACHE) {
                String string5;
                this.mTimeClosed = string5 = this.getTime();
            }
            throw runtimeException;
        }
    }

    private void checkLockHoldTime() {
        long l;
        long l2;
        long l3;
        long l4 = SystemClock.elapsedRealtime();
        long l5 = l4 - (l3 = this.mLockAcquiredWallTime);
        if (l5 < 2000L && !Log.isLoggable(TAG, 2) && l4 - (l2 = this.mLastLockMessageTime) < 20000L) {
            return;
        }
        if (l5 <= 300L) {
            return;
        }
        long l6 = Debug.threadCpuTimeNanos();
        int n = (int)((l6 - (l = this.mLockAcquiredThreadTime)) / 1000000L);
        if (n <= 100 && l5 <= 2000L) {
            return;
        }
        this.mLastLockMessageTime = l4;
        StringBuilder stringBuilder = new StringBuilder().append("lock held on ");
        String string2 = this.mPath;
        String string3 = stringBuilder.append(string2).append(" for ").append(l5).append("ms. Thread time was ").append(n).append("ms").toString();
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING_STACK_TRACE) {
            Exception exception = new Exception();
            int n2 = Log.d(TAG, string3, exception);
            return;
        }
        int n3 = Log.d(TAG, string3);
    }

    private void closeClosable() {
        this.deallocCachedSqlStatements();
        Iterator<Map.Entry<SQLiteClosable, Object>> iterator = this.mPrograms.entrySet().iterator();
        while (iterator.hasNext()) {
            SQLiteClosable sQLiteClosable = iterator.next().getKey();
            if (sQLiteClosable == null) continue;
            sQLiteClosable.onAllReferencesReleasedFromContainer();
        }
        return;
    }

    public static SQLiteDatabase create(CursorFactory cursorFactory) {
        return SQLiteDatabase.openDatabase(":memory:", cursorFactory, 0x10000000);
    }

    private native void dbclose();

    private native void dbopen(String var1, int var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deallocCachedSqlStatements() {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            Iterator<SQLiteCompiledSql> iterator = this.mCompiledQueries.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.mCompiledQueries.clear();
                    return;
                }
                iterator.next().releaseSqlStatement();
            }
        }
    }

    private native void enableSqlProfiling(String var1);

    private native void enableSqlTracing(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String findEditTable(String string2) {
        if (TextUtils.isEmpty(string2)) throw new IllegalStateException("Invalid tables");
        int n = string2.indexOf(32);
        int n2 = string2.indexOf(44);
        if (n > 0) {
            if (n < n2) return string2.substring(0, n);
            if (n2 < 0) {
                return string2.substring(0, n);
            }
        }
        if (n2 <= 0) return string2;
        if (n2 < n) return string2.substring(0, n2);
        if (n >= 0) return string2;
        return string2.substring(0, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<Pair<String, String>> getAttachedDbs(SQLiteDatabase sQLiteDatabase) {
        if (!sQLiteDatabase.isOpen()) {
            return null;
        }
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        Cursor cursor = sQLiteDatabase.rawQuery("pragma database_list;", null);
        while (cursor.moveToNext()) {
            String string2 = cursor.getString(1);
            String string3 = cursor.getString(2);
            Pair<String, String> pair = new Pair<String, String>(string2, string3);
            boolean bl = arrayList.add(pair);
        }
        cursor.close();
        return arrayList;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        var0 = new ArrayList<SQLiteDebug.DbStats>();
        var1_1 = ActiveDatabases.access$000(ActiveDatabases.getInstance()).iterator();
        block0: while (var1_1.hasNext()) {
            block8: {
                var2_2 = (SQLiteDatabase)((WeakReference)var1_1.next()).get();
                if (var2_2 == null || !var2_2.isOpen()) continue;
                var3_3 = var2_2.native_getDbLookaside();
                var4_4 = var2_2.getPath();
                var5_5 = var4_4.lastIndexOf("/");
                if (var5_5 != -1) {
                    var6_6 = var5_5 + 1;
lbl11:
                    // 2 sources

                    while (true) {
                        var8_7 = var4_4.substring(var6_6);
                        var9_8 = SQLiteDatabase.getAttachedDbs(var2_2);
                        if (var9_8 == null) continue block0;
                        block2: for (var10_9 = 0; var10_9 < (var11_10 = var9_8.size()); ++var10_9) {
                            var12_11 /* !! */  = var9_8.get(var10_9);
                            var13_12 = new StringBuilder();
                            var14_13 = (String)var12_11 /* !! */ .first;
                            var15_14 = var13_12.append(var14_13).append(".page_count;").toString();
                            var6_6 = (int)SQLiteDatabase.getPragmaVal(var2_2, var15_14);
                            if (var10_9 == 0) {
                                var4_4 = var8_7;
lbl23:
                                // 3 sources

                                while (true) {
                                    if (var6_6 <= 0L) continue block2;
                                    var16_15 = var2_2.getPageSize();
                                    var18_16 = new SQLiteDebug.DbStats(var4_4, var6_6, var16_15, var3_3);
                                    var19_17 = var0.add(var18_16);
                                    continue block2;
                                    break;
                                }
                            }
                            break block8;
                        }
                        continue block0;
                        break;
                    }
                }
                var6_6 = 0;
                ** continue;
            }
            var3_3 = 0;
            var20_18 = new StringBuilder().append("  (attached) ");
            var21_19 = (String)var12_11 /* !! */ .first;
            var4_4 = var20_18.append(var21_19).toString();
            if (((String)var12_11 /* !! */ .second).trim().length() <= 0) ** GOTO lbl23
            var22_20 = ((String)var12_11 /* !! */ .second).lastIndexOf("/");
            var23_21 = new StringBuilder().append(var4_4).append(" : ");
            var24_22 = (String)var12_11 /* !! */ .second;
            if (var22_20 != -1) {
                var12_11 /* !! */  = (Pair<String, String>)(var22_20 + 1);
lbl44:
                // 2 sources

                while (true) {
                    var25_23 = var24_22.substring((int)var12_11 /* !! */ );
                    var4_4 = var23_21.append(var25_23).toString();
                    ** continue;
                    break;
                }
            }
            var12_11 /* !! */  = (Pair<String, String>)false;
            ** continue;
        }
        return var0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPathForLogs() {
        String string2;
        if (this.mPathForLogs != null) {
            return this.mPathForLogs;
        }
        if (this.mPath == null) {
            return null;
        }
        if (this.mPath.indexOf(64) == -1) {
            String string3;
            this.mPathForLogs = string3 = this.mPath;
            return this.mPathForLogs;
        }
        Pattern pattern = EMAIL_IN_DB_PATTERN;
        String string4 = this.mPath;
        this.mPathForLogs = string2 = pattern.matcher(string4).replaceAll("XX@YY");
        return this.mPathForLogs;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getPragmaVal(SQLiteDatabase sQLiteDatabase, String string2) {
        long l;
        SQLiteStatement sQLiteStatement;
        if (!sQLiteDatabase.isOpen()) {
            return 0L;
        }
        SQLiteProgram sQLiteProgram = null;
        try {
            String string3 = "PRAGMA " + string2;
            sQLiteStatement = new SQLiteStatement(sQLiteDatabase, string3);
        }
        catch (Throwable throwable) {}
        try {
            long l2;
            l = l2 = sQLiteStatement.simpleQueryForLong();
            if (sQLiteStatement == null) return l;
        }
        catch (Throwable throwable) {
            sQLiteProgram = sQLiteStatement;
        }
        sQLiteStatement.close();
        return l;
        {
            void var11_9;
            if (sQLiteProgram == null) throw var11_9;
            sQLiteProgram.close();
            throw var11_9;
        }
    }

    private String getTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ");
        Long l = System.currentTimeMillis();
        return simpleDateFormat.format(l);
    }

    private void lockForced() {
        long l;
        long l2;
        this.mLock.lock();
        if (!SQLiteDebug.DEBUG_LOCK_TIME_TRACKING) {
            return;
        }
        if (this.mLock.getHoldCount() != 1) {
            return;
        }
        this.mLockAcquiredWallTime = l2 = SystemClock.elapsedRealtime();
        this.mLockAcquiredThreadTime = l = Debug.threadCpuTimeNanos();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void markTableSyncable(String string2, String string3, String string4, String string5) {
        this.lock();
        String string6 = "SELECT _sync_dirty FROM " + string4 + " LIMIT 0";
        this.native_execSQL(string6);
        String string7 = "SELECT " + string3 + " FROM " + string2 + " LIMIT 0";
        this.native_execSQL(string7);
        SyncUpdateInfo syncUpdateInfo = new SyncUpdateInfo(string4, string5, string3);
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            SyncUpdateInfo syncUpdateInfo2 = this.mSyncUpdateInfo.put(string2, syncUpdateInfo);
            return;
        }
        finally {
            this.unlock();
        }
    }

    private native int native_getDbLookaside();

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLiteDatabase openDatabase(String string2, CursorFactory cursorFactory, int n) {
        SQLiteDatabase sQLiteDatabase;
        block7: {
            SQLiteDatabase sQLiteDatabase2;
            try {
                sQLiteDatabase2 = new SQLiteDatabase(string2, cursorFactory, n);
            }
            catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {}
            try {
                if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
                    sQLiteDatabase2.enableSqlTracing(string2);
                }
                if (SQLiteDebug.DEBUG_SQL_TIME) {
                    sQLiteDatabase2.enableSqlProfiling(string2);
                }
                sQLiteDatabase = sQLiteDatabase2;
                break block7;
            }
            catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
                SQLiteDatabase sQLiteDatabase3 = sQLiteDatabase2;
            }
            {
                void var8_9;
                String string3 = "Deleting and re-creating corrupt database " + string2;
                int n2 = Log.e(TAG, string3, (Throwable)var8_9);
                int n3 = EventLog.writeEvent(75004, string2);
                if (!string2.equalsIgnoreCase(":memory")) {
                    boolean bl = new File(string2).delete();
                }
                sQLiteDatabase = new SQLiteDatabase(string2, cursorFactory, n);
            }
        }
        HashSet hashSet = ActiveDatabases.getInstance().mActiveDatabases;
        WeakReference<SQLiteDatabase> weakReference = new WeakReference<SQLiteDatabase>(sQLiteDatabase);
        boolean bl = hashSet.add(weakReference);
        return sQLiteDatabase;
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, CursorFactory cursorFactory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), cursorFactory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String string2, CursorFactory cursorFactory) {
        return SQLiteDatabase.openDatabase(string2, cursorFactory, 0x10000000);
    }

    public static native int releaseMemory();

    private void unlockForced() {
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.checkLockHoldTime();
        }
        this.mLock.unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean yieldIfContendedHelper(boolean bl, long l) {
        if (this.mLock.getQueueLength() == 0) {
            long l2;
            long l3;
            this.mLockAcquiredWallTime = l3 = SystemClock.elapsedRealtime();
            this.mLockAcquiredThreadTime = l2 = Debug.threadCpuTimeNanos();
            return false;
        }
        this.setTransactionSuccessful();
        SQLiteTransactionListener sQLiteTransactionListener = this.mTransactionListener;
        this.endTransaction();
        if (bl && this.isDbLockedByCurrentThread()) {
            throw new IllegalStateException("Db locked more than once. yielfIfContended cannot yield");
        }
        if (l > 0L) {
            for (long i = l; i > 0L; i -= 1000L) {
                long l4 = i < 1000L ? i : 1000L;
                try {
                    Thread.sleep(l4);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    boolean bl2 = Thread.interrupted();
                }
                if (this.mLock.getQueueLength() != 0) continue;
            }
        }
        this.beginTransactionWithListener(sQLiteTransactionListener);
        return true;
    }

    void addSQLiteClosable(SQLiteClosable sQLiteClosable) {
        this.lock();
        try {
            Object var2_2 = this.mPrograms.put(sQLiteClosable, null);
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addToCompiledQueries(String string2, SQLiteCompiledSql sQLiteCompiledSql) {
        if (this.mMaxSqlCacheSize == 0) {
            if (!SQLiteDebug.DEBUG_SQL_CACHE) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("|NOT adding_sql_to_cache|");
            String string3 = this.getPath();
            String string4 = stringBuilder.append(string3).append("|").append(string2).toString();
            int n = Log.v(TAG, string4);
            return;
        }
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            int n;
            if (this.mCompiledQueries.get(string2) != null) {
                return;
            }
            int n2 = this.mCompiledQueries.size();
            if (n2 != (n = this.mMaxSqlCacheSize)) {
                int n3;
                this.mCacheFullWarnings = n3 = this.mCacheFullWarnings + 1;
                if (n3 == 1) {
                    StringBuilder stringBuilder = new StringBuilder().append("Reached MAX size for compiled-sql statement cache for database ");
                    String string5 = this.getPath();
                    String string6 = stringBuilder.append(string5).append("; i.e., NO space for this sql statement in cache: ").append(string2).append(". Please change your sql statements to use '?' for ").append("bindargs, instead of using actual values").toString();
                    int n4 = Log.w(TAG, string6);
                }
            } else {
                SQLiteCompiledSql sQLiteCompiledSql2 = this.mCompiledQueries.put(string2, sQLiteCompiledSql);
                if (SQLiteDebug.DEBUG_SQL_CACHE) {
                    StringBuilder stringBuilder = new StringBuilder().append("|adding_sql_to_cache|");
                    String string7 = this.getPath();
                    StringBuilder stringBuilder2 = stringBuilder.append(string7).append("|");
                    int n5 = this.mCompiledQueries.size();
                    String string8 = stringBuilder2.append(n5).append("|").append(string2).toString();
                    int n6 = Log.v(TAG, string8);
                }
            }
            return;
        }
    }

    public void beginTransaction() {
        this.beginTransactionWithListener(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beginTransactionWithListener(SQLiteTransactionListener var1_1) {
        this.lockForced();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        var2_2 = false;
        if (this.mLock.getHoldCount() > 1) {
            if (!this.mInnerTransactionIsSuccessful) return;
            var3_3 = new IllegalStateException("Cannot call beginTransaction between calling setTransactionSuccessful and endTransaction");
            var4_4 = Log.e("Database", "beginTransaction() failed", var3_3);
            throw var3_3;
        }
        ** GOTO lbl16
        {
            catch (Throwable var5_5) {
                if (var2_2) throw var5_5;
                this.unlockForced();
                throw var5_5;
            }
lbl16:
            // 1 sources

            this.execSQL("BEGIN EXCLUSIVE;");
            this.mTransactionListener = var1_1;
            this.mTransactionIsSuccessful = true;
            this.mInnerTransactionIsSuccessful = false;
            if (var1_1 == null) return;
            try {
                var1_1.onBegin();
            }
            catch (RuntimeException var6_6) {}
            {
                this.execSQL("ROLLBACK;");
                throw var6_6;
            }
            return;
        }
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.lock();
        try {
            this.closeClosable();
            this.onAllReferencesReleased();
            return;
        }
        finally {
            this.unlock();
        }
    }

    public SQLiteStatement compileStatement(String string2) throws SQLException {
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, string2);
            return sQLiteStatement;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delete(String string2, String string3, String[] stringArray) {
        int n;
        block8: {
            BlockGuard.getThreadPolicy().onWriteToDisk();
            this.lock();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            SQLiteProgram sQLiteProgram = null;
            try {
                int n2;
                StringBuilder stringBuilder = new StringBuilder().append("DELETE FROM ").append(string2);
                String string4 = !TextUtils.isEmpty(string3) ? " WHERE " + string3 : "";
                String string5 = stringBuilder.append(string4).toString();
                sQLiteProgram = this.compileStatement(string5);
                if (stringArray != null) {
                    int n3 = stringArray.length;
                    for (int i = 0; i < n3; ++i) {
                        int n4 = i + 1;
                        String string6 = stringArray[i];
                        DatabaseUtils.bindObjectToProgram(sQLiteProgram, n4, string6);
                    }
                }
                ((SQLiteStatement)sQLiteProgram).execute();
                n = n2 = this.lastChangeCount();
                if (sQLiteProgram == null) break block8;
            }
            catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
                try {
                    this.onCorruption();
                    throw sQLiteDatabaseCorruptException;
                }
                catch (Throwable throwable) {
                    if (sQLiteProgram != null) {
                        sQLiteProgram.close();
                    }
                    this.unlock();
                    throw throwable;
                }
            }
            sQLiteProgram.close();
        }
        this.unlock();
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTransaction() {
        block18: {
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            if (!this.mLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("no transaction pending");
            }
            try {
                if (this.mInnerTransactionIsSuccessful) {
                    this.mInnerTransactionIsSuccessful = false;
                } else {
                    var2_1 = null;
                    this.mTransactionIsSuccessful = var2_1;
                }
                if ((var1_2 = this.mLock.getHoldCount()) != 1) {
                    this.mTransactionListener = null;
                    this.unlockForced();
                    return;
                }
                var4_4 = null;
                var2_1 = this.mTransactionListener;
                if (var2_1 == null) ** GOTO lbl35
                if (!this.mTransactionIsSuccessful) break block18;
                this.mTransactionListener.onCommit();
            }
            catch (Throwable var3_3) {
                this.mTransactionListener = null;
                this.unlockForced();
                throw var3_3;
            }
        }
        ** try [egrp 5[TRYBLOCK] [6 : 147->159)] { 
lbl-1000:
        // 1 sources

        {
            this.mTransactionListener.onRollback();
        }
lbl32:
        // 2 sources

        catch (RuntimeException var4_5) {
            var2_1 = null;
            this.mTransactionIsSuccessful = var2_1;
        }
lbl35:
        // 4 sources

        if (this.mTransactionIsSuccessful) {
            this.execSQL("COMMIT;");
        } else {
            try {
                this.execSQL("ROLLBACK;");
                if (var4_4 != null) {
                    throw var4_4;
                }
            }
            catch (SQLException var5_6) {
                var6_7 = Log.d("Database", "exception during rollback, maybe the DB previously performed an auto-rollback");
            }
        }
        this.mTransactionListener = null;
        this.unlockForced();
    }

    public void execSQL(String string2) throws SQLException {
        long l;
        block6: {
            String string3;
            BlockGuard.getThreadPolicy().onWriteToDisk();
            l = SystemClock.uptimeMillis();
            this.lock();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            String string4 = this.mLastSqlStatement;
            this.logTimeStat(string4, l, GET_LOCK_LOG_PREFIX);
            try {
                this.native_execSQL(string2);
                if (string2 != COMMIT_SQL) break block6;
                string3 = this.mLastSqlStatement;
            }
            catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
                this.onCorruption();
                throw sQLiteDatabaseCorruptException;
            }
            finally {
                this.unlock();
            }
            this.logTimeStat(string3, l, COMMIT_SQL);
            return;
        }
        this.logTimeStat(string2, l, null);
    }

    /*
     * Exception decompiling
     */
    public void execSQL(String var1, Object[] var2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void finalize() {
        if (!this.isOpen()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("close() was never explicitly called on database '");
        String string2 = this.mPath;
        String string3 = stringBuilder.append(string2).append("' ").toString();
        Throwable throwable = this.mStackTrace;
        int n = Log.e(TAG, string3, throwable);
        this.closeClosable();
        this.onAllReferencesReleased();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    SQLiteCompiledSql getCompiledStatementForSql(String string2) {
        Object object = this.mCompiledQueries;
        // MONITORENTER : object
        if (this.mMaxSqlCacheSize == 0) {
            if (SQLiteDebug.DEBUG_SQL_CACHE) {
                StringBuilder stringBuilder = new StringBuilder().append("|cache NOT found|");
                String string3 = this.getPath();
                String string4 = stringBuilder.append(string3).toString();
                int n = Log.v(TAG, string4);
            }
            SQLiteCompiledSql sQLiteCompiledSql = null;
            // MONITOREXIT : object
            return sQLiteCompiledSql;
        }
        SQLiteCompiledSql sQLiteCompiledSql = this.mCompiledQueries.get(string2);
        boolean bl = sQLiteCompiledSql != null;
        // MONITOREXIT : object
        if (bl) {
            int n;
            this.mNumCacheHits = n = this.mNumCacheHits + 1;
        } else {
            int n;
            this.mNumCacheMisses = n = this.mNumCacheMisses + 1;
        }
        if (!SQLiteDebug.DEBUG_SQL_CACHE) return sQLiteCompiledSql;
        StringBuilder stringBuilder = new StringBuilder().append("|cache_stats|");
        String string5 = this.getPath();
        StringBuilder stringBuilder2 = stringBuilder.append(string5).append("|");
        int n = this.mCompiledQueries.size();
        StringBuilder stringBuilder3 = stringBuilder2.append(n).append("|");
        int n2 = this.mNumCacheHits;
        StringBuilder stringBuilder4 = stringBuilder3.append(n2).append("|");
        int n3 = this.mNumCacheMisses;
        StringBuilder stringBuilder5 = stringBuilder4.append(n3).append("|").append(bl).append("|");
        String string6 = this.mTimeOpened;
        StringBuilder stringBuilder6 = stringBuilder5.append(string6).append("|");
        String string7 = this.mTimeClosed;
        StringBuilder stringBuilder7 = stringBuilder6.append(string7);
        object = "|";
        String string8 = stringBuilder7.append("|").append(string2).toString();
        int n4 = Log.v(TAG, string8);
        return sQLiteCompiledSql;
    }

    public int getMaxSqlCacheSize() {
        synchronized (this) {
            int n = this.mMaxSqlCacheSize;
            return n;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaximumSize() {
        long l;
        SQLiteProgram sQLiteProgram;
        block6: {
            SQLiteStatement sQLiteStatement;
            sQLiteProgram = null;
            this.lock();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            try {
                sQLiteStatement = new SQLiteStatement(this, "PRAGMA max_page_count;");
            }
            catch (Throwable throwable) {}
            try {
                long l2 = sQLiteStatement.simpleQueryForLong();
                long l3 = this.getPageSize();
                l = l3 * l2;
                if (sQLiteStatement == null) break block6;
            }
            catch (Throwable throwable) {
                sQLiteProgram = sQLiteStatement;
            }
            sQLiteStatement.close();
        }
        this.unlock();
        return l;
        {
            void var9_7;
            if (sQLiteProgram != null) {
                sQLiteProgram.close();
            }
            this.unlock();
            throw var9_7;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getPageSize() {
        long l;
        SQLiteProgram sQLiteProgram;
        block6: {
            SQLiteStatement sQLiteStatement;
            sQLiteProgram = null;
            this.lock();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            try {
                sQLiteStatement = new SQLiteStatement(this, "PRAGMA page_size;");
            }
            catch (Throwable throwable) {}
            try {
                long l2;
                l = l2 = sQLiteStatement.simpleQueryForLong();
                if (sQLiteStatement == null) break block6;
            }
            catch (Throwable throwable) {
                sQLiteProgram = sQLiteStatement;
            }
            sQLiteStatement.close();
        }
        this.unlock();
        return l;
        {
            void var7_6;
            if (sQLiteProgram != null) {
                sQLiteProgram.close();
            }
            this.unlock();
            throw var7_6;
        }
    }

    public final String getPath() {
        return this.mPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getSyncedTables() {
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        synchronized (map) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator<String> iterator = this.mSyncUpdateInfo.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                SyncUpdateInfo syncUpdateInfo = this.mSyncUpdateInfo.get(string2);
                if (syncUpdateInfo.deletedTable == null) continue;
                String string3 = syncUpdateInfo.deletedTable;
                String string4 = hashMap.put(string2, string3);
            }
            return hashMap;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getVersion() {
        long l;
        SQLiteStatement sQLiteStatement;
        SQLiteProgram sQLiteProgram = null;
        this.lock();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        try {
            sQLiteStatement = new SQLiteStatement(this, "PRAGMA user_version;");
        }
        catch (Throwable throwable) {}
        try {
            l = sQLiteStatement.simpleQueryForLong();
        }
        catch (Throwable throwable) {
            sQLiteProgram = sQLiteStatement;
        }
        int n = (int)l;
        if (sQLiteStatement != null) {
            sQLiteStatement.close();
        }
        this.unlock();
        return n;
        {
            void var6_6;
            if (sQLiteProgram != null) {
                sQLiteProgram.close();
            }
            this.unlock();
            throw var6_6;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean inTransaction() {
        if (this.mLock.getHoldCount() <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long insert(String string2, String string3, ContentValues contentValues) {
        try {
            long l = this.insertWithOnConflict(string2, string3, contentValues, 0);
            return l;
        }
        catch (SQLException sQLException) {
            String string4 = "Error inserting " + contentValues;
            int n = Log.e(TAG, string4, sQLException);
            return 65535L;
        }
    }

    public long insertOrThrow(String string2, String string3, ContentValues contentValues) throws SQLException {
        return this.insertWithOnConflict(string2, string3, contentValues, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insertWithOnConflict(String string2, String string3, ContentValues contentValues, int n) {
        Iterator<Map.Entry<String, Object>> iterator;
        BlockGuard.getThreadPolicy().onWriteToDisk();
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        StringBuilder stringBuilder = new StringBuilder(152);
        StringBuilder stringBuilder2 = stringBuilder.append("INSERT");
        String string4 = CONFLICT_VALUES[n];
        StringBuilder stringBuilder3 = stringBuilder.append(string4);
        StringBuilder stringBuilder4 = stringBuilder.append(" INTO ");
        StringBuilder stringBuilder5 = stringBuilder;
        String string5 = string2;
        StringBuilder stringBuilder6 = stringBuilder5.append(string5);
        StringBuilder stringBuilder7 = new StringBuilder(40);
        Set<Map.Entry<String, Object>> set = null;
        if (contentValues != null && contentValues.size() > 0) {
            set = contentValues.valueSet();
            iterator = set.iterator();
            StringBuilder stringBuilder8 = stringBuilder.append('(');
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    StringBuilder stringBuilder9 = stringBuilder.append(", ");
                    StringBuilder stringBuilder10 = stringBuilder7.append(", ");
                }
                bl = true;
                String string6 = iterator.next().getKey();
                StringBuilder stringBuilder11 = stringBuilder;
                String string7 = string6;
                StringBuilder stringBuilder12 = stringBuilder11.append(string7);
                StringBuilder stringBuilder13 = stringBuilder7.append('?');
            }
            StringBuilder stringBuilder14 = stringBuilder.append(')');
        } else {
            StringBuilder stringBuilder15 = new StringBuilder().append("(");
            String string8 = string3;
            String string9 = stringBuilder15.append(string8).append(") ").toString();
            StringBuilder stringBuilder16 = stringBuilder.append(string9);
            StringBuilder stringBuilder17 = stringBuilder7.append("NULL");
        }
        StringBuilder stringBuilder18 = stringBuilder.append(" VALUES(");
        StringBuilder stringBuilder19 = stringBuilder.append(stringBuilder7);
        StringBuilder stringBuilder20 = stringBuilder.append(");");
        this.lock();
        try {
            String string10 = stringBuilder.toString();
            SQLiteDatabase sQLiteDatabase = this;
            String string11 = string10;
            SQLiteStatement sQLiteStatement = sQLiteDatabase.compileStatement(string11);
            if (set != null) {
                int n2 = set.size();
                iterator = set.iterator();
                for (int i = 0; i < n2; ++i) {
                    Map.Entry<String, Object> entry = iterator.next();
                    int n3 = i + 1;
                    Object object = entry.getValue();
                    DatabaseUtils.bindObjectToProgram(sQLiteStatement, n3, object);
                }
            }
            sQLiteStatement.execute();
            long l = this.lastInsertRow();
            if (l == 65535L) {
                StringBuilder stringBuilder21 = new StringBuilder().append("Error inserting ");
                ContentValues contentValues2 = contentValues;
                String string12 = stringBuilder21.append(contentValues2).append(" using ").append((Object)stringBuilder).toString();
                int n4 = Log.e(TAG, string12);
                return l;
            }
            if (!Log.isLoggable(TAG, 2)) return l;
            StringBuilder stringBuilder22 = new StringBuilder().append("Inserting row ").append(l).append(" from ");
            ContentValues contentValues3 = contentValues;
            String string13 = stringBuilder22.append(contentValues3).append(" using ").append((Object)stringBuilder).toString();
            int n5 = Log.v(TAG, string13);
            return l;
        }
        catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
            this.onCorruption();
            throw sQLiteDatabaseCorruptException;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public boolean isDbLockedByCurrentThread() {
        return this.mLock.isHeldByCurrentThread();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDbLockedByOtherThreads() {
        if (this.mLock.isHeldByCurrentThread()) return false;
        if (!this.mLock.isLocked()) return false;
        return true;
    }

    public boolean isInCompiledSqlCache(String string2) {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            boolean bl = this.mCompiledQueries.containsKey(string2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (this.mNativeHandle == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReadOnly() {
        if ((this.mFlags & 1) != 1) return false;
        return true;
    }

    native int lastChangeCount();

    native long lastInsertRow();

    void lock() {
        long l;
        long l2;
        if (!this.mLockingEnabled) {
            return;
        }
        this.mLock.lock();
        if (!SQLiteDebug.DEBUG_LOCK_TIME_TRACKING) {
            return;
        }
        if (this.mLock.getHoldCount() != 1) {
            return;
        }
        this.mLockAcquiredWallTime = l2 = SystemClock.elapsedRealtime();
        this.mLockAcquiredThreadTime = l = Debug.threadCpuTimeNanos();
    }

    void logTimeStat(String string2, long l) {
        this.logTimeStat(string2, l, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    void logTimeStat(String string2, long l, String string3) {
        String string4;
        int n;
        long l2;
        this.mLastSqlStatement = string2;
        long l3 = SystemClock.uptimeMillis() - l;
        if (l3 == 0L && string3 == GET_LOCK_LOG_PREFIX) {
            return;
        }
        if (sQueryLogTimeInMillis == 0) {
            sQueryLogTimeInMillis = SystemProperties.getInt("db.db_operation.threshold_ms", 500);
        }
        if (l3 >= (l2 = (long)sQueryLogTimeInMillis)) {
            n = 100;
        } else {
            long l4 = 100L * l3;
            long l5 = sQueryLogTimeInMillis;
            n = (int)(l4 / l5) + 1;
            if (this.mRandom.nextInt(100) >= n) {
                return;
            }
        }
        if (string3 != null) {
            string2 = string3 + string2;
        }
        if (string2.length() > 64) {
            string2 = string2.substring(0, 64);
        }
        if ((string4 = AppGlobals.getInitialPackage()) == null) {
            string4 = "";
        }
        Object[] objectArray = new Object[5];
        String string5 = this.getPathForLogs();
        objectArray[0] = string5;
        objectArray[1] = string2;
        Long l6 = l3;
        objectArray[2] = l6;
        objectArray[3] = string4;
        Integer n2 = n;
        objectArray[4] = n2;
        int n3 = EventLog.writeEvent(52000, objectArray);
    }

    public void markTableSyncable(String string2, String string3) {
        this.markTableSyncable(string2, "_id", string2, string3);
    }

    public void markTableSyncable(String string2, String string3, String string4) {
        this.markTableSyncable(string2, string3, string4, null);
    }

    native void native_execSQL(String var1) throws SQLException;

    native void native_setLocale(String var1, int var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean needUpgrade(int n) {
        int n2 = this.getVersion();
        if (n <= n2) return false;
        return true;
    }

    @Override
    protected void onAllReferencesReleased() {
        if (!this.isOpen()) {
            return;
        }
        if (SQLiteDebug.DEBUG_SQL_CACHE) {
            String string2;
            this.mTimeClosed = string2 = this.getTime();
        }
        this.dbclose();
    }

    void onCorruption() {
        StringBuilder stringBuilder = new StringBuilder().append("Removing corrupt database: ");
        String string2 = this.mPath;
        String string3 = stringBuilder.append(string2).toString();
        int n = Log.e(TAG, string3);
        String string4 = this.mPath;
        int n2 = EventLog.writeEvent(75004, string4);
        try {
            this.close();
            if (this.mPath.equalsIgnoreCase(":memory")) {
                return;
            }
            String string5 = this.mPath;
            boolean bl = new File(string5).delete();
            return;
        }
        catch (Throwable throwable) {
            if (!this.mPath.equalsIgnoreCase(":memory")) {
                String string6 = this.mPath;
                boolean bl = new File(string6).delete();
            }
            throw throwable;
        }
    }

    public void purgeFromCompiledSqlCache(String string2) {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            SQLiteCompiledSql sQLiteCompiledSql = this.mCompiledQueries.remove(string2);
            return;
        }
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6) {
        SQLiteDatabase sQLiteDatabase = this;
        String string7 = string2;
        String[] stringArray3 = stringArray;
        String string8 = string3;
        String[] stringArray4 = stringArray2;
        String string9 = string4;
        String string10 = string5;
        String string11 = string6;
        return sQLiteDatabase.query(false, string7, stringArray3, string8, stringArray4, string9, string10, string11, null);
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        SQLiteDatabase sQLiteDatabase = this;
        String string8 = string2;
        String[] stringArray3 = stringArray;
        String string9 = string3;
        String[] stringArray4 = stringArray2;
        String string10 = string4;
        String string11 = string5;
        String string12 = string6;
        String string13 = string7;
        return sQLiteDatabase.query(false, string8, stringArray3, string9, stringArray4, string10, string11, string12, string13);
    }

    public Cursor query(boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        SQLiteDatabase sQLiteDatabase = this;
        boolean bl2 = bl;
        String string8 = string2;
        String[] stringArray3 = stringArray;
        String string9 = string3;
        String[] stringArray4 = stringArray2;
        String string10 = string4;
        String string11 = string5;
        String string12 = string6;
        String string13 = string7;
        return sQLiteDatabase.queryWithFactory(null, bl2, string8, stringArray3, string9, stringArray4, string10, string11, string12, string13);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        boolean bl2 = bl;
        String string8 = string2;
        String[] stringArray3 = stringArray;
        String string9 = string3;
        String string10 = string4;
        String string11 = string5;
        String string12 = string6;
        String string13 = string7;
        String string14 = SQLiteQueryBuilder.buildQueryString(bl2, string8, stringArray3, string9, string10, string11, string12, string13);
        String string15 = SQLiteDatabase.findEditTable(string2);
        return this.rawQueryWithFactory(cursorFactory, string14, stringArray2, string15);
    }

    public Cursor rawQuery(String string2, String[] stringArray) {
        return this.rawQueryWithFactory(null, string2, stringArray, null);
    }

    public Cursor rawQuery(String string2, String[] stringArray, int n, int n2) {
        SQLiteCursor sQLiteCursor = (SQLiteCursor)this.rawQueryWithFactory(null, string2, stringArray, null);
        sQLiteCursor.setLoadStyle(n, n2);
        return sQLiteCursor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String string2, String[] stringArray, String string3) {
        Throwable throwable2;
        block11: {
            String string4;
            StringBuilder stringBuilder;
            String string5;
            int n;
            Cursor cursor;
            block9: {
                long l;
                long l2;
                int n2;
                SQLiteDirectCursorDriver sQLiteDirectCursorDriver;
                long l3;
                block10: {
                    CursorFactory cursorFactory2;
                    if (!this.isOpen()) {
                        throw new IllegalStateException("database not open");
                    }
                    BlockGuard.getThreadPolicy().onReadFromDisk();
                    l3 = 0L;
                    if (this.mSlowQueryThreshold != -1) {
                        l3 = System.currentTimeMillis();
                    }
                    sQLiteDirectCursorDriver = new SQLiteDirectCursorDriver(this, string2, string3);
                    Cursor cursor2 = null;
                    if (cursorFactory != null) {
                        cursorFactory2 = cursorFactory;
                    } else {
                        cursorFactory2 = this.mFactory;
                    }
                    try {
                        Cursor cursor3;
                        cursor = cursor3 = sQLiteDirectCursorDriver.query(cursorFactory2, stringArray);
                        if (this.mSlowQueryThreshold == -1) break block9;
                        n2 = -1;
                        if (cursor == null) break block10;
                        n2 = cursor.getCount();
                    }
                    catch (Throwable throwable2) {
                        long l4;
                        long l5;
                        if (this.mSlowQueryThreshold == -1) break block11;
                        n = -1;
                        if (cursor2 != null) {
                            n = cursor2.getCount();
                        }
                        if ((l5 = System.currentTimeMillis() - l3) < (l4 = (long)this.mSlowQueryThreshold)) break block11;
                        string5 = "Cursor";
                        StringBuilder stringBuilder2 = new StringBuilder().append("query (").append(l5).append(" ms): ");
                        String string6 = ((Object)sQLiteDirectCursorDriver).toString();
                        stringBuilder = stringBuilder2.append(string6).append(", args are ");
                        string4 = stringArray != null ? TextUtils.join((CharSequence)",", stringArray) : "<null>";
                    }
                }
                if ((l2 = System.currentTimeMillis() - l3) >= (l = (long)this.mSlowQueryThreshold)) {
                    String string7 = "Cursor";
                    StringBuilder stringBuilder3 = new StringBuilder().append("query (").append(l2).append(" ms): ");
                    String string8 = ((Object)sQLiteDirectCursorDriver).toString();
                    StringBuilder stringBuilder4 = stringBuilder3.append(string8).append(", args are ");
                    String string9 = stringArray != null ? TextUtils.join((CharSequence)",", stringArray) : "<null>";
                    String string10 = stringBuilder4.append(string9).append(", count is ").append(n2).toString();
                    int n3 = Log.v(string7, string10);
                }
            }
            return cursor;
            String string11 = stringBuilder.append(string4).append(", count is ").append(n).toString();
            int n4 = Log.v(string5, string11);
        }
        throw throwable2;
    }

    void removeSQLiteClosable(SQLiteClosable sQLiteClosable) {
        this.lock();
        try {
            Object object = this.mPrograms.remove(sQLiteClosable);
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long replace(String string2, String string3, ContentValues contentValues) {
        try {
            long l = this.insertWithOnConflict(string2, string3, contentValues, 5);
            return l;
        }
        catch (SQLException sQLException) {
            String string4 = "Error inserting " + contentValues;
            int n = Log.e(TAG, string4, sQLException);
            return 65535L;
        }
    }

    public long replaceOrThrow(String string2, String string3, ContentValues contentValues) throws SQLException {
        return this.insertWithOnConflict(string2, string3, contentValues, 5);
    }

    public void resetCompiledSqlCache() {
        Map<String, SQLiteCompiledSql> map = this.mCompiledQueries;
        synchronized (map) {
            this.mCompiledQueries.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void rowUpdated(String string2, long l) {
        Map<String, SyncUpdateInfo> map = this.mSyncUpdateInfo;
        // MONITORENTER : map
        SyncUpdateInfo syncUpdateInfo = this.mSyncUpdateInfo.get(string2);
        // MONITOREXIT : map
        if (syncUpdateInfo == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("UPDATE ");
        String string3 = syncUpdateInfo.masterTable;
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" SET _sync_dirty=1 WHERE _id=(SELECT ");
        String string4 = syncUpdateInfo.foreignKey;
        String string5 = stringBuilder2.append(string4).append(" FROM ").append(string2).append(" WHERE _id=").append(l).append(")").toString();
        this.execSQL(string5);
    }

    public void setLocale(Locale locale) {
        this.lock();
        try {
            String string2 = locale.toString();
            int n = this.mFlags;
            this.native_setLocale(string2, n);
            return;
        }
        finally {
            this.unlock();
        }
    }

    public void setLockingEnabled(boolean bl) {
        this.mLockingEnabled = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxSqlCacheSize(int n) {
        synchronized (this) {
            if (n > 250 || n < 0) {
                throw new IllegalStateException("expected value between 0 and 250");
            }
            int n2 = this.mMaxSqlCacheSize;
            if (n < n2) {
                throw new IllegalStateException("cannot set cacheSize to a value less than the value set with previous setMaxSqlCacheSize() call.");
            }
            this.mMaxSqlCacheSize = n;
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long setMaximumSize(long l) {
        long l2;
        SQLiteProgram sQLiteProgram;
        block7: {
            SQLiteStatement sQLiteStatement;
            long l3;
            sQLiteProgram = null;
            this.lock();
            if (!this.isOpen()) {
                throw new IllegalStateException("database not open");
            }
            try {
                l3 = this.getPageSize();
                long l4 = l / l3;
                if (l % l3 != 0L) {
                    ++l4;
                }
                String string2 = "PRAGMA max_page_count = " + l4;
                sQLiteStatement = new SQLiteStatement(this, string2);
            }
            catch (Throwable throwable) {}
            try {
                long l5 = sQLiteStatement.simpleQueryForLong();
                l2 = l5 * l3;
                if (sQLiteStatement == null) break block7;
            }
            catch (Throwable throwable) {
                sQLiteProgram = sQLiteStatement;
            }
            sQLiteStatement.close();
        }
        this.unlock();
        return l2;
        {
            void var14_10;
            if (sQLiteProgram != null) {
                sQLiteProgram.close();
            }
            this.unlock();
            throw var14_10;
        }
    }

    public void setPageSize(long l) {
        String string2 = "PRAGMA page_size = " + l;
        this.execSQL(string2);
    }

    public void setTransactionSuccessful() {
        if (!this.isOpen()) {
            throw new IllegalStateException("database not open");
        }
        if (!this.mLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("no transaction pending");
        }
        if (this.mInnerTransactionIsSuccessful) {
            throw new IllegalStateException("setTransactionSuccessful may only be called once per call to beginTransaction");
        }
        this.mInnerTransactionIsSuccessful = true;
    }

    public void setVersion(int n) {
        String string2 = "PRAGMA user_version = " + n;
        this.execSQL(string2);
    }

    void unlock() {
        if (!this.mLockingEnabled) {
            return;
        }
        if (SQLiteDebug.DEBUG_LOCK_TIME_TRACKING && this.mLock.getHoldCount() == 1) {
            this.checkLockHoldTime();
        }
        this.mLock.unlock();
    }

    public int update(String string2, ContentValues contentValues, String string3, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this;
        String string4 = string2;
        ContentValues contentValues2 = contentValues;
        String string5 = string3;
        String[] stringArray2 = stringArray;
        return sQLiteDatabase.updateWithOnConflict(string4, contentValues2, string5, stringArray2, 0);
    }

    /*
     * Exception decompiling
     */
    public int updateWithOnConflict(String var1, ContentValues var2, String var3, String[] var4, int var5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 510->563)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public boolean yieldIfContended() {
        return this.yieldIfContendedHelper(false, 65535L);
    }

    public boolean yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true, 65535L);
    }

    public boolean yieldIfContendedSafely(long l) {
        return this.yieldIfContendedHelper(true, l);
    }

    static class ActiveDatabases {
        private static final ActiveDatabases activeDatabases = new ActiveDatabases();
        private HashSet<WeakReference<SQLiteDatabase>> mActiveDatabases;

        private ActiveDatabases() {
            HashSet hashSet = new HashSet();
            this.mActiveDatabases = hashSet;
        }

        static ActiveDatabases getInstance() {
            return activeDatabases;
        }
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }

    private static class SyncUpdateInfo {
        String deletedTable;
        String foreignKey;
        String masterTable;

        SyncUpdateInfo(String string2, String string3, String string4) {
            this.masterTable = string2;
            this.deletedTable = string3;
            this.foreignKey = string4;
        }
    }
}

