/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import java.util.ArrayList;

public final class SQLiteDebug {
    public static final boolean DEBUG_ACTIVE_CURSOR_FINALIZATION;
    public static final boolean DEBUG_LOCK_TIME_TRACKING;
    public static final boolean DEBUG_LOCK_TIME_TRACKING_STACK_TRACE;
    public static final boolean DEBUG_SQL_CACHE;
    public static final boolean DEBUG_SQL_STATEMENTS;
    public static final boolean DEBUG_SQL_TIME;
    private static int sNumActiveCursorsFinalized;

    static {
        DEBUG_SQL_STATEMENTS = Log.isLoggable("SQLiteStatements", 2);
        DEBUG_SQL_TIME = Log.isLoggable("SQLiteTime", 2);
        DEBUG_SQL_CACHE = Log.isLoggable("SQLiteCompiledSql", 2);
        DEBUG_ACTIVE_CURSOR_FINALIZATION = Log.isLoggable("SQLiteCursorClosing", 2);
        DEBUG_LOCK_TIME_TRACKING = Log.isLoggable("SQLiteLockTime", 2);
        DEBUG_LOCK_TIME_TRACKING_STACK_TRACE = Log.isLoggable("SQLiteLockStackTrace", 2);
        sNumActiveCursorsFinalized = 0;
    }

    public static PagerStats getDatabaseInfo() {
        PagerStats pagerStats = new PagerStats();
        SQLiteDebug.getPagerStats(pagerStats);
        ArrayList<DbStats> arrayList = SQLiteDatabase.getDbStats();
        pagerStats.dbStats = arrayList;
        return pagerStats;
    }

    public static native long getHeapAllocatedSize();

    public static native void getHeapDirtyPages(int[] var0);

    public static native long getHeapFreeSize();

    public static native long getHeapSize();

    public static int getNumActiveCursorsFinalized() {
        return sNumActiveCursorsFinalized;
    }

    public static native void getPagerStats(PagerStats var0);

    static void notifyActiveCursorFinalized() {
        synchronized (SQLiteDebug.class) {
            ++sNumActiveCursorsFinalized;
            return;
        }
    }

    public static class DbStats {
        public String dbName;
        public long dbSize;
        public int lookaside;
        public long pageSize;

        public DbStats(String string2, long l, long l2, int n) {
            long l3;
            long l4;
            this.dbName = string2;
            this.pageSize = l4 = l2 / 1024L;
            this.dbSize = l3 = l * l2 / 1024L;
            this.lookaside = n;
        }
    }

    public static class PagerStats {
        @Deprecated
        public long databaseBytes;
        public ArrayList<DbStats> dbStats;
        public int largestMemAlloc;
        public int memoryUsed;
        @Deprecated
        public int numPagers;
        public int pageCacheOverflo;
        @Deprecated
        public long referencedBytes;
        @Deprecated
        public long totalBytes;
    }
}

