/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;

public abstract class SQLiteOpenHelper {
    private static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    private final Context mContext;
    private SQLiteDatabase mDatabase = null;
    private final SQLiteDatabase.CursorFactory mFactory;
    private boolean mIsInitializing = false;
    private final String mName;
    private final int mNewVersion;

    public SQLiteOpenHelper(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n) {
        if (n < 1) {
            String string3 = "Version must be >= 1, was " + n;
            throw new IllegalArgumentException(string3);
        }
        this.mContext = context;
        this.mName = string2;
        this.mFactory = cursorFactory;
        this.mNewVersion = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        synchronized (this) {
            if (this.mIsInitializing) {
                throw new IllegalStateException("Closed during initialization");
            }
            if (this.mDatabase != null && this.mDatabase.isOpen()) {
                this.mDatabase.close();
                this.mDatabase = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLiteDatabase getReadableDatabase() {
        synchronized (this) {
            SQLiteDatabase sQLiteDatabase;
            if (this.mDatabase != null && this.mDatabase.isOpen()) {
                return this.mDatabase;
            }
            if (this.mIsInitializing) {
                throw new IllegalStateException("getReadableDatabase called recursively");
            }
            try {
                SQLiteDatabase sQLiteDatabase2 = this.getWritableDatabase();
                return sQLiteDatabase2;
            }
            catch (SQLiteException sQLiteException) {
                SQLiteDatabase sQLiteDatabase3;
                if (this.mName == null) {
                    throw sQLiteException;
                }
                String string2 = TAG;
                StringBuilder stringBuilder = new StringBuilder().append("Couldn't open ");
                String string3 = this.mName;
                String string4 = stringBuilder.append(string3).append(" for writing (will try read-only):").toString();
                int n = Log.e(string2, string4, sQLiteException);
                boolean bl = true;
                try {
                    this.mIsInitializing = bl;
                    Context context = this.mContext;
                    String string5 = this.mName;
                    String string6 = context.getDatabasePath(string5).getPath();
                    SQLiteDatabase.CursorFactory cursorFactory = this.mFactory;
                    sQLiteDatabase3 = SQLiteDatabase.openDatabase(string6, cursorFactory, 1);
                    int n2 = sQLiteDatabase3.getVersion();
                    int n3 = this.mNewVersion;
                    if (n2 != n3) {
                        StringBuilder stringBuilder2 = new StringBuilder().append("Can't upgrade read-only database from version ");
                        int n4 = sQLiteDatabase3.getVersion();
                        StringBuilder stringBuilder3 = stringBuilder2.append(n4).append(" to ");
                        int n5 = this.mNewVersion;
                        String string7 = stringBuilder3.append(n5).append(": ").append(string6).toString();
                        throw new SQLiteException(string7);
                    }
                    this.onOpen(sQLiteDatabase3);
                    String string8 = TAG;
                    StringBuilder stringBuilder4 = new StringBuilder().append("Opened ");
                    String string9 = this.mName;
                    String string10 = stringBuilder4.append(string9).append(" in read-only mode").toString();
                    int n6 = Log.w(string8, string10);
                    sQLiteDatabase = this.mDatabase = sQLiteDatabase3;
                }
                finally {
                    boolean bl2;
                    this.mIsInitializing = bl2 = false;
                    if (sQLiteDatabase3 == null) return sQLiteDatabase;
                    SQLiteDatabase sQLiteDatabase4 = this.mDatabase;
                    if (sQLiteDatabase3 == sQLiteDatabase4) return sQLiteDatabase;
                    sQLiteDatabase3.close();
                }
            }
            return sQLiteDatabase;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLiteDatabase getWritableDatabase() {
        synchronized (this) {
            block25: {
                block26: {
                    block28: {
                        if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
                            return this.mDatabase;
                        }
                        if (this.mIsInitializing) {
                            throw new IllegalStateException("getWritableDatabase called recursively");
                        }
                        var3_3 = false;
                        var4_4 = null;
                        if (this.mDatabase != null) {
                            this.mDatabase.lock();
                        }
                        var5_5 = null;
                        this.mIsInitializing = var5_5;
                        if (this.mName == null) {
                            var4_4 = SQLiteDatabase.create(null);
                        } else {
                            var9_10 = this.mContext;
                            var10_11 = this.mName;
                            var11_12 = this.mFactory;
                            var4_4 = var12_13 = var9_10.openOrCreateDatabase(var10_11, 0, var11_12);
                        }
                        if ((var6_7 = var4_4.getVersion()) == (var7_8 = this.mNewVersion)) ** GOTO lbl43
                        var4_4.beginTransaction();
                        if (var6_7 != 0) ** GOTO lbl26
                        this.onCreate(var4_4);
                        break block28;
lbl26:
                        // 1 sources

                        var13_14 = this.mNewVersion;
                        if (var6_7 > var13_14) {
                            var14_15 = SQLiteOpenHelper.TAG;
                            var15_16 = new StringBuilder().append("Can't downgrade read-only database from version ").append(var6_7).append(" to ");
                            var16_17 = this.mNewVersion;
                            var17_18 = var15_16.append(var16_17).append(": ");
                            var18_19 = var4_4.getPath();
                            var19_20 = var17_18.append(var18_19).toString();
                            var20_21 = Log.wtf(var14_15, var19_20);
                        }
                        var21_22 = this.mNewVersion;
                        this.onUpgrade(var4_4, var6_7, var21_22);
                    }
                    var8_9 = this.mNewVersion;
                    var4_4.setVersion(var8_9);
                    var4_4.setTransactionSuccessful();
                    var4_4.endTransaction();
lbl43:
                    // 2 sources

                    this.onOpen(var4_4);
                    var3_3 = true;
                    var1_1 = null;
                    this.mIsInitializing = var1_1;
                    if (!var3_3) ** GOTO lbl68
                    var1_1 = this.mDatabase;
                    if (var1_1 == null) break block25;
                    try {
                        this.mDatabase.close();
                        break block26;
                    }
                    catch (Exception var24_25) {}
                    catch (Throwable var5_6) {
                        try {
                            var4_4.endTransaction();
                            throw var5_6;
                        }
                        catch (Throwable var1_2) {
                            block30: {
                                block27: {
                                    block29: {
                                        var22_23 = null;
                                        this.mIsInitializing = var22_23;
                                        if (!var3_3) break block29;
                                        var22_23 = this.mDatabase;
                                        if (var22_23 == null) break block30;
                                        try {
                                            this.mDatabase.close();
                                            break block27;
                                        }
                                        catch (Exception var23_24) {}
lbl68:
                                        // 1 sources

                                        if (this.mDatabase != null) {
                                            this.mDatabase.unlock();
                                        }
                                        if (var4_4 == null) return var4_4;
                                        var4_4.close();
                                        return var4_4;
                                    }
                                    if (this.mDatabase != null) {
                                        this.mDatabase.unlock();
                                    }
                                    if (var4_4 == null) throw var1_2;
                                    var4_4.close();
                                    throw var1_2;
                                }
                                this.mDatabase.unlock();
                            }
                            this.mDatabase = var4_4;
                            throw var1_2;
                        }
                    }
                }
                this.mDatabase.unlock();
            }
            this.mDatabase = var4_4;
            return var4_4;
        }
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public void onOpen(SQLiteDatabase sQLiteDatabase) {
    }

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);
}

