/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteCompiledSql;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.util.Log;
import java.util.Map;

public abstract class SQLiteProgram
extends SQLiteClosable {
    private static final String TAG = "SQLiteProgram";
    private SQLiteCompiledSql mCompiledSql;
    @Deprecated
    protected SQLiteDatabase mDatabase;
    final String mSql;
    @Deprecated
    protected int nHandle = 0;
    @Deprecated
    protected int nStatement = 0;

    /*
     * Enabled aggressive block sorting
     */
    SQLiteProgram(SQLiteDatabase sQLiteDatabase, String string2) {
        int n;
        SQLiteCompiledSql sQLiteCompiledSql;
        int n2;
        String string3;
        this.mDatabase = sQLiteDatabase;
        this.mSql = string3 = string2.trim();
        sQLiteDatabase.acquireReference();
        sQLiteDatabase.addSQLiteClosable(this);
        this.nHandle = n2 = sQLiteDatabase.mNativeHandle;
        String string4 = this.mSql.substring(0, 6);
        if (!(string4.equalsIgnoreCase("INSERT") || string4.equalsIgnoreCase("UPDATE") || string4.equalsIgnoreCase("REPLAC") || string4.equalsIgnoreCase("DELETE") || string4.equalsIgnoreCase("SELECT"))) {
            int n3;
            SQLiteCompiledSql sQLiteCompiledSql2;
            this.mCompiledSql = sQLiteCompiledSql2 = new SQLiteCompiledSql(sQLiteDatabase, string2);
            this.nStatement = n3 = this.mCompiledSql.nStatement;
            return;
        }
        this.mCompiledSql = sQLiteCompiledSql = sQLiteDatabase.getCompiledStatementForSql(string2);
        if (this.mCompiledSql == null) {
            SQLiteCompiledSql sQLiteCompiledSql3;
            this.mCompiledSql = sQLiteCompiledSql3 = new SQLiteCompiledSql(sQLiteDatabase, string2);
            boolean bl = this.mCompiledSql.acquire();
            SQLiteCompiledSql sQLiteCompiledSql4 = this.mCompiledSql;
            sQLiteDatabase.addToCompiledQueries(string2, sQLiteCompiledSql4);
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                StringBuilder stringBuilder = new StringBuilder().append("Created DbObj (id#");
                int n4 = this.mCompiledSql.nStatement;
                String string5 = stringBuilder.append(n4).append(") for sql: ").append(string2).toString();
                int n5 = Log.v(TAG, string5);
            }
        } else if (!this.mCompiledSql.acquire()) {
            SQLiteCompiledSql sQLiteCompiledSql5;
            int n6 = this.mCompiledSql.nStatement;
            this.mCompiledSql = sQLiteCompiledSql5 = new SQLiteCompiledSql(sQLiteDatabase, string2);
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                StringBuilder stringBuilder = new StringBuilder().append("** possible bug ** Created NEW DbObj (id#");
                int n7 = this.mCompiledSql.nStatement;
                String string6 = stringBuilder.append(n7).append(") because the previously created DbObj (id#").append(n6).append(") was not released for sql:").append(string2).toString();
                int n8 = Log.v(TAG, string6);
            }
        }
        this.nStatement = n = this.mCompiledSql.nStatement;
    }

    private final native void native_clear_bindings();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseCompiledSqlIfNotInCache() {
        if (this.mCompiledSql == null) {
            return;
        }
        Map<String, SQLiteCompiledSql> map = this.mDatabase.mCompiledQueries;
        synchronized (map) {
            Map<String, SQLiteCompiledSql> map2 = this.mDatabase.mCompiledQueries;
            SQLiteCompiledSql sQLiteCompiledSql = this.mCompiledSql;
            if (!map2.containsValue(sQLiteCompiledSql)) {
                this.mCompiledSql.releaseSqlStatement();
                this.mCompiledSql = null;
                this.nStatement = 0;
            } else {
                this.mCompiledSql.release();
            }
            return;
        }
    }

    public void bindBlob(int n, byte[] byArray) {
        if (byArray == null) {
            String string2 = "the bind value at index " + n + " is null";
            throw new IllegalArgumentException(string2);
        }
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string3 = this.mDatabase.getPath();
            String string4 = stringBuilder.append(string3).append(" already closed").toString();
            throw new IllegalStateException(string4);
        }
        this.acquireReference();
        try {
            this.native_bind_blob(n, byArray);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void bindDouble(int n, double d) {
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string2 = this.mDatabase.getPath();
            String string3 = stringBuilder.append(string2).append(" already closed").toString();
            throw new IllegalStateException(string3);
        }
        this.acquireReference();
        try {
            this.native_bind_double(n, d);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void bindLong(int n, long l) {
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string2 = this.mDatabase.getPath();
            String string3 = stringBuilder.append(string2).append(" already closed").toString();
            throw new IllegalStateException(string3);
        }
        this.acquireReference();
        try {
            this.native_bind_long(n, l);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void bindNull(int n) {
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string2 = this.mDatabase.getPath();
            String string3 = stringBuilder.append(string2).append(" already closed").toString();
            throw new IllegalStateException(string3);
        }
        this.acquireReference();
        try {
            this.native_bind_null(n);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void bindString(int n, String string2) {
        if (string2 == null) {
            String string3 = "the bind value at index " + n + " is null";
            throw new IllegalArgumentException(string3);
        }
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string4 = this.mDatabase.getPath();
            String string5 = stringBuilder.append(string4).append(" already closed").toString();
            throw new IllegalStateException(string5);
        }
        this.acquireReference();
        try {
            this.native_bind_string(n, string2);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void clearBindings() {
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string2 = this.mDatabase.getPath();
            String string3 = stringBuilder.append(string2).append(" already closed").toString();
            throw new IllegalStateException(string3);
        }
        this.acquireReference();
        try {
            this.native_clear_bindings();
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void close() {
        if (!this.mDatabase.isOpen()) {
            return;
        }
        this.mDatabase.lock();
        try {
            this.releaseReference();
            return;
        }
        finally {
            this.mDatabase.unlock();
        }
    }

    @Deprecated
    protected void compile(String string2, boolean bl) {
    }

    String getSqlString() {
        return this.mSql;
    }

    public final int getUniqueId() {
        return this.nStatement;
    }

    protected final native void native_bind_blob(int var1, byte[] var2);

    protected final native void native_bind_double(int var1, double var2);

    protected final native void native_bind_long(int var1, long var2);

    protected final native void native_bind_null(int var1);

    protected final native void native_bind_string(int var1, String var2);

    @Deprecated
    protected final native void native_compile(String var1);

    @Deprecated
    protected final native void native_finalize();

    @Override
    protected void onAllReferencesReleased() {
        this.releaseCompiledSqlIfNotInCache();
        this.mDatabase.releaseReference();
        this.mDatabase.removeSQLiteClosable(this);
    }

    @Override
    protected void onAllReferencesReleasedFromContainer() {
        this.releaseCompiledSqlIfNotInCache();
        this.mDatabase.releaseReference();
    }
}

