/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.CursorWindow;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteMisuseException;
import android.database.sqlite.SQLiteProgram;
import android.os.SystemClock;
import android.util.Log;

public class SQLiteQuery
extends SQLiteProgram {
    private static final String TAG = "Cursor";
    private String[] mBindArgs;
    private boolean mClosed = false;
    private int mOffsetIndex;

    SQLiteQuery(SQLiteDatabase sQLiteDatabase, String string2, int n, String[] stringArray) {
        super(sQLiteDatabase, string2);
        this.mOffsetIndex = n;
        this.mBindArgs = stringArray;
    }

    private final native int native_column_count();

    private final native String native_column_name(int var1);

    private final native int native_fill_window(CursorWindow var1, int var2, int var3, int var4, int var5);

    @Override
    public void bindDouble(int n, double d) {
        String string2;
        String[] stringArray = this.mBindArgs;
        int n2 = n - 1;
        stringArray[n2] = string2 = Double.toString(d);
        if (this.mClosed) {
            return;
        }
        super.bindDouble(n, d);
    }

    @Override
    public void bindLong(int n, long l) {
        String string2;
        String[] stringArray = this.mBindArgs;
        int n2 = n - 1;
        stringArray[n2] = string2 = Long.toString(l);
        if (this.mClosed) {
            return;
        }
        super.bindLong(n, l);
    }

    @Override
    public void bindNull(int n) {
        String[] stringArray = this.mBindArgs;
        int n2 = n - 1;
        stringArray[n2] = null;
        if (this.mClosed) {
            return;
        }
        super.bindNull(n);
    }

    @Override
    public void bindString(int n, String string2) {
        String[] stringArray = this.mBindArgs;
        int n2 = n - 1;
        stringArray[n2] = string2;
        if (this.mClosed) {
            return;
        }
        super.bindString(n, string2);
    }

    @Override
    public void close() {
        super.close();
        this.mClosed = true;
    }

    int columnCountLocked() {
        int n;
        this.acquireReference();
        try {
            int n2;
            n = n2 = this.native_column_count();
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return n;
    }

    String columnNameLocked(int n) {
        String string2;
        this.acquireReference();
        try {
            String string3;
            string2 = string3 = this.native_column_name(n);
        }
        catch (Throwable throwable) {
            this.releaseReference();
            throw throwable;
        }
        this.releaseReference();
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    int fillWindow(CursorWindow var1_1, int var2_2, int var3_3) {
        var4_4 = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        var6_5 = this.mDatabase;
        var7_6 = this.mSql;
        var6_5.logTimeStat(var7_6, var4_4, "GETLOCK:");
        this.acquireReference();
        var1_1.acquireReference();
        var8_7 = var1_1.getStartPosition();
        var9_8 = this.mOffsetIndex;
        var10_9 = this;
        var11_10 = var1_1;
        var12_11 = var2_2;
        var13_12 = var3_3;
        var14_13 = var10_9.native_fill_window(var11_10, var8_7, var9_8, var12_11, var13_12);
        if (SQLiteDebug.DEBUG_SQL_STATEMENTS) {
            var15_14 = new StringBuilder().append("fillWindow(): ");
            var16_15 = this.mSql;
            var17_16 = var15_14.append(var16_15).toString();
            var18_17 = Log.d("Cursor", var17_16);
        }
        var19_18 = this.mDatabase;
        var20_19 = this.mSql;
        var19_18.logTimeStat(var20_19, var4_4);
        var1_1.releaseReference();
        var21_20 = var14_13;
lbl28:
        // 2 sources

        return var21_20;
        catch (IllegalStateException var22_21) {
            var21_20 = 0;
            var1_1.releaseReference();
            this.releaseReference();
            this.mDatabase.unlock();
            ** continue;
        }
        catch (SQLiteDatabaseCorruptException var23_22) {
            try {
                this.mDatabase.onCorruption();
                throw var23_22;
            }
            catch (Throwable var24_23) {
                var1_1.releaseReference();
                throw var24_23;
                {
                    catch (Throwable var25_24) {
                        throw var25_24;
                    }
                }
            }
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    void requery() {
        if (this.mBindArgs == null) {
            return;
        }
        int n = this.mBindArgs.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            try {
                String string2 = this.mBindArgs[n2];
                super.bindString(n3, string2);
                ++n2;
            }
            catch (SQLiteMisuseException sQLiteMisuseException) {
                StringBuilder stringBuilder = new StringBuilder().append("mSql ");
                String string3 = this.mSql;
                String string4 = stringBuilder.append(string3).toString();
                StringBuilder stringBuilder2 = new StringBuilder(string4);
                for (int i = 0; i < n; ++i) {
                    StringBuilder stringBuilder3 = stringBuilder2.append(" ");
                    String string5 = this.mBindArgs[i];
                    StringBuilder stringBuilder4 = stringBuilder2.append(string5);
                }
                StringBuilder stringBuilder5 = stringBuilder2.append(" ");
                String string6 = stringBuilder2.toString();
                throw new IllegalStateException(string6, sQLiteMisuseException);
            }
        }
        return;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("SQLiteQuery: ");
        String string2 = this.mSql;
        return stringBuilder.append(string2).toString();
    }
}

