/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SQLiteQueryBuilder {
    private static final String TAG = "SQLiteQueryBuilder";
    private static final Pattern sLimitPattern = Pattern.compile("\\s*\\d+\\s*(,\\s*\\d+\\s*)?");
    private boolean mDistinct = false;
    private SQLiteDatabase.CursorFactory mFactory = null;
    private Map<String, String> mProjectionMap = null;
    private boolean mStrictProjectionMap;
    private String mTables = "";
    private StringBuilder mWhereClause = null;

    private static void appendClause(StringBuilder stringBuilder, String string2, String string3) {
        if (TextUtils.isEmpty(string3)) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        StringBuilder stringBuilder3 = stringBuilder.append(string3);
    }

    private static void appendClauseEscapeClause(StringBuilder stringBuilder, String string2, String string3) {
        if (TextUtils.isEmpty(string3)) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        DatabaseUtils.appendEscapedSQLString(stringBuilder, string3);
    }

    public static void appendColumns(StringBuilder stringBuilder, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) continue;
            if (i > 0) {
                StringBuilder stringBuilder2 = stringBuilder.append(", ");
            }
            StringBuilder stringBuilder3 = stringBuilder.append(string2);
        }
        StringBuilder stringBuilder4 = stringBuilder.append(' ');
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String buildQueryString(boolean bl, String string2, String[] stringArray, String string3, String string4, String string5, String string6, String string7) {
        if (TextUtils.isEmpty(string4) && !TextUtils.isEmpty(string5)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        if (!TextUtils.isEmpty(string7) && !sLimitPattern.matcher(string7).matches()) {
            String string8 = "invalid LIMIT clauses:" + string7;
            throw new IllegalArgumentException(string8);
        }
        StringBuilder stringBuilder = new StringBuilder(120);
        StringBuilder stringBuilder2 = stringBuilder.append("SELECT ");
        if (bl) {
            StringBuilder stringBuilder3 = stringBuilder.append("DISTINCT ");
        }
        if (stringArray != null && stringArray.length != 0) {
            SQLiteQueryBuilder.appendColumns(stringBuilder, stringArray);
        } else {
            StringBuilder stringBuilder4 = stringBuilder.append("* ");
        }
        StringBuilder stringBuilder5 = stringBuilder.append("FROM ");
        StringBuilder stringBuilder6 = stringBuilder.append(string2);
        SQLiteQueryBuilder.appendClause(stringBuilder, " WHERE ", string3);
        SQLiteQueryBuilder.appendClause(stringBuilder, " GROUP BY ", string4);
        SQLiteQueryBuilder.appendClause(stringBuilder, " HAVING ", string5);
        SQLiteQueryBuilder.appendClause(stringBuilder, " ORDER BY ", string6);
        SQLiteQueryBuilder.appendClause(stringBuilder, " LIMIT ", string7);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String[] computeProjection(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (this.mProjectionMap == null) {
                return stringArray;
            }
        } else {
            if (this.mProjectionMap == null) {
                return null;
            }
            Set<Map.Entry<String, String>> set = this.mProjectionMap.entrySet();
            String[] stringArray2 = new String[set.size()];
            Iterator<Map.Entry<String, String>> iterator = set.iterator();
            int n = 0;
            while (true) {
                String string2;
                if (!iterator.hasNext()) {
                    return stringArray2;
                }
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().equals("_count")) continue;
                int n2 = n + 1;
                stringArray2[n] = string2 = entry.getValue();
                int n3 = n2;
            }
        }
        String[] stringArray3 = new String[stringArray.length];
        int n = stringArray.length;
        int n4 = 0;
        while (true) {
            if (n4 >= n) {
                return stringArray3;
            }
            String string3 = stringArray[n4];
            String string4 = this.mProjectionMap.get(string3);
            if (string4 != null) {
                stringArray3[n4] = string4;
            } else {
                if (this.mStrictProjectionMap || !string3.contains(" AS ") && !string3.contains(" as ")) break;
                stringArray3[n4] = string3;
            }
            ++n4;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Invalid column ");
        String string5 = stringArray[n4];
        String string6 = stringBuilder.append(string5).toString();
        throw new IllegalArgumentException(string6);
    }

    public void appendWhere(CharSequence charSequence) {
        if (this.mWhereClause == null) {
            StringBuilder stringBuilder;
            int n = charSequence.length() + 16;
            this.mWhereClause = stringBuilder = new StringBuilder(n);
        }
        if (this.mWhereClause.length() == 0) {
            StringBuilder stringBuilder = this.mWhereClause.append('(');
        }
        StringBuilder stringBuilder = this.mWhereClause.append(charSequence);
    }

    public void appendWhereEscapeString(String string2) {
        if (this.mWhereClause == null) {
            StringBuilder stringBuilder;
            int n = string2.length() + 16;
            this.mWhereClause = stringBuilder = new StringBuilder(n);
        }
        if (this.mWhereClause.length() == 0) {
            StringBuilder stringBuilder = this.mWhereClause.append('(');
        }
        DatabaseUtils.appendEscapedSQLString(this.mWhereClause, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildQuery(String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        String[] stringArray3 = this.computeProjection(stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.mWhereClause != null && this.mWhereClause.length() > 0;
        if (bl) {
            String string7 = this.mWhereClause.toString();
            StringBuilder stringBuilder2 = stringBuilder.append(string7);
            StringBuilder stringBuilder3 = stringBuilder.append(')');
        }
        if (string2 != null && string2.length() > 0) {
            if (bl) {
                StringBuilder stringBuilder4 = stringBuilder.append(" AND ");
            }
            StringBuilder stringBuilder5 = stringBuilder.append('(');
            StringBuilder stringBuilder6 = stringBuilder.append(string2);
            StringBuilder stringBuilder7 = stringBuilder.append(')');
        }
        boolean bl2 = this.mDistinct;
        String string8 = this.mTables;
        String string9 = stringBuilder.toString();
        String string10 = string3;
        String string11 = string4;
        String string12 = string5;
        String string13 = string6;
        return SQLiteQueryBuilder.buildQueryString(bl2, string8, stringArray3, string9, string10, string11, string12, string13);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildUnionQuery(String[] stringArray, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(128);
        int n = stringArray.length;
        String string4 = this.mDistinct ? " UNION " : " UNION ALL ";
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                SQLiteQueryBuilder.appendClause(stringBuilder, " ORDER BY ", string2);
                SQLiteQueryBuilder.appendClause(stringBuilder, " LIMIT ", string3);
                return stringBuilder.toString();
            }
            if (n2 > 0) {
                StringBuilder stringBuilder2 = stringBuilder.append(string4);
            }
            String string5 = stringArray[n2];
            StringBuilder stringBuilder3 = stringBuilder.append(string5);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildUnionSubQuery(String string2, String[] stringArray, Set<String> set, int n, String string3, String string4, String[] stringArray2, String string5, String string6) {
        int n2 = stringArray.length;
        String[] stringArray3 = new String[n2];
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                SQLiteQueryBuilder sQLiteQueryBuilder = this;
                String string7 = string4;
                String[] stringArray4 = stringArray2;
                String string8 = string5;
                String string9 = string6;
                return sQLiteQueryBuilder.buildQuery(stringArray3, string7, stringArray4, string8, string9, null, null);
            }
            String string10 = stringArray[n3];
            if (string10.equals(string2)) {
                String string11;
                StringBuilder stringBuilder = new StringBuilder().append("'");
                String string12 = string3;
                stringArray3[n3] = string11 = stringBuilder.append(string12).append("' AS ").append(string2).toString();
            } else {
                String string13;
                String string14;
                Set<String> set2;
                int n4 = n3;
                int n5 = n;
                stringArray3[n3] = n4 <= n5 || (set2 = set).contains(string14 = string10) ? string10 : (string13 = "NULL AS " + string10);
            }
            ++n3;
        }
    }

    public String getTables() {
        return this.mTables;
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5) {
        SQLiteQueryBuilder sQLiteQueryBuilder = this;
        SQLiteDatabase sQLiteDatabase2 = sQLiteDatabase;
        String[] stringArray3 = stringArray;
        String string6 = string2;
        String[] stringArray4 = stringArray2;
        String string7 = string3;
        String string8 = string4;
        String string9 = string5;
        return sQLiteQueryBuilder.query(sQLiteDatabase2, stringArray3, string6, stringArray4, string7, string8, string9, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        if (this.mTables == null) {
            return null;
        }
        SQLiteQueryBuilder sQLiteQueryBuilder = this;
        String[] stringArray3 = stringArray;
        String string7 = string2;
        String[] stringArray4 = stringArray2;
        String string8 = string3;
        String string9 = string4;
        String string10 = string5;
        String string11 = string6;
        String string12 = sQLiteQueryBuilder.buildQuery(stringArray3, string7, stringArray4, string8, string9, string10, string11);
        if (Log.isLoggable(TAG, 3)) {
            String string13 = "Performing query: " + string12;
            int n = Log.d(TAG, string13);
        }
        SQLiteDatabase.CursorFactory cursorFactory = this.mFactory;
        String string14 = SQLiteDatabase.findEditTable(this.mTables);
        return sQLiteDatabase.rawQueryWithFactory(cursorFactory, string12, stringArray2, string14);
    }

    public void setCursorFactory(SQLiteDatabase.CursorFactory cursorFactory) {
        this.mFactory = cursorFactory;
    }

    public void setDistinct(boolean bl) {
        this.mDistinct = bl;
    }

    public void setProjectionMap(Map<String, String> map) {
        this.mProjectionMap = map;
    }

    public void setStrictProjectionMap(boolean bl) {
        this.mStrictProjectionMap = bl;
    }

    public void setTables(String string2) {
        this.mTables = string2;
    }
}

