/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.os.SystemClock;
import dalvik.system.BlockGuard;

public class SQLiteStatement
extends SQLiteProgram {
    SQLiteStatement(SQLiteDatabase sQLiteDatabase, String string2) {
        super(sQLiteDatabase, string2);
    }

    private final native long native_1x1_long();

    private final native String native_1x1_string();

    private final native void native_execute();

    public void execute() {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string2 = this.mDatabase.getPath();
            String string3 = stringBuilder.append(string2).append(" already closed").toString();
            throw new IllegalStateException(string3);
        }
        long l = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
            SQLiteDatabase sQLiteDatabase = this.mDatabase;
            String string4 = this.mSql;
            sQLiteDatabase.logTimeStat(string4, l);
            return;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long executeInsert() {
        BlockGuard.getThreadPolicy().onWriteToDisk();
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string2 = this.mDatabase.getPath();
            String string3 = stringBuilder.append(string2).append(" already closed").toString();
            throw new IllegalStateException(string3);
        }
        long l = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            long l2;
            this.native_execute();
            SQLiteDatabase sQLiteDatabase = this.mDatabase;
            String string4 = this.mSql;
            sQLiteDatabase.logTimeStat(string4, l);
            long l3 = this.mDatabase.lastChangeCount() > 0 ? (l2 = this.mDatabase.lastInsertRow()) : 65535L;
            return l3;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    public long simpleQueryForLong() {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string2 = this.mDatabase.getPath();
            String string3 = stringBuilder.append(string2).append(" already closed").toString();
            throw new IllegalStateException(string3);
        }
        long l = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            long l2 = this.native_1x1_long();
            SQLiteDatabase sQLiteDatabase = this.mDatabase;
            String string4 = this.mSql;
            sQLiteDatabase.logTimeStat(string4, l);
            return l2;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    public String simpleQueryForString() {
        BlockGuard.getThreadPolicy().onReadFromDisk();
        if (!this.mDatabase.isOpen()) {
            StringBuilder stringBuilder = new StringBuilder().append("database ");
            String string2 = this.mDatabase.getPath();
            String string3 = stringBuilder.append(string2).append(" already closed").toString();
            throw new IllegalStateException(string3);
        }
        long l = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            String string4 = this.native_1x1_string();
            SQLiteDatabase sQLiteDatabase = this.mDatabase;
            String string5 = this.mSql;
            sQLiteDatabase.logTimeStat(string5, l);
            return string4;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }
}

