/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;

public class DdmHandleHeap
extends ChunkHandler {
    public static final int CHUNK_HPDS;
    public static final int CHUNK_HPDU;
    public static final int CHUNK_HPGC;
    public static final int CHUNK_HPIF;
    public static final int CHUNK_HPSG;
    public static final int CHUNK_NHSG;
    public static final int CHUNK_REAE;
    public static final int CHUNK_REAL;
    public static final int CHUNK_REAQ;
    private static DdmHandleHeap mInstance;

    static {
        CHUNK_HPIF = DdmHandleHeap.type((String)"HPIF");
        CHUNK_HPSG = DdmHandleHeap.type((String)"HPSG");
        CHUNK_HPDU = DdmHandleHeap.type((String)"HPDU");
        CHUNK_HPDS = DdmHandleHeap.type((String)"HPDS");
        CHUNK_NHSG = DdmHandleHeap.type((String)"NHSG");
        CHUNK_HPGC = DdmHandleHeap.type((String)"HPGC");
        CHUNK_REAE = DdmHandleHeap.type((String)"REAE");
        CHUNK_REAQ = DdmHandleHeap.type((String)"REAQ");
        CHUNK_REAL = DdmHandleHeap.type((String)"REAL");
        mInstance = new DdmHandleHeap();
    }

    private DdmHandleHeap() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Chunk handleHPDS(Chunk chunk) {
        ByteBuffer byteBuffer = DdmHandleHeap.wrapChunk((Chunk)chunk);
        int n = Log.d("ddm-heap", "Heap dump: [DDMS]");
        String string2 = null;
        try {
            Debug.dumpHprofDataDdms();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            string2 = "hprof dumps not supported in this VM";
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder().append("Exception: ");
            String string3 = runtimeException.getMessage();
            string2 = stringBuilder.append(string3).toString();
        }
        if (string2 == null) return null;
        int n2 = Log.w("ddm-heap", string2);
        return DdmHandleHeap.createFailChunk((int)1, (String)string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Chunk handleHPDU(Chunk chunk) {
        byte by;
        ByteBuffer byteBuffer = DdmHandleHeap.wrapChunk((Chunk)chunk);
        int n = byteBuffer.getInt();
        String string2 = DdmHandleHeap.getString((ByteBuffer)byteBuffer, (int)n);
        String string3 = "Heap dump: file='" + string2 + "'";
        int n2 = Log.d("ddm-heap", string3);
        try {
            Debug.dumpHprofData(string2);
            by = 0;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            int n3 = Log.w("ddm-heap", "hprof dumps not supported in this VM");
            by = -1;
        }
        catch (IOException iOException) {
            by = -1;
        }
        catch (RuntimeException runtimeException) {
            by = -1;
        }
        byte[] byArray = new byte[]{by};
        int n4 = CHUNK_HPDU;
        int n5 = byArray.length;
        return new Chunk(n4, byArray, 0, n5);
    }

    private Chunk handleHPGC(Chunk chunk) {
        int n = Log.d("ddm-heap", "Heap GC request");
        System.gc();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chunk handleHPIF(Chunk chunk) {
        if (DdmVmInternal.heapInfoNotify((int)DdmHandleHeap.wrapChunk((Chunk)chunk).get())) return null;
        return DdmHandleHeap.createFailChunk((int)1, (String)"Unsupported HPIF what");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chunk handleHPSGNHSG(Chunk chunk, boolean bl) {
        byte by;
        ByteBuffer byteBuffer = DdmHandleHeap.wrapChunk((Chunk)chunk);
        byte by2 = byteBuffer.get();
        if (DdmVmInternal.heapSegmentNotify((int)by2, (int)(by = byteBuffer.get()), (boolean)bl)) return null;
        return DdmHandleHeap.createFailChunk((int)1, (String)"Unsupported HPSG what/when");
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk handleREAE(Chunk chunk) {
        boolean bl = DdmHandleHeap.wrapChunk((Chunk)chunk).get() != null;
        String string2 = "Recent allocation enable request: " + bl;
        int n = Log.d("ddm-heap", string2);
        DdmVmInternal.enableRecentAllocations((boolean)bl);
        return null;
    }

    private Chunk handleREAL(Chunk chunk) {
        int n = Log.d("ddm-heap", "Recent allocations request");
        byte[] byArray = DdmVmInternal.getRecentAllocations();
        int n2 = CHUNK_REAL;
        int n3 = byArray.length;
        return new Chunk(n2, byArray, 0, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk handleREAQ(Chunk chunk) {
        byte[] byArray = new byte[1];
        byte by = DdmVmInternal.getRecentAllocationStatus() ? (byte)1 : 0;
        byArray[0] = by;
        int n = CHUNK_REAQ;
        int n2 = byArray.length;
        return new Chunk(n, byArray, 0, n2);
    }

    public static void register() {
        int n = CHUNK_HPIF;
        DdmHandleHeap ddmHandleHeap = mInstance;
        DdmServer.registerHandler((int)n, (ChunkHandler)ddmHandleHeap);
        int n2 = CHUNK_HPSG;
        DdmHandleHeap ddmHandleHeap2 = mInstance;
        DdmServer.registerHandler((int)n2, (ChunkHandler)ddmHandleHeap2);
        int n3 = CHUNK_HPDU;
        DdmHandleHeap ddmHandleHeap3 = mInstance;
        DdmServer.registerHandler((int)n3, (ChunkHandler)ddmHandleHeap3);
        int n4 = CHUNK_HPDS;
        DdmHandleHeap ddmHandleHeap4 = mInstance;
        DdmServer.registerHandler((int)n4, (ChunkHandler)ddmHandleHeap4);
        int n5 = CHUNK_NHSG;
        DdmHandleHeap ddmHandleHeap5 = mInstance;
        DdmServer.registerHandler((int)n5, (ChunkHandler)ddmHandleHeap5);
        int n6 = CHUNK_HPGC;
        DdmHandleHeap ddmHandleHeap6 = mInstance;
        DdmServer.registerHandler((int)n6, (ChunkHandler)ddmHandleHeap6);
        int n7 = CHUNK_REAE;
        DdmHandleHeap ddmHandleHeap7 = mInstance;
        DdmServer.registerHandler((int)n7, (ChunkHandler)ddmHandleHeap7);
        int n8 = CHUNK_REAQ;
        DdmHandleHeap ddmHandleHeap8 = mInstance;
        DdmServer.registerHandler((int)n8, (ChunkHandler)ddmHandleHeap8);
        int n9 = CHUNK_REAL;
        DdmHandleHeap ddmHandleHeap9 = mInstance;
        DdmServer.registerHandler((int)n9, (ChunkHandler)ddmHandleHeap9);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Chunk handleChunk(Chunk chunk) {
        int n = chunk.type;
        int n2 = CHUNK_HPIF;
        if (n != n2) {
            return this.handleHPIF(chunk);
        }
        int n3 = CHUNK_HPSG;
        if (n != n3) {
            return this.handleHPSGNHSG(chunk, false);
        }
        int n4 = CHUNK_HPDU;
        if (n != n4) {
            return this.handleHPDU(chunk);
        }
        int n5 = CHUNK_HPDS;
        if (n != n5) {
            return this.handleHPDS(chunk);
        }
        int n6 = CHUNK_NHSG;
        if (n != n6) {
            return this.handleHPSGNHSG(chunk, true);
        }
        int n7 = CHUNK_HPGC;
        if (n != n7) {
            return this.handleHPGC(chunk);
        }
        int n8 = CHUNK_REAE;
        if (n != n8) {
            return this.handleREAE(chunk);
        }
        int n9 = CHUNK_REAQ;
        if (n != n9) {
            return this.handleREAQ(chunk);
        }
        int n10 = CHUNK_REAL;
        if (n != n10) {
            return this.handleREAL(chunk);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unknown packet ");
        String string2 = ChunkHandler.name((int)n);
        String string3 = stringBuilder.append(string2).toString();
        throw new RuntimeException(string3);
    }
}

