/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleProfiling
extends ChunkHandler {
    public static final int CHUNK_MPRE;
    public static final int CHUNK_MPRQ;
    public static final int CHUNK_MPRS;
    public static final int CHUNK_MPSE;
    public static final int CHUNK_MPSS;
    private static DdmHandleProfiling mInstance;

    static {
        CHUNK_MPRS = DdmHandleProfiling.type((String)"MPRS");
        CHUNK_MPRE = DdmHandleProfiling.type((String)"MPRE");
        CHUNK_MPSS = DdmHandleProfiling.type((String)"MPSS");
        CHUNK_MPSE = DdmHandleProfiling.type((String)"MPSE");
        CHUNK_MPRQ = DdmHandleProfiling.type((String)"MPRQ");
        mInstance = new DdmHandleProfiling();
    }

    private DdmHandleProfiling() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Chunk handleMPRE(Chunk chunk) {
        byte by;
        try {
            Debug.stopMethodTracing();
            by = 0;
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder().append("Method profiling end failed: ");
            String string2 = runtimeException.getMessage();
            String string3 = stringBuilder.append(string2).toString();
            int n = Log.w("ddm-heap", string3);
            by = 1;
        }
        byte[] byArray = new byte[]{by};
        int n = CHUNK_MPRE;
        int n2 = byArray.length;
        return new Chunk(n, byArray, 0, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk handleMPRQ(Chunk chunk) {
        boolean bl = Debug.isMethodTracingActive();
        byte by = (byte)(bl ? 1 : 0);
        byte[] byArray = new byte[]{by};
        int n = CHUNK_MPRQ;
        int n2 = byArray.length;
        return new Chunk(n, byArray, 0, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chunk handleMPRS(Chunk chunk) {
        ByteBuffer byteBuffer = DdmHandleProfiling.wrapChunk((Chunk)chunk);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        String string2 = DdmHandleProfiling.getString((ByteBuffer)byteBuffer, (int)n3);
        try {
            Debug.startMethodTracing(string2, n, n2);
            return null;
        }
        catch (RuntimeException runtimeException) {
            String string3 = runtimeException.getMessage();
            return DdmHandleProfiling.createFailChunk((int)1, (String)string3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chunk handleMPSE(Chunk chunk) {
        try {
            Debug.stopMethodTracing();
            return null;
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder().append("Method prof stream end failed: ");
            String string2 = runtimeException.getMessage();
            String string3 = stringBuilder.append(string2).toString();
            int n = Log.w("ddm-heap", string3);
            String string4 = runtimeException.getMessage();
            return DdmHandleProfiling.createFailChunk((int)1, (String)string4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chunk handleMPSS(Chunk chunk) {
        ByteBuffer byteBuffer = DdmHandleProfiling.wrapChunk((Chunk)chunk);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        try {
            Debug.startMethodTracingDdms(n, n2);
            return null;
        }
        catch (RuntimeException runtimeException) {
            String string2 = runtimeException.getMessage();
            return DdmHandleProfiling.createFailChunk((int)1, (String)string2);
        }
    }

    public static void register() {
        int n = CHUNK_MPRS;
        DdmHandleProfiling ddmHandleProfiling = mInstance;
        DdmServer.registerHandler((int)n, (ChunkHandler)ddmHandleProfiling);
        int n2 = CHUNK_MPRE;
        DdmHandleProfiling ddmHandleProfiling2 = mInstance;
        DdmServer.registerHandler((int)n2, (ChunkHandler)ddmHandleProfiling2);
        int n3 = CHUNK_MPSS;
        DdmHandleProfiling ddmHandleProfiling3 = mInstance;
        DdmServer.registerHandler((int)n3, (ChunkHandler)ddmHandleProfiling3);
        int n4 = CHUNK_MPSE;
        DdmHandleProfiling ddmHandleProfiling4 = mInstance;
        DdmServer.registerHandler((int)n4, (ChunkHandler)ddmHandleProfiling4);
        int n5 = CHUNK_MPRQ;
        DdmHandleProfiling ddmHandleProfiling5 = mInstance;
        DdmServer.registerHandler((int)n5, (ChunkHandler)ddmHandleProfiling5);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Chunk handleChunk(Chunk chunk) {
        int n = chunk.type;
        int n2 = CHUNK_MPRS;
        if (n != n2) {
            return this.handleMPRS(chunk);
        }
        int n3 = CHUNK_MPRE;
        if (n != n3) {
            return this.handleMPRE(chunk);
        }
        int n4 = CHUNK_MPSS;
        if (n != n4) {
            return this.handleMPSS(chunk);
        }
        int n5 = CHUNK_MPSE;
        if (n != n5) {
            return this.handleMPSE(chunk);
        }
        int n6 = CHUNK_MPRQ;
        if (n != n6) {
            return this.handleMPRQ(chunk);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unknown packet ");
        String string2 = ChunkHandler.name((int)n);
        String string3 = stringBuilder.append(string2).toString();
        throw new RuntimeException(string3);
    }
}

