/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;

public class DdmHandleThread
extends ChunkHandler {
    public static final int CHUNK_STKL;
    public static final int CHUNK_THCR;
    public static final int CHUNK_THDE;
    public static final int CHUNK_THEN;
    public static final int CHUNK_THST;
    private static DdmHandleThread mInstance;

    static {
        CHUNK_THEN = DdmHandleThread.type((String)"THEN");
        CHUNK_THCR = DdmHandleThread.type((String)"THCR");
        CHUNK_THDE = DdmHandleThread.type((String)"THDE");
        CHUNK_THST = DdmHandleThread.type((String)"THST");
        CHUNK_STKL = DdmHandleThread.type((String)"STKL");
        mInstance = new DdmHandleThread();
    }

    private DdmHandleThread() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk createStackChunk(StackTraceElement[] stackTraceElementArray, int n) {
        int n2 = 0 + 4 + 4 + 4;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            int n3 = stackTraceElement.getClassName().length() * 2 + 4;
            int n4 = n2 + n3;
            int n5 = stackTraceElement.getMethodName().length() * 2 + 4;
            int n6 = n4 + n5 + 4;
            if (stackTraceElement.getFileName() != null) {
                int n7 = stackTraceElement.getFileName().length() * 2;
                n6 += n7;
            }
            n2 = n6 + 4;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        ByteBuffer byteBuffer2 = byteBuffer.putInt(0);
        ByteBuffer byteBuffer3 = byteBuffer.putInt(n);
        int n8 = stackTraceElementArray.length;
        ByteBuffer byteBuffer4 = byteBuffer.putInt(n8);
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        int n9 = stackTraceElementArray2.length;
        int n10 = 0;
        while (true) {
            if (n10 >= n9) {
                int n11 = CHUNK_STKL;
                return new Chunk(n11, byteBuffer);
            }
            StackTraceElement stackTraceElement = stackTraceElementArray2[n10];
            int n12 = stackTraceElement.getClassName().length();
            ByteBuffer byteBuffer5 = byteBuffer.putInt(n12);
            String string2 = stackTraceElement.getClassName();
            DdmHandleThread.putString((ByteBuffer)byteBuffer, (String)string2);
            int n13 = stackTraceElement.getMethodName().length();
            ByteBuffer byteBuffer6 = byteBuffer.putInt(n13);
            String string3 = stackTraceElement.getMethodName();
            DdmHandleThread.putString((ByteBuffer)byteBuffer, (String)string3);
            if (stackTraceElement.getFileName() != null) {
                int n14 = stackTraceElement.getFileName().length();
                ByteBuffer byteBuffer7 = byteBuffer.putInt(n14);
                String string4 = stackTraceElement.getFileName();
                DdmHandleThread.putString((ByteBuffer)byteBuffer, (String)string4);
            } else {
                ByteBuffer byteBuffer8 = byteBuffer.putInt(0);
            }
            int n15 = stackTraceElement.getLineNumber();
            ByteBuffer byteBuffer9 = byteBuffer.putInt(n15);
            ++n10;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chunk handleSTKL(Chunk chunk) {
        int n = DdmHandleThread.wrapChunk((Chunk)chunk).getInt();
        StackTraceElement[] stackTraceElementArray = DdmVmInternal.getStackTraceById((int)n);
        if (stackTraceElementArray != null) return this.createStackChunk(stackTraceElementArray, n);
        return DdmHandleThread.createFailChunk((int)1, (String)"Stack trace unavailable");
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk handleTHEN(Chunk chunk) {
        boolean bl = DdmHandleThread.wrapChunk((Chunk)chunk).get() != null;
        DdmVmInternal.threadNotify((boolean)bl);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chunk handleTHST(Chunk chunk) {
        ByteBuffer byteBuffer = DdmHandleThread.wrapChunk((Chunk)chunk);
        byte[] byArray = DdmVmInternal.getThreadStats();
        if (byArray == null) return DdmHandleThread.createFailChunk((int)1, (String)"Can't build THST chunk");
        int n = CHUNK_THST;
        int n2 = byArray.length;
        return new Chunk(n, byArray, 0, n2);
    }

    public static void register() {
        int n = CHUNK_THEN;
        DdmHandleThread ddmHandleThread = mInstance;
        DdmServer.registerHandler((int)n, (ChunkHandler)ddmHandleThread);
        int n2 = CHUNK_THST;
        DdmHandleThread ddmHandleThread2 = mInstance;
        DdmServer.registerHandler((int)n2, (ChunkHandler)ddmHandleThread2);
        int n3 = CHUNK_STKL;
        DdmHandleThread ddmHandleThread3 = mInstance;
        DdmServer.registerHandler((int)n3, (ChunkHandler)ddmHandleThread3);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Chunk handleChunk(Chunk chunk) {
        int n = chunk.type;
        int n2 = CHUNK_THEN;
        if (n != n2) {
            return this.handleTHEN(chunk);
        }
        int n3 = CHUNK_THST;
        if (n != n3) {
            return this.handleTHST(chunk);
        }
        int n4 = CHUNK_STKL;
        if (n != n4) {
            return this.handleSTKL(chunk);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unknown packet ");
        String string2 = ChunkHandler.name((int)n);
        String string3 = stringBuilder.append(string2).toString();
        throw new RuntimeException(string3);
    }
}

