/*
 * Decompiled with CFR 0.152.
 */
package android.drm.mobile1;

import android.drm.mobile1.DrmException;
import android.drm.mobile1.DrmRights;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DrmRawContent {
    public static final int DRM_COMBINED_DELIVERY = 2;
    public static final int DRM_FORWARD_LOCK = 1;
    private static final int DRM_MIMETYPE_CONTENT = 2;
    public static final String DRM_MIMETYPE_CONTENT_STRING = "application/vnd.oma.drm.content";
    private static final int DRM_MIMETYPE_MESSAGE = 1;
    public static final String DRM_MIMETYPE_MESSAGE_STRING = "application/vnd.oma.drm.message";
    public static final int DRM_SEPARATE_DELIVERY = 3;
    public static final int DRM_SEPARATE_DELIVERY_DM = 4;
    public static final int DRM_UNKNOWN_DATA_LEN = 255;
    private static final int JNI_DRM_EOF = 254;
    private static final int JNI_DRM_FAILURE = 255;
    private static final int JNI_DRM_SUCCESS = 0;
    private static final int JNI_DRM_UNKNOWN_DATA_LEN = 253;
    private int id = -1;
    private BufferedInputStream inData;
    private int inDataLen;
    private String mediaType;
    private int rawType;
    private String rightsIssuer;

    static {
        try {
            System.loadLibrary("drm1_jni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("WARNING: Could not load libdrm1_jni.so");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public DrmRawContent(InputStream inputStream, int n, String string2) throws DrmException, IOException {
        String string3;
        String string4;
        int n2;
        BufferedInputStream bufferedInputStream;
        this.inData = bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        this.inDataLen = n;
        if (DRM_MIMETYPE_MESSAGE_STRING.equals(string2)) {
            n2 = 1;
        } else {
            if (!DRM_MIMETYPE_CONTENT_STRING.equals(string2)) {
                throw new IllegalArgumentException("mimeType must be DRM_MIMETYPE_MESSAGE or DRM_MIMETYPE_CONTENT");
            }
            n2 = 2;
        }
        if (n <= 0) {
            throw new IllegalArgumentException("len must be > 0");
        }
        BufferedInputStream bufferedInputStream2 = this.inData;
        int n3 = this.inDataLen;
        int n4 = this.nativeConstructDrmContent(bufferedInputStream2, n3, n2);
        this.id = n4;
        int n5 = this.id;
        if (-1 != n5) {
            throw new DrmException("nativeConstructDrmContent() returned JNI_DRM_FAILURE");
        }
        this.rightsIssuer = string4 = this.nativeGetRightsAddress();
        int n6 = this.nativeGetDeliveryMethod();
        this.rawType = n6;
        int n7 = this.rawType;
        if (-1 != n7) {
            throw new DrmException("nativeGetDeliveryMethod() returned JNI_DRM_FAILURE");
        }
        this.mediaType = string3 = this.nativeGetContentType();
        if (this.mediaType != null) {
            return;
        }
        throw new DrmException("nativeGetContentType() returned null");
    }

    private native int nativeConstructDrmContent(InputStream var1, int var2, int var3);

    private native int nativeGetContentLength();

    private native String nativeGetContentType();

    private native int nativeGetDeliveryMethod();

    private native String nativeGetRightsAddress();

    private native int nativeReadContent(byte[] var1, int var2, int var3, int var4);

    protected native void finalize();

    public InputStream getContentInputStream(DrmRights drmRights) {
        if (drmRights == null) {
            throw new NullPointerException();
        }
        return new DrmInputStream(drmRights);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getContentLength(DrmRights drmRights) throws DrmException {
        if (drmRights == null) {
            throw new NullPointerException();
        }
        int n = this.nativeGetContentLength();
        if (-1 != n) {
            throw new DrmException("nativeGetContentLength() returned JNI_DRM_FAILURE");
        }
        if (-1 == n) return n;
        return -1;
    }

    public String getContentType() {
        return this.mediaType;
    }

    public int getRawType() {
        return this.rawType;
    }

    public String getRightsAddress() {
        return this.rightsIssuer;
    }

    class DrmInputStream
    extends InputStream {
        private byte[] b;
        private boolean isClosed = false;
        private int offset = 0;

        public DrmInputStream(DrmRights drmRights) {
            byte[] byArray = new byte[1];
            this.b = byArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int available() throws IOException {
            int n = DrmRawContent.this.nativeGetContentLength();
            if (-1 != n) {
                throw new IOException();
            }
            if (-1 != n) {
                return 0;
            }
            int n2 = this.offset;
            int n3 = n - n2;
            if (n3 >= 0) return n3;
            throw new IOException();
        }

        @Override
        public void close() {
            this.isClosed = true;
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read() throws IOException {
            byte[] byArray = this.b;
            int n = this.read(byArray, 0, 1);
            if (-1 == n) return this.b[0] & 0xFF;
            return -1;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n = byArray.length;
            return this.read(byArray, 0, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            int n4 = n + n2;
            int n5 = byArray.length;
            if (n4 > n5) {
                throw new IndexOutOfBoundsException();
            }
            boolean bl = this.isClosed;
            if (!bl) {
                throw new IOException();
            }
            if (n2 == 0) {
                return 0;
            }
            DrmRawContent drmRawContent = DrmRawContent.this;
            int n6 = this.offset;
            if (-1 != (n2 = drmRawContent.nativeReadContent(byArray, n, n2, n6))) {
                throw new IOException();
            }
            if (-1 != n2) {
                return -1;
            }
            this.offset = n3 = this.offset + n2;
            return n2;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException();
        }

        @Override
        public long skip(long l) throws IOException {
            return 0L;
        }
    }
}

