/*
 * Decompiled with CFR 0.152.
 */
package android.drm.mobile1;

import android.drm.mobile1.DrmConstraintInfo;

public class DrmRights {
    public static final int DRM_PERMISSION_DISPLAY = 2;
    public static final int DRM_PERMISSION_EXECUTE = 3;
    public static final int DRM_PERMISSION_PLAY = 1;
    public static final int DRM_PERMISSION_PRINT = 4;
    private static final int JNI_DRM_FAILURE = 255;
    private static final int JNI_DRM_SUCCESS;
    private String roId = "";

    static {
        try {
            System.loadLibrary("drm1_jni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("WARNING: Could not load libdrm1_jni.so");
        }
    }

    private native int nativeConsumeRights(int var1);

    private native int nativeGetConstraintInfo(int var1, DrmConstraintInfo var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean consumeRights(int n) {
        int n2 = this.nativeConsumeRights(n);
        if (-1 == n2) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DrmConstraintInfo getConstraint(int n) {
        DrmConstraintInfo drmConstraintInfo = new DrmConstraintInfo();
        int n2 = this.nativeGetConstraintInfo(n, drmConstraintInfo);
        if (-1 == n2) return drmConstraintInfo;
        return null;
    }
}

