/*
 * Decompiled with CFR 0.152.
 */
package android.drm.mobile1;

import android.drm.mobile1.DrmException;
import android.drm.mobile1.DrmRawContent;
import android.drm.mobile1.DrmRights;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DrmRightsManager {
    private static final int DRM_MIMETYPE_MESSAGE = 1;
    private static final int DRM_MIMETYPE_RIGHTS_WBXML = 4;
    public static final String DRM_MIMETYPE_RIGHTS_WBXML_STRING = "application/vnd.oma.drm.rights+wbxml";
    private static final int DRM_MIMETYPE_RIGHTS_XML = 3;
    public static final String DRM_MIMETYPE_RIGHTS_XML_STRING = "application/vnd.oma.drm.rights+xml";
    private static final int JNI_DRM_FAILURE = 255;
    private static final int JNI_DRM_SUCCESS;
    private static DrmRightsManager singleton;

    static {
        singleton = null;
        try {
            System.loadLibrary("drm1_jni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("WARNING: Could not load libdrm1_jni.so");
        }
    }

    protected DrmRightsManager() {
    }

    public static DrmRightsManager getInstance() {
        synchronized (DrmRightsManager.class) {
            if (singleton == null) {
                singleton = new DrmRightsManager();
            }
            DrmRightsManager drmRightsManager = singleton;
            return drmRightsManager;
        }
    }

    private native int nativeDeleteRights(DrmRights var1);

    private native int nativeGetNumOfRights();

    private native int nativeGetRightsList(DrmRights[] var1, int var2);

    private native int nativeInstallDrmRights(InputStream var1, int var2, int var3, DrmRights var4);

    private native int nativeQueryRights(DrmRawContent var1, DrmRights var2);

    public void deleteRights(DrmRights drmRights) {
        synchronized (this) {
            int n;
            int n2 = n = this.nativeDeleteRights(drmRights);
            if (-1 != n2) {
                // empty if block
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getRightsList() {
        synchronized (this) {
            int n;
            int n2;
            ArrayList<DrmRights> arrayList;
            block7: {
                int n3;
                arrayList = new ArrayList<DrmRights>();
                n2 = n3 = this.nativeGetNumOfRights();
                if (-1 == n2) break block7;
                return null;
            }
            if (n2 <= 0) return arrayList;
            DrmRights[] drmRightsArray = new DrmRights[n2];
            for (n = 0; n < n2; ++n) {
                DrmRights drmRights;
                drmRightsArray[n] = drmRights = new DrmRights();
            }
            if (-1 != (n2 = this.nativeGetRightsList(drmRightsArray, n2))) {
                return null;
            }
            n = 0;
            while (n < n2) {
                DrmRights drmRights = drmRightsArray[n];
                boolean bl = arrayList.add(drmRights);
                ++n;
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DrmRights installRights(InputStream inputStream, int n, String string2) throws DrmException, IOException {
        synchronized (this) {
            int n2;
            boolean bl = DRM_MIMETYPE_RIGHTS_XML_STRING.equals(string2);
            if (bl) {
                n2 = 3;
            } else if (DRM_MIMETYPE_RIGHTS_WBXML_STRING.equals(string2)) {
                n2 = 4;
            } else {
                if (!"application/vnd.oma.drm.message".equals(string2)) {
                    throw new IllegalArgumentException("mimeType must be DRM_MIMETYPE_RIGHTS_XML or DRM_MIMETYPE_RIGHTS_WBXML or DRM_MIMETYPE_MESSAGE");
                }
                n2 = 1;
            }
            if (n <= 0) {
                return null;
            }
            DrmRights drmRights = new DrmRights();
            int n3 = this.nativeInstallDrmRights(inputStream, n, n2, drmRights);
            if (-1 == n3) return drmRights;
            throw new DrmException("nativeInstallDrmRights() returned JNI_DRM_FAILURE");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DrmRights queryRights(DrmRawContent drmRawContent) {
        synchronized (this) {
            int n;
            DrmRights drmRights = new DrmRights();
            int n2 = n = this.nativeQueryRights(drmRawContent, drmRights);
            if (-1 == n2) return drmRights;
            return null;
        }
    }
}

