/*
 * Decompiled with CFR 0.152.
 */
package android.emoji;

import android.graphics.Bitmap;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;

public final class EmojiFactory {
    private Map<Integer, WeakReference<Bitmap>> mCache;
    private String mName;
    private int mNativeEmojiFactory;
    private int sCacheSize = 100;

    private EmojiFactory(int n, String string2) {
        this.mNativeEmojiFactory = n;
        this.mName = string2;
        CustomLinkedHashMap<Integer, WeakReference<Bitmap>> customLinkedHashMap = new CustomLinkedHashMap<Integer, WeakReference<Bitmap>>();
        this.mCache = customLinkedHashMap;
    }

    private native void nativeDestructor(int var1);

    private native int nativeGetAndroidPuaFromVendorSpecificPua(int var1, int var2);

    private native int nativeGetAndroidPuaFromVendorSpecificSjis(int var1, char var2);

    private native Bitmap nativeGetBitmapFromAndroidPua(int var1, int var2);

    private native int nativeGetMaximumAndroidPua(int var1);

    private native int nativeGetMaximumVendorSpecificPua(int var1);

    private native int nativeGetMinimumAndroidPua(int var1);

    private native int nativeGetMinimumVendorSpecificPua(int var1);

    private native int nativeGetVendorSpecificPuaFromAndroidPua(int var1, int var2);

    private native int nativeGetVendorSpecificSjisFromAndroidPua(int var1, int var2);

    public static native EmojiFactory newAvailableInstance();

    public static native EmojiFactory newInstance(String var0);

    protected void finalize() throws Throwable {
        try {
            int n = this.mNativeEmojiFactory;
            this.nativeDestructor(n);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getAndroidPuaFromVendorSpecificPua(int n) {
        int n2 = this.mNativeEmojiFactory;
        return this.nativeGetAndroidPuaFromVendorSpecificPua(n2, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getAndroidPuaFromVendorSpecificPua(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = this.mNativeEmojiFactory;
        int n2 = this.nativeGetMinimumVendorSpecificPua(n);
        int n3 = this.mNativeEmojiFactory;
        int n4 = this.nativeGetMaximumVendorSpecificPua(n3);
        int n5 = string2.length();
        int[] nArray = new int[string2.codePointCount(0, n5)];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8;
            int n9 = string2.codePointAt(n7);
            nArray[n6] = n2 <= n9 && n9 <= n4 && (n8 = this.getAndroidPuaFromVendorSpecificPua(n9)) > 0 ? n8 : n9;
            n7 = string2.offsetByCodePoints(n7, 1);
            ++n6;
        }
        return new String(nArray, 0, n6);
    }

    public int getAndroidPuaFromVendorSpecificSjis(char c) {
        int n = this.mNativeEmojiFactory;
        return this.nativeGetAndroidPuaFromVendorSpecificSjis(n, c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bitmap getBitmapFromAndroidPua(int n) {
        synchronized (this) {
            WeakReference<Bitmap> weakReference;
            block4: {
                Map<Integer, WeakReference<Bitmap>> map = this.mCache;
                Integer n2 = n;
                weakReference = map.get(n2);
                if (weakReference != null) break block4;
                int n3 = this.mNativeEmojiFactory;
                Bitmap bitmap = this.nativeGetBitmapFromAndroidPua(n3, n);
                if (bitmap == null) return bitmap;
                Map<Integer, WeakReference<Bitmap>> map2 = this.mCache;
                Integer n4 = n;
                WeakReference<Bitmap> weakReference2 = new WeakReference<Bitmap>(bitmap);
                WeakReference<Bitmap> weakReference3 = map2.put(n4, weakReference2);
                return bitmap;
            }
            Bitmap bitmap = (Bitmap)weakReference.get();
            if (bitmap != null) return bitmap;
            int n5 = this.mNativeEmojiFactory;
            Bitmap bitmap2 = this.nativeGetBitmapFromAndroidPua(n5, n);
            Map<Integer, WeakReference<Bitmap>> map = this.mCache;
            Integer n6 = n;
            WeakReference<Bitmap> weakReference4 = new WeakReference<Bitmap>(bitmap2);
            WeakReference<Bitmap> weakReference5 = map.put(n6, weakReference4);
            return bitmap2;
        }
    }

    public Bitmap getBitmapFromVendorSpecificPua(int n) {
        synchronized (this) {
            Bitmap bitmap;
            int n2 = this.getAndroidPuaFromVendorSpecificPua(n);
            Bitmap bitmap2 = bitmap = this.getBitmapFromAndroidPua(n2);
            return bitmap2;
        }
    }

    public Bitmap getBitmapFromVendorSpecificSjis(char c) {
        synchronized (this) {
            Bitmap bitmap;
            int n = this.getAndroidPuaFromVendorSpecificSjis(c);
            Bitmap bitmap2 = bitmap = this.getBitmapFromAndroidPua(n);
            return bitmap2;
        }
    }

    public int getMaximumAndroidPua() {
        int n = this.mNativeEmojiFactory;
        return this.nativeGetMaximumAndroidPua(n);
    }

    public int getMinimumAndroidPua() {
        int n = this.mNativeEmojiFactory;
        return this.nativeGetMinimumAndroidPua(n);
    }

    public int getVendorSpecificPuaFromAndroidPua(int n) {
        int n2 = this.mNativeEmojiFactory;
        return this.nativeGetVendorSpecificPuaFromAndroidPua(n2, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getVendorSpecificPuaFromAndroidPua(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = this.mNativeEmojiFactory;
        int n2 = this.nativeGetMinimumAndroidPua(n);
        int n3 = this.mNativeEmojiFactory;
        int n4 = this.nativeGetMaximumAndroidPua(n3);
        int n5 = string2.length();
        int[] nArray = new int[string2.codePointCount(0, n5)];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8;
            int n9 = string2.codePointAt(n7);
            nArray[n6] = n2 <= n9 && n9 <= n4 && (n8 = this.getVendorSpecificPuaFromAndroidPua(n9)) > 0 ? n8 : n9;
            n7 = string2.offsetByCodePoints(n7, 1);
            ++n6;
        }
        return new String(nArray, 0, n6);
    }

    public int getVendorSpecificSjisFromAndroidPua(int n) {
        int n2 = this.mNativeEmojiFactory;
        return this.nativeGetVendorSpecificSjisFromAndroidPua(n2, n);
    }

    public String name() {
        return this.mName;
    }

    private class CustomLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        public CustomLinkedHashMap() {
            super(16, 0.75f, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            int n;
            int n2 = this.size();
            if (n2 <= (n = EmojiFactory.this.sCacheSize)) return false;
            return true;
        }
    }
}

