/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GestureStroke;
import android.gesture.GestureUtils;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class Gesture
implements Parcelable {
    private static final boolean BITMAP_RENDERING_ANTIALIAS = true;
    private static final boolean BITMAP_RENDERING_DITHER = true;
    private static final int BITMAP_RENDERING_WIDTH = 2;
    public static final Parcelable.Creator<Gesture> CREATOR;
    private static final long GESTURE_ID_BASE;
    private static final AtomicInteger sGestureCount;
    private final RectF mBoundingBox;
    private long mGestureID;
    private final ArrayList<GestureStroke> mStrokes;

    static {
        GESTURE_ID_BASE = System.currentTimeMillis();
        sGestureCount = new AtomicInteger(0);
        CREATOR = new Parcelable.Creator<Gesture>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Gesture createFromParcel(Parcel parcel) {
                long l;
                Gesture gesture;
                block5: {
                    gesture = null;
                    l = parcel.readLong();
                    byte[] byArray = parcel.createByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    try {
                        Gesture gesture2;
                        gesture = gesture2 = Gesture.deserialize(dataInputStream);
                    }
                    catch (IOException iOException) {
                        int n = Log.e("Gestures", "Error reading Gesture from parcel:", iOException);
                        break block5;
                    }
                    finally {
                        GestureUtils.closeStream(dataInputStream);
                    }
                    GestureUtils.closeStream(dataInputStream);
                }
                if (gesture == null) return gesture;
                long l2 = Gesture.access$002(gesture, l);
                return gesture;
            }

            public Gesture[] newArray(int n) {
                return new Gesture[n];
            }
        };
    }

    public Gesture() {
        long l;
        RectF rectF;
        this.mBoundingBox = rectF = new RectF();
        ArrayList arrayList = new ArrayList();
        this.mStrokes = arrayList;
        long l2 = GESTURE_ID_BASE;
        long l3 = sGestureCount.incrementAndGet();
        this.mGestureID = l = l2 + l3;
    }

    static /* synthetic */ long access$002(Gesture gesture, long l) {
        gesture.mGestureID = l;
        return l;
    }

    static Gesture deserialize(DataInputStream dataInputStream) throws IOException {
        long l;
        Gesture gesture = new Gesture();
        gesture.mGestureID = l = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            GestureStroke gestureStroke = GestureStroke.deserialize(dataInputStream);
            gesture.addStroke(gestureStroke);
        }
        return gesture;
    }

    public void addStroke(GestureStroke gestureStroke) {
        boolean bl = this.mStrokes.add(gestureStroke);
        RectF rectF = this.mBoundingBox;
        RectF rectF2 = gestureStroke.boundingBox;
        rectF.union(rectF2);
    }

    public Object clone() {
        Gesture gesture = new Gesture();
        RectF rectF = gesture.mBoundingBox;
        float f = this.mBoundingBox.left;
        float f2 = this.mBoundingBox.top;
        float f3 = this.mBoundingBox.right;
        float f4 = this.mBoundingBox.bottom;
        rectF.set(f, f2, f3, f4);
        int n = this.mStrokes.size();
        for (int i = 0; i < n; ++i) {
            GestureStroke gestureStroke = this.mStrokes.get(i);
            ArrayList<GestureStroke> arrayList = gesture.mStrokes;
            GestureStroke gestureStroke2 = (GestureStroke)gestureStroke.clone();
            boolean bl = arrayList.add(gestureStroke2);
        }
        return gesture;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public RectF getBoundingBox() {
        return this.mBoundingBox;
    }

    public long getID() {
        return this.mGestureID;
    }

    public float getLength() {
        int n = 0;
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            float f = n;
            float f2 = arrayList.get((int)i).length;
            n = (int)(f + f2);
        }
        return n;
    }

    public ArrayList<GestureStroke> getStrokes() {
        return this.mStrokes;
    }

    public int getStrokesCount() {
        return this.mStrokes.size();
    }

    void serialize(DataOutputStream dataOutputStream) throws IOException {
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n = arrayList.size();
        long l = this.mGestureID;
        dataOutputStream.writeLong(l);
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.get(n2).serialize(dataOutputStream);
            ++n2;
        }
        return;
    }

    void setID(long l) {
        this.mGestureID = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Bitmap toBitmap(int n, int n2, int n3, int n4) {
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        int n5 = n;
        int n6 = n2;
        Bitmap.Config config2 = config;
        Bitmap bitmap = Bitmap.createBitmap(n5, n6, config2);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        Paint paint2 = paint;
        int n7 = n4;
        paint2.setColor(n7);
        Paint.Style style2 = Paint.Style.STROKE;
        paint.setStyle(style2);
        Paint.Join join = Paint.Join.ROUND;
        paint.setStrokeJoin(join);
        Paint.Cap cap = Paint.Cap.ROUND;
        paint.setStrokeCap(cap);
        paint.setStrokeWidth(2.0f);
        Path path = this.toPath();
        RectF rectF = new RectF();
        path.computeBounds(rectF, true);
        int n8 = n3 * 2;
        float f = n - n8;
        float f2 = rectF.width();
        float f3 = f / f2;
        int n9 = n3 * 2;
        float f4 = n2 - n9;
        float f5 = rectF.height();
        float f6 = f4 / f5;
        float f7 = f3 > f6 ? f6 : f3;
        float f8 = 2.0f / f7;
        paint.setStrokeWidth(f8);
        float f9 = -rectF.left;
        float f10 = n;
        float f11 = rectF.width() * f7;
        float f12 = (f10 - f11) / 2.0f;
        float f13 = f9 + f12;
        float f14 = -rectF.top;
        float f15 = n2;
        float f16 = rectF.height() * f7;
        float f17 = (f15 - f16) / 2.0f;
        float f18 = f14 + f17;
        path.offset(f13, f18);
        float f19 = n3;
        float f20 = n3;
        canvas.translate(f19, f20);
        canvas.scale(f7, f7);
        canvas.drawPath(path, paint);
        return bitmap;
    }

    public Bitmap toBitmap(int n, int n2, int n3, int n4, int n5) {
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap(n, n2, config);
        Canvas canvas = new Canvas(bitmap);
        float f = n3;
        float f2 = n3;
        canvas.translate(f, f2);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setDither(true);
        paint.setColor(n5);
        Paint.Style style2 = Paint.Style.STROKE;
        paint.setStyle(style2);
        Paint.Join join = Paint.Join.ROUND;
        paint.setStrokeJoin(join);
        Paint.Cap cap = Paint.Cap.ROUND;
        paint.setStrokeCap(cap);
        paint.setStrokeWidth(2.0f);
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n6 = arrayList.size();
        for (int i = 0; i < n6; ++i) {
            GestureStroke gestureStroke = arrayList.get(i);
            int n7 = n3 * 2;
            float f3 = n - n7;
            int n8 = n3 * 2;
            float f4 = n2 - n8;
            Path path = gestureStroke.toPath(f3, f4, n4);
            canvas.drawPath(path, paint);
        }
        return bitmap;
    }

    public Path toPath() {
        return this.toPath(null);
    }

    public Path toPath(int n, int n2, int n3, int n4) {
        Gesture gesture = this;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        return gesture.toPath(null, n5, n6, n7, n8);
    }

    public Path toPath(Path path) {
        if (path == null) {
            path = new Path();
        }
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Path path2 = arrayList.get(i).getPath();
            path.addPath(path2);
        }
        return path;
    }

    public Path toPath(Path path, int n, int n2, int n3, int n4) {
        if (path == null) {
            path = new Path();
        }
        ArrayList<GestureStroke> arrayList = this.mStrokes;
        int n5 = arrayList.size();
        for (int i = 0; i < n5; ++i) {
            GestureStroke gestureStroke = arrayList.get(i);
            int n6 = n3 * 2;
            float f = n - n6;
            int n7 = n3 * 2;
            float f2 = n2 - n7;
            Path path2 = gestureStroke.toPath(f, f2, n4);
            path.addPath(path2);
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        ByteArrayOutputStream byteArrayOutputStream;
        boolean bl;
        block6: {
            long l = this.mGestureID;
            parcel.writeLong(l);
            bl = false;
            byteArrayOutputStream = new ByteArrayOutputStream(32768);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                this.serialize(dataOutputStream);
                bl = true;
            }
            catch (IOException iOException) {
                int n2 = Log.e("Gestures", "Error writing Gesture to parcel:", iOException);
                break block6;
            }
            finally {
                GestureUtils.closeStream(dataOutputStream);
                GestureUtils.closeStream(byteArrayOutputStream);
            }
            GestureUtils.closeStream(dataOutputStream);
            GestureUtils.closeStream(byteArrayOutputStream);
        }
        if (!bl) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        parcel.writeByteArray(byArray);
    }
}

