/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.content.Context;
import android.content.res.Resources;
import android.gesture.GestureLibrary;
import android.gesture.GestureStore;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public final class GestureLibraries {
    private GestureLibraries() {
    }

    public static GestureLibrary fromFile(File file) {
        return new FileGestureLibrary(file);
    }

    public static GestureLibrary fromFile(String string2) {
        return GestureLibraries.fromFile(new File(string2));
    }

    public static GestureLibrary fromPrivateFile(Context context, String string2) {
        return GestureLibraries.fromFile(context.getFileStreamPath(string2));
    }

    public static GestureLibrary fromRawResource(Context context, int n) {
        return new ResourceGestureLibrary(context, n);
    }

    private static class ResourceGestureLibrary
    extends GestureLibrary {
        private final WeakReference<Context> mContext;
        private final int mResourceId;

        public ResourceGestureLibrary(Context context, int n) {
            WeakReference<Context> weakReference = new WeakReference<Context>(context);
            this.mContext = weakReference;
            this.mResourceId = n;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean load() {
            boolean bl = false;
            Context context = (Context)this.mContext.get();
            if (context == null) return bl;
            Resources resources = context.getResources();
            int n = this.mResourceId;
            InputStream inputStream = resources.openRawResource(n);
            try {
                this.mStore.load(inputStream, true);
                return true;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not load the gesture library from raw resource ");
                Resources resources2 = context.getResources();
                int n2 = this.mResourceId;
                String string2 = resources2.getResourceName(n2);
                String string3 = stringBuilder.append(string2).toString();
                int n3 = Log.d("Gestures", string3, iOException);
                return bl;
            }
        }

        @Override
        public boolean save() {
            return false;
        }
    }

    private static class FileGestureLibrary
    extends GestureLibrary {
        private final File mPath;

        public FileGestureLibrary(File file) {
            this.mPath = file;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isReadOnly() {
            if (this.mPath.canWrite()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean load() {
            boolean bl = false;
            File file = this.mPath;
            if (!file.exists()) return bl;
            if (!file.canRead()) return bl;
            try {
                GestureStore gestureStore = this.mStore;
                FileInputStream fileInputStream = new FileInputStream(file);
                gestureStore.load(fileInputStream, true);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not load the gesture library from ");
                File file2 = this.mPath;
                String string2 = stringBuilder.append(file2).toString();
                int n = Log.d("Gestures", string2, fileNotFoundException);
                return bl;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not load the gesture library from ");
                File file3 = this.mPath;
                String string3 = stringBuilder.append(file3).toString();
                int n = Log.d("Gestures", string3, iOException);
                return bl;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean save() {
            if (!this.mStore.hasChanged()) {
                return true;
            }
            File file = this.mPath;
            File file2 = file.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                return false;
            }
            boolean bl = false;
            try {
                boolean bl2 = file.createNewFile();
                GestureStore gestureStore = this.mStore;
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                gestureStore.save(fileOutputStream, true);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not save the gesture library in ");
                File file3 = this.mPath;
                String string2 = stringBuilder.append(file3).toString();
                int n = Log.d("Gestures", string2, fileNotFoundException);
                return bl;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not save the gesture library in ");
                File file4 = this.mPath;
                String string3 = stringBuilder.append(file4).toString();
                int n = Log.d("Gestures", string3, iOException);
                return bl;
            }
        }
    }
}

