/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.content.Context;
import android.content.res.TypedArray;
import android.gesture.Gesture;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.GestureUtils;
import android.gesture.OrientedBoundingBox;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.util.ArrayList;

public class GestureOverlayView
extends FrameLayout {
    private static final boolean DITHER_FLAG = true;
    private static final int FADE_ANIMATION_RATE = 16;
    private static final boolean GESTURE_RENDERING_ANTIALIAS = true;
    public static final int GESTURE_STROKE_TYPE_MULTIPLE = 1;
    public static final int GESTURE_STROKE_TYPE_SINGLE = 0;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private int mCertainGestureColor;
    private int mCurrentColor;
    private Gesture mCurrentGesture;
    private float mCurveEndX;
    private float mCurveEndY;
    private long mFadeDuration;
    private boolean mFadeEnabled;
    private long mFadeOffset;
    private float mFadingAlpha;
    private boolean mFadingHasStarted;
    private final FadeOutRunnable mFadingOut;
    private long mFadingStart;
    private final Paint mGesturePaint;
    private float mGestureStrokeAngleThreshold;
    private float mGestureStrokeLengthThreshold;
    private float mGestureStrokeSquarenessTreshold;
    private int mGestureStrokeType;
    private float mGestureStrokeWidth;
    private boolean mGestureVisible;
    private boolean mHandleGestureActions;
    private boolean mInterceptEvents;
    private final AccelerateDecelerateInterpolator mInterpolator;
    private final Rect mInvalidRect;
    private int mInvalidateExtraBorder;
    private boolean mIsFadingOut;
    private boolean mIsGesturing;
    private boolean mIsListeningForGestures;
    private final ArrayList<OnGestureListener> mOnGestureListeners;
    private final ArrayList<OnGesturePerformedListener> mOnGesturePerformedListeners;
    private final ArrayList<OnGesturingListener> mOnGesturingListeners;
    private int mOrientation;
    private final Path mPath;
    private boolean mPreviousWasGesturing;
    private boolean mResetGesture;
    private final ArrayList<GesturePoint> mStrokeBuffer;
    private float mTotalLength;
    private int mUncertainGestureColor;
    private float mX;
    private float mY;

    public GestureOverlayView(Context context) {
        super(context);
        FadeOutRunnable fadeOutRunnable;
        AccelerateDecelerateInterpolator accelerateDecelerateInterpolator;
        Path path;
        Rect rect;
        Paint paint;
        this.mGesturePaint = paint = new Paint();
        this.mFadeDuration = 150L;
        this.mFadeOffset = 420L;
        this.mFadeEnabled = true;
        this.mCertainGestureColor = 65280;
        this.mUncertainGestureColor = 1224736512;
        this.mGestureStrokeWidth = 12.0f;
        this.mInvalidateExtraBorder = 10;
        this.mGestureStrokeType = 0;
        this.mGestureStrokeLengthThreshold = 50.0f;
        this.mGestureStrokeSquarenessTreshold = 0.275f;
        this.mGestureStrokeAngleThreshold = 40.0f;
        this.mOrientation = 1;
        this.mInvalidRect = rect = new Rect();
        this.mPath = path = new Path();
        this.mGestureVisible = true;
        this.mIsGesturing = false;
        this.mPreviousWasGesturing = false;
        this.mInterceptEvents = true;
        ArrayList arrayList = new ArrayList(100);
        this.mStrokeBuffer = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.mOnGestureListeners = arrayList2;
        ArrayList arrayList3 = new ArrayList();
        this.mOnGesturePerformedListeners = arrayList3;
        ArrayList arrayList4 = new ArrayList();
        this.mOnGesturingListeners = arrayList4;
        this.mIsFadingOut = false;
        this.mFadingAlpha = 1.0f;
        this.mInterpolator = accelerateDecelerateInterpolator = new AccelerateDecelerateInterpolator();
        this.mFadingOut = fadeOutRunnable = new FadeOutRunnable();
        this.init();
    }

    public GestureOverlayView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843470);
    }

    public GestureOverlayView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        boolean bl;
        boolean bl2;
        float f;
        float f2;
        float f3;
        int n3;
        long l;
        long l2;
        int n4;
        int n5;
        int n6;
        float f4;
        FadeOutRunnable fadeOutRunnable;
        AccelerateDecelerateInterpolator accelerateDecelerateInterpolator;
        Path path;
        Rect rect;
        Paint paint;
        this.mGesturePaint = paint = new Paint();
        this.mFadeDuration = 150L;
        this.mFadeOffset = 420L;
        this.mFadeEnabled = true;
        this.mCertainGestureColor = 65280;
        this.mUncertainGestureColor = 1224736512;
        this.mGestureStrokeWidth = 12.0f;
        this.mInvalidateExtraBorder = 10;
        this.mGestureStrokeType = 0;
        this.mGestureStrokeLengthThreshold = 50.0f;
        this.mGestureStrokeSquarenessTreshold = 0.275f;
        this.mGestureStrokeAngleThreshold = 40.0f;
        this.mOrientation = 1;
        this.mInvalidRect = rect = new Rect();
        this.mPath = path = new Path();
        this.mGestureVisible = true;
        this.mIsGesturing = false;
        this.mPreviousWasGesturing = false;
        this.mInterceptEvents = true;
        ArrayList arrayList = new ArrayList(100);
        this.mStrokeBuffer = arrayList;
        ArrayList arrayList2 = new ArrayList();
        this.mOnGestureListeners = arrayList2;
        ArrayList arrayList3 = new ArrayList();
        this.mOnGesturePerformedListeners = arrayList3;
        ArrayList arrayList4 = new ArrayList();
        this.mOnGesturingListeners = arrayList4;
        this.mIsFadingOut = false;
        this.mFadingAlpha = 1.0f;
        this.mInterpolator = accelerateDecelerateInterpolator = new AccelerateDecelerateInterpolator();
        this.mFadingOut = fadeOutRunnable = new FadeOutRunnable();
        int[] nArray = R.styleable.GestureOverlayView;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        float f5 = this.mGestureStrokeWidth;
        this.mGestureStrokeWidth = f4 = typedArray.getFloat(1, f5);
        int n7 = (int)this.mGestureStrokeWidth - 1;
        this.mInvalidateExtraBorder = n6 = Math.max(1, n7);
        int n8 = this.mCertainGestureColor;
        this.mCertainGestureColor = n5 = typedArray.getColor(2, n8);
        int n9 = this.mUncertainGestureColor;
        this.mUncertainGestureColor = n4 = typedArray.getColor(3, n9);
        int n10 = (int)this.mFadeDuration;
        this.mFadeDuration = l2 = (long)typedArray.getInt(5, n10);
        int n11 = (int)this.mFadeOffset;
        this.mFadeOffset = l = (long)typedArray.getInt(4, n11);
        int n12 = this.mGestureStrokeType;
        this.mGestureStrokeType = n3 = typedArray.getInt(6, n12);
        float f6 = this.mGestureStrokeLengthThreshold;
        this.mGestureStrokeLengthThreshold = f3 = typedArray.getFloat(7, f6);
        float f7 = this.mGestureStrokeAngleThreshold;
        this.mGestureStrokeAngleThreshold = f2 = typedArray.getFloat(9, f7);
        float f8 = this.mGestureStrokeSquarenessTreshold;
        this.mGestureStrokeSquarenessTreshold = f = typedArray.getFloat(8, f8);
        boolean bl3 = this.mInterceptEvents;
        this.mInterceptEvents = bl2 = typedArray.getBoolean(10, bl3);
        boolean bl4 = this.mFadeEnabled;
        this.mFadeEnabled = bl = typedArray.getBoolean(11, bl4);
        int n13 = this.mOrientation;
        this.mOrientation = n2 = typedArray.getInt(0, n13);
        typedArray.recycle();
        this.init();
    }

    static /* synthetic */ float access$1002(GestureOverlayView gestureOverlayView, float f) {
        gestureOverlayView.mFadingAlpha = f;
        return f;
    }

    static /* synthetic */ boolean access$102(GestureOverlayView gestureOverlayView, boolean bl) {
        gestureOverlayView.mIsFadingOut = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1202(GestureOverlayView gestureOverlayView, boolean bl) {
        gestureOverlayView.mResetGesture = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(GestureOverlayView gestureOverlayView, boolean bl) {
        gestureOverlayView.mPreviousWasGesturing = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(GestureOverlayView gestureOverlayView, boolean bl) {
        gestureOverlayView.mFadingHasStarted = bl;
        return bl;
    }

    static /* synthetic */ Gesture access$802(GestureOverlayView gestureOverlayView, Gesture gesture) {
        gestureOverlayView.mCurrentGesture = gesture;
        return gesture;
    }

    private void cancelGesture(MotionEvent motionEvent) {
        ArrayList<OnGestureListener> arrayList = this.mOnGestureListeners;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).onGestureCancelled(this, motionEvent);
        }
        this.clear(false);
    }

    private void clear(boolean bl, boolean bl2, boolean bl3) {
        this.setPaintAlpha(255);
        FadeOutRunnable fadeOutRunnable = this.mFadingOut;
        boolean bl4 = this.removeCallbacks(fadeOutRunnable);
        this.mResetGesture = false;
        this.mFadingOut.fireActionPerformed = bl2;
        this.mFadingOut.resetMultipleStrokes = false;
        if (bl && this.mCurrentGesture != null) {
            long l;
            this.mFadingAlpha = 1.0f;
            this.mIsFadingOut = true;
            this.mFadingHasStarted = false;
            long l2 = AnimationUtils.currentAnimationTimeMillis();
            long l3 = this.mFadeOffset;
            this.mFadingStart = l = l2 + l3;
            FadeOutRunnable fadeOutRunnable2 = this.mFadingOut;
            long l4 = this.mFadeOffset;
            boolean bl5 = this.postDelayed(fadeOutRunnable2, l4);
            return;
        }
        this.mFadingAlpha = 1.0f;
        this.mIsFadingOut = false;
        this.mFadingHasStarted = false;
        if (bl3) {
            this.mCurrentGesture = null;
            this.mPath.rewind();
            this.invalidate();
            return;
        }
        if (bl2) {
            FadeOutRunnable fadeOutRunnable3 = this.mFadingOut;
            long l = this.mFadeOffset;
            boolean bl6 = this.postDelayed(fadeOutRunnable3, l);
            return;
        }
        if (this.mGestureStrokeType == 1) {
            this.mFadingOut.resetMultipleStrokes = true;
            FadeOutRunnable fadeOutRunnable4 = this.mFadingOut;
            long l = this.mFadeOffset;
            boolean bl7 = this.postDelayed(fadeOutRunnable4, l);
            return;
        }
        this.mCurrentGesture = null;
        this.mPath.rewind();
        this.invalidate();
    }

    private void fireOnGesturePerformed() {
        ArrayList<OnGesturePerformedListener> arrayList = this.mOnGesturePerformedListeners;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            OnGesturePerformedListener onGesturePerformedListener = arrayList.get(n2);
            Gesture gesture = this.mCurrentGesture;
            onGesturePerformedListener.onGesturePerformed(this, gesture);
            ++n2;
        }
        return;
    }

    private void init() {
        int n;
        this.setWillNotDraw(false);
        Paint paint = this.mGesturePaint;
        paint.setAntiAlias(true);
        int n2 = this.mCertainGestureColor;
        paint.setColor(n2);
        Paint.Style style2 = Paint.Style.STROKE;
        paint.setStyle(style2);
        Paint.Join join = Paint.Join.ROUND;
        paint.setStrokeJoin(join);
        Paint.Cap cap = Paint.Cap.ROUND;
        paint.setStrokeCap(cap);
        float f = this.mGestureStrokeWidth;
        paint.setStrokeWidth(f);
        paint.setDither(true);
        this.mCurrentColor = n = this.mCertainGestureColor;
        this.setPaintAlpha(255);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            default: {
                return false;
            }
            case 0: {
                this.touchDown(motionEvent);
                this.invalidate();
                return true;
            }
            case 2: {
                if (!this.mIsListeningForGestures) return false;
                Rect rect = this.touchMove(motionEvent);
                if (rect == null) return true;
                this.invalidate(rect);
                return true;
            }
            case 1: {
                if (!this.mIsListeningForGestures) return false;
                this.touchUp(motionEvent, false);
                this.invalidate();
                return true;
            }
            case 3: 
        }
        if (!this.mIsListeningForGestures) return false;
        this.touchUp(motionEvent, true);
        this.invalidate();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setCurrentColor(int n) {
        this.mCurrentColor = n;
        if (this.mFadingHasStarted) {
            float f = this.mFadingAlpha;
            int n2 = (int)(255.0f * f);
            this.setPaintAlpha(n2);
        } else {
            this.setPaintAlpha(255);
        }
        this.invalidate();
    }

    private void setPaintAlpha(int n) {
        int n2 = n >> 7;
        int n3 = n + n2;
        int n4 = (this.mCurrentColor >>> 24) * n3 >> 8;
        Paint paint = this.mGesturePaint;
        int n5 = this.mCurrentColor << 8 >>> 8;
        int n6 = n4 << 24;
        int n7 = n5 | n6;
        paint.setColor(n7);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void touchDown(MotionEvent motionEvent) {
        this.mIsListeningForGestures = true;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        this.mX = f;
        this.mY = f2;
        this.mTotalLength = 0.0f;
        this.mIsGesturing = false;
        if (this.mGestureStrokeType == 0 || this.mResetGesture) {
            if (this.mHandleGestureActions) {
                int n = this.mUncertainGestureColor;
                this.setCurrentColor(n);
            }
            this.mResetGesture = false;
            this.mCurrentGesture = null;
            this.mPath.rewind();
        } else if ((this.mCurrentGesture == null || this.mCurrentGesture.getStrokesCount() == 0) && this.mHandleGestureActions) {
            int n = this.mUncertainGestureColor;
            this.setCurrentColor(n);
        }
        if (this.mFadingHasStarted) {
            this.cancelClearAnimation();
        } else if (this.mIsFadingOut) {
            this.setPaintAlpha(255);
            this.mIsFadingOut = false;
            this.mFadingHasStarted = false;
            FadeOutRunnable fadeOutRunnable = this.mFadingOut;
            boolean bl = this.removeCallbacks(fadeOutRunnable);
        }
        if (this.mCurrentGesture == null) {
            Gesture gesture;
            this.mCurrentGesture = gesture = new Gesture();
        }
        ArrayList<GesturePoint> arrayList = this.mStrokeBuffer;
        long l = motionEvent.getEventTime();
        GesturePoint gesturePoint = new GesturePoint(f, f2, l);
        boolean bl = arrayList.add(gesturePoint);
        this.mPath.moveTo(f, f2);
        int n = this.mInvalidateExtraBorder;
        Rect rect = this.mInvalidRect;
        int n2 = (int)f - n;
        int n3 = (int)f2 - n;
        int n4 = (int)f + n;
        int n5 = (int)f2 + n;
        rect.set(n2, n3, n4, n5);
        this.mCurveEndX = f;
        this.mCurveEndY = f2;
        ArrayList<OnGestureListener> arrayList2 = this.mOnGestureListeners;
        int n6 = arrayList2.size();
        int n7 = 0;
        while (n7 < n6) {
            arrayList2.get(n7).onGestureStarted(this, motionEvent);
            ++n7;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Rect touchMove(MotionEvent motionEvent) {
        Rect rect = null;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        float f3 = this.mX;
        float f4 = this.mY;
        float f5 = Math.abs(f - f3);
        float f6 = Math.abs(f2 - f4);
        if (f5 >= 3.0f || f6 >= 3.0f) {
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            float f12;
            float f13;
            GesturePoint gesturePoint;
            float f14;
            float f15;
            float f16;
            float f17;
            float f18;
            float f19;
            rect = this.mInvalidRect;
            int n = this.mInvalidateExtraBorder;
            int n2 = (int)this.mCurveEndX - n;
            int n3 = (int)this.mCurveEndY - n;
            int n4 = (int)this.mCurveEndX + n;
            int n5 = (int)this.mCurveEndY + n;
            Rect rect2 = rect;
            int n6 = n2;
            int n7 = n3;
            int n8 = n4;
            int n9 = n5;
            rect2.set(n6, n7, n8, n9);
            this.mCurveEndX = f19 = (f18 = (f + f3) / 2.0f);
            this.mCurveEndY = f17 = (f16 = (f2 + f4) / 2.0f);
            Path path = this.mPath;
            float f20 = f3;
            float f21 = f4;
            float f22 = f18;
            float f23 = f16;
            path.quadTo(f20, f21, f22, f23);
            int n10 = (int)f3 - n;
            int n11 = (int)f4 - n;
            int n12 = (int)f3 + n;
            int n13 = (int)f4 + n;
            Rect rect3 = rect;
            int n14 = n10;
            int n15 = n11;
            int n16 = n12;
            int n17 = n13;
            rect3.union(n14, n15, n16, n17);
            int n18 = (int)f18 - n;
            int n19 = (int)f16 - n;
            int n20 = (int)f18 + n;
            int n21 = (int)f16 + n;
            Rect rect4 = rect;
            int n22 = n18;
            int n23 = n19;
            int n24 = n20;
            int n25 = n21;
            rect4.union(n22, n23, n24, n25);
            this.mX = f15 = f;
            this.mY = f14 = f2;
            ArrayList<GesturePoint> arrayList = this.mStrokeBuffer;
            long l = motionEvent.getEventTime();
            GesturePoint gesturePoint2 = gesturePoint;
            float f24 = f;
            float f25 = f2;
            long l2 = l;
            gesturePoint2(f24, f25, l2);
            boolean bl = arrayList.add(gesturePoint);
            if (this.mHandleGestureActions && !this.mIsGesturing && (f13 = (this.mTotalLength = (f12 = (f11 = this.mTotalLength) + (f10 = (float)Math.sqrt((f9 = f5 * f5) + (f8 = f6 * f6)))))) > (f7 = this.mGestureStrokeLengthThreshold)) {
                float f26;
                float f27;
                int n26;
                int n27;
                float f28;
                float f29;
                OrientedBoundingBox orientedBoundingBox = GestureUtils.computeOrientedBoundingBox(this.mStrokeBuffer);
                float f30 = Math.abs(orientedBoundingBox.orientation);
                if (f30 > 90.0f) {
                    f30 = 180.0f - f30;
                }
                if ((f29 = orientedBoundingBox.squareness) > (f28 = this.mGestureStrokeSquarenessTreshold) || ((n27 = this.mOrientation) == (n26 = 1) ? f30 < (f27 = this.mGestureStrokeAngleThreshold) : f30 > (f26 = this.mGestureStrokeAngleThreshold))) {
                    boolean bl2;
                    this.mIsGesturing = bl2 = true;
                    int n28 = this.mCertainGestureColor;
                    GestureOverlayView gestureOverlayView = this;
                    int n29 = n28;
                    gestureOverlayView.setCurrentColor(n29);
                    ArrayList<OnGesturingListener> arrayList2 = this.mOnGesturingListeners;
                    int n30 = arrayList2.size();
                    int n31 = 0;
                    while (n31 < n30) {
                        ArrayList<OnGesturingListener> arrayList3 = arrayList2;
                        int n32 = n31++;
                        OnGesturingListener onGesturingListener = arrayList3.get(n32);
                        GestureOverlayView gestureOverlayView2 = this;
                        onGesturingListener.onGesturingStarted(gestureOverlayView2);
                    }
                }
            }
            ArrayList<OnGestureListener> arrayList4 = this.mOnGestureListeners;
            int n33 = arrayList4.size();
            for (int i = 0; i < n33; ++i) {
                OnGestureListener onGestureListener = arrayList4.get(i);
                GestureOverlayView gestureOverlayView = this;
                MotionEvent motionEvent2 = motionEvent;
                onGestureListener.onGesture(gestureOverlayView, motionEvent2);
            }
        }
        return rect;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void touchUp(MotionEvent motionEvent, boolean bl) {
        boolean bl2;
        this.mIsListeningForGestures = false;
        if (this.mCurrentGesture != null) {
            Gesture gesture = this.mCurrentGesture;
            ArrayList<GesturePoint> arrayList = this.mStrokeBuffer;
            GestureStroke gestureStroke = new GestureStroke(arrayList);
            gesture.addStroke(gestureStroke);
            if (!bl) {
                ArrayList<OnGestureListener> arrayList2 = this.mOnGestureListeners;
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    arrayList2.get(i).onGestureEnded(this, motionEvent);
                }
                boolean bl3 = this.mHandleGestureActions && this.mFadeEnabled;
                boolean bl4 = this.mHandleGestureActions && this.mIsGesturing;
                this.clear(bl3, bl4, false);
            } else {
                this.cancelGesture(motionEvent);
            }
        } else {
            this.cancelGesture(motionEvent);
        }
        this.mStrokeBuffer.clear();
        this.mPreviousWasGesturing = bl2 = this.mIsGesturing;
        this.mIsGesturing = false;
        ArrayList<OnGesturingListener> arrayList = this.mOnGesturingListeners;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.get(n2).onGesturingEnded(this);
            ++n2;
        }
        return;
    }

    public void addOnGestureListener(OnGestureListener onGestureListener) {
        boolean bl = this.mOnGestureListeners.add(onGestureListener);
    }

    public void addOnGesturePerformedListener(OnGesturePerformedListener onGesturePerformedListener) {
        boolean bl = this.mOnGesturePerformedListeners.add(onGesturePerformedListener);
        if (this.mOnGesturePerformedListeners.size() <= 0) {
            return;
        }
        this.mHandleGestureActions = true;
    }

    public void addOnGesturingListener(OnGesturingListener onGesturingListener) {
        boolean bl = this.mOnGesturingListeners.add(onGesturingListener);
    }

    public void cancelClearAnimation() {
        this.setPaintAlpha(255);
        this.mIsFadingOut = false;
        this.mFadingHasStarted = false;
        FadeOutRunnable fadeOutRunnable = this.mFadingOut;
        boolean bl = this.removeCallbacks(fadeOutRunnable);
        this.mPath.rewind();
        this.mCurrentGesture = null;
    }

    public void cancelGesture() {
        long l;
        this.mIsListeningForGestures = false;
        Gesture gesture = this.mCurrentGesture;
        ArrayList<GesturePoint> arrayList = this.mStrokeBuffer;
        GestureStroke gestureStroke = new GestureStroke(arrayList);
        gesture.addStroke(gestureStroke);
        long l2 = l = SystemClock.uptimeMillis();
        float f = 0.0f;
        MotionEvent motionEvent = MotionEvent.obtain(l, l2, 3, 0.0f, f, 0);
        ArrayList<OnGestureListener> arrayList2 = this.mOnGestureListeners;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.get(i).onGestureCancelled(this, motionEvent);
        }
        motionEvent.recycle();
        this.clear(false);
        this.mIsGesturing = false;
        this.mPreviousWasGesturing = false;
        this.mStrokeBuffer.clear();
        ArrayList<OnGesturingListener> arrayList3 = this.mOnGesturingListeners;
        int n2 = arrayList3.size();
        int n3 = 0;
        while (n3 < n2) {
            arrayList3.get(n3).onGesturingEnded(this);
            ++n3;
        }
        return;
    }

    public void clear(boolean bl) {
        this.clear(bl, false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled()) {
            return super.dispatchTouchEvent(motionEvent);
        }
        boolean bl = (this.mIsGesturing || this.mCurrentGesture != null && this.mCurrentGesture.getStrokesCount() > 0 && this.mPreviousWasGesturing) && this.mInterceptEvents;
        boolean bl2 = this.processEvent(motionEvent);
        if (bl) {
            motionEvent.setAction(3);
        }
        boolean bl3 = super.dispatchTouchEvent(motionEvent);
        return true;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mCurrentGesture == null) {
            return;
        }
        if (!this.mGestureVisible) {
            return;
        }
        Path path = this.mPath;
        Paint paint = this.mGesturePaint;
        canvas.drawPath(path, paint);
    }

    public ArrayList<GesturePoint> getCurrentStroke() {
        return this.mStrokeBuffer;
    }

    public long getFadeOffset() {
        return this.mFadeOffset;
    }

    public Gesture getGesture() {
        return this.mCurrentGesture;
    }

    public int getGestureColor() {
        return this.mCertainGestureColor;
    }

    public Paint getGesturePaint() {
        return this.mGesturePaint;
    }

    public Path getGesturePath() {
        return this.mPath;
    }

    public Path getGesturePath(Path path) {
        Path path2 = this.mPath;
        path.set(path2);
        return path;
    }

    public float getGestureStrokeAngleThreshold() {
        return this.mGestureStrokeAngleThreshold;
    }

    public float getGestureStrokeLengthThreshold() {
        return this.mGestureStrokeLengthThreshold;
    }

    public float getGestureStrokeSquarenessTreshold() {
        return this.mGestureStrokeSquarenessTreshold;
    }

    public int getGestureStrokeType() {
        return this.mGestureStrokeType;
    }

    public float getGestureStrokeWidth() {
        return this.mGestureStrokeWidth;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getUncertainGestureColor() {
        return this.mUncertainGestureColor;
    }

    public boolean isEventsInterceptionEnabled() {
        return this.mInterceptEvents;
    }

    public boolean isFadeEnabled() {
        return this.mFadeEnabled;
    }

    public boolean isGestureVisible() {
        return this.mGestureVisible;
    }

    public boolean isGesturing() {
        return this.mIsGesturing;
    }

    @Override
    protected void onDetachedFromWindow() {
        this.cancelClearAnimation();
    }

    public void removeAllOnGestureListeners() {
        this.mOnGestureListeners.clear();
    }

    public void removeAllOnGesturePerformedListeners() {
        this.mOnGesturePerformedListeners.clear();
        this.mHandleGestureActions = false;
    }

    public void removeAllOnGesturingListeners() {
        this.mOnGesturingListeners.clear();
    }

    public void removeOnGestureListener(OnGestureListener onGestureListener) {
        boolean bl = this.mOnGestureListeners.remove(onGestureListener);
    }

    public void removeOnGesturePerformedListener(OnGesturePerformedListener onGesturePerformedListener) {
        boolean bl = this.mOnGesturePerformedListeners.remove(onGesturePerformedListener);
        if (this.mOnGesturePerformedListeners.size() > 0) {
            return;
        }
        this.mHandleGestureActions = false;
    }

    public void removeOnGesturingListener(OnGesturingListener onGesturingListener) {
        boolean bl = this.mOnGesturingListeners.remove(onGesturingListener);
    }

    public void setEventsInterceptionEnabled(boolean bl) {
        this.mInterceptEvents = bl;
    }

    public void setFadeEnabled(boolean bl) {
        this.mFadeEnabled = bl;
    }

    public void setFadeOffset(long l) {
        this.mFadeOffset = l;
    }

    public void setGesture(Gesture gesture) {
        if (this.mCurrentGesture != null) {
            this.clear(false);
        }
        int n = this.mCertainGestureColor;
        this.setCurrentColor(n);
        this.mCurrentGesture = gesture;
        Path path = this.mCurrentGesture.toPath();
        RectF rectF = new RectF();
        path.computeBounds(rectF, true);
        this.mPath.rewind();
        Path path2 = this.mPath;
        float f = -rectF.left;
        float f2 = this.getWidth();
        float f3 = rectF.width();
        float f4 = (f2 - f3) / 2.0f;
        float f5 = f + f4;
        float f6 = -rectF.top;
        float f7 = this.getHeight();
        float f8 = rectF.height();
        float f9 = (f7 - f8) / 2.0f;
        float f10 = f6 + f9;
        path2.addPath(path, f5, f10);
        this.mResetGesture = true;
        this.invalidate();
    }

    public void setGestureColor(int n) {
        this.mCertainGestureColor = n;
    }

    public void setGestureStrokeAngleThreshold(float f) {
        this.mGestureStrokeAngleThreshold = f;
    }

    public void setGestureStrokeLengthThreshold(float f) {
        this.mGestureStrokeLengthThreshold = f;
    }

    public void setGestureStrokeSquarenessTreshold(float f) {
        this.mGestureStrokeSquarenessTreshold = f;
    }

    public void setGestureStrokeType(int n) {
        this.mGestureStrokeType = n;
    }

    public void setGestureStrokeWidth(float f) {
        int n;
        this.mGestureStrokeWidth = f;
        int n2 = (int)f - 1;
        this.mInvalidateExtraBorder = n = Math.max(1, n2);
        this.mGesturePaint.setStrokeWidth(f);
    }

    public void setGestureVisible(boolean bl) {
        this.mGestureVisible = bl;
    }

    public void setOrientation(int n) {
        this.mOrientation = n;
    }

    public void setUncertainGestureColor(int n) {
        this.mUncertainGestureColor = n;
    }

    public static interface OnGesturePerformedListener {
        public void onGesturePerformed(GestureOverlayView var1, Gesture var2);
    }

    public static interface OnGestureListener {
        public void onGesture(GestureOverlayView var1, MotionEvent var2);

        public void onGestureCancelled(GestureOverlayView var1, MotionEvent var2);

        public void onGestureEnded(GestureOverlayView var1, MotionEvent var2);

        public void onGestureStarted(GestureOverlayView var1, MotionEvent var2);
    }

    public static interface OnGesturingListener {
        public void onGesturingEnded(GestureOverlayView var1);

        public void onGesturingStarted(GestureOverlayView var1);
    }

    private class FadeOutRunnable
    implements Runnable {
        boolean fireActionPerformed;
        boolean resetMultipleStrokes;

        private FadeOutRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (GestureOverlayView.this.mIsFadingOut) {
                long l;
                long l2;
                long l3 = AnimationUtils.currentAnimationTimeMillis();
                long l4 = l3 - (l2 = GestureOverlayView.this.mFadingStart);
                if (l4 > (l = GestureOverlayView.this.mFadeDuration)) {
                    if (this.fireActionPerformed) {
                        GestureOverlayView.this.fireOnGesturePerformed();
                    }
                    boolean bl = GestureOverlayView.access$502(GestureOverlayView.this, false);
                    boolean bl2 = GestureOverlayView.access$102(GestureOverlayView.this, false);
                    boolean bl3 = GestureOverlayView.access$602(GestureOverlayView.this, false);
                    GestureOverlayView.this.mPath.rewind();
                    Gesture gesture = GestureOverlayView.access$802(GestureOverlayView.this, null);
                    GestureOverlayView.this.setPaintAlpha(255);
                } else {
                    boolean bl = GestureOverlayView.access$602(GestureOverlayView.this, true);
                    float f = l4;
                    float f2 = GestureOverlayView.this.mFadeDuration;
                    float f3 = f / f2;
                    float f4 = Math.min(1.0f, f3);
                    float f5 = Math.max(0.0f, f4);
                    GestureOverlayView gestureOverlayView = GestureOverlayView.this;
                    float f6 = GestureOverlayView.this.mInterpolator.getInterpolation(f5);
                    float f7 = 1.0f - f6;
                    float f8 = GestureOverlayView.access$1002(gestureOverlayView, f7);
                    GestureOverlayView gestureOverlayView2 = GestureOverlayView.this;
                    float f9 = GestureOverlayView.this.mFadingAlpha;
                    int n = (int)(255.0f * f9);
                    gestureOverlayView2.setPaintAlpha(n);
                    boolean bl4 = GestureOverlayView.this.postDelayed(this, 16L);
                }
            } else if (this.resetMultipleStrokes) {
                boolean bl = GestureOverlayView.access$1202(GestureOverlayView.this, true);
            } else {
                GestureOverlayView.this.fireOnGesturePerformed();
                boolean bl = GestureOverlayView.access$602(GestureOverlayView.this, false);
                GestureOverlayView.this.mPath.rewind();
                Gesture gesture = GestureOverlayView.access$802(GestureOverlayView.this, null);
                boolean bl5 = GestureOverlayView.access$502(GestureOverlayView.this, false);
                GestureOverlayView.this.setPaintAlpha(255);
            }
            GestureOverlayView.this.invalidate();
        }
    }
}

