/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GestureUtils;
import android.gesture.Instance;
import android.gesture.InstanceLearner;
import android.gesture.Learner;
import android.gesture.Prediction;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GestureStore {
    private static final short FILE_FORMAT_VERSION = 1;
    public static final int ORIENTATION_INVARIANT = 1;
    public static final int ORIENTATION_SENSITIVE = 2;
    static final int ORIENTATION_SENSITIVE_4 = 4;
    static final int ORIENTATION_SENSITIVE_8 = 8;
    private static final boolean PROFILE_LOADING_SAVING = false;
    public static final int SEQUENCE_INVARIANT = 1;
    public static final int SEQUENCE_SENSITIVE = 2;
    private boolean mChanged;
    private Learner mClassifier;
    private final HashMap<String, ArrayList<Gesture>> mNamedGestures;
    private int mOrientationStyle = 2;
    private int mSequenceType = 2;

    public GestureStore() {
        HashMap hashMap = new HashMap();
        this.mNamedGestures = hashMap;
        this.mChanged = false;
        InstanceLearner instanceLearner = new InstanceLearner();
        this.mClassifier = instanceLearner;
    }

    private void readFormatV1(DataInputStream dataInputStream) throws IOException {
        Learner learner = this.mClassifier;
        HashMap<String, ArrayList<Gesture>> hashMap = this.mNamedGestures;
        hashMap.clear();
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            String string2 = dataInputStream.readUTF();
            int n3 = dataInputStream.readInt();
            ArrayList<Gesture> arrayList = new ArrayList<Gesture>(n3);
            for (int i = 0; i < n3; ++i) {
                Gesture gesture = Gesture.deserialize(dataInputStream);
                boolean bl = arrayList.add(gesture);
                int n4 = this.mSequenceType;
                int n5 = this.mOrientationStyle;
                Instance instance = Instance.createInstance(n4, n5, gesture, string2);
                learner.addInstance(instance);
            }
            ArrayList arrayList2 = hashMap.put(string2, arrayList);
            ++n2;
        }
        return;
    }

    public void addGesture(String string2, Gesture gesture) {
        if (string2 == null) {
            return;
        }
        if (string2.length() == 0) {
            return;
        }
        ArrayList<Gesture> arrayList = this.mNamedGestures.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            ArrayList<Gesture> arrayList2 = this.mNamedGestures.put(string2, arrayList);
        }
        boolean bl = arrayList.add(gesture);
        Learner learner = this.mClassifier;
        int n = this.mSequenceType;
        int n2 = this.mOrientationStyle;
        Instance instance = Instance.createInstance(n, n2, gesture, string2);
        learner.addInstance(instance);
        this.mChanged = true;
    }

    public Set<String> getGestureEntries() {
        return this.mNamedGestures.keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<Gesture> getGestures(String string2) {
        ArrayList<Gesture> arrayList = this.mNamedGestures.get(string2);
        if (arrayList == null) return null;
        return new ArrayList<Gesture>(arrayList);
    }

    Learner getLearner() {
        return this.mClassifier;
    }

    public int getOrientationStyle() {
        return this.mOrientationStyle;
    }

    public int getSequenceType() {
        return this.mSequenceType;
    }

    public boolean hasChanged() {
        return this.mChanged;
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(inputStream, false);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(InputStream var1_1, boolean var2_2) throws IOException {
        var3_3 = null;
        var5_5 = var1_1 instanceof BufferedInputStream != false ? var1_1 : new BufferedInputStream(var1_1, 32768);
        var4_4 = new DataInputStream(var5_5);
        {
            catch (Throwable var7_7) {}
        }
        try {
            var6_6 = var4_4.readShort();
        }
        catch (Throwable var7_9) {
            var3_3 = var4_4;
        }
        switch (var6_6) {
            default: {
                break;
            }
            ** GOTO lbl-1000
            case 1: {
                this.readFormatV1(var4_4);
            }
        }
        if (!var2_2) {
            return;
        }
        GestureUtils.closeStream(var4_4);
        return;
lbl-1000:
        // 2 sources

        {
            if (var2_2) {
                GestureUtils.closeStream(var3_3);
            }
            throw var7_8;
        }
    }

    public ArrayList<Prediction> recognize(Gesture gesture) {
        int n = this.mSequenceType;
        int n2 = this.mOrientationStyle;
        Instance instance = Instance.createInstance(n, n2, gesture, null);
        Learner learner = this.mClassifier;
        int n3 = this.mSequenceType;
        int n4 = this.mOrientationStyle;
        float[] fArray = instance.vector;
        return learner.classify(n3, n4, fArray);
    }

    public void removeEntry(String string2) {
        ArrayList<Gesture> arrayList = this.mNamedGestures.remove(string2);
        this.mClassifier.removeInstances(string2);
        this.mChanged = true;
    }

    public void removeGesture(String string2, Gesture gesture) {
        ArrayList<Gesture> arrayList = this.mNamedGestures.get(string2);
        if (arrayList == null) {
            return;
        }
        boolean bl = arrayList.remove(gesture);
        if (arrayList.isEmpty()) {
            ArrayList<Gesture> arrayList2 = this.mNamedGestures.remove(string2);
        }
        Learner learner = this.mClassifier;
        long l = gesture.getID();
        learner.removeInstance(l);
        this.mChanged = true;
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(outputStream, false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(OutputStream var1_1, boolean var2_2) throws IOException {
        block10: {
            block9: {
                var3_3 = null;
                var4_4 = this.mNamedGestures;
                var6_6 = var1_1 instanceof BufferedOutputStream != false ? var1_1 : new BufferedOutputStream(var1_1, 32768);
                var5_5 = new DataOutputStream(var6_6);
                var7_7 = 1;
                var5_5.writeShort(var7_7);
                var8_8 = var4_4.size();
                var5_5.writeInt(var8_8);
                for (Map.Entry<String, ArrayList<Gesture>> var10_10 : var4_4.entrySet()) {
                    var11_11 = var10_10.getKey();
                    var12_12 = var10_10.getValue();
                    var13_13 = var12_12.size();
                    var5_5.writeUTF(var11_11);
                    var5_5.writeInt(var13_13);
                    for (var14_14 = 0; var14_14 < var13_13; ++var14_14) {
                        var12_12.get(var14_14).serialize(var5_5);
                    }
                }
                break block9;
                catch (Throwable var15_15) {}
                ** GOTO lbl-1000
            }
            try {
                var5_5.flush();
                this.mChanged = false;
                if (var2_2) break block10;
                return;
            }
            catch (Throwable var15_17) {
                var3_3 = var5_5;
            }
        }
        GestureUtils.closeStream(var5_5);
        return;
lbl-1000:
        // 2 sources

        {
            if (var2_2) {
                GestureUtils.closeStream(var3_3);
            }
            throw var15_16;
        }
    }

    public void setOrientationStyle(int n) {
        this.mOrientationStyle = n;
    }

    public void setSequenceType(int n) {
        this.mSequenceType = n;
    }
}

