/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GesturePoint;
import android.gesture.GestureUtils;
import android.gesture.OrientedBoundingBox;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class GestureStroke {
    static final float TOUCH_TOLERANCE = 3.0f;
    public final RectF boundingBox;
    public final float length;
    private Path mCachedPath;
    public final float[] points;
    private final long[] timestamps;

    private GestureStroke(RectF rectF, float f, float[] fArray, long[] lArray) {
        RectF rectF2;
        float f2 = rectF.left;
        float f3 = rectF.top;
        float f4 = rectF.right;
        float f5 = rectF.bottom;
        this.boundingBox = rectF2 = new RectF(f2, f3, f4, f5);
        this.length = f;
        float[] fArray2 = (float[])fArray.clone();
        this.points = fArray2;
        long[] lArray2 = (long[])lArray.clone();
        this.timestamps = lArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public GestureStroke(ArrayList<GesturePoint> arrayList) {
        int n = arrayList.size();
        float[] fArray = new float[n * 2];
        int n2 = n;
        RectF rectF = null;
        float f = 0.0f;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            long l;
            float f2;
            float f3;
            if (n4 >= n) {
                float f4;
                RectF rectF2;
                int n5 = n2;
                this.timestamps = (long[])n5;
                float[] fArray2 = fArray;
                this.points = fArray2;
                this.boundingBox = rectF2 = rectF;
                this.length = f4 = f;
                return;
            }
            ArrayList<GesturePoint> arrayList2 = arrayList;
            int n6 = n4;
            GesturePoint gesturePoint = arrayList2.get(n6);
            int n7 = n4 * 2;
            fArray[n7] = f3 = gesturePoint.x;
            int n8 = n4 * 2 + 1;
            fArray[n8] = f2 = gesturePoint.y;
            n2[n3] = l = gesturePoint.timestamp;
            if (rectF == null) {
                float f5;
                float f6;
                float f7;
                float f8;
                rectF = new RectF();
                rectF.top = f8 = gesturePoint.y;
                rectF.left = f7 = gesturePoint.x;
                rectF.right = f6 = gesturePoint.x;
                rectF.bottom = f5 = gesturePoint.y;
                f = 0.0f;
            } else {
                double d = f;
                float f9 = gesturePoint.x;
                int n9 = (n4 - 1) * 2;
                float f10 = fArray[n9];
                double d2 = Math.pow(f9 - f10, 2.0);
                float f11 = gesturePoint.y;
                int n10 = (n4 - 1) * 2 + 1;
                float f12 = fArray[n10];
                double d3 = Math.pow(f11 - f12, 2.0);
                double d4 = Math.sqrt(d2 + d3);
                f = (float)(d + d4);
                float f13 = gesturePoint.x;
                float f14 = gesturePoint.y;
                rectF.union(f13, f14);
            }
            ++n3;
            ++n4;
        }
    }

    static GestureStroke deserialize(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        ArrayList<GesturePoint> arrayList = new ArrayList<GesturePoint>(n);
        for (int i = 0; i < n; ++i) {
            GesturePoint gesturePoint = GesturePoint.deserialize(dataInputStream);
            boolean bl = arrayList.add(gesturePoint);
        }
        return new GestureStroke(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void makePath() {
        float[] fArray = this.points;
        int n = fArray.length;
        Path path = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.mCachedPath = path;
                return;
            }
            float f = fArray[n2];
            int n3 = n2 + 1;
            float f2 = fArray[n3];
            if (path == null) {
                path = new Path();
                path.moveTo(f, f2);
                bl = f;
                bl2 = f2;
            } else {
                float f3 = Math.abs(f - bl);
                float f4 = Math.abs(f2 - bl2);
                if (f3 >= 3.0f || f4 >= 3.0f) {
                    float f5 = (f + bl) / 2.0f;
                    float f6 = (f2 + bl2) / 2.0f;
                    path.quadTo((float)bl, (float)bl2, f5, f6);
                    bl = f;
                    bl2 = f2;
                }
            }
            n2 += 2;
        }
    }

    public void clearPath() {
        if (this.mCachedPath == null) {
            return;
        }
        this.mCachedPath.rewind();
    }

    public Object clone() {
        RectF rectF = this.boundingBox;
        float f = this.length;
        float[] fArray = this.points;
        long[] lArray = this.timestamps;
        return new GestureStroke(rectF, f, fArray, lArray);
    }

    public OrientedBoundingBox computeOrientedBoundingBox() {
        return GestureUtils.computeOrientedBoundingBox(this.points);
    }

    void draw(Canvas canvas, Paint paint) {
        if (this.mCachedPath == null) {
            this.makePath();
        }
        Path path = this.mCachedPath;
        canvas.drawPath(path, paint);
    }

    public Path getPath() {
        if (this.mCachedPath == null) {
            this.makePath();
        }
        return this.mCachedPath;
    }

    void serialize(DataOutputStream dataOutputStream) throws IOException {
        float[] fArray = this.points;
        long[] lArray = this.timestamps;
        int n = this.points.length;
        int n2 = n / 2;
        dataOutputStream.writeInt(n2);
        int n3 = 0;
        while (n3 < n) {
            float f = fArray[n3];
            dataOutputStream.writeFloat(f);
            int n4 = n3 + 1;
            float f2 = fArray[n4];
            dataOutputStream.writeFloat(f2);
            int n5 = n3 / 2;
            long l = lArray[n5];
            dataOutputStream.writeLong(l);
            n3 += 2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Path toPath(float f, float f2, int n) {
        float f3;
        float f4;
        GestureStroke gestureStroke = this;
        int n2 = n;
        float[] fArray = GestureUtils.temporalSampling(gestureStroke, n2);
        RectF rectF = this.boundingBox;
        float f5 = -rectF.left;
        float f6 = -rectF.top;
        float[] fArray2 = fArray;
        float f7 = f5;
        float f8 = f6;
        float[] fArray3 = GestureUtils.translate(fArray2, f7, f8);
        float f9 = rectF.width();
        float f10 = f / f9;
        float f11 = f10 > (f4 = f2 / (f3 = rectF.height())) ? f4 : f10;
        float[] fArray4 = GestureUtils.scale(fArray, f11, f11);
        boolean bl = false;
        boolean bl2 = false;
        Path path = null;
        int n3 = fArray.length;
        int n4 = 0;
        while (n4 < n3) {
            float f12 = fArray[n4];
            int n5 = n4 + 1;
            float f13 = fArray[n5];
            if (path == null) {
                Path path2 = path = new Path();
                float f14 = f12;
                float f15 = f13;
                path2.moveTo(f14, f15);
                bl = f12;
                bl2 = f13;
            } else {
                float f16 = Math.abs(f12 - bl);
                float f17 = Math.abs(f13 - bl2);
                if (f16 >= 3.0f || f17 >= 3.0f) {
                    float f18 = (f12 + bl) / 2.0f;
                    float f19 = (f13 + bl2) / 2.0f;
                    Path path3 = path;
                    boolean bl3 = bl;
                    boolean bl4 = bl2;
                    float f20 = f18;
                    float f21 = f19;
                    path3.quadTo((float)bl3, (float)bl4, f20, f21);
                    bl = f12;
                    bl2 = f13;
                }
            }
            n4 += 2;
        }
        return path;
    }
}

